/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.concurrent;

import code.ponfee.commons.concurrent.ThreadPoolExecutors;
import code.ponfee.commons.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Threads {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolExecutors.class);

    public static boolean isStopped(Thread thread) {
        return thread.getState() == Thread.State.TERMINATED;
    }

    public static boolean stopThread(Thread thread, int sleepCount, long sleepMillis, long joinMillis) {
        if (Threads.isStopped(thread)) {
            return false;
        }
        if (Thread.currentThread() == thread) {
            LOG.warn("Call stop on self thread: {}\n{}", (Object)thread.getName(), (Object)ObjectUtils.getStackTrace());
            thread.interrupt();
            return Threads.stopThread(thread);
        }
        LOG.info("Thread stopping: {}", (Object)thread.getName());
        while (sleepCount-- > 0 && sleepMillis > 0L && !Threads.isStopped(thread)) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                LOG.error("Waiting thread terminal interrupted: " + thread.getName(), (Throwable)e);
                thread.interrupt();
                Thread.currentThread().interrupt();
            }
        }
        if (!Threads.isStopped(thread)) {
            thread.interrupt();
            if (joinMillis > 0L) {
                try {
                    thread.join(joinMillis);
                }
                catch (InterruptedException e) {
                    LOG.error("Join thread terminal interrupted: " + thread.getName(), (Throwable)e);
                    thread.interrupt();
                    Thread.currentThread().interrupt();
                }
            }
        }
        return Threads.stopThread(thread);
    }

    public static void interruptIfNecessary(Throwable t) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean stopThread(Thread thread) {
        if (Threads.isStopped(thread)) {
            return false;
        }
        Thread thread2 = thread;
        synchronized (thread2) {
            if (Threads.isStopped(thread)) {
                return false;
            }
            try {
                thread.stop();
            }
            catch (Exception e) {
                LOG.error("Invoke thread stop occur error: " + thread.getName(), (Throwable)e);
            }
            LOG.warn("Invoked java.lang.Thread#stop() method: {}", (Object)thread.getName());
        }
        return true;
    }
}

