/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.constrain;

import code.ponfee.commons.model.Result;
import code.ponfee.commons.model.ResultCode;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;

public abstract class Jsr303Validator {
    public Object verify(ProceedingJoinPoint pjp, BindingResult bindingResult) throws Throwable {
        if (bindingResult.hasErrors()) {
            return this.handleFailure(((MethodSignature)pjp.getSignature()).getMethod().getReturnType(), bindingResult);
        }
        return pjp.proceed();
    }

    protected Object handleFailure(Class<?> returnType, BindingResult bindingResult) {
        String errorMsg = bindingResult.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(",", "[", "]"));
        if (returnType == Result.class) {
            return Result.failure(ResultCode.BAD_REQUEST.getCode(), ResultCode.BAD_REQUEST.getMsg() + ": " + errorMsg);
        }
        throw new IllegalArgumentException(errorMsg);
    }
}

