/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.data;

import code.ponfee.commons.reflect.BeanMaps;
import java.util.Properties;
import javax.sql.DataSource;

public interface DataSourceFactory<T extends DataSource> {
    public static final DataSourceFactory COMMON_FACTORY = new DataSourceFactory(){};

    default public void configure(T dataSource, Properties commonConfig) {
        BeanMaps.PROPS.copyFromMap(commonConfig, dataSource);
    }

    default public T create(String dataSourceClassName, Properties basicConfig, Properties commonConfig) {
        DataSource dataSource;
        try {
            dataSource = (DataSource)Class.forName(dataSourceClassName).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        BeanMaps.PROPS.copyFromMap(basicConfig, dataSource);
        this.configure(dataSource, commonConfig);
        return (T)dataSource;
    }
}

