/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.data;

import code.ponfee.commons.data.DataSourceFactory;
import code.ponfee.commons.util.Asserts;
import code.ponfee.commons.util.PropertiesUtils;
import code.ponfee.commons.util.Strings;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class NamedDataSource {
    private static final Pattern PATTERN_DBURL_KEY = Pattern.compile("^(\\w+)\\.url$");
    private final String name;
    private final DataSource dataSource;

    public NamedDataSource(String name, DataSource dataSource) {
        this.name = name;
        this.dataSource = dataSource;
    }

    public static NamedDataSource of(String name, DataSource dataSource) {
        return new NamedDataSource(name, dataSource);
    }

    public String getName() {
        return this.name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static NamedDataSource[] build(String prefix, Properties props) {
        prefix = StringUtils.isBlank((CharSequence)prefix) ? "" : prefix.trim() + ".";
        props = PropertiesUtils.filterProperties(props, prefix);
        LinkedHashSet names = new LinkedHashSet();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name;
            Matcher matcher = PATTERN_DBURL_KEY.matcher(k.toString());
            if (matcher.matches() && !names.add(name = matcher.group(1))) {
                throw new IllegalStateException("Duplicated datasource name '" + name + "'.");
            }
        }));
        Asserts.isTrue((!names.isEmpty() ? 1 : 0) != 0, (String)"Not configured datasource 'name' option.");
        Pattern pattern = Pattern.compile("^(?!(" + Strings.join(names, "|") + ")\\.).*");
        Properties commonConfig = new Properties();
        props.entrySet().stream().filter(e -> pattern.matcher(e.toString()).matches()).forEach(e -> commonConfig.put(e.getKey(), e.getValue()));
        String defaultDsName = (String)commonConfig.remove("default");
        String defaultType = (String)commonConfig.remove("type");
        LinkedList<NamedDataSource> dataSources = new LinkedList<NamedDataSource>();
        for (String name : names) {
            String dsType = Strings.ifEmpty((String)props.remove(name + ".type"), defaultType);
            Properties basicConfig = PropertiesUtils.filterProperties(props, name + ".");
            Object dataSource = DataSourceFactory.COMMON_FACTORY.create(dsType, basicConfig, commonConfig);
            NamedDataSource namedDs = NamedDataSource.of(name, dataSource);
            if (name.equals(defaultDsName)) {
                dataSources.add(0, namedDs);
                continue;
            }
            dataSources.add(namedDs);
        }
        return dataSources.toArray(new NamedDataSource[0]);
    }
}

