/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.data.lookup;

import code.ponfee.commons.base.Initializable;
import code.ponfee.commons.base.Releasable;
import code.ponfee.commons.data.NamedDataSource;
import code.ponfee.commons.data.lookup.DataSourceLookup;
import code.ponfee.commons.data.lookup.MultipleDataSourceContext;
import code.ponfee.commons.exception.Throwables;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.jdbc.datasource.AbstractDataSource;

public class MultipleScalableDataSource
extends AbstractDataSource
implements DataSourceLookup,
Initializable,
Closeable {
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private final DataSource defaultDataSource;

    public MultipleScalableDataSource(NamedDataSource dataSource) {
        this(dataSource.getName(), dataSource.getDataSource(), new NamedDataSource[0]);
    }

    public MultipleScalableDataSource(NamedDataSource ... dataSources) {
        this(dataSources[0].getName(), dataSources[0].getDataSource(), (NamedDataSource[])ArrayUtils.subarray((Object[])dataSources, (int)1, (int)dataSources.length));
    }

    public MultipleScalableDataSource(String defaultName, DataSource defaultDataSource, NamedDataSource ... othersDataSource) {
        Map<String, DataSource> dataSources = MultipleDataSourceContext.process(defaultName, defaultDataSource, othersDataSource);
        this.defaultDataSource = defaultDataSource;
        this.dataSources.putAll(dataSources);
    }

    public synchronized void add(NamedDataSource ds) {
        this.add(ds.getName(), ds.getDataSource());
    }

    public synchronized void add(@Nonnull String dataSourceName, @Nonnull DataSource datasource) {
        if (this.dataSources.containsKey(dataSourceName)) {
            throw new IllegalArgumentException("Duplicated name: " + dataSourceName);
        }
        this.dataSources.put(dataSourceName, datasource);
        MultipleDataSourceContext.add(dataSourceName);
    }

    public synchronized void remove(String dataSourceName) {
        this.dataSources.remove(dataSourceName);
        MultipleDataSourceContext.remove(dataSourceName);
    }

    public synchronized void remove(@Nonnull DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Iterator<Map.Entry<String, DataSource>> iter = this.dataSources.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, DataSource> entry = iter.next();
            if (!dataSource.equals(entry.getValue())) continue;
            iter.remove();
            MultipleDataSourceContext.remove(entry.getKey());
        }
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    @Override
    public DataSource lookupDataSource(String name) {
        return this.dataSources.get(name);
    }

    @Override
    public void init() {
        this.dataSources.forEach((name, ds) -> Initializable.init(ds));
    }

    @Override
    public void close() {
        this.dataSources.forEach((name, ds) -> {
            try {
                Releasable.release(ds);
            }
            catch (Exception e) {
                Throwables.console(e);
            }
        });
    }

    private DataSource determineTargetDataSource() {
        DataSource dataSource;
        String lookupKey = MultipleDataSourceContext.get();
        DataSource dataSource2 = dataSource = lookupKey == null ? this.defaultDataSource : this.dataSources.get(lookupKey);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot found DataSource by name [" + lookupKey + "]");
        }
        return dataSource;
    }
}

