/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.export;

import code.ponfee.commons.concurrent.MultithreadExecutors;
import code.ponfee.commons.export.AbstractDataExporter;
import code.ponfee.commons.export.Table;
import code.ponfee.commons.util.Holder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public abstract class AbstractSplitExporter
extends AbstractDataExporter<Void> {
    private final int batchSize;
    private final String savingFilePathPrefix;
    private final String fileSuffix;
    private final Executor executor;

    public AbstractSplitExporter(int batchSize, String savingFilePathPrefix, String fileSuffix, Executor executor) {
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
        this.savingFilePathPrefix = savingFilePathPrefix;
        this.fileSuffix = fileSuffix;
        this.executor = executor;
    }

    @Override
    public final <E> void build(Table<E> table) {
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(this.executor);
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger split = new AtomicInteger(0);
        Holder subTable = Holder.of(table.copyOfWithoutTbody(Function.identity()));
        this.rollingTbody(table, (data, i) -> {
            ((Table)subTable.get()).addRow(data);
            if (count.incrementAndGet() == this.batchSize) {
                Table<Object[]> last = subTable.set(table.copyOfWithoutTbody(Function.identity()));
                String path = this.buildFilePath(split.incrementAndGet());
                service.submit(this.splitExporter(last, path), Boolean.TRUE);
                count.set(0);
            }
        });
        if (!subTable.get().isEmptyTbody()) {
            String path = this.buildFilePath(split.incrementAndGet());
            service.submit(this.splitExporter(subTable.get(), path), Boolean.TRUE);
        }
        if (split.get() > 0) {
            super.nonEmpty();
            MultithreadExecutors.joinDiscard(service, split.get());
        }
    }

    protected abstract AbstractAsyncSplitExporter splitExporter(Table<Object[]> var1, String var2);

    @Override
    public final Void export() {
        throw new UnsupportedOperationException();
    }

    private String buildFilePath(int fileNo) {
        return this.savingFilePathPrefix + String.format("%04d", fileNo) + this.fileSuffix;
    }

    public static abstract class AbstractAsyncSplitExporter
    implements Runnable {
        private final Table<Object[]> subTable;
        protected final String savingFilePath;

        public AbstractAsyncSplitExporter(Table<Object[]> subTable, String savingFilePath) {
            this.subTable = subTable;
            this.savingFilePath = savingFilePath;
        }

        @Override
        public final void run() {
            this.subTable.toEnd();
            try (AbstractDataExporter<?> exporter = this.createExporter();){
                exporter.build(this.subTable);
                this.complete(exporter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract AbstractDataExporter<?> createExporter() throws IOException;

        protected void complete(AbstractDataExporter<?> exporter) {
        }
    }
}

