/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.export;

import code.ponfee.commons.export.AbstractDataExporter;
import code.ponfee.commons.export.AbstractSplitExporter;
import code.ponfee.commons.export.CsvFileExporter;
import code.ponfee.commons.export.Table;
import java.io.IOException;
import java.util.concurrent.Executor;

public class SplitCsvFileExporter
extends AbstractSplitExporter {
    private final boolean withBom;

    public SplitCsvFileExporter(int batchSize, String savingFilePathPrefix, boolean withBom, Executor executor) {
        super(batchSize, savingFilePathPrefix, ".csv", executor);
        this.withBom = withBom;
    }

    @Override
    protected AbstractSplitExporter.AbstractAsyncSplitExporter splitExporter(Table<Object[]> subTable, String savingFilePath) {
        return new AsnycCsvFileExporter(subTable, savingFilePath, this.withBom);
    }

    private static class AsnycCsvFileExporter
    extends AbstractSplitExporter.AbstractAsyncSplitExporter {
        final boolean withBom;

        AsnycCsvFileExporter(Table<Object[]> subTable, String savingFilePath, boolean withBom) {
            super(subTable, savingFilePath);
            this.withBom = withBom;
        }

        @Override
        protected AbstractDataExporter<?> createExporter() throws IOException {
            return new CsvFileExporter(this.savingFilePath, this.withBom);
        }
    }
}

