/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.http;

import code.ponfee.commons.http.ContentType;
import code.ponfee.commons.http.HttpException;
import code.ponfee.commons.http.HttpParams;
import code.ponfee.commons.http.HttpRequest;
import code.ponfee.commons.http.HttpStatus;
import code.ponfee.commons.io.Closeables;
import code.ponfee.commons.json.Jsons;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public final class Http {
    private final String url;
    private final HttpMethod method;
    private final Map<String, String> headers = new HashMap<String, String>(0);
    private final Map<String, Object> params = new HashMap<String, Object>(0);
    private final List<MimePart> parts = new ArrayList<MimePart>(0);
    private String data;
    private int connectTimeout = 2000;
    private int readTimeout = 5000;
    private Boolean encode = Boolean.TRUE;
    private String contentType;
    private String contentCharset;
    private String accept;
    private SSLSocketFactory sslSocketFactory;
    private Map<String, List<String>> respHeaders;
    private HttpStatus status;

    private Http(@Nonnull String url, @Nonnull HttpMethod method) {
        this.url = url;
        this.method = method;
    }

    public static Http get(String url) {
        return new Http(url, HttpMethod.GET);
    }

    public static Http post(String url) {
        return new Http(url, HttpMethod.POST);
    }

    public static Http put(String url) {
        return new Http(url, HttpMethod.PUT);
    }

    public static Http head(String url) {
        return new Http(url, HttpMethod.HEAD);
    }

    public static Http delete(String url) {
        return new Http(url, HttpMethod.DELETE);
    }

    public static Http trace(String url) {
        return new Http(url, HttpMethod.TRACE);
    }

    public static Http options(String url) {
        return new Http(url, HttpMethod.OPTIONS);
    }

    public static Http of(String url, String method) {
        return Http.of(url, (HttpMethod)EnumUtils.getEnumIgnoreCase(HttpMethod.class, (String)method, (Enum)HttpMethod.GET));
    }

    public static Http of(String url, HttpMethod method) {
        return new Http(url, method);
    }

    public Http addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Http addHeader(Map<String, String> headers) {
        if (MapUtils.isNotEmpty(headers)) {
            this.headers.putAll(headers);
        }
        return this;
    }

    public Http addParam(Map<String, ?> params) {
        this.params.putAll(params);
        return this;
    }

    public <T> Http addParam(String name, T value) {
        this.params.put(name, value);
        return this;
    }

    public Http data(Map<String, ?> data) {
        return this.data(data, "UTF-8");
    }

    public Http data(Map<String, ?> data, String charset) {
        return this.data(HttpParams.buildParams(data, charset));
    }

    public Http data(String data) {
        Preconditions.checkState((this.data == null ? 1 : 0) != 0, (Object)"data are already set.");
        Preconditions.checkArgument((data != null && data.length() != 0 ? 1 : 0) != 0, (Object)"data cannot be empty.");
        this.data = data;
        return this;
    }

    public Http addPart(String formName, String fileName, Object mimePart) {
        return this.addPart(formName, fileName, null, mimePart);
    }

    public Http addPart(String formName, String fileName, String contentType, Object mimePart) {
        this.parts.add(new MimePart(formName, fileName, contentType, mimePart));
        return this;
    }

    public Http encode(Boolean encode) {
        this.encode = encode;
        return this;
    }

    public Http contentType(ContentType contentType, String contentCharset) {
        this.contentType = contentType.value();
        this.contentCharset = contentCharset;
        return this;
    }

    public Http contentType(ContentType contentType) {
        return this.contentType(contentType, "UTF-8");
    }

    public Http accept(ContentType contentType) {
        this.accept = contentType.value();
        return this;
    }

    public Http connTimeoutSeconds(int seconds) {
        this.connectTimeout = seconds * 1000;
        return this;
    }

    public Http readTimeoutSeconds(int seconds) {
        this.readTimeout = seconds * 1000;
        return this;
    }

    public Http setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        return this;
    }

    public Http setSSLSocketFactory(SSLContext sslContext) {
        return this.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    public <T> T request(JavaType type) {
        return Jsons.fromJson(this.request(), type);
    }

    public <T> T request(Class<T> type) {
        return Jsons.fromJson(this.request(), type);
    }

    public String request() {
        HttpRequest request = this.request0();
        try {
            String string = request.body();
            return string;
        }
        finally {
            this.disconnect(request);
        }
    }

    public void download(String filepath) {
        try (FileOutputStream out = new FileOutputStream(filepath);){
            this.download(out);
        }
        catch (IOException e) {
            throw new HttpException("download error: " + filepath, e);
        }
    }

    public byte[] download() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.download(output);
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(OutputStream output) {
        BufferedOutputStream bos = null;
        HttpRequest request = this.request0();
        try {
            if (HttpStatus.Series.valueOf(this.status) != HttpStatus.Series.SUCCESSFUL) {
                throw new HttpException("request failed, status: " + request.code());
            }
            bos = new BufferedOutputStream(output);
            request.receive(bos);
            this.disconnect(request);
        }
        catch (Throwable throwable) {
            this.disconnect(request);
            Closeables.console(bos);
            throw throwable;
        }
        Closeables.console(bos);
    }

    public Map<String, List<String>> getRespHeaders() {
        return this.respHeaders;
    }

    public Map<String, String> getReqHeaders() {
        return this.headers;
    }

    public String[] getRespHeaders(String name) {
        if (this.respHeaders == null) {
            return null;
        }
        List<String> values = this.respHeaders.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public String getRespHeader(String name) {
        if (this.respHeaders == null) {
            return null;
        }
        List<String> values = this.respHeaders.get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    private HttpRequest request0() {
        HttpRequest request;
        switch (this.method) {
            case GET: {
                request = HttpRequest.get((CharSequence)this.url, this.params, this.encode);
                break;
            }
            case POST: {
                request = HttpRequest.post((CharSequence)this.url, this.params, this.encode);
                break;
            }
            case PUT: {
                request = HttpRequest.put((CharSequence)this.url, this.params, this.encode);
                break;
            }
            case HEAD: {
                request = HttpRequest.head((CharSequence)this.url, this.params, this.encode);
                break;
            }
            case DELETE: {
                request = HttpRequest.delete((CharSequence)this.url, this.params, this.encode);
                break;
            }
            case TRACE: {
                request = HttpRequest.trace(this.url);
                break;
            }
            case OPTIONS: {
                request = HttpRequest.options(this.url);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported http method " + this.method.name());
            }
        }
        request.connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).decompress(true).acceptGzipEncoding().headers(this.headers);
        if (!StringUtils.isEmpty((CharSequence)this.contentType)) {
            request.contentType(this.contentType, this.contentCharset);
        }
        if (!StringUtils.isEmpty((CharSequence)this.accept)) {
            request.accept(this.accept);
        }
        request.trustAllHosts();
        if (this.sslSocketFactory != null) {
            request.setSSLSocketFactory(this.sslSocketFactory);
        } else {
            request.trustAllCerts();
        }
        if (!StringUtils.isEmpty((CharSequence)this.data)) {
            request.send(this.data);
        }
        for (MimePart part : this.parts) {
            request.part(part.formName, part.fileName, part.contentType, part.stream);
        }
        this.status = request.status();
        return request;
    }

    private void disconnect(HttpRequest request) {
        if (request != null) {
            this.respHeaders = request.headers();
            try {
                request.disconnect();
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    private static final class MimePart {
        final String formName;
        final String fileName;
        final String contentType;
        final InputStream stream;

        MimePart(String formName, String fileName, String contentType, Object mime) {
            if (mime instanceof byte[]) {
                this.stream = new ByteArrayInputStream((byte[])mime);
            } else if (mime instanceof Byte[]) {
                this.stream = new ByteArrayInputStream(ArrayUtils.toPrimitive((Byte[])((Byte[])mime)));
            } else if (mime instanceof String || mime instanceof File) {
                File file = mime instanceof File ? (File)mime : new File((String)mime);
                try {
                    this.stream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if (mime instanceof InputStream) {
                this.stream = (InputStream)mime;
            } else {
                throw new IllegalArgumentException("mime must be one of them: file, file path, byte array, input stream.");
            }
            this.formName = formName;
            this.fileName = fileName;
            this.contentType = contentType;
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        TRACE,
        OPTIONS;

    }
}

