/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.io;

import code.ponfee.commons.io.Closeables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class WrappedBufferedWriter
extends Writer {
    private OutputStream output;
    private BufferedWriter buffer;

    public WrappedBufferedWriter(File file) throws FileNotFoundException {
        this(file, Charset.defaultCharset());
    }

    public WrappedBufferedWriter(File file, String charset) throws FileNotFoundException {
        this(new FileOutputStream(file), Charset.forName(charset));
    }

    public WrappedBufferedWriter(File file, Charset charset) throws FileNotFoundException {
        this(new FileOutputStream(file), charset);
    }

    public WrappedBufferedWriter(OutputStream output, Charset charset) {
        this.output = output;
        this.buffer = new BufferedWriter(new OutputStreamWriter(output, charset), 8192);
    }

    @Override
    public void write(String str) throws IOException {
        this.buffer.write(str);
    }

    @Override
    public void write(int c) throws IOException {
        this.buffer.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.buffer.write(cbuf);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.buffer.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.buffer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.buffer.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.buffer.append(c);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() {
        Closeables.console(this.buffer);
        this.buffer = null;
        this.output = null;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.buffer.write(cbuf, off, len);
    }

    public void newLine() throws IOException {
        this.buffer.newLine();
    }

    public void write(byte[] bytes) throws IOException {
        this.output.write(bytes);
    }

    public void writeln() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String str) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.buffer.write(str);
            this.writeln();
        }
    }
}

