/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.io.charset;

import code.ponfee.commons.io.CharsetDetector;
import code.ponfee.commons.io.Files;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesDetector {
    private static final Logger LOG = LoggerFactory.getLogger(BytesDetector.class);
    private static final int[][] GB_FREQ = new int[94][94];
    private static final int[][] GBK_FREQ = new int[126][191];
    private static final int[][] BIG5_FREQ = new int[94][158];
    private static final int[][] BIG5P_FREQ = new int[126][191];
    private static final int[][] EUC_TW_FREQ = new int[94][94];
    private static final int[][] KR_FREQ = new int[94][94];
    private static final int[][] JP_FREQ = new int[94][94];

    public static Charset detect(InputStream input, int length) throws IOException {
        String charset = BytesDetector.detect(Files.readByteArray(input, length));
        return charset == null ? CharsetDetector.DEFAULT_CHARSET : Charset.forName(charset);
    }

    public static String detect(byte[] rawtext) {
        int[] scores = new int[]{BytesDetector.gb2312_probability(rawtext), BytesDetector.gbk_probability(rawtext), BytesDetector.gb18030_probability(rawtext), BytesDetector.hz_probability(rawtext), BytesDetector.big5_probability(rawtext), BytesDetector.euc_tw_probability(rawtext), BytesDetector.utf8_probability(rawtext), 0, 0, BytesDetector.utf16_probability(rawtext), 0, 0, BytesDetector.iso_2022_cn_probability(rawtext), 0, 0, BytesDetector.euc_kr_probability(rawtext), BytesDetector.cp949_probability(rawtext), BytesDetector.iso_2022_kr_probability(rawtext), 0, BytesDetector.sjis_probability(rawtext), BytesDetector.euc_jp_probability(rawtext), BytesDetector.iso_2022_jp_probability(rawtext), BytesDetector.ascii_probability(rawtext)};
        int maxScore = 0;
        int encodingGuess = -1;
        for (int i = 0; i < scores.length; ++i) {
            LOG.debug("Encoding {} score {}", (Object)Encoding.JAVA_CHARSET[i], (Object)scores[i]);
            if (scores[i] <= maxScore) continue;
            encodingGuess = i;
            maxScore = scores[i];
        }
        return maxScore > 50 ? Encoding.JAVA_CHARSET[encodingGuess] : null;
    }

    private static int gb2312_probability(byte[] rawtext) {
        int dbchars = 1;
        int gbchars = 1;
        long gbfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++gbchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                if (GB_FREQ[row][column] != 0) {
                    gbfreq += (long)GB_FREQ[row][column];
                } else if (15 <= row && row < 55) {
                    gbfreq += 200L;
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)gbchars / (float)dbchars);
        float freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int gbk_probability(byte[] rawtext) {
        int dbchars = 1;
        int gbchars = 1;
        long gbfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            int column;
            int row;
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 161;
                column = rawtext[i + 1] + 256 - 161;
                if (GB_FREQ[row][column] != 0) {
                    gbfreq += (long)GB_FREQ[row][column];
                } else if (15 <= row && row < 55) {
                    gbfreq += 200L;
                }
            } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 129;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 64;
                if (GBK_FREQ[row][column] != 0) {
                    gbfreq += (long)GBK_FREQ[row][column];
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)gbchars / (float)dbchars);
        float freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    private static int gb18030_probability(byte[] rawtext) {
        int dbchars = 1;
        int gbchars = 1;
        long gbfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            int column;
            int row;
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && i + 1 < rawtext.length && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 161;
                column = rawtext[i + 1] + 256 - 161;
                if (GB_FREQ[row][column] != 0) {
                    gbfreq += (long)GB_FREQ[row][column];
                } else if (15 <= row && row < 55) {
                    gbfreq += 200L;
                }
            } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && i + 1 < rawtext.length && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 129;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 64;
                if (GBK_FREQ[row][column] != 0) {
                    gbfreq += (long)GBK_FREQ[row][column];
                }
            } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && i + 3 < rawtext.length && 48 <= rawtext[i + 1] && rawtext[i + 1] <= 57 && -127 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && 48 <= rawtext[i + 3] && rawtext[i + 3] <= 57) {
                ++gbchars;
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)gbchars / (float)dbchars);
        float freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    private static int hz_probability(byte[] rawtext) {
        long hzfreq = 0L;
        long totalfreq = 1L;
        int hzstart = 0;
        int n = rawtext.length - 1;
        block0: for (int i = 0; i < rawtext.length; ++i) {
            if (rawtext[i] != 126) continue;
            if (rawtext[i + 1] == 123) {
                ++hzstart;
                i += 2;
                while (i < n && rawtext[i] != 10 && rawtext[i] != 13) {
                    int column;
                    int row;
                    if (rawtext[i] == 126 && rawtext[i + 1] == 125) {
                        ++i;
                        continue block0;
                    }
                    if (33 <= rawtext[i] && rawtext[i] <= 119 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 119) {
                        row = rawtext[i] - 33;
                        column = rawtext[i + 1] - 33;
                        totalfreq += 500L;
                        if (GB_FREQ[row][column] != 0) {
                            hzfreq += (long)GB_FREQ[row][column];
                        } else if (15 <= row && row < 55) {
                            hzfreq += 200L;
                        }
                    } else if (BytesDetector.between(rawtext[i]) && BytesDetector.between(rawtext[i + 1])) {
                        row = rawtext[i] + 256 - 161;
                        column = rawtext[i + 1] + 256 - 161;
                        totalfreq += 500L;
                        if (GB_FREQ[row][column] != 0) {
                            hzfreq += (long)GB_FREQ[row][column];
                        } else if (15 <= row && row < 55) {
                            hzfreq += 200L;
                        }
                    }
                    i += 2;
                }
                continue;
            }
            if (rawtext[i + 1] == 125) {
                ++i;
                continue;
            }
            if (rawtext[i + 1] != 126) continue;
            ++i;
        }
        float rangeval = hzstart > 4 ? 50.0f : (hzstart > 1 ? 41.0f : (hzstart > 0 ? 39.0f : 0.0f));
        float freqval = 50.0f * ((float)hzfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static boolean between(byte b) {
        return -95 <= b && -9 >= b;
    }

    private static int big5_probability(byte[] rawtext) {
        int dbchars = 1;
        int bfchars = 1;
        long bffreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -7 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                ++bfchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 97;
                if (BIG5_FREQ[row][column] != 0) {
                    bffreq += (long)BIG5_FREQ[row][column];
                } else if (3 <= row && row <= 37) {
                    bffreq += 200L;
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)bfchars / (float)dbchars);
        float freqval = 50.0f * ((float)bffreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int euc_tw_probability(byte[] rawtext) {
        int dbchars = 1;
        int cnschars = 1;
        long cnsfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (i + 3 < rawtext.length && -114 == rawtext[i] && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -80 && -95 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && -95 <= rawtext[i + 3] && rawtext[i + 3] <= -2) {
                ++cnschars;
                i += 3;
                continue;
            }
            if (-95 > rawtext[i] || rawtext[i] > -2 || -95 > rawtext[i + 1] || rawtext[i + 1] > -2) continue;
            ++cnschars;
            totalfreq += 500L;
            int row = rawtext[i] + 256 - 161;
            int column = rawtext[i + 1] + 256 - 161;
            if (EUC_TW_FREQ[row][column] != 0) {
                cnsfreq += (long)EUC_TW_FREQ[row][column];
            } else if (35 <= row && row <= 92) {
                cnsfreq += 150L;
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)cnschars / (float)dbchars);
        float freqval = 50.0f * ((float)cnsfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int iso_2022_cn_probability(byte[] rawtext) {
        int dbchars = 1;
        int isochars = 1;
        long isofreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            int column;
            int row;
            if (rawtext[i] != 27 || i + 3 >= rawtext.length) continue;
            if (rawtext[i + 1] == 36 && rawtext[i + 2] == 41 && rawtext[i + 3] == 65) {
                i += 4;
                while (rawtext[i] != 27) {
                    ++dbchars;
                    if (33 <= rawtext[i] && rawtext[i] <= 119 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 119) {
                        ++isochars;
                        row = rawtext[i] - 33;
                        column = rawtext[i + 1] - 33;
                        totalfreq += 500L;
                        if (GB_FREQ[row][column] != 0) {
                            isofreq += (long)GB_FREQ[row][column];
                        } else if (15 <= row && row < 55) {
                            isofreq += 200L;
                        }
                        ++i;
                    }
                    ++i;
                }
            } else if (i + 3 < rawtext.length && rawtext[i + 1] == 36 && rawtext[i + 2] == 41 && rawtext[i + 3] == 71) {
                i += 4;
                while (rawtext[i] != 27) {
                    ++dbchars;
                    if (33 <= rawtext[i] && rawtext[i] <= 126 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 126) {
                        ++isochars;
                        totalfreq += 500L;
                        row = rawtext[i] - 33;
                        column = rawtext[i + 1] - 33;
                        if (EUC_TW_FREQ[row][column] != 0) {
                            isofreq += (long)EUC_TW_FREQ[row][column];
                        } else if (35 <= row && row <= 92) {
                            isofreq += 150L;
                        }
                        ++i;
                    }
                    ++i;
                }
            }
            if (rawtext[i] != 27 || i + 2 >= rawtext.length || rawtext[i + 1] != 40 || rawtext[i + 2] != 66) continue;
            i += 2;
        }
        float rangeval = 50.0f * ((float)isochars / (float)dbchars);
        float freqval = 50.0f * ((float)isofreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int utf8_probability(byte[] rawtext) {
        int goodbytes = 0;
        int asciibytes = 0;
        for (int i = 0; i < rawtext.length; ++i) {
            if ((rawtext[i] & 0x7F) == rawtext[i]) {
                ++asciibytes;
                continue;
            }
            if (-64 <= rawtext[i] && rawtext[i] <= -33 && i + 1 < rawtext.length && -128 <= rawtext[i + 1] && rawtext[i + 1] <= -65) {
                goodbytes += 2;
                ++i;
                continue;
            }
            if (-32 > rawtext[i] || rawtext[i] > -17 || i + 2 >= rawtext.length || -128 > rawtext[i + 1] || rawtext[i + 1] > -65 || -128 > rawtext[i + 2] || rawtext[i + 2] > -65) continue;
            goodbytes += 3;
            i += 2;
        }
        if (asciibytes == rawtext.length) {
            return 0;
        }
        int score = (int)(100.0f * ((float)goodbytes / (float)(rawtext.length - asciibytes)));
        if (score > 98) {
            return score;
        }
        if (score > 95 && goodbytes > 30) {
            return score;
        }
        return 0;
    }

    private static int utf16_probability(byte[] rawtext) {
        if (rawtext.length > 1 && -2 == rawtext[0] && -1 == rawtext[1] || -1 == rawtext[0] && -2 == rawtext[1]) {
            return 100;
        }
        return 0;
    }

    private static int ascii_probability(byte[] rawtext) {
        int score = 75;
        for (int i = 0; i < rawtext.length; ++i) {
            if (rawtext[i] < 0) {
                score -= 5;
            } else if (rawtext[i] == 27) {
                score -= 5;
            }
            if (score > 0) continue;
            return 0;
        }
        return score;
    }

    private static int euc_kr_probability(byte[] rawtext) {
        int dbchars = 1;
        int krchars = 1;
        long krfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++krchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                if (KR_FREQ[row][column] != 0) {
                    krfreq += (long)KR_FREQ[row][column];
                } else if (15 <= row && row < 55) {
                    krfreq += 0L;
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)krchars / (float)dbchars);
        float freqval = 50.0f * ((float)krfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int cp949_probability(byte[] rawtext) {
        int dbchars = 1;
        int krchars = 1;
        long krfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-127 <= rawtext[i] && rawtext[i] <= -2 && (65 <= rawtext[i + 1] && rawtext[i + 1] <= 90 || 97 <= rawtext[i + 1] && rawtext[i + 1] <= 122 || -127 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                int column;
                int row;
                ++krchars;
                totalfreq += 500L;
                if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2 && KR_FREQ[row = rawtext[i] + 256 - 161][column = rawtext[i + 1] + 256 - 161] != 0) {
                    krfreq += (long)KR_FREQ[row][column];
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)krchars / (float)dbchars);
        float freqval = 50.0f * ((float)krfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int iso_2022_kr_probability(byte[] rawtext) {
        for (int i = 0; i < rawtext.length; ++i) {
            if (i + 3 >= rawtext.length || rawtext[i] != 27 || (char)rawtext[i + 1] != '$' || (char)rawtext[i + 2] != ')' || (char)rawtext[i + 3] != 'C') continue;
            return 100;
        }
        return 0;
    }

    private static int euc_jp_probability(byte[] rawtext) {
        int dbchars = 1;
        int jpchars = 1;
        long jpfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++jpchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                if (JP_FREQ[row][column] != 0) {
                    jpfreq += (long)JP_FREQ[row][column];
                } else if (15 <= row && row < 55) {
                    jpfreq += 0L;
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)jpchars / (float)dbchars);
        float freqval = 50.0f * ((float)jpfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    private static int iso_2022_jp_probability(byte[] rawtext) {
        for (int i = 0; i < rawtext.length; ++i) {
            if (i + 2 >= rawtext.length || rawtext[i] != 27 || (char)rawtext[i + 1] != '$' || (char)rawtext[i + 2] != 'B') continue;
            return 100;
        }
        return 0;
    }

    private static int sjis_probability(byte[] rawtext) {
        int dbchars = 1;
        int jpchars = 1;
        long jpfreq = 0L;
        long totalfreq = 1L;
        int n = rawtext.length - 1;
        for (int i = 0; i < n; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (i + 1 < rawtext.length && (-127 <= rawtext[i] && rawtext[i] <= -97 || -32 <= rawtext[i] && rawtext[i] <= -17) && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -128 <= rawtext[i + 1] && rawtext[i + 1] <= -4)) {
                int adjust;
                ++jpchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256;
                int column = rawtext[i + 1] + 256;
                if (column < 159) {
                    adjust = 1;
                    column = column > 127 ? (column -= 32) : (column -= 25);
                } else {
                    adjust = 0;
                    column -= 126;
                }
                row = row < 160 ? (row - 112 << 1) - adjust : (row - 176 << 1) - adjust;
                column = 32;
                if ((row -= 32) < JP_FREQ.length && column < JP_FREQ[row].length && JP_FREQ[row][column] != 0) {
                    jpfreq += (long)JP_FREQ[row][column];
                }
                ++i;
                continue;
            }
            if (-95 <= rawtext[i] && rawtext[i] > -33) continue;
        }
        float rangeval = 50.0f * ((float)jpchars / (float)dbchars);
        float freqval = 50.0f * ((float)jpfreq / (float)totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    /*
     * Opcode count of 19857 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        BytesDetector.GB_FREQ[20][35] = 599;
        BytesDetector.GB_FREQ[49][26] = 598;
        BytesDetector.GB_FREQ[41][38] = 597;
        BytesDetector.GB_FREQ[17][26] = 596;
        BytesDetector.GB_FREQ[32][42] = 595;
        BytesDetector.GB_FREQ[39][42] = 594;
        BytesDetector.GB_FREQ[45][49] = 593;
        BytesDetector.GB_FREQ[51][57] = 592;
        BytesDetector.GB_FREQ[50][47] = 591;
        BytesDetector.GB_FREQ[42][90] = 590;
        BytesDetector.GB_FREQ[52][65] = 589;
        BytesDetector.GB_FREQ[53][47] = 588;
        BytesDetector.GB_FREQ[19][82] = 587;
        BytesDetector.GB_FREQ[31][19] = 586;
        BytesDetector.GB_FREQ[40][46] = 585;
        BytesDetector.GB_FREQ[24][89] = 584;
        BytesDetector.GB_FREQ[23][85] = 583;
        BytesDetector.GB_FREQ[20][28] = 582;
        BytesDetector.GB_FREQ[42][20] = 581;
        BytesDetector.GB_FREQ[34][38] = 580;
        BytesDetector.GB_FREQ[45][9] = 579;
        BytesDetector.GB_FREQ[54][50] = 578;
        BytesDetector.GB_FREQ[25][44] = 577;
        BytesDetector.GB_FREQ[35][66] = 576;
        BytesDetector.GB_FREQ[20][55] = 575;
        BytesDetector.GB_FREQ[18][85] = 574;
        BytesDetector.GB_FREQ[20][31] = 573;
        BytesDetector.GB_FREQ[49][17] = 572;
        BytesDetector.GB_FREQ[41][16] = 571;
        BytesDetector.GB_FREQ[35][73] = 570;
        BytesDetector.GB_FREQ[20][34] = 569;
        BytesDetector.GB_FREQ[29][44] = 568;
        BytesDetector.GB_FREQ[35][38] = 567;
        BytesDetector.GB_FREQ[49][9] = 566;
        BytesDetector.GB_FREQ[46][33] = 565;
        BytesDetector.GB_FREQ[49][51] = 564;
        BytesDetector.GB_FREQ[40][89] = 563;
        BytesDetector.GB_FREQ[26][64] = 562;
        BytesDetector.GB_FREQ[54][51] = 561;
        BytesDetector.GB_FREQ[54][36] = 560;
        BytesDetector.GB_FREQ[39][4] = 559;
        BytesDetector.GB_FREQ[53][13] = 558;
        BytesDetector.GB_FREQ[24][92] = 557;
        BytesDetector.GB_FREQ[27][49] = 556;
        BytesDetector.GB_FREQ[48][6] = 555;
        BytesDetector.GB_FREQ[21][51] = 554;
        BytesDetector.GB_FREQ[30][40] = 553;
        BytesDetector.GB_FREQ[42][92] = 552;
        BytesDetector.GB_FREQ[31][78] = 551;
        BytesDetector.GB_FREQ[25][82] = 550;
        BytesDetector.GB_FREQ[47][0] = 549;
        BytesDetector.GB_FREQ[34][19] = 548;
        BytesDetector.GB_FREQ[47][35] = 547;
        BytesDetector.GB_FREQ[21][63] = 546;
        BytesDetector.GB_FREQ[43][75] = 545;
        BytesDetector.GB_FREQ[21][87] = 544;
        BytesDetector.GB_FREQ[35][59] = 543;
        BytesDetector.GB_FREQ[25][34] = 542;
        BytesDetector.GB_FREQ[21][27] = 541;
        BytesDetector.GB_FREQ[39][26] = 540;
        BytesDetector.GB_FREQ[34][26] = 539;
        BytesDetector.GB_FREQ[39][52] = 538;
        BytesDetector.GB_FREQ[50][57] = 537;
        BytesDetector.GB_FREQ[37][79] = 536;
        BytesDetector.GB_FREQ[26][24] = 535;
        BytesDetector.GB_FREQ[22][1] = 534;
        BytesDetector.GB_FREQ[18][40] = 533;
        BytesDetector.GB_FREQ[41][33] = 532;
        BytesDetector.GB_FREQ[53][26] = 531;
        BytesDetector.GB_FREQ[54][86] = 530;
        BytesDetector.GB_FREQ[20][16] = 529;
        BytesDetector.GB_FREQ[46][74] = 528;
        BytesDetector.GB_FREQ[30][19] = 527;
        BytesDetector.GB_FREQ[45][35] = 526;
        BytesDetector.GB_FREQ[45][61] = 525;
        BytesDetector.GB_FREQ[30][9] = 524;
        BytesDetector.GB_FREQ[41][53] = 523;
        BytesDetector.GB_FREQ[41][13] = 522;
        BytesDetector.GB_FREQ[50][34] = 521;
        BytesDetector.GB_FREQ[53][86] = 520;
        BytesDetector.GB_FREQ[47][47] = 519;
        BytesDetector.GB_FREQ[22][28] = 518;
        BytesDetector.GB_FREQ[50][53] = 517;
        BytesDetector.GB_FREQ[39][70] = 516;
        BytesDetector.GB_FREQ[38][15] = 515;
        BytesDetector.GB_FREQ[42][88] = 514;
        BytesDetector.GB_FREQ[16][29] = 513;
        BytesDetector.GB_FREQ[27][90] = 512;
        BytesDetector.GB_FREQ[29][12] = 511;
        BytesDetector.GB_FREQ[44][22] = 510;
        BytesDetector.GB_FREQ[34][69] = 509;
        BytesDetector.GB_FREQ[24][10] = 508;
        BytesDetector.GB_FREQ[44][11] = 507;
        BytesDetector.GB_FREQ[39][92] = 506;
        BytesDetector.GB_FREQ[49][48] = 505;
        BytesDetector.GB_FREQ[31][46] = 504;
        BytesDetector.GB_FREQ[19][50] = 503;
        BytesDetector.GB_FREQ[21][14] = 502;
        BytesDetector.GB_FREQ[32][28] = 501;
        BytesDetector.GB_FREQ[18][3] = 500;
        BytesDetector.GB_FREQ[53][9] = 499;
        BytesDetector.GB_FREQ[34][80] = 498;
        BytesDetector.GB_FREQ[48][88] = 497;
        BytesDetector.GB_FREQ[46][53] = 496;
        BytesDetector.GB_FREQ[22][53] = 495;
        BytesDetector.GB_FREQ[28][10] = 494;
        BytesDetector.GB_FREQ[44][65] = 493;
        BytesDetector.GB_FREQ[20][10] = 492;
        BytesDetector.GB_FREQ[40][76] = 491;
        BytesDetector.GB_FREQ[47][8] = 490;
        BytesDetector.GB_FREQ[50][74] = 489;
        BytesDetector.GB_FREQ[23][62] = 488;
        BytesDetector.GB_FREQ[49][65] = 487;
        BytesDetector.GB_FREQ[28][87] = 486;
        BytesDetector.GB_FREQ[15][48] = 485;
        BytesDetector.GB_FREQ[22][7] = 484;
        BytesDetector.GB_FREQ[19][42] = 483;
        BytesDetector.GB_FREQ[41][20] = 482;
        BytesDetector.GB_FREQ[26][55] = 481;
        BytesDetector.GB_FREQ[21][93] = 480;
        BytesDetector.GB_FREQ[31][76] = 479;
        BytesDetector.GB_FREQ[34][31] = 478;
        BytesDetector.GB_FREQ[20][66] = 477;
        BytesDetector.GB_FREQ[51][33] = 476;
        BytesDetector.GB_FREQ[34][86] = 475;
        BytesDetector.GB_FREQ[37][67] = 474;
        BytesDetector.GB_FREQ[53][53] = 473;
        BytesDetector.GB_FREQ[40][88] = 472;
        BytesDetector.GB_FREQ[39][10] = 471;
        BytesDetector.GB_FREQ[24][3] = 470;
        BytesDetector.GB_FREQ[27][25] = 469;
        BytesDetector.GB_FREQ[26][15] = 468;
        BytesDetector.GB_FREQ[21][88] = 467;
        BytesDetector.GB_FREQ[52][62] = 466;
        BytesDetector.GB_FREQ[46][81] = 465;
        BytesDetector.GB_FREQ[38][72] = 464;
        BytesDetector.GB_FREQ[17][30] = 463;
        BytesDetector.GB_FREQ[52][92] = 462;
        BytesDetector.GB_FREQ[34][90] = 461;
        BytesDetector.GB_FREQ[21][7] = 460;
        BytesDetector.GB_FREQ[36][13] = 459;
        BytesDetector.GB_FREQ[45][41] = 458;
        BytesDetector.GB_FREQ[32][5] = 457;
        BytesDetector.GB_FREQ[26][89] = 456;
        BytesDetector.GB_FREQ[23][87] = 455;
        BytesDetector.GB_FREQ[20][39] = 454;
        BytesDetector.GB_FREQ[27][23] = 453;
        BytesDetector.GB_FREQ[25][59] = 452;
        BytesDetector.GB_FREQ[49][20] = 451;
        BytesDetector.GB_FREQ[54][77] = 450;
        BytesDetector.GB_FREQ[27][67] = 449;
        BytesDetector.GB_FREQ[47][33] = 448;
        BytesDetector.GB_FREQ[41][17] = 447;
        BytesDetector.GB_FREQ[19][81] = 446;
        BytesDetector.GB_FREQ[16][66] = 445;
        BytesDetector.GB_FREQ[45][26] = 444;
        BytesDetector.GB_FREQ[49][81] = 443;
        BytesDetector.GB_FREQ[53][55] = 442;
        BytesDetector.GB_FREQ[16][26] = 441;
        BytesDetector.GB_FREQ[54][62] = 440;
        BytesDetector.GB_FREQ[20][70] = 439;
        BytesDetector.GB_FREQ[42][35] = 438;
        BytesDetector.GB_FREQ[20][57] = 437;
        BytesDetector.GB_FREQ[34][36] = 436;
        BytesDetector.GB_FREQ[46][63] = 435;
        BytesDetector.GB_FREQ[19][45] = 434;
        BytesDetector.GB_FREQ[21][10] = 433;
        BytesDetector.GB_FREQ[52][93] = 432;
        BytesDetector.GB_FREQ[25][2] = 431;
        BytesDetector.GB_FREQ[30][57] = 430;
        BytesDetector.GB_FREQ[41][24] = 429;
        BytesDetector.GB_FREQ[28][43] = 428;
        BytesDetector.GB_FREQ[45][86] = 427;
        BytesDetector.GB_FREQ[51][56] = 426;
        BytesDetector.GB_FREQ[37][28] = 425;
        BytesDetector.GB_FREQ[52][69] = 424;
        BytesDetector.GB_FREQ[43][92] = 423;
        BytesDetector.GB_FREQ[41][31] = 422;
        BytesDetector.GB_FREQ[37][87] = 421;
        BytesDetector.GB_FREQ[47][36] = 420;
        BytesDetector.GB_FREQ[16][16] = 419;
        BytesDetector.GB_FREQ[40][56] = 418;
        BytesDetector.GB_FREQ[24][55] = 417;
        BytesDetector.GB_FREQ[17][1] = 416;
        BytesDetector.GB_FREQ[35][57] = 415;
        BytesDetector.GB_FREQ[27][50] = 414;
        BytesDetector.GB_FREQ[26][14] = 413;
        BytesDetector.GB_FREQ[50][40] = 412;
        BytesDetector.GB_FREQ[39][19] = 411;
        BytesDetector.GB_FREQ[19][89] = 410;
        BytesDetector.GB_FREQ[29][91] = 409;
        BytesDetector.GB_FREQ[17][89] = 408;
        BytesDetector.GB_FREQ[39][74] = 407;
        BytesDetector.GB_FREQ[46][39] = 406;
        BytesDetector.GB_FREQ[40][28] = 405;
        BytesDetector.GB_FREQ[45][68] = 404;
        BytesDetector.GB_FREQ[43][10] = 403;
        BytesDetector.GB_FREQ[42][13] = 402;
        BytesDetector.GB_FREQ[44][81] = 401;
        BytesDetector.GB_FREQ[41][47] = 400;
        BytesDetector.GB_FREQ[48][58] = 399;
        BytesDetector.GB_FREQ[43][68] = 398;
        BytesDetector.GB_FREQ[16][79] = 397;
        BytesDetector.GB_FREQ[19][5] = 396;
        BytesDetector.GB_FREQ[54][59] = 395;
        BytesDetector.GB_FREQ[17][36] = 394;
        BytesDetector.GB_FREQ[18][0] = 393;
        BytesDetector.GB_FREQ[41][5] = 392;
        BytesDetector.GB_FREQ[41][72] = 391;
        BytesDetector.GB_FREQ[16][39] = 390;
        BytesDetector.GB_FREQ[54][0] = 389;
        BytesDetector.GB_FREQ[51][16] = 388;
        BytesDetector.GB_FREQ[29][36] = 387;
        BytesDetector.GB_FREQ[47][5] = 386;
        BytesDetector.GB_FREQ[47][51] = 385;
        BytesDetector.GB_FREQ[44][7] = 384;
        BytesDetector.GB_FREQ[35][30] = 383;
        BytesDetector.GB_FREQ[26][9] = 382;
        BytesDetector.GB_FREQ[16][7] = 381;
        BytesDetector.GB_FREQ[32][1] = 380;
        BytesDetector.GB_FREQ[33][76] = 379;
        BytesDetector.GB_FREQ[34][91] = 378;
        BytesDetector.GB_FREQ[52][36] = 377;
        BytesDetector.GB_FREQ[26][77] = 376;
        BytesDetector.GB_FREQ[35][48] = 375;
        BytesDetector.GB_FREQ[40][80] = 374;
        BytesDetector.GB_FREQ[41][92] = 373;
        BytesDetector.GB_FREQ[27][93] = 372;
        BytesDetector.GB_FREQ[15][17] = 371;
        BytesDetector.GB_FREQ[16][76] = 370;
        BytesDetector.GB_FREQ[51][12] = 369;
        BytesDetector.GB_FREQ[18][20] = 368;
        BytesDetector.GB_FREQ[15][54] = 367;
        BytesDetector.GB_FREQ[50][5] = 366;
        BytesDetector.GB_FREQ[33][22] = 365;
        BytesDetector.GB_FREQ[37][57] = 364;
        BytesDetector.GB_FREQ[28][47] = 363;
        BytesDetector.GB_FREQ[42][31] = 362;
        BytesDetector.GB_FREQ[18][2] = 361;
        BytesDetector.GB_FREQ[43][64] = 360;
        BytesDetector.GB_FREQ[23][47] = 359;
        BytesDetector.GB_FREQ[28][79] = 358;
        BytesDetector.GB_FREQ[25][45] = 357;
        BytesDetector.GB_FREQ[23][91] = 356;
        BytesDetector.GB_FREQ[22][19] = 355;
        BytesDetector.GB_FREQ[25][46] = 354;
        BytesDetector.GB_FREQ[22][36] = 353;
        BytesDetector.GB_FREQ[54][85] = 352;
        BytesDetector.GB_FREQ[46][20] = 351;
        BytesDetector.GB_FREQ[27][37] = 350;
        BytesDetector.GB_FREQ[26][81] = 349;
        BytesDetector.GB_FREQ[42][29] = 348;
        BytesDetector.GB_FREQ[31][90] = 347;
        BytesDetector.GB_FREQ[41][59] = 346;
        BytesDetector.GB_FREQ[24][65] = 345;
        BytesDetector.GB_FREQ[44][84] = 344;
        BytesDetector.GB_FREQ[24][90] = 343;
        BytesDetector.GB_FREQ[38][54] = 342;
        BytesDetector.GB_FREQ[28][70] = 341;
        BytesDetector.GB_FREQ[27][15] = 340;
        BytesDetector.GB_FREQ[28][80] = 339;
        BytesDetector.GB_FREQ[29][8] = 338;
        BytesDetector.GB_FREQ[45][80] = 337;
        BytesDetector.GB_FREQ[53][37] = 336;
        BytesDetector.GB_FREQ[28][65] = 335;
        BytesDetector.GB_FREQ[23][86] = 334;
        BytesDetector.GB_FREQ[39][45] = 333;
        BytesDetector.GB_FREQ[53][32] = 332;
        BytesDetector.GB_FREQ[38][68] = 331;
        BytesDetector.GB_FREQ[45][78] = 330;
        BytesDetector.GB_FREQ[43][7] = 329;
        BytesDetector.GB_FREQ[46][82] = 328;
        BytesDetector.GB_FREQ[27][38] = 327;
        BytesDetector.GB_FREQ[16][62] = 326;
        BytesDetector.GB_FREQ[24][17] = 325;
        BytesDetector.GB_FREQ[22][70] = 324;
        BytesDetector.GB_FREQ[52][28] = 323;
        BytesDetector.GB_FREQ[23][40] = 322;
        BytesDetector.GB_FREQ[28][50] = 321;
        BytesDetector.GB_FREQ[42][91] = 320;
        BytesDetector.GB_FREQ[47][76] = 319;
        BytesDetector.GB_FREQ[15][42] = 318;
        BytesDetector.GB_FREQ[43][55] = 317;
        BytesDetector.GB_FREQ[29][84] = 316;
        BytesDetector.GB_FREQ[44][90] = 315;
        BytesDetector.GB_FREQ[53][16] = 314;
        BytesDetector.GB_FREQ[22][93] = 313;
        BytesDetector.GB_FREQ[34][10] = 312;
        BytesDetector.GB_FREQ[32][53] = 311;
        BytesDetector.GB_FREQ[43][65] = 310;
        BytesDetector.GB_FREQ[28][7] = 309;
        BytesDetector.GB_FREQ[35][46] = 308;
        BytesDetector.GB_FREQ[21][39] = 307;
        BytesDetector.GB_FREQ[44][18] = 306;
        BytesDetector.GB_FREQ[40][10] = 305;
        BytesDetector.GB_FREQ[54][53] = 304;
        BytesDetector.GB_FREQ[38][74] = 303;
        BytesDetector.GB_FREQ[28][26] = 302;
        BytesDetector.GB_FREQ[15][13] = 301;
        BytesDetector.GB_FREQ[39][34] = 300;
        BytesDetector.GB_FREQ[39][46] = 299;
        BytesDetector.GB_FREQ[42][66] = 298;
        BytesDetector.GB_FREQ[33][58] = 297;
        BytesDetector.GB_FREQ[15][56] = 296;
        BytesDetector.GB_FREQ[18][51] = 295;
        BytesDetector.GB_FREQ[49][68] = 294;
        BytesDetector.GB_FREQ[30][37] = 293;
        BytesDetector.GB_FREQ[51][84] = 292;
        BytesDetector.GB_FREQ[51][9] = 291;
        BytesDetector.GB_FREQ[40][70] = 290;
        BytesDetector.GB_FREQ[41][84] = 289;
        BytesDetector.GB_FREQ[28][64] = 288;
        BytesDetector.GB_FREQ[32][88] = 287;
        BytesDetector.GB_FREQ[24][5] = 286;
        BytesDetector.GB_FREQ[53][23] = 285;
        BytesDetector.GB_FREQ[42][27] = 284;
        BytesDetector.GB_FREQ[22][38] = 283;
        BytesDetector.GB_FREQ[32][86] = 282;
        BytesDetector.GB_FREQ[34][30] = 281;
        BytesDetector.GB_FREQ[38][63] = 280;
        BytesDetector.GB_FREQ[24][59] = 279;
        BytesDetector.GB_FREQ[22][81] = 278;
        BytesDetector.GB_FREQ[32][11] = 277;
        BytesDetector.GB_FREQ[51][21] = 276;
        BytesDetector.GB_FREQ[54][41] = 275;
        BytesDetector.GB_FREQ[21][50] = 274;
        BytesDetector.GB_FREQ[23][89] = 273;
        BytesDetector.GB_FREQ[19][87] = 272;
        BytesDetector.GB_FREQ[26][7] = 271;
        BytesDetector.GB_FREQ[30][75] = 270;
        BytesDetector.GB_FREQ[43][84] = 269;
        BytesDetector.GB_FREQ[51][25] = 268;
        BytesDetector.GB_FREQ[16][67] = 267;
        BytesDetector.GB_FREQ[32][9] = 266;
        BytesDetector.GB_FREQ[48][51] = 265;
        BytesDetector.GB_FREQ[39][7] = 264;
        BytesDetector.GB_FREQ[44][88] = 263;
        BytesDetector.GB_FREQ[52][24] = 262;
        BytesDetector.GB_FREQ[23][34] = 261;
        BytesDetector.GB_FREQ[32][75] = 260;
        BytesDetector.GB_FREQ[19][10] = 259;
        BytesDetector.GB_FREQ[28][91] = 258;
        BytesDetector.GB_FREQ[32][83] = 257;
        BytesDetector.GB_FREQ[25][75] = 256;
        BytesDetector.GB_FREQ[53][45] = 255;
        BytesDetector.GB_FREQ[29][85] = 254;
        BytesDetector.GB_FREQ[53][59] = 253;
        BytesDetector.GB_FREQ[16][2] = 252;
        BytesDetector.GB_FREQ[19][78] = 251;
        BytesDetector.GB_FREQ[15][75] = 250;
        BytesDetector.GB_FREQ[51][42] = 249;
        BytesDetector.GB_FREQ[45][67] = 248;
        BytesDetector.GB_FREQ[15][74] = 247;
        BytesDetector.GB_FREQ[25][81] = 246;
        BytesDetector.GB_FREQ[37][62] = 245;
        BytesDetector.GB_FREQ[16][55] = 244;
        BytesDetector.GB_FREQ[18][38] = 243;
        BytesDetector.GB_FREQ[23][23] = 242;
        BytesDetector.GB_FREQ[38][30] = 241;
        BytesDetector.GB_FREQ[17][28] = 240;
        BytesDetector.GB_FREQ[44][73] = 239;
        BytesDetector.GB_FREQ[23][78] = 238;
        BytesDetector.GB_FREQ[40][77] = 237;
        BytesDetector.GB_FREQ[38][87] = 236;
        BytesDetector.GB_FREQ[27][19] = 235;
        BytesDetector.GB_FREQ[38][82] = 234;
        BytesDetector.GB_FREQ[37][22] = 233;
        BytesDetector.GB_FREQ[41][30] = 232;
        BytesDetector.GB_FREQ[54][9] = 231;
        BytesDetector.GB_FREQ[32][30] = 230;
        BytesDetector.GB_FREQ[30][52] = 229;
        BytesDetector.GB_FREQ[40][84] = 228;
        BytesDetector.GB_FREQ[53][57] = 227;
        BytesDetector.GB_FREQ[27][27] = 226;
        BytesDetector.GB_FREQ[38][64] = 225;
        BytesDetector.GB_FREQ[18][43] = 224;
        BytesDetector.GB_FREQ[23][69] = 223;
        BytesDetector.GB_FREQ[28][12] = 222;
        BytesDetector.GB_FREQ[50][78] = 221;
        BytesDetector.GB_FREQ[50][1] = 220;
        BytesDetector.GB_FREQ[26][88] = 219;
        BytesDetector.GB_FREQ[36][40] = 218;
        BytesDetector.GB_FREQ[33][89] = 217;
        BytesDetector.GB_FREQ[41][28] = 216;
        BytesDetector.GB_FREQ[31][77] = 215;
        BytesDetector.GB_FREQ[46][1] = 214;
        BytesDetector.GB_FREQ[47][19] = 213;
        BytesDetector.GB_FREQ[35][55] = 212;
        BytesDetector.GB_FREQ[41][21] = 211;
        BytesDetector.GB_FREQ[27][10] = 210;
        BytesDetector.GB_FREQ[32][77] = 209;
        BytesDetector.GB_FREQ[26][37] = 208;
        BytesDetector.GB_FREQ[20][33] = 207;
        BytesDetector.GB_FREQ[41][52] = 206;
        BytesDetector.GB_FREQ[32][18] = 205;
        BytesDetector.GB_FREQ[38][13] = 204;
        BytesDetector.GB_FREQ[20][18] = 203;
        BytesDetector.GB_FREQ[20][24] = 202;
        BytesDetector.GB_FREQ[45][19] = 201;
        BytesDetector.GB_FREQ[18][53] = 200;
        BytesDetector.BIG5_FREQ[9][89] = 600;
        BytesDetector.BIG5_FREQ[11][15] = 599;
        BytesDetector.BIG5_FREQ[3][66] = 598;
        BytesDetector.BIG5_FREQ[6][121] = 597;
        BytesDetector.BIG5_FREQ[3][0] = 596;
        BytesDetector.BIG5_FREQ[5][82] = 595;
        BytesDetector.BIG5_FREQ[3][42] = 594;
        BytesDetector.BIG5_FREQ[5][34] = 593;
        BytesDetector.BIG5_FREQ[3][8] = 592;
        BytesDetector.BIG5_FREQ[3][6] = 591;
        BytesDetector.BIG5_FREQ[3][67] = 590;
        BytesDetector.BIG5_FREQ[7][139] = 589;
        BytesDetector.BIG5_FREQ[23][137] = 588;
        BytesDetector.BIG5_FREQ[12][46] = 587;
        BytesDetector.BIG5_FREQ[4][8] = 586;
        BytesDetector.BIG5_FREQ[4][41] = 585;
        BytesDetector.BIG5_FREQ[18][47] = 584;
        BytesDetector.BIG5_FREQ[12][114] = 583;
        BytesDetector.BIG5_FREQ[6][1] = 582;
        BytesDetector.BIG5_FREQ[22][60] = 581;
        BytesDetector.BIG5_FREQ[5][46] = 580;
        BytesDetector.BIG5_FREQ[11][79] = 579;
        BytesDetector.BIG5_FREQ[3][23] = 578;
        BytesDetector.BIG5_FREQ[7][114] = 577;
        BytesDetector.BIG5_FREQ[29][102] = 576;
        BytesDetector.BIG5_FREQ[19][14] = 575;
        BytesDetector.BIG5_FREQ[4][133] = 574;
        BytesDetector.BIG5_FREQ[3][29] = 573;
        BytesDetector.BIG5_FREQ[4][109] = 572;
        BytesDetector.BIG5_FREQ[14][127] = 571;
        BytesDetector.BIG5_FREQ[5][48] = 570;
        BytesDetector.BIG5_FREQ[13][104] = 569;
        BytesDetector.BIG5_FREQ[3][132] = 568;
        BytesDetector.BIG5_FREQ[26][64] = 567;
        BytesDetector.BIG5_FREQ[7][19] = 566;
        BytesDetector.BIG5_FREQ[4][12] = 565;
        BytesDetector.BIG5_FREQ[11][124] = 564;
        BytesDetector.BIG5_FREQ[7][89] = 563;
        BytesDetector.BIG5_FREQ[15][124] = 562;
        BytesDetector.BIG5_FREQ[4][108] = 561;
        BytesDetector.BIG5_FREQ[19][66] = 560;
        BytesDetector.BIG5_FREQ[3][21] = 559;
        BytesDetector.BIG5_FREQ[24][12] = 558;
        BytesDetector.BIG5_FREQ[28][111] = 557;
        BytesDetector.BIG5_FREQ[12][107] = 556;
        BytesDetector.BIG5_FREQ[3][112] = 555;
        BytesDetector.BIG5_FREQ[8][113] = 554;
        BytesDetector.BIG5_FREQ[5][40] = 553;
        BytesDetector.BIG5_FREQ[26][145] = 552;
        BytesDetector.BIG5_FREQ[3][48] = 551;
        BytesDetector.BIG5_FREQ[3][70] = 550;
        BytesDetector.BIG5_FREQ[22][17] = 549;
        BytesDetector.BIG5_FREQ[16][47] = 548;
        BytesDetector.BIG5_FREQ[3][53] = 547;
        BytesDetector.BIG5_FREQ[4][24] = 546;
        BytesDetector.BIG5_FREQ[32][120] = 545;
        BytesDetector.BIG5_FREQ[24][49] = 544;
        BytesDetector.BIG5_FREQ[24][142] = 543;
        BytesDetector.BIG5_FREQ[18][66] = 542;
        BytesDetector.BIG5_FREQ[29][150] = 541;
        BytesDetector.BIG5_FREQ[5][122] = 540;
        BytesDetector.BIG5_FREQ[5][114] = 539;
        BytesDetector.BIG5_FREQ[3][44] = 538;
        BytesDetector.BIG5_FREQ[10][128] = 537;
        BytesDetector.BIG5_FREQ[15][20] = 536;
        BytesDetector.BIG5_FREQ[13][33] = 535;
        BytesDetector.BIG5_FREQ[14][87] = 534;
        BytesDetector.BIG5_FREQ[3][126] = 533;
        BytesDetector.BIG5_FREQ[4][53] = 532;
        BytesDetector.BIG5_FREQ[4][40] = 531;
        BytesDetector.BIG5_FREQ[9][93] = 530;
        BytesDetector.BIG5_FREQ[15][137] = 529;
        BytesDetector.BIG5_FREQ[10][123] = 528;
        BytesDetector.BIG5_FREQ[4][56] = 527;
        BytesDetector.BIG5_FREQ[5][71] = 526;
        BytesDetector.BIG5_FREQ[10][8] = 525;
        BytesDetector.BIG5_FREQ[5][16] = 524;
        BytesDetector.BIG5_FREQ[5][146] = 523;
        BytesDetector.BIG5_FREQ[18][88] = 522;
        BytesDetector.BIG5_FREQ[24][4] = 521;
        BytesDetector.BIG5_FREQ[20][47] = 520;
        BytesDetector.BIG5_FREQ[5][33] = 519;
        BytesDetector.BIG5_FREQ[9][43] = 518;
        BytesDetector.BIG5_FREQ[20][12] = 517;
        BytesDetector.BIG5_FREQ[20][13] = 516;
        BytesDetector.BIG5_FREQ[5][156] = 515;
        BytesDetector.BIG5_FREQ[22][140] = 514;
        BytesDetector.BIG5_FREQ[8][146] = 513;
        BytesDetector.BIG5_FREQ[21][123] = 512;
        BytesDetector.BIG5_FREQ[4][90] = 511;
        BytesDetector.BIG5_FREQ[5][62] = 510;
        BytesDetector.BIG5_FREQ[17][59] = 509;
        BytesDetector.BIG5_FREQ[10][37] = 508;
        BytesDetector.BIG5_FREQ[18][107] = 507;
        BytesDetector.BIG5_FREQ[14][53] = 506;
        BytesDetector.BIG5_FREQ[22][51] = 505;
        BytesDetector.BIG5_FREQ[8][13] = 504;
        BytesDetector.BIG5_FREQ[5][29] = 503;
        BytesDetector.BIG5_FREQ[9][7] = 502;
        BytesDetector.BIG5_FREQ[22][14] = 501;
        BytesDetector.BIG5_FREQ[8][55] = 500;
        BytesDetector.BIG5_FREQ[33][9] = 499;
        BytesDetector.BIG5_FREQ[16][64] = 498;
        BytesDetector.BIG5_FREQ[7][131] = 497;
        BytesDetector.BIG5_FREQ[34][4] = 496;
        BytesDetector.BIG5_FREQ[7][101] = 495;
        BytesDetector.BIG5_FREQ[11][139] = 494;
        BytesDetector.BIG5_FREQ[3][135] = 493;
        BytesDetector.BIG5_FREQ[7][102] = 492;
        BytesDetector.BIG5_FREQ[17][13] = 491;
        BytesDetector.BIG5_FREQ[3][20] = 490;
        BytesDetector.BIG5_FREQ[27][106] = 489;
        BytesDetector.BIG5_FREQ[5][88] = 488;
        BytesDetector.BIG5_FREQ[6][33] = 487;
        BytesDetector.BIG5_FREQ[5][139] = 486;
        BytesDetector.BIG5_FREQ[6][0] = 485;
        BytesDetector.BIG5_FREQ[17][58] = 484;
        BytesDetector.BIG5_FREQ[5][133] = 483;
        BytesDetector.BIG5_FREQ[9][107] = 482;
        BytesDetector.BIG5_FREQ[23][39] = 481;
        BytesDetector.BIG5_FREQ[5][23] = 480;
        BytesDetector.BIG5_FREQ[3][79] = 479;
        BytesDetector.BIG5_FREQ[32][97] = 478;
        BytesDetector.BIG5_FREQ[3][136] = 477;
        BytesDetector.BIG5_FREQ[4][94] = 476;
        BytesDetector.BIG5_FREQ[21][61] = 475;
        BytesDetector.BIG5_FREQ[23][123] = 474;
        BytesDetector.BIG5_FREQ[26][16] = 473;
        BytesDetector.BIG5_FREQ[24][137] = 472;
        BytesDetector.BIG5_FREQ[22][18] = 471;
        BytesDetector.BIG5_FREQ[5][1] = 470;
        BytesDetector.BIG5_FREQ[20][119] = 469;
        BytesDetector.BIG5_FREQ[3][7] = 468;
        BytesDetector.BIG5_FREQ[10][79] = 467;
        BytesDetector.BIG5_FREQ[15][105] = 466;
        BytesDetector.BIG5_FREQ[3][144] = 465;
        BytesDetector.BIG5_FREQ[12][80] = 464;
        BytesDetector.BIG5_FREQ[15][73] = 463;
        BytesDetector.BIG5_FREQ[3][19] = 462;
        BytesDetector.BIG5_FREQ[8][109] = 461;
        BytesDetector.BIG5_FREQ[3][15] = 460;
        BytesDetector.BIG5_FREQ[31][82] = 459;
        BytesDetector.BIG5_FREQ[3][43] = 458;
        BytesDetector.BIG5_FREQ[25][119] = 457;
        BytesDetector.BIG5_FREQ[16][111] = 456;
        BytesDetector.BIG5_FREQ[7][77] = 455;
        BytesDetector.BIG5_FREQ[3][95] = 454;
        BytesDetector.BIG5_FREQ[24][82] = 453;
        BytesDetector.BIG5_FREQ[7][52] = 452;
        BytesDetector.BIG5_FREQ[9][151] = 451;
        BytesDetector.BIG5_FREQ[3][129] = 450;
        BytesDetector.BIG5_FREQ[5][87] = 449;
        BytesDetector.BIG5_FREQ[3][55] = 448;
        BytesDetector.BIG5_FREQ[8][153] = 447;
        BytesDetector.BIG5_FREQ[4][83] = 446;
        BytesDetector.BIG5_FREQ[3][114] = 445;
        BytesDetector.BIG5_FREQ[23][147] = 444;
        BytesDetector.BIG5_FREQ[15][31] = 443;
        BytesDetector.BIG5_FREQ[3][54] = 442;
        BytesDetector.BIG5_FREQ[11][122] = 441;
        BytesDetector.BIG5_FREQ[4][4] = 440;
        BytesDetector.BIG5_FREQ[34][149] = 439;
        BytesDetector.BIG5_FREQ[3][17] = 438;
        BytesDetector.BIG5_FREQ[21][64] = 437;
        BytesDetector.BIG5_FREQ[26][144] = 436;
        BytesDetector.BIG5_FREQ[4][62] = 435;
        BytesDetector.BIG5_FREQ[8][15] = 434;
        BytesDetector.BIG5_FREQ[35][80] = 433;
        BytesDetector.BIG5_FREQ[7][110] = 432;
        BytesDetector.BIG5_FREQ[23][114] = 431;
        BytesDetector.BIG5_FREQ[3][108] = 430;
        BytesDetector.BIG5_FREQ[3][62] = 429;
        BytesDetector.BIG5_FREQ[21][41] = 428;
        BytesDetector.BIG5_FREQ[15][99] = 427;
        BytesDetector.BIG5_FREQ[5][47] = 426;
        BytesDetector.BIG5_FREQ[4][96] = 425;
        BytesDetector.BIG5_FREQ[20][122] = 424;
        BytesDetector.BIG5_FREQ[5][21] = 423;
        BytesDetector.BIG5_FREQ[4][157] = 422;
        BytesDetector.BIG5_FREQ[16][14] = 421;
        BytesDetector.BIG5_FREQ[3][117] = 420;
        BytesDetector.BIG5_FREQ[7][129] = 419;
        BytesDetector.BIG5_FREQ[4][27] = 418;
        BytesDetector.BIG5_FREQ[5][30] = 417;
        BytesDetector.BIG5_FREQ[22][16] = 416;
        BytesDetector.BIG5_FREQ[5][64] = 415;
        BytesDetector.BIG5_FREQ[17][99] = 414;
        BytesDetector.BIG5_FREQ[17][57] = 413;
        BytesDetector.BIG5_FREQ[8][105] = 412;
        BytesDetector.BIG5_FREQ[5][112] = 411;
        BytesDetector.BIG5_FREQ[20][59] = 410;
        BytesDetector.BIG5_FREQ[6][129] = 409;
        BytesDetector.BIG5_FREQ[18][17] = 408;
        BytesDetector.BIG5_FREQ[3][92] = 407;
        BytesDetector.BIG5_FREQ[28][118] = 406;
        BytesDetector.BIG5_FREQ[3][109] = 405;
        BytesDetector.BIG5_FREQ[31][51] = 404;
        BytesDetector.BIG5_FREQ[13][116] = 403;
        BytesDetector.BIG5_FREQ[6][15] = 402;
        BytesDetector.BIG5_FREQ[36][136] = 401;
        BytesDetector.BIG5_FREQ[12][74] = 400;
        BytesDetector.BIG5_FREQ[20][88] = 399;
        BytesDetector.BIG5_FREQ[36][68] = 398;
        BytesDetector.BIG5_FREQ[3][147] = 397;
        BytesDetector.BIG5_FREQ[15][84] = 396;
        BytesDetector.BIG5_FREQ[16][32] = 395;
        BytesDetector.BIG5_FREQ[16][58] = 394;
        BytesDetector.BIG5_FREQ[7][66] = 393;
        BytesDetector.BIG5_FREQ[23][107] = 392;
        BytesDetector.BIG5_FREQ[9][6] = 391;
        BytesDetector.BIG5_FREQ[12][86] = 390;
        BytesDetector.BIG5_FREQ[23][112] = 389;
        BytesDetector.BIG5_FREQ[37][23] = 388;
        BytesDetector.BIG5_FREQ[3][138] = 387;
        BytesDetector.BIG5_FREQ[20][68] = 386;
        BytesDetector.BIG5_FREQ[15][116] = 385;
        BytesDetector.BIG5_FREQ[18][64] = 384;
        BytesDetector.BIG5_FREQ[12][139] = 383;
        BytesDetector.BIG5_FREQ[11][155] = 382;
        BytesDetector.BIG5_FREQ[4][156] = 381;
        BytesDetector.BIG5_FREQ[12][84] = 380;
        BytesDetector.BIG5_FREQ[18][49] = 379;
        BytesDetector.BIG5_FREQ[25][125] = 378;
        BytesDetector.BIG5_FREQ[25][147] = 377;
        BytesDetector.BIG5_FREQ[15][110] = 376;
        BytesDetector.BIG5_FREQ[19][96] = 375;
        BytesDetector.BIG5_FREQ[30][152] = 374;
        BytesDetector.BIG5_FREQ[6][31] = 373;
        BytesDetector.BIG5_FREQ[27][117] = 372;
        BytesDetector.BIG5_FREQ[3][10] = 371;
        BytesDetector.BIG5_FREQ[6][131] = 370;
        BytesDetector.BIG5_FREQ[13][112] = 369;
        BytesDetector.BIG5_FREQ[36][156] = 368;
        BytesDetector.BIG5_FREQ[4][60] = 367;
        BytesDetector.BIG5_FREQ[15][121] = 366;
        BytesDetector.BIG5_FREQ[4][112] = 365;
        BytesDetector.BIG5_FREQ[30][142] = 364;
        BytesDetector.BIG5_FREQ[23][154] = 363;
        BytesDetector.BIG5_FREQ[27][101] = 362;
        BytesDetector.BIG5_FREQ[9][140] = 361;
        BytesDetector.BIG5_FREQ[3][89] = 360;
        BytesDetector.BIG5_FREQ[18][148] = 359;
        BytesDetector.BIG5_FREQ[4][69] = 358;
        BytesDetector.BIG5_FREQ[16][49] = 357;
        BytesDetector.BIG5_FREQ[6][117] = 356;
        BytesDetector.BIG5_FREQ[36][55] = 355;
        BytesDetector.BIG5_FREQ[5][123] = 354;
        BytesDetector.BIG5_FREQ[4][126] = 353;
        BytesDetector.BIG5_FREQ[4][119] = 352;
        BytesDetector.BIG5_FREQ[9][95] = 351;
        BytesDetector.BIG5_FREQ[5][24] = 350;
        BytesDetector.BIG5_FREQ[16][133] = 349;
        BytesDetector.BIG5_FREQ[10][134] = 348;
        BytesDetector.BIG5_FREQ[26][59] = 347;
        BytesDetector.BIG5_FREQ[6][41] = 346;
        BytesDetector.BIG5_FREQ[6][146] = 345;
        BytesDetector.BIG5_FREQ[19][24] = 344;
        BytesDetector.BIG5_FREQ[5][113] = 343;
        BytesDetector.BIG5_FREQ[10][118] = 342;
        BytesDetector.BIG5_FREQ[34][151] = 341;
        BytesDetector.BIG5_FREQ[9][72] = 340;
        BytesDetector.BIG5_FREQ[31][25] = 339;
        BytesDetector.BIG5_FREQ[18][126] = 338;
        BytesDetector.BIG5_FREQ[18][28] = 337;
        BytesDetector.BIG5_FREQ[4][153] = 336;
        BytesDetector.BIG5_FREQ[3][84] = 335;
        BytesDetector.BIG5_FREQ[21][18] = 334;
        BytesDetector.BIG5_FREQ[25][129] = 333;
        BytesDetector.BIG5_FREQ[6][107] = 332;
        BytesDetector.BIG5_FREQ[12][25] = 331;
        BytesDetector.BIG5_FREQ[17][109] = 330;
        BytesDetector.BIG5_FREQ[7][76] = 329;
        BytesDetector.BIG5_FREQ[15][15] = 328;
        BytesDetector.BIG5_FREQ[4][14] = 327;
        BytesDetector.BIG5_FREQ[23][88] = 326;
        BytesDetector.BIG5_FREQ[18][2] = 325;
        BytesDetector.BIG5_FREQ[6][88] = 324;
        BytesDetector.BIG5_FREQ[16][84] = 323;
        BytesDetector.BIG5_FREQ[12][48] = 322;
        BytesDetector.BIG5_FREQ[7][68] = 321;
        BytesDetector.BIG5_FREQ[5][50] = 320;
        BytesDetector.BIG5_FREQ[13][54] = 319;
        BytesDetector.BIG5_FREQ[7][98] = 318;
        BytesDetector.BIG5_FREQ[11][6] = 317;
        BytesDetector.BIG5_FREQ[9][80] = 316;
        BytesDetector.BIG5_FREQ[16][41] = 315;
        BytesDetector.BIG5_FREQ[7][43] = 314;
        BytesDetector.BIG5_FREQ[28][117] = 313;
        BytesDetector.BIG5_FREQ[3][51] = 312;
        BytesDetector.BIG5_FREQ[7][3] = 311;
        BytesDetector.BIG5_FREQ[20][81] = 310;
        BytesDetector.BIG5_FREQ[4][2] = 309;
        BytesDetector.BIG5_FREQ[11][16] = 308;
        BytesDetector.BIG5_FREQ[10][4] = 307;
        BytesDetector.BIG5_FREQ[10][119] = 306;
        BytesDetector.BIG5_FREQ[6][142] = 305;
        BytesDetector.BIG5_FREQ[18][51] = 304;
        BytesDetector.BIG5_FREQ[8][144] = 303;
        BytesDetector.BIG5_FREQ[10][65] = 302;
        BytesDetector.BIG5_FREQ[11][64] = 301;
        BytesDetector.BIG5_FREQ[11][130] = 300;
        BytesDetector.BIG5_FREQ[9][92] = 299;
        BytesDetector.BIG5_FREQ[18][29] = 298;
        BytesDetector.BIG5_FREQ[18][78] = 297;
        BytesDetector.BIG5_FREQ[18][151] = 296;
        BytesDetector.BIG5_FREQ[33][127] = 295;
        BytesDetector.BIG5_FREQ[35][113] = 294;
        BytesDetector.BIG5_FREQ[10][155] = 293;
        BytesDetector.BIG5_FREQ[3][76] = 292;
        BytesDetector.BIG5_FREQ[36][123] = 291;
        BytesDetector.BIG5_FREQ[13][143] = 290;
        BytesDetector.BIG5_FREQ[5][135] = 289;
        BytesDetector.BIG5_FREQ[23][116] = 288;
        BytesDetector.BIG5_FREQ[6][101] = 287;
        BytesDetector.BIG5_FREQ[14][74] = 286;
        BytesDetector.BIG5_FREQ[7][153] = 285;
        BytesDetector.BIG5_FREQ[3][101] = 284;
        BytesDetector.BIG5_FREQ[9][74] = 283;
        BytesDetector.BIG5_FREQ[3][156] = 282;
        BytesDetector.BIG5_FREQ[4][147] = 281;
        BytesDetector.BIG5_FREQ[9][12] = 280;
        BytesDetector.BIG5_FREQ[18][133] = 279;
        BytesDetector.BIG5_FREQ[4][0] = 278;
        BytesDetector.BIG5_FREQ[7][155] = 277;
        BytesDetector.BIG5_FREQ[9][144] = 276;
        BytesDetector.BIG5_FREQ[23][49] = 275;
        BytesDetector.BIG5_FREQ[5][89] = 274;
        BytesDetector.BIG5_FREQ[10][11] = 273;
        BytesDetector.BIG5_FREQ[3][110] = 272;
        BytesDetector.BIG5_FREQ[3][40] = 271;
        BytesDetector.BIG5_FREQ[29][115] = 270;
        BytesDetector.BIG5_FREQ[9][100] = 269;
        BytesDetector.BIG5_FREQ[21][67] = 268;
        BytesDetector.BIG5_FREQ[23][145] = 267;
        BytesDetector.BIG5_FREQ[10][47] = 266;
        BytesDetector.BIG5_FREQ[4][31] = 265;
        BytesDetector.BIG5_FREQ[4][81] = 264;
        BytesDetector.BIG5_FREQ[22][62] = 263;
        BytesDetector.BIG5_FREQ[4][28] = 262;
        BytesDetector.BIG5_FREQ[27][39] = 261;
        BytesDetector.BIG5_FREQ[27][54] = 260;
        BytesDetector.BIG5_FREQ[32][46] = 259;
        BytesDetector.BIG5_FREQ[4][76] = 258;
        BytesDetector.BIG5_FREQ[26][15] = 257;
        BytesDetector.BIG5_FREQ[12][154] = 256;
        BytesDetector.BIG5_FREQ[9][150] = 255;
        BytesDetector.BIG5_FREQ[15][17] = 254;
        BytesDetector.BIG5_FREQ[5][129] = 253;
        BytesDetector.BIG5_FREQ[10][40] = 252;
        BytesDetector.BIG5_FREQ[13][37] = 251;
        BytesDetector.BIG5_FREQ[31][104] = 250;
        BytesDetector.BIG5_FREQ[3][152] = 249;
        BytesDetector.BIG5_FREQ[5][22] = 248;
        BytesDetector.BIG5_FREQ[8][48] = 247;
        BytesDetector.BIG5_FREQ[4][74] = 246;
        BytesDetector.BIG5_FREQ[6][17] = 245;
        BytesDetector.BIG5_FREQ[30][82] = 244;
        BytesDetector.BIG5_FREQ[4][116] = 243;
        BytesDetector.BIG5_FREQ[16][42] = 242;
        BytesDetector.BIG5_FREQ[5][55] = 241;
        BytesDetector.BIG5_FREQ[4][64] = 240;
        BytesDetector.BIG5_FREQ[14][19] = 239;
        BytesDetector.BIG5_FREQ[35][82] = 238;
        BytesDetector.BIG5_FREQ[30][139] = 237;
        BytesDetector.BIG5_FREQ[26][152] = 236;
        BytesDetector.BIG5_FREQ[32][32] = 235;
        BytesDetector.BIG5_FREQ[21][102] = 234;
        BytesDetector.BIG5_FREQ[10][131] = 233;
        BytesDetector.BIG5_FREQ[9][128] = 232;
        BytesDetector.BIG5_FREQ[3][87] = 231;
        BytesDetector.BIG5_FREQ[4][51] = 230;
        BytesDetector.BIG5_FREQ[10][15] = 229;
        BytesDetector.BIG5_FREQ[4][150] = 228;
        BytesDetector.BIG5_FREQ[7][4] = 227;
        BytesDetector.BIG5_FREQ[7][51] = 226;
        BytesDetector.BIG5_FREQ[7][157] = 225;
        BytesDetector.BIG5_FREQ[4][146] = 224;
        BytesDetector.BIG5_FREQ[4][91] = 223;
        BytesDetector.BIG5_FREQ[7][13] = 222;
        BytesDetector.BIG5_FREQ[17][116] = 221;
        BytesDetector.BIG5_FREQ[23][21] = 220;
        BytesDetector.BIG5_FREQ[5][106] = 219;
        BytesDetector.BIG5_FREQ[14][100] = 218;
        BytesDetector.BIG5_FREQ[10][152] = 217;
        BytesDetector.BIG5_FREQ[14][89] = 216;
        BytesDetector.BIG5_FREQ[6][138] = 215;
        BytesDetector.BIG5_FREQ[12][157] = 214;
        BytesDetector.BIG5_FREQ[10][102] = 213;
        BytesDetector.BIG5_FREQ[19][94] = 212;
        BytesDetector.BIG5_FREQ[7][74] = 211;
        BytesDetector.BIG5_FREQ[18][128] = 210;
        BytesDetector.BIG5_FREQ[27][111] = 209;
        BytesDetector.BIG5_FREQ[11][57] = 208;
        BytesDetector.BIG5_FREQ[3][131] = 207;
        BytesDetector.BIG5_FREQ[30][23] = 206;
        BytesDetector.BIG5_FREQ[30][126] = 205;
        BytesDetector.BIG5_FREQ[4][36] = 204;
        BytesDetector.BIG5_FREQ[26][124] = 203;
        BytesDetector.BIG5_FREQ[4][19] = 202;
        BytesDetector.BIG5_FREQ[9][152] = 201;
        BytesDetector.BIG5P_FREQ[41][122] = 600;
        BytesDetector.BIG5P_FREQ[35][0] = 599;
        BytesDetector.BIG5P_FREQ[43][15] = 598;
        BytesDetector.BIG5P_FREQ[35][99] = 597;
        BytesDetector.BIG5P_FREQ[35][6] = 596;
        BytesDetector.BIG5P_FREQ[35][8] = 595;
        BytesDetector.BIG5P_FREQ[38][154] = 594;
        BytesDetector.BIG5P_FREQ[37][34] = 593;
        BytesDetector.BIG5P_FREQ[37][115] = 592;
        BytesDetector.BIG5P_FREQ[36][12] = 591;
        BytesDetector.BIG5P_FREQ[18][77] = 590;
        BytesDetector.BIG5P_FREQ[35][100] = 589;
        BytesDetector.BIG5P_FREQ[35][42] = 588;
        BytesDetector.BIG5P_FREQ[120][75] = 587;
        BytesDetector.BIG5P_FREQ[35][23] = 586;
        BytesDetector.BIG5P_FREQ[13][72] = 585;
        BytesDetector.BIG5P_FREQ[0][67] = 584;
        BytesDetector.BIG5P_FREQ[39][172] = 583;
        BytesDetector.BIG5P_FREQ[22][182] = 582;
        BytesDetector.BIG5P_FREQ[15][186] = 581;
        BytesDetector.BIG5P_FREQ[15][165] = 580;
        BytesDetector.BIG5P_FREQ[35][44] = 579;
        BytesDetector.BIG5P_FREQ[40][13] = 578;
        BytesDetector.BIG5P_FREQ[38][1] = 577;
        BytesDetector.BIG5P_FREQ[37][33] = 576;
        BytesDetector.BIG5P_FREQ[36][24] = 575;
        BytesDetector.BIG5P_FREQ[56][4] = 574;
        BytesDetector.BIG5P_FREQ[35][29] = 573;
        BytesDetector.BIG5P_FREQ[9][96] = 572;
        BytesDetector.BIG5P_FREQ[37][62] = 571;
        BytesDetector.BIG5P_FREQ[48][47] = 570;
        BytesDetector.BIG5P_FREQ[51][14] = 569;
        BytesDetector.BIG5P_FREQ[39][122] = 568;
        BytesDetector.BIG5P_FREQ[44][46] = 567;
        BytesDetector.BIG5P_FREQ[35][21] = 566;
        BytesDetector.BIG5P_FREQ[36][8] = 565;
        BytesDetector.BIG5P_FREQ[36][141] = 564;
        BytesDetector.BIG5P_FREQ[3][81] = 563;
        BytesDetector.BIG5P_FREQ[37][155] = 562;
        BytesDetector.BIG5P_FREQ[42][84] = 561;
        BytesDetector.BIG5P_FREQ[36][40] = 560;
        BytesDetector.BIG5P_FREQ[35][103] = 559;
        BytesDetector.BIG5P_FREQ[11][84] = 558;
        BytesDetector.BIG5P_FREQ[45][33] = 557;
        BytesDetector.BIG5P_FREQ[121][79] = 556;
        BytesDetector.BIG5P_FREQ[2][77] = 555;
        BytesDetector.BIG5P_FREQ[36][41] = 554;
        BytesDetector.BIG5P_FREQ[37][47] = 553;
        BytesDetector.BIG5P_FREQ[39][125] = 552;
        BytesDetector.BIG5P_FREQ[37][26] = 551;
        BytesDetector.BIG5P_FREQ[35][48] = 550;
        BytesDetector.BIG5P_FREQ[35][28] = 549;
        BytesDetector.BIG5P_FREQ[35][159] = 548;
        BytesDetector.BIG5P_FREQ[37][40] = 547;
        BytesDetector.BIG5P_FREQ[35][145] = 546;
        BytesDetector.BIG5P_FREQ[37][147] = 545;
        BytesDetector.BIG5P_FREQ[46][160] = 544;
        BytesDetector.BIG5P_FREQ[37][46] = 543;
        BytesDetector.BIG5P_FREQ[50][99] = 542;
        BytesDetector.BIG5P_FREQ[52][13] = 541;
        BytesDetector.BIG5P_FREQ[10][82] = 540;
        BytesDetector.BIG5P_FREQ[35][169] = 539;
        BytesDetector.BIG5P_FREQ[35][31] = 538;
        BytesDetector.BIG5P_FREQ[47][31] = 537;
        BytesDetector.BIG5P_FREQ[18][79] = 536;
        BytesDetector.BIG5P_FREQ[16][113] = 535;
        BytesDetector.BIG5P_FREQ[37][104] = 534;
        BytesDetector.BIG5P_FREQ[39][134] = 533;
        BytesDetector.BIG5P_FREQ[36][53] = 532;
        BytesDetector.BIG5P_FREQ[38][0] = 531;
        BytesDetector.BIG5P_FREQ[4][86] = 530;
        BytesDetector.BIG5P_FREQ[54][17] = 529;
        BytesDetector.BIG5P_FREQ[43][157] = 528;
        BytesDetector.BIG5P_FREQ[35][165] = 527;
        BytesDetector.BIG5P_FREQ[69][147] = 526;
        BytesDetector.BIG5P_FREQ[117][95] = 525;
        BytesDetector.BIG5P_FREQ[35][162] = 524;
        BytesDetector.BIG5P_FREQ[35][17] = 523;
        BytesDetector.BIG5P_FREQ[36][142] = 522;
        BytesDetector.BIG5P_FREQ[36][4] = 521;
        BytesDetector.BIG5P_FREQ[37][166] = 520;
        BytesDetector.BIG5P_FREQ[35][168] = 519;
        BytesDetector.BIG5P_FREQ[35][19] = 518;
        BytesDetector.BIG5P_FREQ[37][48] = 517;
        BytesDetector.BIG5P_FREQ[42][37] = 516;
        BytesDetector.BIG5P_FREQ[40][146] = 515;
        BytesDetector.BIG5P_FREQ[36][123] = 514;
        BytesDetector.BIG5P_FREQ[22][41] = 513;
        BytesDetector.BIG5P_FREQ[20][119] = 512;
        BytesDetector.BIG5P_FREQ[2][74] = 511;
        BytesDetector.BIG5P_FREQ[44][113] = 510;
        BytesDetector.BIG5P_FREQ[35][125] = 509;
        BytesDetector.BIG5P_FREQ[37][16] = 508;
        BytesDetector.BIG5P_FREQ[35][20] = 507;
        BytesDetector.BIG5P_FREQ[35][55] = 506;
        BytesDetector.BIG5P_FREQ[37][145] = 505;
        BytesDetector.BIG5P_FREQ[0][88] = 504;
        BytesDetector.BIG5P_FREQ[3][94] = 503;
        BytesDetector.BIG5P_FREQ[6][65] = 502;
        BytesDetector.BIG5P_FREQ[26][15] = 501;
        BytesDetector.BIG5P_FREQ[41][126] = 500;
        BytesDetector.BIG5P_FREQ[36][129] = 499;
        BytesDetector.BIG5P_FREQ[31][75] = 498;
        BytesDetector.BIG5P_FREQ[19][61] = 497;
        BytesDetector.BIG5P_FREQ[35][128] = 496;
        BytesDetector.BIG5P_FREQ[29][79] = 495;
        BytesDetector.BIG5P_FREQ[36][62] = 494;
        BytesDetector.BIG5P_FREQ[37][189] = 493;
        BytesDetector.BIG5P_FREQ[39][109] = 492;
        BytesDetector.BIG5P_FREQ[39][135] = 491;
        BytesDetector.BIG5P_FREQ[72][15] = 490;
        BytesDetector.BIG5P_FREQ[47][106] = 489;
        BytesDetector.BIG5P_FREQ[54][14] = 488;
        BytesDetector.BIG5P_FREQ[24][52] = 487;
        BytesDetector.BIG5P_FREQ[38][162] = 486;
        BytesDetector.BIG5P_FREQ[41][43] = 485;
        BytesDetector.BIG5P_FREQ[37][121] = 484;
        BytesDetector.BIG5P_FREQ[14][66] = 483;
        BytesDetector.BIG5P_FREQ[37][30] = 482;
        BytesDetector.BIG5P_FREQ[35][7] = 481;
        BytesDetector.BIG5P_FREQ[49][58] = 480;
        BytesDetector.BIG5P_FREQ[43][188] = 479;
        BytesDetector.BIG5P_FREQ[24][66] = 478;
        BytesDetector.BIG5P_FREQ[35][171] = 477;
        BytesDetector.BIG5P_FREQ[40][186] = 476;
        BytesDetector.BIG5P_FREQ[39][164] = 475;
        BytesDetector.BIG5P_FREQ[78][186] = 474;
        BytesDetector.BIG5P_FREQ[8][72] = 473;
        BytesDetector.BIG5P_FREQ[36][190] = 472;
        BytesDetector.BIG5P_FREQ[35][53] = 471;
        BytesDetector.BIG5P_FREQ[35][54] = 470;
        BytesDetector.BIG5P_FREQ[22][159] = 469;
        BytesDetector.BIG5P_FREQ[35][9] = 468;
        BytesDetector.BIG5P_FREQ[41][140] = 467;
        BytesDetector.BIG5P_FREQ[37][22] = 466;
        BytesDetector.BIG5P_FREQ[48][97] = 465;
        BytesDetector.BIG5P_FREQ[50][97] = 464;
        BytesDetector.BIG5P_FREQ[36][127] = 463;
        BytesDetector.BIG5P_FREQ[37][23] = 462;
        BytesDetector.BIG5P_FREQ[40][55] = 461;
        BytesDetector.BIG5P_FREQ[35][43] = 460;
        BytesDetector.BIG5P_FREQ[26][22] = 459;
        BytesDetector.BIG5P_FREQ[35][15] = 458;
        BytesDetector.BIG5P_FREQ[72][179] = 457;
        BytesDetector.BIG5P_FREQ[20][129] = 456;
        BytesDetector.BIG5P_FREQ[52][101] = 455;
        BytesDetector.BIG5P_FREQ[35][12] = 454;
        BytesDetector.BIG5P_FREQ[42][156] = 453;
        BytesDetector.BIG5P_FREQ[15][157] = 452;
        BytesDetector.BIG5P_FREQ[50][140] = 451;
        BytesDetector.BIG5P_FREQ[26][28] = 450;
        BytesDetector.BIG5P_FREQ[54][51] = 449;
        BytesDetector.BIG5P_FREQ[35][112] = 448;
        BytesDetector.BIG5P_FREQ[36][116] = 447;
        BytesDetector.BIG5P_FREQ[42][11] = 446;
        BytesDetector.BIG5P_FREQ[37][172] = 445;
        BytesDetector.BIG5P_FREQ[37][29] = 444;
        BytesDetector.BIG5P_FREQ[44][107] = 443;
        BytesDetector.BIG5P_FREQ[50][17] = 442;
        BytesDetector.BIG5P_FREQ[39][107] = 441;
        BytesDetector.BIG5P_FREQ[19][109] = 440;
        BytesDetector.BIG5P_FREQ[36][60] = 439;
        BytesDetector.BIG5P_FREQ[49][132] = 438;
        BytesDetector.BIG5P_FREQ[26][16] = 437;
        BytesDetector.BIG5P_FREQ[43][155] = 436;
        BytesDetector.BIG5P_FREQ[37][120] = 435;
        BytesDetector.BIG5P_FREQ[15][159] = 434;
        BytesDetector.BIG5P_FREQ[43][6] = 433;
        BytesDetector.BIG5P_FREQ[45][188] = 432;
        BytesDetector.BIG5P_FREQ[35][38] = 431;
        BytesDetector.BIG5P_FREQ[39][143] = 430;
        BytesDetector.BIG5P_FREQ[48][144] = 429;
        BytesDetector.BIG5P_FREQ[37][168] = 428;
        BytesDetector.BIG5P_FREQ[37][1] = 427;
        BytesDetector.BIG5P_FREQ[36][109] = 426;
        BytesDetector.BIG5P_FREQ[46][53] = 425;
        BytesDetector.BIG5P_FREQ[38][54] = 424;
        BytesDetector.BIG5P_FREQ[36][0] = 423;
        BytesDetector.BIG5P_FREQ[72][33] = 422;
        BytesDetector.BIG5P_FREQ[42][8] = 421;
        BytesDetector.BIG5P_FREQ[36][31] = 420;
        BytesDetector.BIG5P_FREQ[35][150] = 419;
        BytesDetector.BIG5P_FREQ[118][93] = 418;
        BytesDetector.BIG5P_FREQ[37][61] = 417;
        BytesDetector.BIG5P_FREQ[0][85] = 416;
        BytesDetector.BIG5P_FREQ[36][27] = 415;
        BytesDetector.BIG5P_FREQ[35][134] = 414;
        BytesDetector.BIG5P_FREQ[36][145] = 413;
        BytesDetector.BIG5P_FREQ[6][96] = 412;
        BytesDetector.BIG5P_FREQ[36][14] = 411;
        BytesDetector.BIG5P_FREQ[16][36] = 410;
        BytesDetector.BIG5P_FREQ[15][175] = 409;
        BytesDetector.BIG5P_FREQ[35][10] = 408;
        BytesDetector.BIG5P_FREQ[36][189] = 407;
        BytesDetector.BIG5P_FREQ[35][51] = 406;
        BytesDetector.BIG5P_FREQ[35][109] = 405;
        BytesDetector.BIG5P_FREQ[35][147] = 404;
        BytesDetector.BIG5P_FREQ[35][180] = 403;
        BytesDetector.BIG5P_FREQ[72][5] = 402;
        BytesDetector.BIG5P_FREQ[36][107] = 401;
        BytesDetector.BIG5P_FREQ[49][116] = 400;
        BytesDetector.BIG5P_FREQ[73][30] = 399;
        BytesDetector.BIG5P_FREQ[6][90] = 398;
        BytesDetector.BIG5P_FREQ[2][70] = 397;
        BytesDetector.BIG5P_FREQ[17][141] = 396;
        BytesDetector.BIG5P_FREQ[35][62] = 395;
        BytesDetector.BIG5P_FREQ[16][180] = 394;
        BytesDetector.BIG5P_FREQ[4][91] = 393;
        BytesDetector.BIG5P_FREQ[15][171] = 392;
        BytesDetector.BIG5P_FREQ[35][177] = 391;
        BytesDetector.BIG5P_FREQ[37][173] = 390;
        BytesDetector.BIG5P_FREQ[16][121] = 389;
        BytesDetector.BIG5P_FREQ[35][5] = 388;
        BytesDetector.BIG5P_FREQ[46][122] = 387;
        BytesDetector.BIG5P_FREQ[40][138] = 386;
        BytesDetector.BIG5P_FREQ[50][49] = 385;
        BytesDetector.BIG5P_FREQ[36][152] = 384;
        BytesDetector.BIG5P_FREQ[13][43] = 383;
        BytesDetector.BIG5P_FREQ[9][88] = 382;
        BytesDetector.BIG5P_FREQ[36][159] = 381;
        BytesDetector.BIG5P_FREQ[27][62] = 380;
        BytesDetector.BIG5P_FREQ[40][18] = 379;
        BytesDetector.BIG5P_FREQ[17][129] = 378;
        BytesDetector.BIG5P_FREQ[43][97] = 377;
        BytesDetector.BIG5P_FREQ[13][131] = 376;
        BytesDetector.BIG5P_FREQ[46][107] = 375;
        BytesDetector.BIG5P_FREQ[60][64] = 374;
        BytesDetector.BIG5P_FREQ[36][179] = 373;
        BytesDetector.BIG5P_FREQ[37][55] = 372;
        BytesDetector.BIG5P_FREQ[41][173] = 371;
        BytesDetector.BIG5P_FREQ[44][172] = 370;
        BytesDetector.BIG5P_FREQ[23][187] = 369;
        BytesDetector.BIG5P_FREQ[36][149] = 368;
        BytesDetector.BIG5P_FREQ[17][125] = 367;
        BytesDetector.BIG5P_FREQ[55][180] = 366;
        BytesDetector.BIG5P_FREQ[51][129] = 365;
        BytesDetector.BIG5P_FREQ[36][51] = 364;
        BytesDetector.BIG5P_FREQ[37][122] = 363;
        BytesDetector.BIG5P_FREQ[48][32] = 362;
        BytesDetector.BIG5P_FREQ[51][99] = 361;
        BytesDetector.BIG5P_FREQ[54][16] = 360;
        BytesDetector.BIG5P_FREQ[41][183] = 359;
        BytesDetector.BIG5P_FREQ[37][179] = 358;
        BytesDetector.BIG5P_FREQ[38][179] = 357;
        BytesDetector.BIG5P_FREQ[35][143] = 356;
        BytesDetector.BIG5P_FREQ[37][24] = 355;
        BytesDetector.BIG5P_FREQ[40][177] = 354;
        BytesDetector.BIG5P_FREQ[47][117] = 353;
        BytesDetector.BIG5P_FREQ[39][52] = 352;
        BytesDetector.BIG5P_FREQ[22][99] = 351;
        BytesDetector.BIG5P_FREQ[40][142] = 350;
        BytesDetector.BIG5P_FREQ[36][49] = 349;
        BytesDetector.BIG5P_FREQ[38][17] = 348;
        BytesDetector.BIG5P_FREQ[39][188] = 347;
        BytesDetector.BIG5P_FREQ[36][186] = 346;
        BytesDetector.BIG5P_FREQ[35][189] = 345;
        BytesDetector.BIG5P_FREQ[41][7] = 344;
        BytesDetector.BIG5P_FREQ[18][91] = 343;
        BytesDetector.BIG5P_FREQ[43][137] = 342;
        BytesDetector.BIG5P_FREQ[35][142] = 341;
        BytesDetector.BIG5P_FREQ[35][117] = 340;
        BytesDetector.BIG5P_FREQ[39][138] = 339;
        BytesDetector.BIG5P_FREQ[16][59] = 338;
        BytesDetector.BIG5P_FREQ[39][174] = 337;
        BytesDetector.BIG5P_FREQ[55][145] = 336;
        BytesDetector.BIG5P_FREQ[37][21] = 335;
        BytesDetector.BIG5P_FREQ[36][180] = 334;
        BytesDetector.BIG5P_FREQ[37][156] = 333;
        BytesDetector.BIG5P_FREQ[49][13] = 332;
        BytesDetector.BIG5P_FREQ[41][107] = 331;
        BytesDetector.BIG5P_FREQ[36][56] = 330;
        BytesDetector.BIG5P_FREQ[53][8] = 329;
        BytesDetector.BIG5P_FREQ[22][114] = 328;
        BytesDetector.BIG5P_FREQ[5][95] = 327;
        BytesDetector.BIG5P_FREQ[37][0] = 326;
        BytesDetector.BIG5P_FREQ[26][183] = 325;
        BytesDetector.BIG5P_FREQ[22][66] = 324;
        BytesDetector.BIG5P_FREQ[35][58] = 323;
        BytesDetector.BIG5P_FREQ[48][117] = 322;
        BytesDetector.BIG5P_FREQ[36][102] = 321;
        BytesDetector.BIG5P_FREQ[22][122] = 320;
        BytesDetector.BIG5P_FREQ[35][11] = 319;
        BytesDetector.BIG5P_FREQ[46][19] = 318;
        BytesDetector.BIG5P_FREQ[22][49] = 317;
        BytesDetector.BIG5P_FREQ[48][166] = 316;
        BytesDetector.BIG5P_FREQ[41][125] = 315;
        BytesDetector.BIG5P_FREQ[41][1] = 314;
        BytesDetector.BIG5P_FREQ[35][178] = 313;
        BytesDetector.BIG5P_FREQ[41][12] = 312;
        BytesDetector.BIG5P_FREQ[26][167] = 311;
        BytesDetector.BIG5P_FREQ[42][152] = 310;
        BytesDetector.BIG5P_FREQ[42][46] = 309;
        BytesDetector.BIG5P_FREQ[42][151] = 308;
        BytesDetector.BIG5P_FREQ[20][135] = 307;
        BytesDetector.BIG5P_FREQ[37][162] = 306;
        BytesDetector.BIG5P_FREQ[37][50] = 305;
        BytesDetector.BIG5P_FREQ[22][185] = 304;
        BytesDetector.BIG5P_FREQ[36][166] = 303;
        BytesDetector.BIG5P_FREQ[19][40] = 302;
        BytesDetector.BIG5P_FREQ[22][107] = 301;
        BytesDetector.BIG5P_FREQ[22][102] = 300;
        BytesDetector.BIG5P_FREQ[57][162] = 299;
        BytesDetector.BIG5P_FREQ[22][124] = 298;
        BytesDetector.BIG5P_FREQ[37][138] = 297;
        BytesDetector.BIG5P_FREQ[37][25] = 296;
        BytesDetector.BIG5P_FREQ[0][69] = 295;
        BytesDetector.BIG5P_FREQ[43][172] = 294;
        BytesDetector.BIG5P_FREQ[42][167] = 293;
        BytesDetector.BIG5P_FREQ[35][120] = 292;
        BytesDetector.BIG5P_FREQ[41][128] = 291;
        BytesDetector.BIG5P_FREQ[2][88] = 290;
        BytesDetector.BIG5P_FREQ[20][123] = 289;
        BytesDetector.BIG5P_FREQ[35][123] = 288;
        BytesDetector.BIG5P_FREQ[36][28] = 287;
        BytesDetector.BIG5P_FREQ[42][188] = 286;
        BytesDetector.BIG5P_FREQ[42][164] = 285;
        BytesDetector.BIG5P_FREQ[42][4] = 284;
        BytesDetector.BIG5P_FREQ[43][57] = 283;
        BytesDetector.BIG5P_FREQ[39][3] = 282;
        BytesDetector.BIG5P_FREQ[42][3] = 281;
        BytesDetector.BIG5P_FREQ[57][158] = 280;
        BytesDetector.BIG5P_FREQ[35][146] = 279;
        BytesDetector.BIG5P_FREQ[24][54] = 278;
        BytesDetector.BIG5P_FREQ[13][110] = 277;
        BytesDetector.BIG5P_FREQ[23][132] = 276;
        BytesDetector.BIG5P_FREQ[26][102] = 275;
        BytesDetector.BIG5P_FREQ[55][178] = 274;
        BytesDetector.BIG5P_FREQ[17][117] = 273;
        BytesDetector.BIG5P_FREQ[41][161] = 272;
        BytesDetector.BIG5P_FREQ[38][150] = 271;
        BytesDetector.BIG5P_FREQ[10][71] = 270;
        BytesDetector.BIG5P_FREQ[47][60] = 269;
        BytesDetector.BIG5P_FREQ[16][114] = 268;
        BytesDetector.BIG5P_FREQ[21][47] = 267;
        BytesDetector.BIG5P_FREQ[39][101] = 266;
        BytesDetector.BIG5P_FREQ[18][45] = 265;
        BytesDetector.BIG5P_FREQ[40][121] = 264;
        BytesDetector.BIG5P_FREQ[45][41] = 263;
        BytesDetector.BIG5P_FREQ[22][167] = 262;
        BytesDetector.BIG5P_FREQ[26][149] = 261;
        BytesDetector.BIG5P_FREQ[15][189] = 260;
        BytesDetector.BIG5P_FREQ[41][177] = 259;
        BytesDetector.BIG5P_FREQ[46][36] = 258;
        BytesDetector.BIG5P_FREQ[20][40] = 257;
        BytesDetector.BIG5P_FREQ[41][54] = 256;
        BytesDetector.BIG5P_FREQ[3][87] = 255;
        BytesDetector.BIG5P_FREQ[40][16] = 254;
        BytesDetector.BIG5P_FREQ[42][15] = 253;
        BytesDetector.BIG5P_FREQ[11][83] = 252;
        BytesDetector.BIG5P_FREQ[0][94] = 251;
        BytesDetector.BIG5P_FREQ[122][81] = 250;
        BytesDetector.BIG5P_FREQ[41][26] = 249;
        BytesDetector.BIG5P_FREQ[36][34] = 248;
        BytesDetector.BIG5P_FREQ[44][148] = 247;
        BytesDetector.BIG5P_FREQ[35][3] = 246;
        BytesDetector.BIG5P_FREQ[36][114] = 245;
        BytesDetector.BIG5P_FREQ[42][112] = 244;
        BytesDetector.BIG5P_FREQ[35][183] = 243;
        BytesDetector.BIG5P_FREQ[49][73] = 242;
        BytesDetector.BIG5P_FREQ[39][2] = 241;
        BytesDetector.BIG5P_FREQ[38][121] = 240;
        BytesDetector.BIG5P_FREQ[44][114] = 239;
        BytesDetector.BIG5P_FREQ[49][32] = 238;
        BytesDetector.BIG5P_FREQ[1][65] = 237;
        BytesDetector.BIG5P_FREQ[38][25] = 236;
        BytesDetector.BIG5P_FREQ[39][4] = 235;
        BytesDetector.BIG5P_FREQ[42][62] = 234;
        BytesDetector.BIG5P_FREQ[35][40] = 233;
        BytesDetector.BIG5P_FREQ[24][2] = 232;
        BytesDetector.BIG5P_FREQ[53][49] = 231;
        BytesDetector.BIG5P_FREQ[41][133] = 230;
        BytesDetector.BIG5P_FREQ[43][134] = 229;
        BytesDetector.BIG5P_FREQ[3][83] = 228;
        BytesDetector.BIG5P_FREQ[38][158] = 227;
        BytesDetector.BIG5P_FREQ[24][17] = 226;
        BytesDetector.BIG5P_FREQ[52][59] = 225;
        BytesDetector.BIG5P_FREQ[38][41] = 224;
        BytesDetector.BIG5P_FREQ[37][127] = 223;
        BytesDetector.BIG5P_FREQ[22][175] = 222;
        BytesDetector.BIG5P_FREQ[44][30] = 221;
        BytesDetector.BIG5P_FREQ[47][178] = 220;
        BytesDetector.BIG5P_FREQ[43][99] = 219;
        BytesDetector.BIG5P_FREQ[19][4] = 218;
        BytesDetector.BIG5P_FREQ[37][97] = 217;
        BytesDetector.BIG5P_FREQ[38][181] = 216;
        BytesDetector.BIG5P_FREQ[45][103] = 215;
        BytesDetector.BIG5P_FREQ[1][86] = 214;
        BytesDetector.BIG5P_FREQ[40][15] = 213;
        BytesDetector.BIG5P_FREQ[22][136] = 212;
        BytesDetector.BIG5P_FREQ[75][165] = 211;
        BytesDetector.BIG5P_FREQ[36][15] = 210;
        BytesDetector.BIG5P_FREQ[46][80] = 209;
        BytesDetector.BIG5P_FREQ[59][55] = 208;
        BytesDetector.BIG5P_FREQ[37][108] = 207;
        BytesDetector.BIG5P_FREQ[21][109] = 206;
        BytesDetector.BIG5P_FREQ[24][165] = 205;
        BytesDetector.BIG5P_FREQ[79][158] = 204;
        BytesDetector.BIG5P_FREQ[44][139] = 203;
        BytesDetector.BIG5P_FREQ[36][124] = 202;
        BytesDetector.BIG5P_FREQ[42][185] = 201;
        BytesDetector.BIG5P_FREQ[39][186] = 200;
        BytesDetector.BIG5P_FREQ[22][128] = 199;
        BytesDetector.BIG5P_FREQ[40][44] = 198;
        BytesDetector.BIG5P_FREQ[41][105] = 197;
        BytesDetector.BIG5P_FREQ[1][70] = 196;
        BytesDetector.BIG5P_FREQ[1][68] = 195;
        BytesDetector.BIG5P_FREQ[53][22] = 194;
        BytesDetector.BIG5P_FREQ[36][54] = 193;
        BytesDetector.BIG5P_FREQ[47][147] = 192;
        BytesDetector.BIG5P_FREQ[35][36] = 191;
        BytesDetector.BIG5P_FREQ[35][185] = 190;
        BytesDetector.BIG5P_FREQ[45][37] = 189;
        BytesDetector.BIG5P_FREQ[43][163] = 188;
        BytesDetector.BIG5P_FREQ[56][115] = 187;
        BytesDetector.BIG5P_FREQ[38][164] = 186;
        BytesDetector.BIG5P_FREQ[35][141] = 185;
        BytesDetector.BIG5P_FREQ[42][132] = 184;
        BytesDetector.BIG5P_FREQ[46][120] = 183;
        BytesDetector.BIG5P_FREQ[69][142] = 182;
        BytesDetector.BIG5P_FREQ[38][175] = 181;
        BytesDetector.BIG5P_FREQ[22][112] = 180;
        BytesDetector.BIG5P_FREQ[38][142] = 179;
        BytesDetector.BIG5P_FREQ[40][37] = 178;
        BytesDetector.BIG5P_FREQ[37][109] = 177;
        BytesDetector.BIG5P_FREQ[40][144] = 176;
        BytesDetector.BIG5P_FREQ[44][117] = 175;
        BytesDetector.BIG5P_FREQ[35][181] = 174;
        BytesDetector.BIG5P_FREQ[26][105] = 173;
        BytesDetector.BIG5P_FREQ[16][48] = 172;
        BytesDetector.BIG5P_FREQ[44][122] = 171;
        BytesDetector.BIG5P_FREQ[12][86] = 170;
        BytesDetector.BIG5P_FREQ[84][53] = 169;
        BytesDetector.BIG5P_FREQ[17][44] = 168;
        BytesDetector.BIG5P_FREQ[59][54] = 167;
        BytesDetector.BIG5P_FREQ[36][98] = 166;
        BytesDetector.BIG5P_FREQ[45][115] = 165;
        BytesDetector.BIG5P_FREQ[73][9] = 164;
        BytesDetector.BIG5P_FREQ[44][123] = 163;
        BytesDetector.BIG5P_FREQ[37][188] = 162;
        BytesDetector.BIG5P_FREQ[51][117] = 161;
        BytesDetector.BIG5P_FREQ[15][156] = 160;
        BytesDetector.BIG5P_FREQ[36][155] = 159;
        BytesDetector.BIG5P_FREQ[44][25] = 158;
        BytesDetector.BIG5P_FREQ[38][12] = 157;
        BytesDetector.BIG5P_FREQ[38][140] = 156;
        BytesDetector.BIG5P_FREQ[23][4] = 155;
        BytesDetector.BIG5P_FREQ[45][149] = 154;
        BytesDetector.BIG5P_FREQ[22][189] = 153;
        BytesDetector.BIG5P_FREQ[38][147] = 152;
        BytesDetector.BIG5P_FREQ[27][5] = 151;
        BytesDetector.BIG5P_FREQ[22][42] = 150;
        BytesDetector.BIG5P_FREQ[3][68] = 149;
        BytesDetector.BIG5P_FREQ[39][51] = 148;
        BytesDetector.BIG5P_FREQ[36][29] = 147;
        BytesDetector.BIG5P_FREQ[20][108] = 146;
        BytesDetector.BIG5P_FREQ[50][57] = 145;
        BytesDetector.BIG5P_FREQ[55][104] = 144;
        BytesDetector.BIG5P_FREQ[22][46] = 143;
        BytesDetector.BIG5P_FREQ[18][164] = 142;
        BytesDetector.BIG5P_FREQ[50][159] = 141;
        BytesDetector.BIG5P_FREQ[85][131] = 140;
        BytesDetector.BIG5P_FREQ[26][79] = 139;
        BytesDetector.BIG5P_FREQ[38][100] = 138;
        BytesDetector.BIG5P_FREQ[53][112] = 137;
        BytesDetector.BIG5P_FREQ[20][190] = 136;
        BytesDetector.BIG5P_FREQ[14][69] = 135;
        BytesDetector.BIG5P_FREQ[23][11] = 134;
        BytesDetector.BIG5P_FREQ[40][114] = 133;
        BytesDetector.BIG5P_FREQ[40][148] = 132;
        BytesDetector.BIG5P_FREQ[53][130] = 131;
        BytesDetector.BIG5P_FREQ[36][2] = 130;
        BytesDetector.BIG5P_FREQ[66][82] = 129;
        BytesDetector.BIG5P_FREQ[45][166] = 128;
        BytesDetector.BIG5P_FREQ[4][88] = 127;
        BytesDetector.BIG5P_FREQ[16][57] = 126;
        BytesDetector.BIG5P_FREQ[22][116] = 125;
        BytesDetector.BIG5P_FREQ[36][108] = 124;
        BytesDetector.BIG5P_FREQ[13][48] = 123;
        BytesDetector.BIG5P_FREQ[54][12] = 122;
        BytesDetector.BIG5P_FREQ[40][136] = 121;
        BytesDetector.BIG5P_FREQ[36][128] = 120;
        BytesDetector.BIG5P_FREQ[23][6] = 119;
        BytesDetector.BIG5P_FREQ[38][125] = 118;
        BytesDetector.BIG5P_FREQ[45][154] = 117;
        BytesDetector.BIG5P_FREQ[51][127] = 116;
        BytesDetector.BIG5P_FREQ[44][163] = 115;
        BytesDetector.BIG5P_FREQ[16][173] = 114;
        BytesDetector.BIG5P_FREQ[43][49] = 113;
        BytesDetector.BIG5P_FREQ[20][112] = 112;
        BytesDetector.BIG5P_FREQ[15][168] = 111;
        BytesDetector.BIG5P_FREQ[35][129] = 110;
        BytesDetector.BIG5P_FREQ[20][45] = 109;
        BytesDetector.BIG5P_FREQ[38][10] = 108;
        BytesDetector.BIG5P_FREQ[57][171] = 107;
        BytesDetector.BIG5P_FREQ[44][190] = 106;
        BytesDetector.BIG5P_FREQ[40][56] = 105;
        BytesDetector.BIG5P_FREQ[36][156] = 104;
        BytesDetector.BIG5P_FREQ[3][88] = 103;
        BytesDetector.BIG5P_FREQ[50][122] = 102;
        BytesDetector.BIG5P_FREQ[36][7] = 101;
        BytesDetector.BIG5P_FREQ[39][43] = 100;
        BytesDetector.BIG5P_FREQ[15][166] = 99;
        BytesDetector.BIG5P_FREQ[42][136] = 98;
        BytesDetector.BIG5P_FREQ[22][131] = 97;
        BytesDetector.BIG5P_FREQ[44][23] = 96;
        BytesDetector.BIG5P_FREQ[54][147] = 95;
        BytesDetector.BIG5P_FREQ[41][32] = 94;
        BytesDetector.BIG5P_FREQ[23][121] = 93;
        BytesDetector.BIG5P_FREQ[39][108] = 92;
        BytesDetector.BIG5P_FREQ[2][78] = 91;
        BytesDetector.BIG5P_FREQ[40][155] = 90;
        BytesDetector.BIG5P_FREQ[55][51] = 89;
        BytesDetector.BIG5P_FREQ[19][34] = 88;
        BytesDetector.BIG5P_FREQ[48][128] = 87;
        BytesDetector.BIG5P_FREQ[48][159] = 86;
        BytesDetector.BIG5P_FREQ[20][70] = 85;
        BytesDetector.BIG5P_FREQ[34][71] = 84;
        BytesDetector.BIG5P_FREQ[16][31] = 83;
        BytesDetector.BIG5P_FREQ[42][157] = 82;
        BytesDetector.BIG5P_FREQ[20][44] = 81;
        BytesDetector.BIG5P_FREQ[11][92] = 80;
        BytesDetector.BIG5P_FREQ[44][180] = 79;
        BytesDetector.BIG5P_FREQ[84][33] = 78;
        BytesDetector.BIG5P_FREQ[16][116] = 77;
        BytesDetector.BIG5P_FREQ[61][163] = 76;
        BytesDetector.BIG5P_FREQ[35][164] = 75;
        BytesDetector.BIG5P_FREQ[36][42] = 74;
        BytesDetector.BIG5P_FREQ[13][40] = 73;
        BytesDetector.BIG5P_FREQ[43][176] = 72;
        BytesDetector.BIG5P_FREQ[2][66] = 71;
        BytesDetector.BIG5P_FREQ[20][133] = 70;
        BytesDetector.BIG5P_FREQ[36][65] = 69;
        BytesDetector.BIG5P_FREQ[38][33] = 68;
        BytesDetector.BIG5P_FREQ[12][91] = 67;
        BytesDetector.BIG5P_FREQ[36][26] = 66;
        BytesDetector.BIG5P_FREQ[15][174] = 65;
        BytesDetector.BIG5P_FREQ[77][32] = 64;
        BytesDetector.BIG5P_FREQ[16][1] = 63;
        BytesDetector.BIG5P_FREQ[25][86] = 62;
        BytesDetector.BIG5P_FREQ[17][13] = 61;
        BytesDetector.BIG5P_FREQ[5][75] = 60;
        BytesDetector.BIG5P_FREQ[36][52] = 59;
        BytesDetector.BIG5P_FREQ[51][164] = 58;
        BytesDetector.BIG5P_FREQ[12][85] = 57;
        BytesDetector.BIG5P_FREQ[39][168] = 56;
        BytesDetector.BIG5P_FREQ[43][16] = 55;
        BytesDetector.BIG5P_FREQ[40][69] = 54;
        BytesDetector.BIG5P_FREQ[26][108] = 53;
        BytesDetector.BIG5P_FREQ[51][56] = 52;
        BytesDetector.BIG5P_FREQ[16][37] = 51;
        BytesDetector.BIG5P_FREQ[40][29] = 50;
        BytesDetector.BIG5P_FREQ[46][171] = 49;
        BytesDetector.BIG5P_FREQ[40][128] = 48;
        BytesDetector.BIG5P_FREQ[72][114] = 47;
        BytesDetector.BIG5P_FREQ[21][103] = 46;
        BytesDetector.BIG5P_FREQ[22][44] = 45;
        BytesDetector.BIG5P_FREQ[40][115] = 44;
        BytesDetector.BIG5P_FREQ[43][7] = 43;
        BytesDetector.BIG5P_FREQ[43][153] = 42;
        BytesDetector.BIG5P_FREQ[17][20] = 41;
        BytesDetector.BIG5P_FREQ[16][49] = 40;
        BytesDetector.BIG5P_FREQ[36][57] = 39;
        BytesDetector.BIG5P_FREQ[18][38] = 38;
        BytesDetector.BIG5P_FREQ[45][184] = 37;
        BytesDetector.BIG5P_FREQ[37][167] = 36;
        BytesDetector.BIG5P_FREQ[26][106] = 35;
        BytesDetector.BIG5P_FREQ[61][121] = 34;
        BytesDetector.BIG5P_FREQ[89][140] = 33;
        BytesDetector.BIG5P_FREQ[46][61] = 32;
        BytesDetector.BIG5P_FREQ[39][163] = 31;
        BytesDetector.BIG5P_FREQ[40][62] = 30;
        BytesDetector.BIG5P_FREQ[38][165] = 29;
        BytesDetector.BIG5P_FREQ[47][37] = 28;
        BytesDetector.BIG5P_FREQ[18][155] = 27;
        BytesDetector.BIG5P_FREQ[20][33] = 26;
        BytesDetector.BIG5P_FREQ[29][90] = 25;
        BytesDetector.BIG5P_FREQ[20][103] = 24;
        BytesDetector.BIG5P_FREQ[37][51] = 23;
        BytesDetector.BIG5P_FREQ[57][0] = 22;
        BytesDetector.BIG5P_FREQ[40][31] = 21;
        BytesDetector.BIG5P_FREQ[45][32] = 20;
        BytesDetector.BIG5P_FREQ[59][23] = 19;
        BytesDetector.BIG5P_FREQ[18][47] = 18;
        BytesDetector.BIG5P_FREQ[45][134] = 17;
        BytesDetector.BIG5P_FREQ[37][59] = 16;
        BytesDetector.BIG5P_FREQ[21][128] = 15;
        BytesDetector.BIG5P_FREQ[36][106] = 14;
        BytesDetector.BIG5P_FREQ[31][39] = 13;
        BytesDetector.BIG5P_FREQ[40][182] = 12;
        BytesDetector.BIG5P_FREQ[52][155] = 11;
        BytesDetector.BIG5P_FREQ[42][166] = 10;
        BytesDetector.BIG5P_FREQ[35][27] = 9;
        BytesDetector.BIG5P_FREQ[38][3] = 8;
        BytesDetector.BIG5P_FREQ[13][44] = 7;
        BytesDetector.BIG5P_FREQ[58][157] = 6;
        BytesDetector.BIG5P_FREQ[47][51] = 5;
        BytesDetector.BIG5P_FREQ[41][37] = 4;
        BytesDetector.BIG5P_FREQ[41][172] = 3;
        BytesDetector.BIG5P_FREQ[51][165] = 2;
        BytesDetector.BIG5P_FREQ[15][161] = 1;
        BytesDetector.BIG5P_FREQ[24][181] = 0;
        BytesDetector.EUC_TW_FREQ[48][49] = 599;
        BytesDetector.EUC_TW_FREQ[35][65] = 598;
        BytesDetector.EUC_TW_FREQ[41][27] = 597;
        BytesDetector.EUC_TW_FREQ[35][0] = 596;
        BytesDetector.EUC_TW_FREQ[39][19] = 595;
        BytesDetector.EUC_TW_FREQ[35][42] = 594;
        BytesDetector.EUC_TW_FREQ[38][66] = 593;
        BytesDetector.EUC_TW_FREQ[35][8] = 592;
        BytesDetector.EUC_TW_FREQ[35][6] = 591;
        BytesDetector.EUC_TW_FREQ[35][66] = 590;
        BytesDetector.EUC_TW_FREQ[43][14] = 589;
        BytesDetector.EUC_TW_FREQ[69][80] = 588;
        BytesDetector.EUC_TW_FREQ[50][48] = 587;
        BytesDetector.EUC_TW_FREQ[36][71] = 586;
        BytesDetector.EUC_TW_FREQ[37][10] = 585;
        BytesDetector.EUC_TW_FREQ[60][52] = 584;
        BytesDetector.EUC_TW_FREQ[51][21] = 583;
        BytesDetector.EUC_TW_FREQ[40][2] = 582;
        BytesDetector.EUC_TW_FREQ[67][35] = 581;
        BytesDetector.EUC_TW_FREQ[38][78] = 580;
        BytesDetector.EUC_TW_FREQ[49][18] = 579;
        BytesDetector.EUC_TW_FREQ[35][23] = 578;
        BytesDetector.EUC_TW_FREQ[42][83] = 577;
        BytesDetector.EUC_TW_FREQ[79][47] = 576;
        BytesDetector.EUC_TW_FREQ[61][82] = 575;
        BytesDetector.EUC_TW_FREQ[38][7] = 574;
        BytesDetector.EUC_TW_FREQ[35][29] = 573;
        BytesDetector.EUC_TW_FREQ[37][77] = 572;
        BytesDetector.EUC_TW_FREQ[54][67] = 571;
        BytesDetector.EUC_TW_FREQ[38][80] = 570;
        BytesDetector.EUC_TW_FREQ[52][74] = 569;
        BytesDetector.EUC_TW_FREQ[36][37] = 568;
        BytesDetector.EUC_TW_FREQ[74][8] = 567;
        BytesDetector.EUC_TW_FREQ[41][83] = 566;
        BytesDetector.EUC_TW_FREQ[36][75] = 565;
        BytesDetector.EUC_TW_FREQ[49][63] = 564;
        BytesDetector.EUC_TW_FREQ[42][58] = 563;
        BytesDetector.EUC_TW_FREQ[56][33] = 562;
        BytesDetector.EUC_TW_FREQ[37][76] = 561;
        BytesDetector.EUC_TW_FREQ[62][39] = 560;
        BytesDetector.EUC_TW_FREQ[35][21] = 559;
        BytesDetector.EUC_TW_FREQ[70][19] = 558;
        BytesDetector.EUC_TW_FREQ[77][88] = 557;
        BytesDetector.EUC_TW_FREQ[51][14] = 556;
        BytesDetector.EUC_TW_FREQ[36][17] = 555;
        BytesDetector.EUC_TW_FREQ[44][51] = 554;
        BytesDetector.EUC_TW_FREQ[38][72] = 553;
        BytesDetector.EUC_TW_FREQ[74][90] = 552;
        BytesDetector.EUC_TW_FREQ[35][48] = 551;
        BytesDetector.EUC_TW_FREQ[35][69] = 550;
        BytesDetector.EUC_TW_FREQ[66][86] = 549;
        BytesDetector.EUC_TW_FREQ[57][20] = 548;
        BytesDetector.EUC_TW_FREQ[35][53] = 547;
        BytesDetector.EUC_TW_FREQ[36][87] = 546;
        BytesDetector.EUC_TW_FREQ[84][67] = 545;
        BytesDetector.EUC_TW_FREQ[70][56] = 544;
        BytesDetector.EUC_TW_FREQ[71][54] = 543;
        BytesDetector.EUC_TW_FREQ[60][70] = 542;
        BytesDetector.EUC_TW_FREQ[80][1] = 541;
        BytesDetector.EUC_TW_FREQ[39][59] = 540;
        BytesDetector.EUC_TW_FREQ[39][51] = 539;
        BytesDetector.EUC_TW_FREQ[35][44] = 538;
        BytesDetector.EUC_TW_FREQ[48][4] = 537;
        BytesDetector.EUC_TW_FREQ[55][24] = 536;
        BytesDetector.EUC_TW_FREQ[52][4] = 535;
        BytesDetector.EUC_TW_FREQ[54][26] = 534;
        BytesDetector.EUC_TW_FREQ[36][31] = 533;
        BytesDetector.EUC_TW_FREQ[37][22] = 532;
        BytesDetector.EUC_TW_FREQ[37][9] = 531;
        BytesDetector.EUC_TW_FREQ[46][0] = 530;
        BytesDetector.EUC_TW_FREQ[56][46] = 529;
        BytesDetector.EUC_TW_FREQ[47][93] = 528;
        BytesDetector.EUC_TW_FREQ[37][25] = 527;
        BytesDetector.EUC_TW_FREQ[39][8] = 526;
        BytesDetector.EUC_TW_FREQ[46][73] = 525;
        BytesDetector.EUC_TW_FREQ[38][48] = 524;
        BytesDetector.EUC_TW_FREQ[39][83] = 523;
        BytesDetector.EUC_TW_FREQ[60][92] = 522;
        BytesDetector.EUC_TW_FREQ[70][11] = 521;
        BytesDetector.EUC_TW_FREQ[63][84] = 520;
        BytesDetector.EUC_TW_FREQ[38][65] = 519;
        BytesDetector.EUC_TW_FREQ[45][45] = 518;
        BytesDetector.EUC_TW_FREQ[63][49] = 517;
        BytesDetector.EUC_TW_FREQ[63][50] = 516;
        BytesDetector.EUC_TW_FREQ[39][93] = 515;
        BytesDetector.EUC_TW_FREQ[68][20] = 514;
        BytesDetector.EUC_TW_FREQ[44][84] = 513;
        BytesDetector.EUC_TW_FREQ[66][34] = 512;
        BytesDetector.EUC_TW_FREQ[37][58] = 511;
        BytesDetector.EUC_TW_FREQ[39][0] = 510;
        BytesDetector.EUC_TW_FREQ[59][1] = 509;
        BytesDetector.EUC_TW_FREQ[47][8] = 508;
        BytesDetector.EUC_TW_FREQ[61][17] = 507;
        BytesDetector.EUC_TW_FREQ[53][87] = 506;
        BytesDetector.EUC_TW_FREQ[67][26] = 505;
        BytesDetector.EUC_TW_FREQ[43][46] = 504;
        BytesDetector.EUC_TW_FREQ[38][61] = 503;
        BytesDetector.EUC_TW_FREQ[45][9] = 502;
        BytesDetector.EUC_TW_FREQ[66][83] = 501;
        BytesDetector.EUC_TW_FREQ[43][88] = 500;
        BytesDetector.EUC_TW_FREQ[85][20] = 499;
        BytesDetector.EUC_TW_FREQ[57][36] = 498;
        BytesDetector.EUC_TW_FREQ[43][6] = 497;
        BytesDetector.EUC_TW_FREQ[86][77] = 496;
        BytesDetector.EUC_TW_FREQ[42][70] = 495;
        BytesDetector.EUC_TW_FREQ[49][78] = 494;
        BytesDetector.EUC_TW_FREQ[36][40] = 493;
        BytesDetector.EUC_TW_FREQ[42][71] = 492;
        BytesDetector.EUC_TW_FREQ[58][49] = 491;
        BytesDetector.EUC_TW_FREQ[35][20] = 490;
        BytesDetector.EUC_TW_FREQ[76][20] = 489;
        BytesDetector.EUC_TW_FREQ[39][25] = 488;
        BytesDetector.EUC_TW_FREQ[40][34] = 487;
        BytesDetector.EUC_TW_FREQ[39][76] = 486;
        BytesDetector.EUC_TW_FREQ[40][1] = 485;
        BytesDetector.EUC_TW_FREQ[59][0] = 484;
        BytesDetector.EUC_TW_FREQ[39][70] = 483;
        BytesDetector.EUC_TW_FREQ[46][14] = 482;
        BytesDetector.EUC_TW_FREQ[68][77] = 481;
        BytesDetector.EUC_TW_FREQ[38][55] = 480;
        BytesDetector.EUC_TW_FREQ[35][78] = 479;
        BytesDetector.EUC_TW_FREQ[84][44] = 478;
        BytesDetector.EUC_TW_FREQ[36][41] = 477;
        BytesDetector.EUC_TW_FREQ[37][62] = 476;
        BytesDetector.EUC_TW_FREQ[65][67] = 475;
        BytesDetector.EUC_TW_FREQ[69][66] = 474;
        BytesDetector.EUC_TW_FREQ[73][55] = 473;
        BytesDetector.EUC_TW_FREQ[71][49] = 472;
        BytesDetector.EUC_TW_FREQ[66][87] = 471;
        BytesDetector.EUC_TW_FREQ[38][33] = 470;
        BytesDetector.EUC_TW_FREQ[64][61] = 469;
        BytesDetector.EUC_TW_FREQ[35][7] = 468;
        BytesDetector.EUC_TW_FREQ[47][49] = 467;
        BytesDetector.EUC_TW_FREQ[56][14] = 466;
        BytesDetector.EUC_TW_FREQ[36][49] = 465;
        BytesDetector.EUC_TW_FREQ[50][81] = 464;
        BytesDetector.EUC_TW_FREQ[55][76] = 463;
        BytesDetector.EUC_TW_FREQ[35][19] = 462;
        BytesDetector.EUC_TW_FREQ[44][47] = 461;
        BytesDetector.EUC_TW_FREQ[35][15] = 460;
        BytesDetector.EUC_TW_FREQ[82][59] = 459;
        BytesDetector.EUC_TW_FREQ[35][43] = 458;
        BytesDetector.EUC_TW_FREQ[73][0] = 457;
        BytesDetector.EUC_TW_FREQ[57][83] = 456;
        BytesDetector.EUC_TW_FREQ[42][46] = 455;
        BytesDetector.EUC_TW_FREQ[36][0] = 454;
        BytesDetector.EUC_TW_FREQ[70][88] = 453;
        BytesDetector.EUC_TW_FREQ[42][22] = 452;
        BytesDetector.EUC_TW_FREQ[46][58] = 451;
        BytesDetector.EUC_TW_FREQ[36][34] = 450;
        BytesDetector.EUC_TW_FREQ[39][24] = 449;
        BytesDetector.EUC_TW_FREQ[35][55] = 448;
        BytesDetector.EUC_TW_FREQ[44][91] = 447;
        BytesDetector.EUC_TW_FREQ[37][51] = 446;
        BytesDetector.EUC_TW_FREQ[36][19] = 445;
        BytesDetector.EUC_TW_FREQ[69][90] = 444;
        BytesDetector.EUC_TW_FREQ[55][35] = 443;
        BytesDetector.EUC_TW_FREQ[35][54] = 442;
        BytesDetector.EUC_TW_FREQ[49][61] = 441;
        BytesDetector.EUC_TW_FREQ[36][67] = 440;
        BytesDetector.EUC_TW_FREQ[88][34] = 439;
        BytesDetector.EUC_TW_FREQ[35][17] = 438;
        BytesDetector.EUC_TW_FREQ[65][69] = 437;
        BytesDetector.EUC_TW_FREQ[74][89] = 436;
        BytesDetector.EUC_TW_FREQ[37][31] = 435;
        BytesDetector.EUC_TW_FREQ[43][48] = 434;
        BytesDetector.EUC_TW_FREQ[89][27] = 433;
        BytesDetector.EUC_TW_FREQ[42][79] = 432;
        BytesDetector.EUC_TW_FREQ[69][57] = 431;
        BytesDetector.EUC_TW_FREQ[36][13] = 430;
        BytesDetector.EUC_TW_FREQ[35][62] = 429;
        BytesDetector.EUC_TW_FREQ[65][47] = 428;
        BytesDetector.EUC_TW_FREQ[56][8] = 427;
        BytesDetector.EUC_TW_FREQ[38][79] = 426;
        BytesDetector.EUC_TW_FREQ[37][64] = 425;
        BytesDetector.EUC_TW_FREQ[64][64] = 424;
        BytesDetector.EUC_TW_FREQ[38][53] = 423;
        BytesDetector.EUC_TW_FREQ[38][31] = 422;
        BytesDetector.EUC_TW_FREQ[56][81] = 421;
        BytesDetector.EUC_TW_FREQ[36][22] = 420;
        BytesDetector.EUC_TW_FREQ[43][4] = 419;
        BytesDetector.EUC_TW_FREQ[36][90] = 418;
        BytesDetector.EUC_TW_FREQ[38][62] = 417;
        BytesDetector.EUC_TW_FREQ[66][85] = 416;
        BytesDetector.EUC_TW_FREQ[39][1] = 415;
        BytesDetector.EUC_TW_FREQ[59][40] = 414;
        BytesDetector.EUC_TW_FREQ[58][93] = 413;
        BytesDetector.EUC_TW_FREQ[44][43] = 412;
        BytesDetector.EUC_TW_FREQ[39][49] = 411;
        BytesDetector.EUC_TW_FREQ[64][2] = 410;
        BytesDetector.EUC_TW_FREQ[41][35] = 409;
        BytesDetector.EUC_TW_FREQ[60][22] = 408;
        BytesDetector.EUC_TW_FREQ[35][91] = 407;
        BytesDetector.EUC_TW_FREQ[78][1] = 406;
        BytesDetector.EUC_TW_FREQ[36][14] = 405;
        BytesDetector.EUC_TW_FREQ[82][29] = 404;
        BytesDetector.EUC_TW_FREQ[52][86] = 403;
        BytesDetector.EUC_TW_FREQ[40][16] = 402;
        BytesDetector.EUC_TW_FREQ[91][52] = 401;
        BytesDetector.EUC_TW_FREQ[50][75] = 400;
        BytesDetector.EUC_TW_FREQ[64][30] = 399;
        BytesDetector.EUC_TW_FREQ[90][78] = 398;
        BytesDetector.EUC_TW_FREQ[36][52] = 397;
        BytesDetector.EUC_TW_FREQ[55][87] = 396;
        BytesDetector.EUC_TW_FREQ[57][5] = 395;
        BytesDetector.EUC_TW_FREQ[57][31] = 394;
        BytesDetector.EUC_TW_FREQ[42][35] = 393;
        BytesDetector.EUC_TW_FREQ[69][50] = 392;
        BytesDetector.EUC_TW_FREQ[45][8] = 391;
        BytesDetector.EUC_TW_FREQ[50][87] = 390;
        BytesDetector.EUC_TW_FREQ[69][55] = 389;
        BytesDetector.EUC_TW_FREQ[92][3] = 388;
        BytesDetector.EUC_TW_FREQ[36][43] = 387;
        BytesDetector.EUC_TW_FREQ[64][10] = 386;
        BytesDetector.EUC_TW_FREQ[56][25] = 385;
        BytesDetector.EUC_TW_FREQ[60][68] = 384;
        BytesDetector.EUC_TW_FREQ[51][46] = 383;
        BytesDetector.EUC_TW_FREQ[50][0] = 382;
        BytesDetector.EUC_TW_FREQ[38][30] = 381;
        BytesDetector.EUC_TW_FREQ[50][85] = 380;
        BytesDetector.EUC_TW_FREQ[60][54] = 379;
        BytesDetector.EUC_TW_FREQ[73][6] = 378;
        BytesDetector.EUC_TW_FREQ[73][28] = 377;
        BytesDetector.EUC_TW_FREQ[56][19] = 376;
        BytesDetector.EUC_TW_FREQ[62][69] = 375;
        BytesDetector.EUC_TW_FREQ[81][66] = 374;
        BytesDetector.EUC_TW_FREQ[40][32] = 373;
        BytesDetector.EUC_TW_FREQ[76][31] = 372;
        BytesDetector.EUC_TW_FREQ[35][10] = 371;
        BytesDetector.EUC_TW_FREQ[41][37] = 370;
        BytesDetector.EUC_TW_FREQ[52][82] = 369;
        BytesDetector.EUC_TW_FREQ[91][72] = 368;
        BytesDetector.EUC_TW_FREQ[37][29] = 367;
        BytesDetector.EUC_TW_FREQ[56][30] = 366;
        BytesDetector.EUC_TW_FREQ[37][80] = 365;
        BytesDetector.EUC_TW_FREQ[81][56] = 364;
        BytesDetector.EUC_TW_FREQ[70][3] = 363;
        BytesDetector.EUC_TW_FREQ[76][15] = 362;
        BytesDetector.EUC_TW_FREQ[46][47] = 361;
        BytesDetector.EUC_TW_FREQ[35][88] = 360;
        BytesDetector.EUC_TW_FREQ[61][58] = 359;
        BytesDetector.EUC_TW_FREQ[37][37] = 358;
        BytesDetector.EUC_TW_FREQ[57][22] = 357;
        BytesDetector.EUC_TW_FREQ[41][23] = 356;
        BytesDetector.EUC_TW_FREQ[90][66] = 355;
        BytesDetector.EUC_TW_FREQ[39][60] = 354;
        BytesDetector.EUC_TW_FREQ[38][0] = 353;
        BytesDetector.EUC_TW_FREQ[37][87] = 352;
        BytesDetector.EUC_TW_FREQ[46][2] = 351;
        BytesDetector.EUC_TW_FREQ[38][56] = 350;
        BytesDetector.EUC_TW_FREQ[58][11] = 349;
        BytesDetector.EUC_TW_FREQ[48][10] = 348;
        BytesDetector.EUC_TW_FREQ[74][4] = 347;
        BytesDetector.EUC_TW_FREQ[40][42] = 346;
        BytesDetector.EUC_TW_FREQ[41][52] = 345;
        BytesDetector.EUC_TW_FREQ[61][92] = 344;
        BytesDetector.EUC_TW_FREQ[39][50] = 343;
        BytesDetector.EUC_TW_FREQ[47][88] = 342;
        BytesDetector.EUC_TW_FREQ[88][36] = 341;
        BytesDetector.EUC_TW_FREQ[45][73] = 340;
        BytesDetector.EUC_TW_FREQ[82][3] = 339;
        BytesDetector.EUC_TW_FREQ[61][36] = 338;
        BytesDetector.EUC_TW_FREQ[60][33] = 337;
        BytesDetector.EUC_TW_FREQ[38][27] = 336;
        BytesDetector.EUC_TW_FREQ[35][83] = 335;
        BytesDetector.EUC_TW_FREQ[65][24] = 334;
        BytesDetector.EUC_TW_FREQ[73][10] = 333;
        BytesDetector.EUC_TW_FREQ[41][13] = 332;
        BytesDetector.EUC_TW_FREQ[50][27] = 331;
        BytesDetector.EUC_TW_FREQ[59][50] = 330;
        BytesDetector.EUC_TW_FREQ[42][45] = 329;
        BytesDetector.EUC_TW_FREQ[55][19] = 328;
        BytesDetector.EUC_TW_FREQ[36][77] = 327;
        BytesDetector.EUC_TW_FREQ[69][31] = 326;
        BytesDetector.EUC_TW_FREQ[60][7] = 325;
        BytesDetector.EUC_TW_FREQ[40][88] = 324;
        BytesDetector.EUC_TW_FREQ[57][56] = 323;
        BytesDetector.EUC_TW_FREQ[50][50] = 322;
        BytesDetector.EUC_TW_FREQ[42][37] = 321;
        BytesDetector.EUC_TW_FREQ[38][82] = 320;
        BytesDetector.EUC_TW_FREQ[52][25] = 319;
        BytesDetector.EUC_TW_FREQ[42][67] = 318;
        BytesDetector.EUC_TW_FREQ[48][40] = 317;
        BytesDetector.EUC_TW_FREQ[45][81] = 316;
        BytesDetector.EUC_TW_FREQ[57][14] = 315;
        BytesDetector.EUC_TW_FREQ[42][13] = 314;
        BytesDetector.EUC_TW_FREQ[78][0] = 313;
        BytesDetector.EUC_TW_FREQ[35][51] = 312;
        BytesDetector.EUC_TW_FREQ[41][67] = 311;
        BytesDetector.EUC_TW_FREQ[64][23] = 310;
        BytesDetector.EUC_TW_FREQ[36][65] = 309;
        BytesDetector.EUC_TW_FREQ[48][50] = 308;
        BytesDetector.EUC_TW_FREQ[46][69] = 307;
        BytesDetector.EUC_TW_FREQ[47][89] = 306;
        BytesDetector.EUC_TW_FREQ[41][48] = 305;
        BytesDetector.EUC_TW_FREQ[60][56] = 304;
        BytesDetector.EUC_TW_FREQ[44][82] = 303;
        BytesDetector.EUC_TW_FREQ[47][35] = 302;
        BytesDetector.EUC_TW_FREQ[49][3] = 301;
        BytesDetector.EUC_TW_FREQ[49][69] = 300;
        BytesDetector.EUC_TW_FREQ[45][93] = 299;
        BytesDetector.EUC_TW_FREQ[60][34] = 298;
        BytesDetector.EUC_TW_FREQ[60][82] = 297;
        BytesDetector.EUC_TW_FREQ[61][61] = 296;
        BytesDetector.EUC_TW_FREQ[86][42] = 295;
        BytesDetector.EUC_TW_FREQ[89][60] = 294;
        BytesDetector.EUC_TW_FREQ[48][31] = 293;
        BytesDetector.EUC_TW_FREQ[35][75] = 292;
        BytesDetector.EUC_TW_FREQ[91][39] = 291;
        BytesDetector.EUC_TW_FREQ[53][19] = 290;
        BytesDetector.EUC_TW_FREQ[39][72] = 289;
        BytesDetector.EUC_TW_FREQ[69][59] = 288;
        BytesDetector.EUC_TW_FREQ[41][7] = 287;
        BytesDetector.EUC_TW_FREQ[54][13] = 286;
        BytesDetector.EUC_TW_FREQ[43][28] = 285;
        BytesDetector.EUC_TW_FREQ[36][6] = 284;
        BytesDetector.EUC_TW_FREQ[45][75] = 283;
        BytesDetector.EUC_TW_FREQ[36][61] = 282;
        BytesDetector.EUC_TW_FREQ[38][21] = 281;
        BytesDetector.EUC_TW_FREQ[45][14] = 280;
        BytesDetector.EUC_TW_FREQ[61][43] = 279;
        BytesDetector.EUC_TW_FREQ[36][63] = 278;
        BytesDetector.EUC_TW_FREQ[43][30] = 277;
        BytesDetector.EUC_TW_FREQ[46][51] = 276;
        BytesDetector.EUC_TW_FREQ[68][87] = 275;
        BytesDetector.EUC_TW_FREQ[39][26] = 274;
        BytesDetector.EUC_TW_FREQ[46][76] = 273;
        BytesDetector.EUC_TW_FREQ[36][15] = 272;
        BytesDetector.EUC_TW_FREQ[35][40] = 271;
        BytesDetector.EUC_TW_FREQ[79][60] = 270;
        BytesDetector.EUC_TW_FREQ[46][7] = 269;
        BytesDetector.EUC_TW_FREQ[65][72] = 268;
        BytesDetector.EUC_TW_FREQ[69][88] = 267;
        BytesDetector.EUC_TW_FREQ[47][18] = 266;
        BytesDetector.EUC_TW_FREQ[37][0] = 265;
        BytesDetector.EUC_TW_FREQ[37][49] = 264;
        BytesDetector.EUC_TW_FREQ[67][37] = 263;
        BytesDetector.EUC_TW_FREQ[36][91] = 262;
        BytesDetector.EUC_TW_FREQ[75][48] = 261;
        BytesDetector.EUC_TW_FREQ[75][63] = 260;
        BytesDetector.EUC_TW_FREQ[83][87] = 259;
        BytesDetector.EUC_TW_FREQ[37][44] = 258;
        BytesDetector.EUC_TW_FREQ[73][54] = 257;
        BytesDetector.EUC_TW_FREQ[51][61] = 256;
        BytesDetector.EUC_TW_FREQ[46][57] = 255;
        BytesDetector.EUC_TW_FREQ[55][21] = 254;
        BytesDetector.EUC_TW_FREQ[39][66] = 253;
        BytesDetector.EUC_TW_FREQ[47][11] = 252;
        BytesDetector.EUC_TW_FREQ[52][8] = 251;
        BytesDetector.EUC_TW_FREQ[82][81] = 250;
        BytesDetector.EUC_TW_FREQ[36][57] = 249;
        BytesDetector.EUC_TW_FREQ[38][54] = 248;
        BytesDetector.EUC_TW_FREQ[43][81] = 247;
        BytesDetector.EUC_TW_FREQ[37][42] = 246;
        BytesDetector.EUC_TW_FREQ[40][18] = 245;
        BytesDetector.EUC_TW_FREQ[80][90] = 244;
        BytesDetector.EUC_TW_FREQ[37][84] = 243;
        BytesDetector.EUC_TW_FREQ[57][15] = 242;
        BytesDetector.EUC_TW_FREQ[38][87] = 241;
        BytesDetector.EUC_TW_FREQ[37][32] = 240;
        BytesDetector.EUC_TW_FREQ[53][53] = 239;
        BytesDetector.EUC_TW_FREQ[89][29] = 238;
        BytesDetector.EUC_TW_FREQ[81][53] = 237;
        BytesDetector.EUC_TW_FREQ[75][3] = 236;
        BytesDetector.EUC_TW_FREQ[83][73] = 235;
        BytesDetector.EUC_TW_FREQ[66][13] = 234;
        BytesDetector.EUC_TW_FREQ[48][7] = 233;
        BytesDetector.EUC_TW_FREQ[46][35] = 232;
        BytesDetector.EUC_TW_FREQ[35][86] = 231;
        BytesDetector.EUC_TW_FREQ[37][20] = 230;
        BytesDetector.EUC_TW_FREQ[46][80] = 229;
        BytesDetector.EUC_TW_FREQ[38][24] = 228;
        BytesDetector.EUC_TW_FREQ[41][68] = 227;
        BytesDetector.EUC_TW_FREQ[42][21] = 226;
        BytesDetector.EUC_TW_FREQ[43][32] = 225;
        BytesDetector.EUC_TW_FREQ[38][20] = 224;
        BytesDetector.EUC_TW_FREQ[37][59] = 223;
        BytesDetector.EUC_TW_FREQ[41][77] = 222;
        BytesDetector.EUC_TW_FREQ[59][57] = 221;
        BytesDetector.EUC_TW_FREQ[68][59] = 220;
        BytesDetector.EUC_TW_FREQ[39][43] = 219;
        BytesDetector.EUC_TW_FREQ[54][39] = 218;
        BytesDetector.EUC_TW_FREQ[48][28] = 217;
        BytesDetector.EUC_TW_FREQ[54][28] = 216;
        BytesDetector.EUC_TW_FREQ[41][44] = 215;
        BytesDetector.EUC_TW_FREQ[51][64] = 214;
        BytesDetector.EUC_TW_FREQ[47][72] = 213;
        BytesDetector.EUC_TW_FREQ[62][67] = 212;
        BytesDetector.EUC_TW_FREQ[42][43] = 211;
        BytesDetector.EUC_TW_FREQ[61][38] = 210;
        BytesDetector.EUC_TW_FREQ[76][25] = 209;
        BytesDetector.EUC_TW_FREQ[48][91] = 208;
        BytesDetector.EUC_TW_FREQ[36][36] = 207;
        BytesDetector.EUC_TW_FREQ[80][32] = 206;
        BytesDetector.EUC_TW_FREQ[81][40] = 205;
        BytesDetector.EUC_TW_FREQ[37][5] = 204;
        BytesDetector.EUC_TW_FREQ[74][69] = 203;
        BytesDetector.EUC_TW_FREQ[36][82] = 202;
        BytesDetector.EUC_TW_FREQ[46][59] = 201;
        BytesDetector.GBK_FREQ[52][132] = 600;
        BytesDetector.GBK_FREQ[73][135] = 599;
        BytesDetector.GBK_FREQ[49][123] = 598;
        BytesDetector.GBK_FREQ[77][146] = 597;
        BytesDetector.GBK_FREQ[81][123] = 596;
        BytesDetector.GBK_FREQ[82][144] = 595;
        BytesDetector.GBK_FREQ[51][179] = 594;
        BytesDetector.GBK_FREQ[83][154] = 593;
        BytesDetector.GBK_FREQ[71][139] = 592;
        BytesDetector.GBK_FREQ[64][139] = 591;
        BytesDetector.GBK_FREQ[85][144] = 590;
        BytesDetector.GBK_FREQ[52][125] = 589;
        BytesDetector.GBK_FREQ[88][25] = 588;
        BytesDetector.GBK_FREQ[81][106] = 587;
        BytesDetector.GBK_FREQ[81][148] = 586;
        BytesDetector.GBK_FREQ[62][137] = 585;
        BytesDetector.GBK_FREQ[94][0] = 584;
        BytesDetector.GBK_FREQ[1][64] = 583;
        BytesDetector.GBK_FREQ[67][163] = 582;
        BytesDetector.GBK_FREQ[20][190] = 581;
        BytesDetector.GBK_FREQ[57][131] = 580;
        BytesDetector.GBK_FREQ[29][169] = 579;
        BytesDetector.GBK_FREQ[72][143] = 578;
        BytesDetector.GBK_FREQ[0][173] = 577;
        BytesDetector.GBK_FREQ[11][23] = 576;
        BytesDetector.GBK_FREQ[61][141] = 575;
        BytesDetector.GBK_FREQ[60][123] = 574;
        BytesDetector.GBK_FREQ[81][114] = 573;
        BytesDetector.GBK_FREQ[82][131] = 572;
        BytesDetector.GBK_FREQ[67][156] = 571;
        BytesDetector.GBK_FREQ[71][167] = 570;
        BytesDetector.GBK_FREQ[20][50] = 569;
        BytesDetector.GBK_FREQ[77][132] = 568;
        BytesDetector.GBK_FREQ[84][38] = 567;
        BytesDetector.GBK_FREQ[26][29] = 566;
        BytesDetector.GBK_FREQ[74][187] = 565;
        BytesDetector.GBK_FREQ[62][116] = 564;
        BytesDetector.GBK_FREQ[67][135] = 563;
        BytesDetector.GBK_FREQ[5][86] = 562;
        BytesDetector.GBK_FREQ[72][186] = 561;
        BytesDetector.GBK_FREQ[75][161] = 560;
        BytesDetector.GBK_FREQ[78][130] = 559;
        BytesDetector.GBK_FREQ[94][30] = 558;
        BytesDetector.GBK_FREQ[84][72] = 557;
        BytesDetector.GBK_FREQ[1][67] = 556;
        BytesDetector.GBK_FREQ[75][172] = 555;
        BytesDetector.GBK_FREQ[74][185] = 554;
        BytesDetector.GBK_FREQ[53][160] = 553;
        BytesDetector.GBK_FREQ[123][14] = 552;
        BytesDetector.GBK_FREQ[79][97] = 551;
        BytesDetector.GBK_FREQ[85][110] = 550;
        BytesDetector.GBK_FREQ[78][171] = 549;
        BytesDetector.GBK_FREQ[52][131] = 548;
        BytesDetector.GBK_FREQ[56][100] = 547;
        BytesDetector.GBK_FREQ[50][182] = 546;
        BytesDetector.GBK_FREQ[94][64] = 545;
        BytesDetector.GBK_FREQ[106][74] = 544;
        BytesDetector.GBK_FREQ[11][102] = 543;
        BytesDetector.GBK_FREQ[53][124] = 542;
        BytesDetector.GBK_FREQ[24][3] = 541;
        BytesDetector.GBK_FREQ[86][148] = 540;
        BytesDetector.GBK_FREQ[53][184] = 539;
        BytesDetector.GBK_FREQ[86][147] = 538;
        BytesDetector.GBK_FREQ[96][161] = 537;
        BytesDetector.GBK_FREQ[82][77] = 536;
        BytesDetector.GBK_FREQ[59][146] = 535;
        BytesDetector.GBK_FREQ[84][126] = 534;
        BytesDetector.GBK_FREQ[79][132] = 533;
        BytesDetector.GBK_FREQ[85][123] = 532;
        BytesDetector.GBK_FREQ[71][101] = 531;
        BytesDetector.GBK_FREQ[85][106] = 530;
        BytesDetector.GBK_FREQ[6][184] = 529;
        BytesDetector.GBK_FREQ[57][156] = 528;
        BytesDetector.GBK_FREQ[75][104] = 527;
        BytesDetector.GBK_FREQ[50][137] = 526;
        BytesDetector.GBK_FREQ[79][133] = 525;
        BytesDetector.GBK_FREQ[76][108] = 524;
        BytesDetector.GBK_FREQ[57][142] = 523;
        BytesDetector.GBK_FREQ[84][130] = 522;
        BytesDetector.GBK_FREQ[52][128] = 521;
        BytesDetector.GBK_FREQ[47][44] = 520;
        BytesDetector.GBK_FREQ[52][152] = 519;
        BytesDetector.GBK_FREQ[54][104] = 518;
        BytesDetector.GBK_FREQ[30][47] = 517;
        BytesDetector.GBK_FREQ[71][123] = 516;
        BytesDetector.GBK_FREQ[52][107] = 515;
        BytesDetector.GBK_FREQ[45][84] = 514;
        BytesDetector.GBK_FREQ[107][118] = 513;
        BytesDetector.GBK_FREQ[5][161] = 512;
        BytesDetector.GBK_FREQ[48][126] = 511;
        BytesDetector.GBK_FREQ[67][170] = 510;
        BytesDetector.GBK_FREQ[43][6] = 509;
        BytesDetector.GBK_FREQ[70][112] = 508;
        BytesDetector.GBK_FREQ[86][174] = 507;
        BytesDetector.GBK_FREQ[84][166] = 506;
        BytesDetector.GBK_FREQ[79][130] = 505;
        BytesDetector.GBK_FREQ[57][141] = 504;
        BytesDetector.GBK_FREQ[81][178] = 503;
        BytesDetector.GBK_FREQ[56][187] = 502;
        BytesDetector.GBK_FREQ[81][162] = 501;
        BytesDetector.GBK_FREQ[53][104] = 500;
        BytesDetector.GBK_FREQ[123][35] = 499;
        BytesDetector.GBK_FREQ[70][169] = 498;
        BytesDetector.GBK_FREQ[69][164] = 497;
        BytesDetector.GBK_FREQ[109][61] = 496;
        BytesDetector.GBK_FREQ[73][130] = 495;
        BytesDetector.GBK_FREQ[62][134] = 494;
        BytesDetector.GBK_FREQ[54][125] = 493;
        BytesDetector.GBK_FREQ[79][105] = 492;
        BytesDetector.GBK_FREQ[70][165] = 491;
        BytesDetector.GBK_FREQ[71][189] = 490;
        BytesDetector.GBK_FREQ[23][147] = 489;
        BytesDetector.GBK_FREQ[51][139] = 488;
        BytesDetector.GBK_FREQ[47][137] = 487;
        BytesDetector.GBK_FREQ[77][123] = 486;
        BytesDetector.GBK_FREQ[86][183] = 485;
        BytesDetector.GBK_FREQ[63][173] = 484;
        BytesDetector.GBK_FREQ[79][144] = 483;
        BytesDetector.GBK_FREQ[84][159] = 482;
        BytesDetector.GBK_FREQ[60][91] = 481;
        BytesDetector.GBK_FREQ[66][187] = 480;
        BytesDetector.GBK_FREQ[73][114] = 479;
        BytesDetector.GBK_FREQ[85][56] = 478;
        BytesDetector.GBK_FREQ[71][149] = 477;
        BytesDetector.GBK_FREQ[84][189] = 476;
        BytesDetector.GBK_FREQ[104][31] = 475;
        BytesDetector.GBK_FREQ[83][82] = 474;
        BytesDetector.GBK_FREQ[68][35] = 473;
        BytesDetector.GBK_FREQ[11][77] = 472;
        BytesDetector.GBK_FREQ[15][155] = 471;
        BytesDetector.GBK_FREQ[83][153] = 470;
        BytesDetector.GBK_FREQ[71][1] = 469;
        BytesDetector.GBK_FREQ[53][190] = 468;
        BytesDetector.GBK_FREQ[50][135] = 467;
        BytesDetector.GBK_FREQ[3][147] = 466;
        BytesDetector.GBK_FREQ[48][136] = 465;
        BytesDetector.GBK_FREQ[66][166] = 464;
        BytesDetector.GBK_FREQ[55][159] = 463;
        BytesDetector.GBK_FREQ[82][150] = 462;
        BytesDetector.GBK_FREQ[58][178] = 461;
        BytesDetector.GBK_FREQ[64][102] = 460;
        BytesDetector.GBK_FREQ[16][106] = 459;
        BytesDetector.GBK_FREQ[68][110] = 458;
        BytesDetector.GBK_FREQ[54][14] = 457;
        BytesDetector.GBK_FREQ[60][140] = 456;
        BytesDetector.GBK_FREQ[91][71] = 455;
        BytesDetector.GBK_FREQ[54][150] = 454;
        BytesDetector.GBK_FREQ[78][177] = 453;
        BytesDetector.GBK_FREQ[78][117] = 452;
        BytesDetector.GBK_FREQ[104][12] = 451;
        BytesDetector.GBK_FREQ[73][150] = 450;
        BytesDetector.GBK_FREQ[51][142] = 449;
        BytesDetector.GBK_FREQ[81][145] = 448;
        BytesDetector.GBK_FREQ[66][183] = 447;
        BytesDetector.GBK_FREQ[51][178] = 446;
        BytesDetector.GBK_FREQ[75][107] = 445;
        BytesDetector.GBK_FREQ[65][119] = 444;
        BytesDetector.GBK_FREQ[69][176] = 443;
        BytesDetector.GBK_FREQ[59][122] = 442;
        BytesDetector.GBK_FREQ[78][160] = 441;
        BytesDetector.GBK_FREQ[85][183] = 440;
        BytesDetector.GBK_FREQ[105][16] = 439;
        BytesDetector.GBK_FREQ[73][110] = 438;
        BytesDetector.GBK_FREQ[104][39] = 437;
        BytesDetector.GBK_FREQ[119][16] = 436;
        BytesDetector.GBK_FREQ[76][162] = 435;
        BytesDetector.GBK_FREQ[67][152] = 434;
        BytesDetector.GBK_FREQ[82][24] = 433;
        BytesDetector.GBK_FREQ[73][121] = 432;
        BytesDetector.GBK_FREQ[83][83] = 431;
        BytesDetector.GBK_FREQ[82][145] = 430;
        BytesDetector.GBK_FREQ[49][133] = 429;
        BytesDetector.GBK_FREQ[94][13] = 428;
        BytesDetector.GBK_FREQ[58][139] = 427;
        BytesDetector.GBK_FREQ[74][189] = 426;
        BytesDetector.GBK_FREQ[66][177] = 425;
        BytesDetector.GBK_FREQ[85][184] = 424;
        BytesDetector.GBK_FREQ[55][183] = 423;
        BytesDetector.GBK_FREQ[71][107] = 422;
        BytesDetector.GBK_FREQ[11][98] = 421;
        BytesDetector.GBK_FREQ[72][153] = 420;
        BytesDetector.GBK_FREQ[2][137] = 419;
        BytesDetector.GBK_FREQ[59][147] = 418;
        BytesDetector.GBK_FREQ[58][152] = 417;
        BytesDetector.GBK_FREQ[55][144] = 416;
        BytesDetector.GBK_FREQ[73][125] = 415;
        BytesDetector.GBK_FREQ[52][154] = 414;
        BytesDetector.GBK_FREQ[70][178] = 413;
        BytesDetector.GBK_FREQ[79][148] = 412;
        BytesDetector.GBK_FREQ[63][143] = 411;
        BytesDetector.GBK_FREQ[50][140] = 410;
        BytesDetector.GBK_FREQ[47][145] = 409;
        BytesDetector.GBK_FREQ[48][123] = 408;
        BytesDetector.GBK_FREQ[56][107] = 407;
        BytesDetector.GBK_FREQ[84][83] = 406;
        BytesDetector.GBK_FREQ[59][112] = 405;
        BytesDetector.GBK_FREQ[124][72] = 404;
        BytesDetector.GBK_FREQ[79][99] = 403;
        BytesDetector.GBK_FREQ[3][37] = 402;
        BytesDetector.GBK_FREQ[114][55] = 401;
        BytesDetector.GBK_FREQ[85][152] = 400;
        BytesDetector.GBK_FREQ[60][47] = 399;
        BytesDetector.GBK_FREQ[65][96] = 398;
        BytesDetector.GBK_FREQ[74][110] = 397;
        BytesDetector.GBK_FREQ[86][182] = 396;
        BytesDetector.GBK_FREQ[50][99] = 395;
        BytesDetector.GBK_FREQ[67][186] = 394;
        BytesDetector.GBK_FREQ[81][74] = 393;
        BytesDetector.GBK_FREQ[80][37] = 392;
        BytesDetector.GBK_FREQ[21][60] = 391;
        BytesDetector.GBK_FREQ[110][12] = 390;
        BytesDetector.GBK_FREQ[60][162] = 389;
        BytesDetector.GBK_FREQ[29][115] = 388;
        BytesDetector.GBK_FREQ[83][130] = 387;
        BytesDetector.GBK_FREQ[52][136] = 386;
        BytesDetector.GBK_FREQ[63][114] = 385;
        BytesDetector.GBK_FREQ[49][127] = 384;
        BytesDetector.GBK_FREQ[83][109] = 383;
        BytesDetector.GBK_FREQ[66][128] = 382;
        BytesDetector.GBK_FREQ[78][136] = 381;
        BytesDetector.GBK_FREQ[81][180] = 380;
        BytesDetector.GBK_FREQ[76][104] = 379;
        BytesDetector.GBK_FREQ[56][156] = 378;
        BytesDetector.GBK_FREQ[61][23] = 377;
        BytesDetector.GBK_FREQ[4][30] = 376;
        BytesDetector.GBK_FREQ[69][154] = 375;
        BytesDetector.GBK_FREQ[100][37] = 374;
        BytesDetector.GBK_FREQ[54][177] = 373;
        BytesDetector.GBK_FREQ[23][119] = 372;
        BytesDetector.GBK_FREQ[71][171] = 371;
        BytesDetector.GBK_FREQ[84][146] = 370;
        BytesDetector.GBK_FREQ[20][184] = 369;
        BytesDetector.GBK_FREQ[86][76] = 368;
        BytesDetector.GBK_FREQ[74][132] = 367;
        BytesDetector.GBK_FREQ[47][97] = 366;
        BytesDetector.GBK_FREQ[82][137] = 365;
        BytesDetector.GBK_FREQ[94][56] = 364;
        BytesDetector.GBK_FREQ[92][30] = 363;
        BytesDetector.GBK_FREQ[19][117] = 362;
        BytesDetector.GBK_FREQ[48][173] = 361;
        BytesDetector.GBK_FREQ[2][136] = 360;
        BytesDetector.GBK_FREQ[7][182] = 359;
        BytesDetector.GBK_FREQ[74][188] = 358;
        BytesDetector.GBK_FREQ[14][132] = 357;
        BytesDetector.GBK_FREQ[62][172] = 356;
        BytesDetector.GBK_FREQ[25][39] = 355;
        BytesDetector.GBK_FREQ[85][129] = 354;
        BytesDetector.GBK_FREQ[64][98] = 353;
        BytesDetector.GBK_FREQ[67][127] = 352;
        BytesDetector.GBK_FREQ[72][167] = 351;
        BytesDetector.GBK_FREQ[57][143] = 350;
        BytesDetector.GBK_FREQ[76][187] = 349;
        BytesDetector.GBK_FREQ[83][181] = 348;
        BytesDetector.GBK_FREQ[84][10] = 347;
        BytesDetector.GBK_FREQ[55][166] = 346;
        BytesDetector.GBK_FREQ[55][188] = 345;
        BytesDetector.GBK_FREQ[13][151] = 344;
        BytesDetector.GBK_FREQ[62][124] = 343;
        BytesDetector.GBK_FREQ[53][136] = 342;
        BytesDetector.GBK_FREQ[106][57] = 341;
        BytesDetector.GBK_FREQ[47][166] = 340;
        BytesDetector.GBK_FREQ[109][30] = 339;
        BytesDetector.GBK_FREQ[78][114] = 338;
        BytesDetector.GBK_FREQ[83][19] = 337;
        BytesDetector.GBK_FREQ[56][162] = 336;
        BytesDetector.GBK_FREQ[60][177] = 335;
        BytesDetector.GBK_FREQ[88][9] = 334;
        BytesDetector.GBK_FREQ[74][163] = 333;
        BytesDetector.GBK_FREQ[52][156] = 332;
        BytesDetector.GBK_FREQ[71][180] = 331;
        BytesDetector.GBK_FREQ[60][57] = 330;
        BytesDetector.GBK_FREQ[72][173] = 329;
        BytesDetector.GBK_FREQ[82][91] = 328;
        BytesDetector.GBK_FREQ[51][186] = 327;
        BytesDetector.GBK_FREQ[75][86] = 326;
        BytesDetector.GBK_FREQ[75][78] = 325;
        BytesDetector.GBK_FREQ[76][170] = 324;
        BytesDetector.GBK_FREQ[60][147] = 323;
        BytesDetector.GBK_FREQ[82][75] = 322;
        BytesDetector.GBK_FREQ[80][148] = 321;
        BytesDetector.GBK_FREQ[86][150] = 320;
        BytesDetector.GBK_FREQ[13][95] = 319;
        BytesDetector.GBK_FREQ[0][11] = 318;
        BytesDetector.GBK_FREQ[84][190] = 317;
        BytesDetector.GBK_FREQ[76][166] = 316;
        BytesDetector.GBK_FREQ[14][72] = 315;
        BytesDetector.GBK_FREQ[67][144] = 314;
        BytesDetector.GBK_FREQ[84][44] = 313;
        BytesDetector.GBK_FREQ[72][125] = 312;
        BytesDetector.GBK_FREQ[66][127] = 311;
        BytesDetector.GBK_FREQ[60][25] = 310;
        BytesDetector.GBK_FREQ[70][146] = 309;
        BytesDetector.GBK_FREQ[79][135] = 308;
        BytesDetector.GBK_FREQ[54][135] = 307;
        BytesDetector.GBK_FREQ[60][104] = 306;
        BytesDetector.GBK_FREQ[55][132] = 305;
        BytesDetector.GBK_FREQ[94][2] = 304;
        BytesDetector.GBK_FREQ[54][133] = 303;
        BytesDetector.GBK_FREQ[56][190] = 302;
        BytesDetector.GBK_FREQ[58][174] = 301;
        BytesDetector.GBK_FREQ[80][144] = 300;
        BytesDetector.GBK_FREQ[85][113] = 299;
        BytesDetector.KR_FREQ[31][43] = 600;
        BytesDetector.KR_FREQ[19][56] = 599;
        BytesDetector.KR_FREQ[38][46] = 598;
        BytesDetector.KR_FREQ[3][3] = 597;
        BytesDetector.KR_FREQ[29][77] = 596;
        BytesDetector.KR_FREQ[19][33] = 595;
        BytesDetector.KR_FREQ[30][0] = 594;
        BytesDetector.KR_FREQ[29][89] = 593;
        BytesDetector.KR_FREQ[31][26] = 592;
        BytesDetector.KR_FREQ[31][38] = 591;
        BytesDetector.KR_FREQ[32][85] = 590;
        BytesDetector.KR_FREQ[15][0] = 589;
        BytesDetector.KR_FREQ[16][54] = 588;
        BytesDetector.KR_FREQ[15][76] = 587;
        BytesDetector.KR_FREQ[31][25] = 586;
        BytesDetector.KR_FREQ[23][13] = 585;
        BytesDetector.KR_FREQ[28][34] = 584;
        BytesDetector.KR_FREQ[18][9] = 583;
        BytesDetector.KR_FREQ[29][37] = 582;
        BytesDetector.KR_FREQ[22][45] = 581;
        BytesDetector.KR_FREQ[19][46] = 580;
        BytesDetector.KR_FREQ[16][65] = 579;
        BytesDetector.KR_FREQ[23][5] = 578;
        BytesDetector.KR_FREQ[26][70] = 577;
        BytesDetector.KR_FREQ[31][53] = 576;
        BytesDetector.KR_FREQ[27][12] = 575;
        BytesDetector.KR_FREQ[30][67] = 574;
        BytesDetector.KR_FREQ[31][57] = 573;
        BytesDetector.KR_FREQ[20][20] = 572;
        BytesDetector.KR_FREQ[30][31] = 571;
        BytesDetector.KR_FREQ[20][72] = 570;
        BytesDetector.KR_FREQ[15][51] = 569;
        BytesDetector.KR_FREQ[3][8] = 568;
        BytesDetector.KR_FREQ[32][53] = 567;
        BytesDetector.KR_FREQ[27][85] = 566;
        BytesDetector.KR_FREQ[25][23] = 565;
        BytesDetector.KR_FREQ[15][44] = 564;
        BytesDetector.KR_FREQ[32][3] = 563;
        BytesDetector.KR_FREQ[31][68] = 562;
        BytesDetector.KR_FREQ[30][24] = 561;
        BytesDetector.KR_FREQ[29][49] = 560;
        BytesDetector.KR_FREQ[27][49] = 559;
        BytesDetector.KR_FREQ[23][23] = 558;
        BytesDetector.KR_FREQ[31][91] = 557;
        BytesDetector.KR_FREQ[31][46] = 556;
        BytesDetector.KR_FREQ[19][74] = 555;
        BytesDetector.KR_FREQ[27][27] = 554;
        BytesDetector.KR_FREQ[3][17] = 553;
        BytesDetector.KR_FREQ[20][38] = 552;
        BytesDetector.KR_FREQ[21][82] = 551;
        BytesDetector.KR_FREQ[28][25] = 550;
        BytesDetector.KR_FREQ[32][5] = 549;
        BytesDetector.KR_FREQ[31][23] = 548;
        BytesDetector.KR_FREQ[25][45] = 547;
        BytesDetector.KR_FREQ[32][87] = 546;
        BytesDetector.KR_FREQ[18][26] = 545;
        BytesDetector.KR_FREQ[24][10] = 544;
        BytesDetector.KR_FREQ[26][82] = 543;
        BytesDetector.KR_FREQ[15][89] = 542;
        BytesDetector.KR_FREQ[28][36] = 541;
        BytesDetector.KR_FREQ[28][31] = 540;
        BytesDetector.KR_FREQ[16][23] = 539;
        BytesDetector.KR_FREQ[16][77] = 538;
        BytesDetector.KR_FREQ[19][84] = 537;
        BytesDetector.KR_FREQ[23][72] = 536;
        BytesDetector.KR_FREQ[38][48] = 535;
        BytesDetector.KR_FREQ[23][2] = 534;
        BytesDetector.KR_FREQ[30][20] = 533;
        BytesDetector.KR_FREQ[38][47] = 532;
        BytesDetector.KR_FREQ[39][12] = 531;
        BytesDetector.KR_FREQ[23][21] = 530;
        BytesDetector.KR_FREQ[18][17] = 529;
        BytesDetector.KR_FREQ[30][87] = 528;
        BytesDetector.KR_FREQ[29][62] = 527;
        BytesDetector.KR_FREQ[29][87] = 526;
        BytesDetector.KR_FREQ[34][53] = 525;
        BytesDetector.KR_FREQ[32][29] = 524;
        BytesDetector.KR_FREQ[35][0] = 523;
        BytesDetector.KR_FREQ[24][43] = 522;
        BytesDetector.KR_FREQ[36][44] = 521;
        BytesDetector.KR_FREQ[20][30] = 520;
        BytesDetector.KR_FREQ[39][86] = 519;
        BytesDetector.KR_FREQ[22][14] = 518;
        BytesDetector.KR_FREQ[29][39] = 517;
        BytesDetector.KR_FREQ[28][38] = 516;
        BytesDetector.KR_FREQ[23][79] = 515;
        BytesDetector.KR_FREQ[24][56] = 514;
        BytesDetector.KR_FREQ[29][63] = 513;
        BytesDetector.KR_FREQ[31][45] = 512;
        BytesDetector.KR_FREQ[23][26] = 511;
        BytesDetector.KR_FREQ[15][87] = 510;
        BytesDetector.KR_FREQ[30][74] = 509;
        BytesDetector.KR_FREQ[24][69] = 508;
        BytesDetector.KR_FREQ[20][4] = 507;
        BytesDetector.KR_FREQ[27][50] = 506;
        BytesDetector.KR_FREQ[30][75] = 505;
        BytesDetector.KR_FREQ[24][13] = 504;
        BytesDetector.KR_FREQ[30][8] = 503;
        BytesDetector.KR_FREQ[31][6] = 502;
        BytesDetector.KR_FREQ[25][80] = 501;
        BytesDetector.KR_FREQ[36][8] = 500;
        BytesDetector.KR_FREQ[15][18] = 499;
        BytesDetector.KR_FREQ[39][23] = 498;
        BytesDetector.KR_FREQ[16][24] = 497;
        BytesDetector.KR_FREQ[31][89] = 496;
        BytesDetector.KR_FREQ[15][71] = 495;
        BytesDetector.KR_FREQ[15][57] = 494;
        BytesDetector.KR_FREQ[30][11] = 493;
        BytesDetector.KR_FREQ[15][36] = 492;
        BytesDetector.KR_FREQ[16][60] = 491;
        BytesDetector.KR_FREQ[24][45] = 490;
        BytesDetector.KR_FREQ[37][35] = 489;
        BytesDetector.KR_FREQ[24][87] = 488;
        BytesDetector.KR_FREQ[20][45] = 487;
        BytesDetector.KR_FREQ[31][90] = 486;
        BytesDetector.KR_FREQ[32][21] = 485;
        BytesDetector.KR_FREQ[19][70] = 484;
        BytesDetector.KR_FREQ[24][15] = 483;
        BytesDetector.KR_FREQ[26][92] = 482;
        BytesDetector.KR_FREQ[37][13] = 481;
        BytesDetector.KR_FREQ[39][2] = 480;
        BytesDetector.KR_FREQ[23][70] = 479;
        BytesDetector.KR_FREQ[27][25] = 478;
        BytesDetector.KR_FREQ[15][69] = 477;
        BytesDetector.KR_FREQ[19][61] = 476;
        BytesDetector.KR_FREQ[31][58] = 475;
        BytesDetector.KR_FREQ[24][57] = 474;
        BytesDetector.KR_FREQ[36][74] = 473;
        BytesDetector.KR_FREQ[21][6] = 472;
        BytesDetector.KR_FREQ[30][44] = 471;
        BytesDetector.KR_FREQ[15][91] = 470;
        BytesDetector.KR_FREQ[27][16] = 469;
        BytesDetector.KR_FREQ[29][42] = 468;
        BytesDetector.KR_FREQ[33][86] = 467;
        BytesDetector.KR_FREQ[29][41] = 466;
        BytesDetector.KR_FREQ[20][68] = 465;
        BytesDetector.KR_FREQ[25][47] = 464;
        BytesDetector.KR_FREQ[22][0] = 463;
        BytesDetector.KR_FREQ[18][14] = 462;
        BytesDetector.KR_FREQ[31][28] = 461;
        BytesDetector.KR_FREQ[15][2] = 460;
        BytesDetector.KR_FREQ[23][76] = 459;
        BytesDetector.KR_FREQ[38][32] = 458;
        BytesDetector.KR_FREQ[29][82] = 457;
        BytesDetector.KR_FREQ[21][86] = 456;
        BytesDetector.KR_FREQ[24][62] = 455;
        BytesDetector.KR_FREQ[31][64] = 454;
        BytesDetector.KR_FREQ[38][26] = 453;
        BytesDetector.KR_FREQ[32][86] = 452;
        BytesDetector.KR_FREQ[22][32] = 451;
        BytesDetector.KR_FREQ[19][59] = 450;
        BytesDetector.KR_FREQ[34][18] = 449;
        BytesDetector.KR_FREQ[18][54] = 448;
        BytesDetector.KR_FREQ[38][63] = 447;
        BytesDetector.KR_FREQ[36][23] = 446;
        BytesDetector.KR_FREQ[35][35] = 445;
        BytesDetector.KR_FREQ[32][62] = 444;
        BytesDetector.KR_FREQ[28][35] = 443;
        BytesDetector.KR_FREQ[27][13] = 442;
        BytesDetector.KR_FREQ[31][59] = 441;
        BytesDetector.KR_FREQ[29][29] = 440;
        BytesDetector.KR_FREQ[15][64] = 439;
        BytesDetector.KR_FREQ[26][84] = 438;
        BytesDetector.KR_FREQ[21][90] = 437;
        BytesDetector.KR_FREQ[20][24] = 436;
        BytesDetector.KR_FREQ[16][18] = 435;
        BytesDetector.KR_FREQ[22][23] = 434;
        BytesDetector.KR_FREQ[31][14] = 433;
        BytesDetector.KR_FREQ[15][1] = 432;
        BytesDetector.KR_FREQ[18][63] = 431;
        BytesDetector.KR_FREQ[19][10] = 430;
        BytesDetector.KR_FREQ[25][49] = 429;
        BytesDetector.KR_FREQ[36][57] = 428;
        BytesDetector.KR_FREQ[20][22] = 427;
        BytesDetector.KR_FREQ[15][15] = 426;
        BytesDetector.KR_FREQ[31][51] = 425;
        BytesDetector.KR_FREQ[24][60] = 424;
        BytesDetector.KR_FREQ[31][70] = 423;
        BytesDetector.KR_FREQ[15][7] = 422;
        BytesDetector.KR_FREQ[28][40] = 421;
        BytesDetector.KR_FREQ[18][41] = 420;
        BytesDetector.KR_FREQ[15][38] = 419;
        BytesDetector.KR_FREQ[32][0] = 418;
        BytesDetector.KR_FREQ[19][51] = 417;
        BytesDetector.KR_FREQ[34][62] = 416;
        BytesDetector.KR_FREQ[16][27] = 415;
        BytesDetector.KR_FREQ[20][70] = 414;
        BytesDetector.KR_FREQ[22][33] = 413;
        BytesDetector.KR_FREQ[26][73] = 412;
        BytesDetector.KR_FREQ[20][79] = 411;
        BytesDetector.KR_FREQ[23][6] = 410;
        BytesDetector.KR_FREQ[24][85] = 409;
        BytesDetector.KR_FREQ[38][51] = 408;
        BytesDetector.KR_FREQ[29][88] = 407;
        BytesDetector.KR_FREQ[38][55] = 406;
        BytesDetector.KR_FREQ[32][32] = 405;
        BytesDetector.KR_FREQ[27][18] = 404;
        BytesDetector.KR_FREQ[23][87] = 403;
        BytesDetector.KR_FREQ[35][6] = 402;
        BytesDetector.KR_FREQ[34][27] = 401;
        BytesDetector.KR_FREQ[39][35] = 400;
        BytesDetector.KR_FREQ[30][88] = 399;
        BytesDetector.KR_FREQ[32][92] = 398;
        BytesDetector.KR_FREQ[32][49] = 397;
        BytesDetector.KR_FREQ[24][61] = 396;
        BytesDetector.KR_FREQ[18][74] = 395;
        BytesDetector.KR_FREQ[23][77] = 394;
        BytesDetector.KR_FREQ[23][50] = 393;
        BytesDetector.KR_FREQ[23][32] = 392;
        BytesDetector.KR_FREQ[23][36] = 391;
        BytesDetector.KR_FREQ[38][38] = 390;
        BytesDetector.KR_FREQ[29][86] = 389;
        BytesDetector.KR_FREQ[36][15] = 388;
        BytesDetector.KR_FREQ[31][50] = 387;
        BytesDetector.KR_FREQ[15][86] = 386;
        BytesDetector.KR_FREQ[39][13] = 385;
        BytesDetector.KR_FREQ[34][26] = 384;
        BytesDetector.KR_FREQ[19][34] = 383;
        BytesDetector.KR_FREQ[16][3] = 382;
        BytesDetector.KR_FREQ[26][93] = 381;
        BytesDetector.KR_FREQ[19][67] = 380;
        BytesDetector.KR_FREQ[24][72] = 379;
        BytesDetector.KR_FREQ[29][17] = 378;
        BytesDetector.KR_FREQ[23][24] = 377;
        BytesDetector.KR_FREQ[25][19] = 376;
        BytesDetector.KR_FREQ[18][65] = 375;
        BytesDetector.KR_FREQ[30][78] = 374;
        BytesDetector.KR_FREQ[27][52] = 373;
        BytesDetector.KR_FREQ[22][18] = 372;
        BytesDetector.KR_FREQ[16][38] = 371;
        BytesDetector.KR_FREQ[21][26] = 370;
        BytesDetector.KR_FREQ[34][20] = 369;
        BytesDetector.KR_FREQ[15][42] = 368;
        BytesDetector.KR_FREQ[16][71] = 367;
        BytesDetector.KR_FREQ[17][17] = 366;
        BytesDetector.KR_FREQ[24][71] = 365;
        BytesDetector.KR_FREQ[18][84] = 364;
        BytesDetector.KR_FREQ[15][40] = 363;
        BytesDetector.KR_FREQ[31][62] = 362;
        BytesDetector.KR_FREQ[15][8] = 361;
        BytesDetector.KR_FREQ[16][69] = 360;
        BytesDetector.KR_FREQ[29][79] = 359;
        BytesDetector.KR_FREQ[38][91] = 358;
        BytesDetector.KR_FREQ[31][92] = 357;
        BytesDetector.KR_FREQ[20][77] = 356;
        BytesDetector.KR_FREQ[3][16] = 355;
        BytesDetector.KR_FREQ[27][87] = 354;
        BytesDetector.KR_FREQ[16][25] = 353;
        BytesDetector.KR_FREQ[36][33] = 352;
        BytesDetector.KR_FREQ[37][76] = 351;
        BytesDetector.KR_FREQ[30][12] = 350;
        BytesDetector.KR_FREQ[26][75] = 349;
        BytesDetector.KR_FREQ[25][14] = 348;
        BytesDetector.KR_FREQ[32][26] = 347;
        BytesDetector.KR_FREQ[23][22] = 346;
        BytesDetector.KR_FREQ[20][90] = 345;
        BytesDetector.KR_FREQ[19][8] = 344;
        BytesDetector.KR_FREQ[38][41] = 343;
        BytesDetector.KR_FREQ[34][2] = 342;
        BytesDetector.KR_FREQ[39][4] = 341;
        BytesDetector.KR_FREQ[27][89] = 340;
        BytesDetector.KR_FREQ[28][41] = 339;
        BytesDetector.KR_FREQ[28][44] = 338;
        BytesDetector.KR_FREQ[24][92] = 337;
        BytesDetector.KR_FREQ[34][65] = 336;
        BytesDetector.KR_FREQ[39][14] = 335;
        BytesDetector.KR_FREQ[21][38] = 334;
        BytesDetector.KR_FREQ[19][31] = 333;
        BytesDetector.KR_FREQ[37][39] = 332;
        BytesDetector.KR_FREQ[33][41] = 331;
        BytesDetector.KR_FREQ[38][4] = 330;
        BytesDetector.KR_FREQ[23][80] = 329;
        BytesDetector.KR_FREQ[25][24] = 328;
        BytesDetector.KR_FREQ[37][17] = 327;
        BytesDetector.KR_FREQ[22][16] = 326;
        BytesDetector.KR_FREQ[22][46] = 325;
        BytesDetector.KR_FREQ[33][91] = 324;
        BytesDetector.KR_FREQ[24][89] = 323;
        BytesDetector.KR_FREQ[30][52] = 322;
        BytesDetector.KR_FREQ[29][38] = 321;
        BytesDetector.KR_FREQ[38][85] = 320;
        BytesDetector.KR_FREQ[15][12] = 319;
        BytesDetector.KR_FREQ[27][58] = 318;
        BytesDetector.KR_FREQ[29][52] = 317;
        BytesDetector.KR_FREQ[37][38] = 316;
        BytesDetector.KR_FREQ[34][41] = 315;
        BytesDetector.KR_FREQ[31][65] = 314;
        BytesDetector.KR_FREQ[29][53] = 313;
        BytesDetector.KR_FREQ[22][47] = 312;
        BytesDetector.KR_FREQ[22][19] = 311;
        BytesDetector.KR_FREQ[26][0] = 310;
        BytesDetector.KR_FREQ[37][86] = 309;
        BytesDetector.KR_FREQ[35][4] = 308;
        BytesDetector.KR_FREQ[36][54] = 307;
        BytesDetector.KR_FREQ[20][76] = 306;
        BytesDetector.KR_FREQ[30][9] = 305;
        BytesDetector.KR_FREQ[30][33] = 304;
        BytesDetector.KR_FREQ[23][17] = 303;
        BytesDetector.KR_FREQ[23][33] = 302;
        BytesDetector.KR_FREQ[38][52] = 301;
        BytesDetector.KR_FREQ[15][19] = 300;
        BytesDetector.KR_FREQ[28][45] = 299;
        BytesDetector.KR_FREQ[29][78] = 298;
        BytesDetector.KR_FREQ[23][15] = 297;
        BytesDetector.KR_FREQ[33][5] = 296;
        BytesDetector.KR_FREQ[17][40] = 295;
        BytesDetector.KR_FREQ[30][83] = 294;
        BytesDetector.KR_FREQ[18][1] = 293;
        BytesDetector.KR_FREQ[30][81] = 292;
        BytesDetector.KR_FREQ[19][40] = 291;
        BytesDetector.KR_FREQ[24][47] = 290;
        BytesDetector.KR_FREQ[17][56] = 289;
        BytesDetector.KR_FREQ[39][80] = 288;
        BytesDetector.KR_FREQ[30][46] = 287;
        BytesDetector.KR_FREQ[16][61] = 286;
        BytesDetector.KR_FREQ[26][78] = 285;
        BytesDetector.KR_FREQ[26][57] = 284;
        BytesDetector.KR_FREQ[20][46] = 283;
        BytesDetector.KR_FREQ[25][15] = 282;
        BytesDetector.KR_FREQ[25][91] = 281;
        BytesDetector.KR_FREQ[21][83] = 280;
        BytesDetector.KR_FREQ[30][77] = 279;
        BytesDetector.KR_FREQ[35][30] = 278;
        BytesDetector.KR_FREQ[30][34] = 277;
        BytesDetector.KR_FREQ[20][69] = 276;
        BytesDetector.KR_FREQ[35][10] = 275;
        BytesDetector.KR_FREQ[29][70] = 274;
        BytesDetector.KR_FREQ[22][50] = 273;
        BytesDetector.KR_FREQ[18][0] = 272;
        BytesDetector.KR_FREQ[22][64] = 271;
        BytesDetector.KR_FREQ[38][65] = 270;
        BytesDetector.KR_FREQ[22][70] = 269;
        BytesDetector.KR_FREQ[24][58] = 268;
        BytesDetector.KR_FREQ[19][66] = 267;
        BytesDetector.KR_FREQ[30][59] = 266;
        BytesDetector.KR_FREQ[37][14] = 265;
        BytesDetector.KR_FREQ[16][56] = 264;
        BytesDetector.KR_FREQ[29][85] = 263;
        BytesDetector.KR_FREQ[31][15] = 262;
        BytesDetector.KR_FREQ[36][84] = 261;
        BytesDetector.KR_FREQ[39][15] = 260;
        BytesDetector.KR_FREQ[39][90] = 259;
        BytesDetector.KR_FREQ[18][12] = 258;
        BytesDetector.KR_FREQ[21][93] = 257;
        BytesDetector.KR_FREQ[24][66] = 256;
        BytesDetector.KR_FREQ[27][90] = 255;
        BytesDetector.KR_FREQ[25][90] = 254;
        BytesDetector.KR_FREQ[22][24] = 253;
        BytesDetector.KR_FREQ[36][67] = 252;
        BytesDetector.KR_FREQ[33][90] = 251;
        BytesDetector.KR_FREQ[15][60] = 250;
        BytesDetector.KR_FREQ[23][85] = 249;
        BytesDetector.KR_FREQ[34][1] = 248;
        BytesDetector.KR_FREQ[39][37] = 247;
        BytesDetector.KR_FREQ[21][18] = 246;
        BytesDetector.KR_FREQ[34][4] = 245;
        BytesDetector.KR_FREQ[28][33] = 244;
        BytesDetector.KR_FREQ[15][13] = 243;
        BytesDetector.KR_FREQ[32][22] = 242;
        BytesDetector.KR_FREQ[30][76] = 241;
        BytesDetector.KR_FREQ[20][21] = 240;
        BytesDetector.KR_FREQ[38][66] = 239;
        BytesDetector.KR_FREQ[32][55] = 238;
        BytesDetector.KR_FREQ[32][89] = 237;
        BytesDetector.KR_FREQ[25][26] = 236;
        BytesDetector.KR_FREQ[16][80] = 235;
        BytesDetector.KR_FREQ[15][43] = 234;
        BytesDetector.KR_FREQ[38][54] = 233;
        BytesDetector.KR_FREQ[39][68] = 232;
        BytesDetector.KR_FREQ[22][88] = 231;
        BytesDetector.KR_FREQ[21][84] = 230;
        BytesDetector.KR_FREQ[21][17] = 229;
        BytesDetector.KR_FREQ[20][28] = 228;
        BytesDetector.KR_FREQ[32][1] = 227;
        BytesDetector.KR_FREQ[33][87] = 226;
        BytesDetector.KR_FREQ[38][71] = 225;
        BytesDetector.KR_FREQ[37][47] = 224;
        BytesDetector.KR_FREQ[18][77] = 223;
        BytesDetector.KR_FREQ[37][58] = 222;
        BytesDetector.KR_FREQ[34][74] = 221;
        BytesDetector.KR_FREQ[32][54] = 220;
        BytesDetector.KR_FREQ[27][33] = 219;
        BytesDetector.KR_FREQ[32][93] = 218;
        BytesDetector.KR_FREQ[23][51] = 217;
        BytesDetector.KR_FREQ[20][57] = 216;
        BytesDetector.KR_FREQ[22][37] = 215;
        BytesDetector.KR_FREQ[39][10] = 214;
        BytesDetector.KR_FREQ[39][17] = 213;
        BytesDetector.KR_FREQ[33][4] = 212;
        BytesDetector.KR_FREQ[32][84] = 211;
        BytesDetector.KR_FREQ[34][3] = 210;
        BytesDetector.KR_FREQ[28][27] = 209;
        BytesDetector.KR_FREQ[15][79] = 208;
        BytesDetector.KR_FREQ[34][21] = 207;
        BytesDetector.KR_FREQ[34][69] = 206;
        BytesDetector.KR_FREQ[21][62] = 205;
        BytesDetector.KR_FREQ[36][24] = 204;
        BytesDetector.KR_FREQ[16][89] = 203;
        BytesDetector.KR_FREQ[18][48] = 202;
        BytesDetector.KR_FREQ[38][15] = 201;
        BytesDetector.KR_FREQ[36][58] = 200;
        BytesDetector.KR_FREQ[21][56] = 199;
        BytesDetector.KR_FREQ[34][48] = 198;
        BytesDetector.KR_FREQ[21][15] = 197;
        BytesDetector.KR_FREQ[39][3] = 196;
        BytesDetector.KR_FREQ[16][44] = 195;
        BytesDetector.KR_FREQ[18][79] = 194;
        BytesDetector.KR_FREQ[25][13] = 193;
        BytesDetector.KR_FREQ[29][47] = 192;
        BytesDetector.KR_FREQ[38][88] = 191;
        BytesDetector.KR_FREQ[20][71] = 190;
        BytesDetector.KR_FREQ[16][58] = 189;
        BytesDetector.KR_FREQ[35][57] = 188;
        BytesDetector.KR_FREQ[29][30] = 187;
        BytesDetector.KR_FREQ[29][23] = 186;
        BytesDetector.KR_FREQ[34][93] = 185;
        BytesDetector.KR_FREQ[30][85] = 184;
        BytesDetector.KR_FREQ[15][80] = 183;
        BytesDetector.KR_FREQ[32][78] = 182;
        BytesDetector.KR_FREQ[37][82] = 181;
        BytesDetector.KR_FREQ[22][40] = 180;
        BytesDetector.KR_FREQ[21][69] = 179;
        BytesDetector.KR_FREQ[26][85] = 178;
        BytesDetector.KR_FREQ[31][31] = 177;
        BytesDetector.KR_FREQ[28][64] = 176;
        BytesDetector.KR_FREQ[38][13] = 175;
        BytesDetector.KR_FREQ[25][2] = 174;
        BytesDetector.KR_FREQ[22][34] = 173;
        BytesDetector.KR_FREQ[28][28] = 172;
        BytesDetector.KR_FREQ[24][91] = 171;
        BytesDetector.KR_FREQ[33][74] = 170;
        BytesDetector.KR_FREQ[29][40] = 169;
        BytesDetector.KR_FREQ[15][77] = 168;
        BytesDetector.KR_FREQ[32][80] = 167;
        BytesDetector.KR_FREQ[30][41] = 166;
        BytesDetector.KR_FREQ[23][30] = 165;
        BytesDetector.KR_FREQ[24][63] = 164;
        BytesDetector.KR_FREQ[30][53] = 163;
        BytesDetector.KR_FREQ[39][70] = 162;
        BytesDetector.KR_FREQ[23][61] = 161;
        BytesDetector.KR_FREQ[37][27] = 160;
        BytesDetector.KR_FREQ[16][55] = 159;
        BytesDetector.KR_FREQ[22][74] = 158;
        BytesDetector.KR_FREQ[26][50] = 157;
        BytesDetector.KR_FREQ[16][10] = 156;
        BytesDetector.KR_FREQ[34][63] = 155;
        BytesDetector.KR_FREQ[35][14] = 154;
        BytesDetector.KR_FREQ[17][7] = 153;
        BytesDetector.KR_FREQ[15][59] = 152;
        BytesDetector.KR_FREQ[27][23] = 151;
        BytesDetector.KR_FREQ[18][70] = 150;
        BytesDetector.KR_FREQ[32][56] = 149;
        BytesDetector.KR_FREQ[37][87] = 148;
        BytesDetector.KR_FREQ[17][61] = 147;
        BytesDetector.KR_FREQ[18][83] = 146;
        BytesDetector.KR_FREQ[23][86] = 145;
        BytesDetector.KR_FREQ[17][31] = 144;
        BytesDetector.KR_FREQ[23][83] = 143;
        BytesDetector.KR_FREQ[35][2] = 142;
        BytesDetector.KR_FREQ[18][64] = 141;
        BytesDetector.KR_FREQ[27][43] = 140;
        BytesDetector.KR_FREQ[32][42] = 139;
        BytesDetector.KR_FREQ[25][76] = 138;
        BytesDetector.KR_FREQ[19][85] = 137;
        BytesDetector.KR_FREQ[37][81] = 136;
        BytesDetector.KR_FREQ[38][83] = 135;
        BytesDetector.KR_FREQ[35][7] = 134;
        BytesDetector.KR_FREQ[16][51] = 133;
        BytesDetector.KR_FREQ[27][22] = 132;
        BytesDetector.KR_FREQ[16][76] = 131;
        BytesDetector.KR_FREQ[22][4] = 130;
        BytesDetector.KR_FREQ[38][84] = 129;
        BytesDetector.KR_FREQ[17][83] = 128;
        BytesDetector.KR_FREQ[24][46] = 127;
        BytesDetector.KR_FREQ[33][15] = 126;
        BytesDetector.KR_FREQ[20][48] = 125;
        BytesDetector.KR_FREQ[17][30] = 124;
        BytesDetector.KR_FREQ[30][93] = 123;
        BytesDetector.KR_FREQ[28][11] = 122;
        BytesDetector.KR_FREQ[28][30] = 121;
        BytesDetector.KR_FREQ[15][62] = 120;
        BytesDetector.KR_FREQ[17][87] = 119;
        BytesDetector.KR_FREQ[32][81] = 118;
        BytesDetector.KR_FREQ[23][37] = 117;
        BytesDetector.KR_FREQ[30][22] = 116;
        BytesDetector.KR_FREQ[32][66] = 115;
        BytesDetector.KR_FREQ[33][78] = 114;
        BytesDetector.KR_FREQ[21][4] = 113;
        BytesDetector.KR_FREQ[31][17] = 112;
        BytesDetector.KR_FREQ[39][61] = 111;
        BytesDetector.KR_FREQ[18][76] = 110;
        BytesDetector.KR_FREQ[15][85] = 109;
        BytesDetector.KR_FREQ[31][47] = 108;
        BytesDetector.KR_FREQ[19][57] = 107;
        BytesDetector.KR_FREQ[23][55] = 106;
        BytesDetector.KR_FREQ[27][29] = 105;
        BytesDetector.KR_FREQ[29][46] = 104;
        BytesDetector.KR_FREQ[33][0] = 103;
        BytesDetector.KR_FREQ[16][83] = 102;
        BytesDetector.KR_FREQ[39][78] = 101;
        BytesDetector.KR_FREQ[32][77] = 100;
        BytesDetector.KR_FREQ[36][25] = 99;
        BytesDetector.KR_FREQ[34][19] = 98;
        BytesDetector.KR_FREQ[38][49] = 97;
        BytesDetector.KR_FREQ[19][25] = 96;
        BytesDetector.KR_FREQ[23][53] = 95;
        BytesDetector.KR_FREQ[28][43] = 94;
        BytesDetector.KR_FREQ[31][44] = 93;
        BytesDetector.KR_FREQ[36][34] = 92;
        BytesDetector.KR_FREQ[16][34] = 91;
        BytesDetector.KR_FREQ[35][1] = 90;
        BytesDetector.KR_FREQ[19][87] = 89;
        BytesDetector.KR_FREQ[18][53] = 88;
        BytesDetector.KR_FREQ[29][54] = 87;
        BytesDetector.KR_FREQ[22][41] = 86;
        BytesDetector.KR_FREQ[38][18] = 85;
        BytesDetector.KR_FREQ[22][2] = 84;
        BytesDetector.KR_FREQ[20][3] = 83;
        BytesDetector.KR_FREQ[39][69] = 82;
        BytesDetector.KR_FREQ[30][29] = 81;
        BytesDetector.KR_FREQ[28][19] = 80;
        BytesDetector.KR_FREQ[29][90] = 79;
        BytesDetector.KR_FREQ[17][86] = 78;
        BytesDetector.KR_FREQ[15][9] = 77;
        BytesDetector.KR_FREQ[39][73] = 76;
        BytesDetector.KR_FREQ[15][37] = 75;
        BytesDetector.KR_FREQ[35][40] = 74;
        BytesDetector.KR_FREQ[33][77] = 73;
        BytesDetector.KR_FREQ[27][86] = 72;
        BytesDetector.KR_FREQ[36][79] = 71;
        BytesDetector.KR_FREQ[23][18] = 70;
        BytesDetector.KR_FREQ[34][87] = 69;
        BytesDetector.KR_FREQ[39][24] = 68;
        BytesDetector.KR_FREQ[26][8] = 67;
        BytesDetector.KR_FREQ[33][48] = 66;
        BytesDetector.KR_FREQ[39][30] = 65;
        BytesDetector.KR_FREQ[33][28] = 64;
        BytesDetector.KR_FREQ[16][67] = 63;
        BytesDetector.KR_FREQ[31][78] = 62;
        BytesDetector.KR_FREQ[32][23] = 61;
        BytesDetector.KR_FREQ[24][55] = 60;
        BytesDetector.KR_FREQ[30][68] = 59;
        BytesDetector.KR_FREQ[18][60] = 58;
        BytesDetector.KR_FREQ[15][17] = 57;
        BytesDetector.KR_FREQ[23][34] = 56;
        BytesDetector.KR_FREQ[20][49] = 55;
        BytesDetector.KR_FREQ[15][78] = 54;
        BytesDetector.KR_FREQ[24][14] = 53;
        BytesDetector.KR_FREQ[19][41] = 52;
        BytesDetector.KR_FREQ[31][55] = 51;
        BytesDetector.KR_FREQ[21][39] = 50;
        BytesDetector.KR_FREQ[35][9] = 49;
        BytesDetector.KR_FREQ[30][15] = 48;
        BytesDetector.KR_FREQ[20][52] = 47;
        BytesDetector.KR_FREQ[35][71] = 46;
        BytesDetector.KR_FREQ[20][7] = 45;
        BytesDetector.KR_FREQ[29][72] = 44;
        BytesDetector.KR_FREQ[37][77] = 43;
        BytesDetector.KR_FREQ[22][35] = 42;
        BytesDetector.KR_FREQ[20][61] = 41;
        BytesDetector.KR_FREQ[31][60] = 40;
        BytesDetector.KR_FREQ[20][93] = 39;
        BytesDetector.KR_FREQ[27][92] = 38;
        BytesDetector.KR_FREQ[28][16] = 37;
        BytesDetector.KR_FREQ[36][26] = 36;
        BytesDetector.KR_FREQ[18][89] = 35;
        BytesDetector.KR_FREQ[21][63] = 34;
        BytesDetector.KR_FREQ[22][52] = 33;
        BytesDetector.KR_FREQ[24][65] = 32;
        BytesDetector.KR_FREQ[31][8] = 31;
        BytesDetector.KR_FREQ[31][49] = 30;
        BytesDetector.KR_FREQ[33][30] = 29;
        BytesDetector.KR_FREQ[37][15] = 28;
        BytesDetector.KR_FREQ[18][18] = 27;
        BytesDetector.KR_FREQ[25][50] = 26;
        BytesDetector.KR_FREQ[29][20] = 25;
        BytesDetector.KR_FREQ[35][48] = 24;
        BytesDetector.KR_FREQ[38][75] = 23;
        BytesDetector.KR_FREQ[26][83] = 22;
        BytesDetector.KR_FREQ[21][87] = 21;
        BytesDetector.KR_FREQ[27][71] = 20;
        BytesDetector.KR_FREQ[32][91] = 19;
        BytesDetector.KR_FREQ[25][73] = 18;
        BytesDetector.KR_FREQ[16][84] = 17;
        BytesDetector.KR_FREQ[25][31] = 16;
        BytesDetector.KR_FREQ[17][90] = 15;
        BytesDetector.KR_FREQ[18][40] = 14;
        BytesDetector.KR_FREQ[17][77] = 13;
        BytesDetector.KR_FREQ[17][35] = 12;
        BytesDetector.KR_FREQ[23][52] = 11;
        BytesDetector.KR_FREQ[23][35] = 10;
        BytesDetector.KR_FREQ[16][5] = 9;
        BytesDetector.KR_FREQ[23][58] = 8;
        BytesDetector.KR_FREQ[19][60] = 7;
        BytesDetector.KR_FREQ[30][32] = 6;
        BytesDetector.KR_FREQ[38][34] = 5;
        BytesDetector.KR_FREQ[23][4] = 4;
        BytesDetector.KR_FREQ[23][1] = 3;
        BytesDetector.KR_FREQ[27][57] = 2;
        BytesDetector.KR_FREQ[39][38] = 1;
        BytesDetector.KR_FREQ[32][33] = 0;
        BytesDetector.JP_FREQ[3][74] = 600;
        BytesDetector.JP_FREQ[3][45] = 599;
        BytesDetector.JP_FREQ[3][3] = 598;
        BytesDetector.JP_FREQ[3][24] = 597;
        BytesDetector.JP_FREQ[3][30] = 596;
        BytesDetector.JP_FREQ[3][42] = 595;
        BytesDetector.JP_FREQ[3][46] = 594;
        BytesDetector.JP_FREQ[3][39] = 593;
        BytesDetector.JP_FREQ[3][11] = 592;
        BytesDetector.JP_FREQ[3][37] = 591;
        BytesDetector.JP_FREQ[3][38] = 590;
        BytesDetector.JP_FREQ[3][31] = 589;
        BytesDetector.JP_FREQ[3][41] = 588;
        BytesDetector.JP_FREQ[3][5] = 587;
        BytesDetector.JP_FREQ[3][10] = 586;
        BytesDetector.JP_FREQ[3][75] = 585;
        BytesDetector.JP_FREQ[3][65] = 584;
        BytesDetector.JP_FREQ[3][72] = 583;
        BytesDetector.JP_FREQ[37][91] = 582;
        BytesDetector.JP_FREQ[0][27] = 581;
        BytesDetector.JP_FREQ[3][18] = 580;
        BytesDetector.JP_FREQ[3][22] = 579;
        BytesDetector.JP_FREQ[3][61] = 578;
        BytesDetector.JP_FREQ[3][14] = 577;
        BytesDetector.JP_FREQ[24][80] = 576;
        BytesDetector.JP_FREQ[4][82] = 575;
        BytesDetector.JP_FREQ[17][80] = 574;
        BytesDetector.JP_FREQ[30][44] = 573;
        BytesDetector.JP_FREQ[3][73] = 572;
        BytesDetector.JP_FREQ[3][64] = 571;
        BytesDetector.JP_FREQ[38][14] = 570;
        BytesDetector.JP_FREQ[33][70] = 569;
        BytesDetector.JP_FREQ[3][1] = 568;
        BytesDetector.JP_FREQ[3][16] = 567;
        BytesDetector.JP_FREQ[3][35] = 566;
        BytesDetector.JP_FREQ[3][40] = 565;
        BytesDetector.JP_FREQ[4][74] = 564;
        BytesDetector.JP_FREQ[4][24] = 563;
        BytesDetector.JP_FREQ[42][59] = 562;
        BytesDetector.JP_FREQ[3][7] = 561;
        BytesDetector.JP_FREQ[3][71] = 560;
        BytesDetector.JP_FREQ[3][12] = 559;
        BytesDetector.JP_FREQ[15][75] = 558;
        BytesDetector.JP_FREQ[3][20] = 557;
        BytesDetector.JP_FREQ[4][39] = 556;
        BytesDetector.JP_FREQ[34][69] = 555;
        BytesDetector.JP_FREQ[3][28] = 554;
        BytesDetector.JP_FREQ[35][24] = 553;
        BytesDetector.JP_FREQ[3][82] = 552;
        BytesDetector.JP_FREQ[28][47] = 551;
        BytesDetector.JP_FREQ[3][67] = 550;
        BytesDetector.JP_FREQ[37][16] = 549;
        BytesDetector.JP_FREQ[26][93] = 548;
        BytesDetector.JP_FREQ[4][1] = 547;
        BytesDetector.JP_FREQ[26][85] = 546;
        BytesDetector.JP_FREQ[31][14] = 545;
        BytesDetector.JP_FREQ[4][3] = 544;
        BytesDetector.JP_FREQ[4][72] = 543;
        BytesDetector.JP_FREQ[24][51] = 542;
        BytesDetector.JP_FREQ[27][51] = 541;
        BytesDetector.JP_FREQ[27][49] = 540;
        BytesDetector.JP_FREQ[22][77] = 539;
        BytesDetector.JP_FREQ[27][10] = 538;
        BytesDetector.JP_FREQ[29][68] = 537;
        BytesDetector.JP_FREQ[20][35] = 536;
        BytesDetector.JP_FREQ[41][11] = 535;
        BytesDetector.JP_FREQ[24][70] = 534;
        BytesDetector.JP_FREQ[36][61] = 533;
        BytesDetector.JP_FREQ[31][23] = 532;
        BytesDetector.JP_FREQ[43][16] = 531;
        BytesDetector.JP_FREQ[23][68] = 530;
        BytesDetector.JP_FREQ[32][15] = 529;
        BytesDetector.JP_FREQ[3][32] = 528;
        BytesDetector.JP_FREQ[19][53] = 527;
        BytesDetector.JP_FREQ[40][83] = 526;
        BytesDetector.JP_FREQ[4][14] = 525;
        BytesDetector.JP_FREQ[36][9] = 524;
        BytesDetector.JP_FREQ[4][73] = 523;
        BytesDetector.JP_FREQ[23][10] = 522;
        BytesDetector.JP_FREQ[3][63] = 521;
        BytesDetector.JP_FREQ[39][14] = 520;
        BytesDetector.JP_FREQ[3][78] = 519;
        BytesDetector.JP_FREQ[33][47] = 518;
        BytesDetector.JP_FREQ[21][39] = 517;
        BytesDetector.JP_FREQ[34][46] = 516;
        BytesDetector.JP_FREQ[36][75] = 515;
        BytesDetector.JP_FREQ[41][92] = 514;
        BytesDetector.JP_FREQ[37][93] = 513;
        BytesDetector.JP_FREQ[4][34] = 512;
        BytesDetector.JP_FREQ[15][86] = 511;
        BytesDetector.JP_FREQ[46][1] = 510;
        BytesDetector.JP_FREQ[37][65] = 509;
        BytesDetector.JP_FREQ[3][62] = 508;
        BytesDetector.JP_FREQ[32][73] = 507;
        BytesDetector.JP_FREQ[21][65] = 506;
        BytesDetector.JP_FREQ[29][75] = 505;
        BytesDetector.JP_FREQ[26][51] = 504;
        BytesDetector.JP_FREQ[3][34] = 503;
        BytesDetector.JP_FREQ[4][10] = 502;
        BytesDetector.JP_FREQ[30][22] = 501;
        BytesDetector.JP_FREQ[35][73] = 500;
        BytesDetector.JP_FREQ[17][82] = 499;
        BytesDetector.JP_FREQ[45][8] = 498;
        BytesDetector.JP_FREQ[27][73] = 497;
        BytesDetector.JP_FREQ[18][55] = 496;
        BytesDetector.JP_FREQ[25][2] = 495;
        BytesDetector.JP_FREQ[3][26] = 494;
        BytesDetector.JP_FREQ[45][46] = 493;
        BytesDetector.JP_FREQ[4][22] = 492;
        BytesDetector.JP_FREQ[4][40] = 491;
        BytesDetector.JP_FREQ[18][10] = 490;
        BytesDetector.JP_FREQ[32][9] = 489;
        BytesDetector.JP_FREQ[26][49] = 488;
        BytesDetector.JP_FREQ[3][47] = 487;
        BytesDetector.JP_FREQ[24][65] = 486;
        BytesDetector.JP_FREQ[4][76] = 485;
        BytesDetector.JP_FREQ[43][67] = 484;
        BytesDetector.JP_FREQ[3][9] = 483;
        BytesDetector.JP_FREQ[41][37] = 482;
        BytesDetector.JP_FREQ[33][68] = 481;
        BytesDetector.JP_FREQ[43][31] = 480;
        BytesDetector.JP_FREQ[19][55] = 479;
        BytesDetector.JP_FREQ[4][30] = 478;
        BytesDetector.JP_FREQ[27][33] = 477;
        BytesDetector.JP_FREQ[16][62] = 476;
        BytesDetector.JP_FREQ[36][35] = 475;
        BytesDetector.JP_FREQ[37][15] = 474;
        BytesDetector.JP_FREQ[27][70] = 473;
        BytesDetector.JP_FREQ[22][71] = 472;
        BytesDetector.JP_FREQ[33][45] = 471;
        BytesDetector.JP_FREQ[31][78] = 470;
        BytesDetector.JP_FREQ[43][59] = 469;
        BytesDetector.JP_FREQ[32][19] = 468;
        BytesDetector.JP_FREQ[17][28] = 467;
        BytesDetector.JP_FREQ[40][28] = 466;
        BytesDetector.JP_FREQ[20][93] = 465;
        BytesDetector.JP_FREQ[18][15] = 464;
        BytesDetector.JP_FREQ[4][23] = 463;
        BytesDetector.JP_FREQ[3][23] = 462;
        BytesDetector.JP_FREQ[26][64] = 461;
        BytesDetector.JP_FREQ[44][92] = 460;
        BytesDetector.JP_FREQ[17][27] = 459;
        BytesDetector.JP_FREQ[3][56] = 458;
        BytesDetector.JP_FREQ[25][38] = 457;
        BytesDetector.JP_FREQ[23][31] = 456;
        BytesDetector.JP_FREQ[35][43] = 455;
        BytesDetector.JP_FREQ[4][54] = 454;
        BytesDetector.JP_FREQ[35][19] = 453;
        BytesDetector.JP_FREQ[22][47] = 452;
        BytesDetector.JP_FREQ[42][0] = 451;
        BytesDetector.JP_FREQ[23][28] = 450;
        BytesDetector.JP_FREQ[46][33] = 449;
        BytesDetector.JP_FREQ[36][85] = 448;
        BytesDetector.JP_FREQ[31][12] = 447;
        BytesDetector.JP_FREQ[3][76] = 446;
        BytesDetector.JP_FREQ[4][75] = 445;
        BytesDetector.JP_FREQ[36][56] = 444;
        BytesDetector.JP_FREQ[4][64] = 443;
        BytesDetector.JP_FREQ[25][77] = 442;
        BytesDetector.JP_FREQ[15][52] = 441;
        BytesDetector.JP_FREQ[33][73] = 440;
        BytesDetector.JP_FREQ[3][55] = 439;
        BytesDetector.JP_FREQ[43][82] = 438;
        BytesDetector.JP_FREQ[27][82] = 437;
        BytesDetector.JP_FREQ[20][3] = 436;
        BytesDetector.JP_FREQ[40][51] = 435;
        BytesDetector.JP_FREQ[3][17] = 434;
        BytesDetector.JP_FREQ[27][71] = 433;
        BytesDetector.JP_FREQ[4][52] = 432;
        BytesDetector.JP_FREQ[44][48] = 431;
        BytesDetector.JP_FREQ[27][2] = 430;
        BytesDetector.JP_FREQ[17][39] = 429;
        BytesDetector.JP_FREQ[31][8] = 428;
        BytesDetector.JP_FREQ[44][54] = 427;
        BytesDetector.JP_FREQ[43][18] = 426;
        BytesDetector.JP_FREQ[43][77] = 425;
        BytesDetector.JP_FREQ[4][61] = 424;
        BytesDetector.JP_FREQ[19][91] = 423;
        BytesDetector.JP_FREQ[31][13] = 422;
        BytesDetector.JP_FREQ[44][71] = 421;
        BytesDetector.JP_FREQ[20][0] = 420;
        BytesDetector.JP_FREQ[23][87] = 419;
        BytesDetector.JP_FREQ[21][14] = 418;
        BytesDetector.JP_FREQ[29][13] = 417;
        BytesDetector.JP_FREQ[3][58] = 416;
        BytesDetector.JP_FREQ[26][18] = 415;
        BytesDetector.JP_FREQ[4][47] = 414;
        BytesDetector.JP_FREQ[4][18] = 413;
        BytesDetector.JP_FREQ[3][53] = 412;
        BytesDetector.JP_FREQ[26][92] = 411;
        BytesDetector.JP_FREQ[21][7] = 410;
        BytesDetector.JP_FREQ[4][37] = 409;
        BytesDetector.JP_FREQ[4][63] = 408;
        BytesDetector.JP_FREQ[36][51] = 407;
        BytesDetector.JP_FREQ[4][32] = 406;
        BytesDetector.JP_FREQ[28][73] = 405;
        BytesDetector.JP_FREQ[4][50] = 404;
        BytesDetector.JP_FREQ[41][60] = 403;
        BytesDetector.JP_FREQ[23][1] = 402;
        BytesDetector.JP_FREQ[36][92] = 401;
        BytesDetector.JP_FREQ[15][41] = 400;
        BytesDetector.JP_FREQ[21][71] = 399;
        BytesDetector.JP_FREQ[41][30] = 398;
        BytesDetector.JP_FREQ[32][76] = 397;
        BytesDetector.JP_FREQ[17][34] = 396;
        BytesDetector.JP_FREQ[26][15] = 395;
        BytesDetector.JP_FREQ[26][25] = 394;
        BytesDetector.JP_FREQ[31][77] = 393;
        BytesDetector.JP_FREQ[31][3] = 392;
        BytesDetector.JP_FREQ[46][34] = 391;
        BytesDetector.JP_FREQ[27][84] = 390;
        BytesDetector.JP_FREQ[23][8] = 389;
        BytesDetector.JP_FREQ[16][0] = 388;
        BytesDetector.JP_FREQ[28][80] = 387;
        BytesDetector.JP_FREQ[26][54] = 386;
        BytesDetector.JP_FREQ[33][18] = 385;
        BytesDetector.JP_FREQ[31][20] = 384;
        BytesDetector.JP_FREQ[31][62] = 383;
        BytesDetector.JP_FREQ[30][41] = 382;
        BytesDetector.JP_FREQ[33][30] = 381;
        BytesDetector.JP_FREQ[45][45] = 380;
        BytesDetector.JP_FREQ[37][82] = 379;
        BytesDetector.JP_FREQ[15][33] = 378;
        BytesDetector.JP_FREQ[20][12] = 377;
        BytesDetector.JP_FREQ[18][5] = 376;
        BytesDetector.JP_FREQ[28][86] = 375;
        BytesDetector.JP_FREQ[30][19] = 374;
        BytesDetector.JP_FREQ[42][43] = 373;
        BytesDetector.JP_FREQ[36][31] = 372;
        BytesDetector.JP_FREQ[17][93] = 371;
        BytesDetector.JP_FREQ[4][15] = 370;
        BytesDetector.JP_FREQ[21][20] = 369;
        BytesDetector.JP_FREQ[23][21] = 368;
        BytesDetector.JP_FREQ[28][72] = 367;
        BytesDetector.JP_FREQ[4][20] = 366;
        BytesDetector.JP_FREQ[26][55] = 365;
        BytesDetector.JP_FREQ[21][5] = 364;
        BytesDetector.JP_FREQ[19][16] = 363;
        BytesDetector.JP_FREQ[23][64] = 362;
        BytesDetector.JP_FREQ[40][59] = 361;
        BytesDetector.JP_FREQ[37][26] = 360;
        BytesDetector.JP_FREQ[26][56] = 359;
        BytesDetector.JP_FREQ[4][12] = 358;
        BytesDetector.JP_FREQ[33][71] = 357;
        BytesDetector.JP_FREQ[32][39] = 356;
        BytesDetector.JP_FREQ[38][40] = 355;
        BytesDetector.JP_FREQ[22][74] = 354;
        BytesDetector.JP_FREQ[3][25] = 353;
        BytesDetector.JP_FREQ[15][48] = 352;
        BytesDetector.JP_FREQ[41][82] = 351;
        BytesDetector.JP_FREQ[41][9] = 350;
        BytesDetector.JP_FREQ[25][48] = 349;
        BytesDetector.JP_FREQ[31][71] = 348;
        BytesDetector.JP_FREQ[43][29] = 347;
        BytesDetector.JP_FREQ[26][80] = 346;
        BytesDetector.JP_FREQ[4][5] = 345;
        BytesDetector.JP_FREQ[18][71] = 344;
        BytesDetector.JP_FREQ[29][0] = 343;
        BytesDetector.JP_FREQ[43][43] = 342;
        BytesDetector.JP_FREQ[23][81] = 341;
        BytesDetector.JP_FREQ[4][42] = 340;
        BytesDetector.JP_FREQ[44][28] = 339;
        BytesDetector.JP_FREQ[23][93] = 338;
        BytesDetector.JP_FREQ[17][81] = 337;
        BytesDetector.JP_FREQ[25][25] = 336;
        BytesDetector.JP_FREQ[41][23] = 335;
        BytesDetector.JP_FREQ[34][35] = 334;
        BytesDetector.JP_FREQ[4][53] = 333;
        BytesDetector.JP_FREQ[28][36] = 332;
        BytesDetector.JP_FREQ[4][41] = 331;
        BytesDetector.JP_FREQ[25][60] = 330;
        BytesDetector.JP_FREQ[23][20] = 329;
        BytesDetector.JP_FREQ[3][43] = 328;
        BytesDetector.JP_FREQ[24][79] = 327;
        BytesDetector.JP_FREQ[29][41] = 326;
        BytesDetector.JP_FREQ[30][83] = 325;
        BytesDetector.JP_FREQ[3][50] = 324;
        BytesDetector.JP_FREQ[22][18] = 323;
        BytesDetector.JP_FREQ[18][3] = 322;
        BytesDetector.JP_FREQ[39][30] = 321;
        BytesDetector.JP_FREQ[4][28] = 320;
        BytesDetector.JP_FREQ[21][64] = 319;
        BytesDetector.JP_FREQ[4][68] = 318;
        BytesDetector.JP_FREQ[17][71] = 317;
        BytesDetector.JP_FREQ[27][0] = 316;
        BytesDetector.JP_FREQ[39][28] = 315;
        BytesDetector.JP_FREQ[30][13] = 314;
        BytesDetector.JP_FREQ[36][70] = 313;
        BytesDetector.JP_FREQ[20][82] = 312;
        BytesDetector.JP_FREQ[33][38] = 311;
        BytesDetector.JP_FREQ[44][87] = 310;
        BytesDetector.JP_FREQ[34][45] = 309;
        BytesDetector.JP_FREQ[4][26] = 308;
        BytesDetector.JP_FREQ[24][44] = 307;
        BytesDetector.JP_FREQ[38][67] = 306;
        BytesDetector.JP_FREQ[38][6] = 305;
        BytesDetector.JP_FREQ[30][68] = 304;
        BytesDetector.JP_FREQ[15][89] = 303;
        BytesDetector.JP_FREQ[24][93] = 302;
        BytesDetector.JP_FREQ[40][41] = 301;
        BytesDetector.JP_FREQ[38][3] = 300;
        BytesDetector.JP_FREQ[28][23] = 299;
        BytesDetector.JP_FREQ[26][17] = 298;
        BytesDetector.JP_FREQ[4][38] = 297;
        BytesDetector.JP_FREQ[22][78] = 296;
        BytesDetector.JP_FREQ[15][37] = 295;
        BytesDetector.JP_FREQ[25][85] = 294;
        BytesDetector.JP_FREQ[4][9] = 293;
        BytesDetector.JP_FREQ[4][7] = 292;
        BytesDetector.JP_FREQ[27][53] = 291;
        BytesDetector.JP_FREQ[39][29] = 290;
        BytesDetector.JP_FREQ[41][43] = 289;
        BytesDetector.JP_FREQ[25][62] = 288;
        BytesDetector.JP_FREQ[4][48] = 287;
        BytesDetector.JP_FREQ[28][28] = 286;
        BytesDetector.JP_FREQ[21][40] = 285;
        BytesDetector.JP_FREQ[36][73] = 284;
        BytesDetector.JP_FREQ[26][39] = 283;
        BytesDetector.JP_FREQ[22][54] = 282;
        BytesDetector.JP_FREQ[33][5] = 281;
        BytesDetector.JP_FREQ[19][21] = 280;
        BytesDetector.JP_FREQ[46][31] = 279;
        BytesDetector.JP_FREQ[20][64] = 278;
        BytesDetector.JP_FREQ[26][63] = 277;
        BytesDetector.JP_FREQ[22][23] = 276;
        BytesDetector.JP_FREQ[25][81] = 275;
        BytesDetector.JP_FREQ[4][62] = 274;
        BytesDetector.JP_FREQ[37][31] = 273;
        BytesDetector.JP_FREQ[40][52] = 272;
        BytesDetector.JP_FREQ[29][79] = 271;
        BytesDetector.JP_FREQ[41][48] = 270;
        BytesDetector.JP_FREQ[31][57] = 269;
        BytesDetector.JP_FREQ[32][92] = 268;
        BytesDetector.JP_FREQ[36][36] = 267;
        BytesDetector.JP_FREQ[27][7] = 266;
        BytesDetector.JP_FREQ[35][29] = 265;
        BytesDetector.JP_FREQ[37][34] = 264;
        BytesDetector.JP_FREQ[34][42] = 263;
        BytesDetector.JP_FREQ[27][15] = 262;
        BytesDetector.JP_FREQ[33][27] = 261;
        BytesDetector.JP_FREQ[31][38] = 260;
        BytesDetector.JP_FREQ[19][79] = 259;
        BytesDetector.JP_FREQ[4][31] = 258;
        BytesDetector.JP_FREQ[4][66] = 257;
        BytesDetector.JP_FREQ[17][32] = 256;
        BytesDetector.JP_FREQ[26][67] = 255;
        BytesDetector.JP_FREQ[16][30] = 254;
        BytesDetector.JP_FREQ[26][46] = 253;
        BytesDetector.JP_FREQ[24][26] = 252;
        BytesDetector.JP_FREQ[35][10] = 251;
        BytesDetector.JP_FREQ[18][37] = 250;
        BytesDetector.JP_FREQ[3][19] = 249;
        BytesDetector.JP_FREQ[33][69] = 248;
        BytesDetector.JP_FREQ[31][9] = 247;
        BytesDetector.JP_FREQ[45][29] = 246;
        BytesDetector.JP_FREQ[3][15] = 245;
        BytesDetector.JP_FREQ[18][54] = 244;
        BytesDetector.JP_FREQ[3][44] = 243;
        BytesDetector.JP_FREQ[31][29] = 242;
        BytesDetector.JP_FREQ[18][45] = 241;
        BytesDetector.JP_FREQ[38][28] = 240;
        BytesDetector.JP_FREQ[24][12] = 239;
        BytesDetector.JP_FREQ[35][82] = 238;
        BytesDetector.JP_FREQ[17][43] = 237;
        BytesDetector.JP_FREQ[28][9] = 236;
        BytesDetector.JP_FREQ[23][25] = 235;
        BytesDetector.JP_FREQ[44][37] = 234;
        BytesDetector.JP_FREQ[23][75] = 233;
        BytesDetector.JP_FREQ[23][92] = 232;
        BytesDetector.JP_FREQ[0][24] = 231;
        BytesDetector.JP_FREQ[19][74] = 230;
        BytesDetector.JP_FREQ[45][32] = 229;
        BytesDetector.JP_FREQ[16][72] = 228;
        BytesDetector.JP_FREQ[16][93] = 227;
        BytesDetector.JP_FREQ[45][13] = 226;
        BytesDetector.JP_FREQ[24][8] = 225;
        BytesDetector.JP_FREQ[25][47] = 224;
        BytesDetector.JP_FREQ[28][26] = 223;
        BytesDetector.JP_FREQ[43][81] = 222;
        BytesDetector.JP_FREQ[32][71] = 221;
        BytesDetector.JP_FREQ[18][41] = 220;
        BytesDetector.JP_FREQ[26][62] = 219;
        BytesDetector.JP_FREQ[41][24] = 218;
        BytesDetector.JP_FREQ[40][11] = 217;
        BytesDetector.JP_FREQ[43][57] = 216;
        BytesDetector.JP_FREQ[34][53] = 215;
        BytesDetector.JP_FREQ[20][32] = 214;
        BytesDetector.JP_FREQ[34][43] = 213;
        BytesDetector.JP_FREQ[41][91] = 212;
        BytesDetector.JP_FREQ[29][57] = 211;
        BytesDetector.JP_FREQ[15][43] = 210;
        BytesDetector.JP_FREQ[22][89] = 209;
        BytesDetector.JP_FREQ[33][83] = 208;
        BytesDetector.JP_FREQ[43][20] = 207;
        BytesDetector.JP_FREQ[25][58] = 206;
        BytesDetector.JP_FREQ[30][30] = 205;
        BytesDetector.JP_FREQ[4][56] = 204;
        BytesDetector.JP_FREQ[17][64] = 203;
        BytesDetector.JP_FREQ[23][0] = 202;
        BytesDetector.JP_FREQ[44][12] = 201;
        BytesDetector.JP_FREQ[25][37] = 200;
        BytesDetector.JP_FREQ[35][13] = 199;
        BytesDetector.JP_FREQ[20][30] = 198;
        BytesDetector.JP_FREQ[21][84] = 197;
        BytesDetector.JP_FREQ[29][14] = 196;
        BytesDetector.JP_FREQ[30][5] = 195;
        BytesDetector.JP_FREQ[37][2] = 194;
        BytesDetector.JP_FREQ[4][78] = 193;
        BytesDetector.JP_FREQ[29][78] = 192;
        BytesDetector.JP_FREQ[29][84] = 191;
        BytesDetector.JP_FREQ[32][86] = 190;
        BytesDetector.JP_FREQ[20][68] = 189;
        BytesDetector.JP_FREQ[30][39] = 188;
        BytesDetector.JP_FREQ[15][69] = 187;
        BytesDetector.JP_FREQ[4][60] = 186;
        BytesDetector.JP_FREQ[20][61] = 185;
        BytesDetector.JP_FREQ[41][67] = 184;
        BytesDetector.JP_FREQ[16][35] = 183;
        BytesDetector.JP_FREQ[36][57] = 182;
        BytesDetector.JP_FREQ[39][80] = 181;
        BytesDetector.JP_FREQ[4][59] = 180;
        BytesDetector.JP_FREQ[4][44] = 179;
        BytesDetector.JP_FREQ[40][54] = 178;
        BytesDetector.JP_FREQ[30][8] = 177;
        BytesDetector.JP_FREQ[44][30] = 176;
        BytesDetector.JP_FREQ[31][93] = 175;
        BytesDetector.JP_FREQ[31][47] = 174;
        BytesDetector.JP_FREQ[16][70] = 173;
        BytesDetector.JP_FREQ[21][0] = 172;
        BytesDetector.JP_FREQ[17][35] = 171;
        BytesDetector.JP_FREQ[21][67] = 170;
        BytesDetector.JP_FREQ[44][18] = 169;
        BytesDetector.JP_FREQ[36][29] = 168;
        BytesDetector.JP_FREQ[18][67] = 167;
        BytesDetector.JP_FREQ[24][28] = 166;
        BytesDetector.JP_FREQ[36][24] = 165;
        BytesDetector.JP_FREQ[23][5] = 164;
        BytesDetector.JP_FREQ[31][65] = 163;
        BytesDetector.JP_FREQ[26][59] = 162;
        BytesDetector.JP_FREQ[28][2] = 161;
        BytesDetector.JP_FREQ[39][69] = 160;
        BytesDetector.JP_FREQ[42][40] = 159;
        BytesDetector.JP_FREQ[37][80] = 158;
        BytesDetector.JP_FREQ[15][66] = 157;
        BytesDetector.JP_FREQ[34][38] = 156;
        BytesDetector.JP_FREQ[28][48] = 155;
        BytesDetector.JP_FREQ[37][77] = 154;
        BytesDetector.JP_FREQ[29][34] = 153;
        BytesDetector.JP_FREQ[33][12] = 152;
        BytesDetector.JP_FREQ[4][65] = 151;
        BytesDetector.JP_FREQ[30][31] = 150;
        BytesDetector.JP_FREQ[27][92] = 149;
        BytesDetector.JP_FREQ[4][2] = 148;
        BytesDetector.JP_FREQ[4][51] = 147;
        BytesDetector.JP_FREQ[23][77] = 146;
        BytesDetector.JP_FREQ[4][35] = 145;
        BytesDetector.JP_FREQ[3][13] = 144;
        BytesDetector.JP_FREQ[26][26] = 143;
        BytesDetector.JP_FREQ[44][4] = 142;
        BytesDetector.JP_FREQ[39][53] = 141;
        BytesDetector.JP_FREQ[20][11] = 140;
        BytesDetector.JP_FREQ[40][33] = 139;
        BytesDetector.JP_FREQ[45][7] = 138;
        BytesDetector.JP_FREQ[4][70] = 137;
        BytesDetector.JP_FREQ[3][49] = 136;
        BytesDetector.JP_FREQ[20][59] = 135;
        BytesDetector.JP_FREQ[21][12] = 134;
        BytesDetector.JP_FREQ[33][53] = 133;
        BytesDetector.JP_FREQ[20][14] = 132;
        BytesDetector.JP_FREQ[37][18] = 131;
        BytesDetector.JP_FREQ[18][17] = 130;
        BytesDetector.JP_FREQ[36][23] = 129;
        BytesDetector.JP_FREQ[18][57] = 128;
        BytesDetector.JP_FREQ[26][74] = 127;
        BytesDetector.JP_FREQ[35][2] = 126;
        BytesDetector.JP_FREQ[38][58] = 125;
        BytesDetector.JP_FREQ[34][68] = 124;
        BytesDetector.JP_FREQ[29][81] = 123;
        BytesDetector.JP_FREQ[20][69] = 122;
        BytesDetector.JP_FREQ[39][86] = 121;
        BytesDetector.JP_FREQ[4][16] = 120;
        BytesDetector.JP_FREQ[16][49] = 119;
        BytesDetector.JP_FREQ[15][72] = 118;
        BytesDetector.JP_FREQ[26][35] = 117;
        BytesDetector.JP_FREQ[32][14] = 116;
        BytesDetector.JP_FREQ[40][90] = 115;
        BytesDetector.JP_FREQ[33][79] = 114;
        BytesDetector.JP_FREQ[35][4] = 113;
        BytesDetector.JP_FREQ[23][33] = 112;
        BytesDetector.JP_FREQ[19][19] = 111;
        BytesDetector.JP_FREQ[31][41] = 110;
        BytesDetector.JP_FREQ[44][1] = 109;
        BytesDetector.JP_FREQ[22][56] = 108;
        BytesDetector.JP_FREQ[31][27] = 107;
        BytesDetector.JP_FREQ[32][18] = 106;
        BytesDetector.JP_FREQ[27][32] = 105;
        BytesDetector.JP_FREQ[37][39] = 104;
        BytesDetector.JP_FREQ[42][11] = 103;
        BytesDetector.JP_FREQ[29][71] = 102;
        BytesDetector.JP_FREQ[32][58] = 101;
        BytesDetector.JP_FREQ[46][10] = 100;
        BytesDetector.JP_FREQ[17][30] = 99;
        BytesDetector.JP_FREQ[38][15] = 98;
        BytesDetector.JP_FREQ[29][60] = 97;
        BytesDetector.JP_FREQ[4][11] = 96;
        BytesDetector.JP_FREQ[38][31] = 95;
        BytesDetector.JP_FREQ[40][79] = 94;
        BytesDetector.JP_FREQ[28][49] = 93;
        BytesDetector.JP_FREQ[28][84] = 92;
        BytesDetector.JP_FREQ[26][77] = 91;
        BytesDetector.JP_FREQ[22][32] = 90;
        BytesDetector.JP_FREQ[33][17] = 89;
        BytesDetector.JP_FREQ[23][18] = 88;
        BytesDetector.JP_FREQ[32][64] = 87;
        BytesDetector.JP_FREQ[4][6] = 86;
        BytesDetector.JP_FREQ[33][51] = 85;
        BytesDetector.JP_FREQ[44][77] = 84;
        BytesDetector.JP_FREQ[29][5] = 83;
        BytesDetector.JP_FREQ[46][25] = 82;
        BytesDetector.JP_FREQ[19][58] = 81;
        BytesDetector.JP_FREQ[4][46] = 80;
        BytesDetector.JP_FREQ[15][71] = 79;
        BytesDetector.JP_FREQ[18][58] = 78;
        BytesDetector.JP_FREQ[26][45] = 77;
        BytesDetector.JP_FREQ[45][66] = 76;
        BytesDetector.JP_FREQ[34][10] = 75;
        BytesDetector.JP_FREQ[19][37] = 74;
        BytesDetector.JP_FREQ[33][65] = 73;
        BytesDetector.JP_FREQ[44][52] = 72;
        BytesDetector.JP_FREQ[16][38] = 71;
        BytesDetector.JP_FREQ[36][46] = 70;
        BytesDetector.JP_FREQ[20][26] = 69;
        BytesDetector.JP_FREQ[30][37] = 68;
        BytesDetector.JP_FREQ[4][58] = 67;
        BytesDetector.JP_FREQ[43][2] = 66;
        BytesDetector.JP_FREQ[30][18] = 65;
        BytesDetector.JP_FREQ[19][35] = 64;
        BytesDetector.JP_FREQ[15][68] = 63;
        BytesDetector.JP_FREQ[3][36] = 62;
        BytesDetector.JP_FREQ[35][40] = 61;
        BytesDetector.JP_FREQ[36][32] = 60;
        BytesDetector.JP_FREQ[37][14] = 59;
        BytesDetector.JP_FREQ[17][11] = 58;
        BytesDetector.JP_FREQ[19][78] = 57;
        BytesDetector.JP_FREQ[37][11] = 56;
        BytesDetector.JP_FREQ[28][63] = 55;
        BytesDetector.JP_FREQ[29][61] = 54;
        BytesDetector.JP_FREQ[33][3] = 53;
        BytesDetector.JP_FREQ[41][52] = 52;
        BytesDetector.JP_FREQ[33][63] = 51;
        BytesDetector.JP_FREQ[22][41] = 50;
        BytesDetector.JP_FREQ[4][19] = 49;
        BytesDetector.JP_FREQ[32][41] = 48;
        BytesDetector.JP_FREQ[24][4] = 47;
        BytesDetector.JP_FREQ[31][28] = 46;
        BytesDetector.JP_FREQ[43][30] = 45;
        BytesDetector.JP_FREQ[17][3] = 44;
        BytesDetector.JP_FREQ[43][70] = 43;
        BytesDetector.JP_FREQ[34][19] = 42;
        BytesDetector.JP_FREQ[20][77] = 41;
        BytesDetector.JP_FREQ[18][83] = 40;
        BytesDetector.JP_FREQ[17][15] = 39;
        BytesDetector.JP_FREQ[23][61] = 38;
        BytesDetector.JP_FREQ[40][27] = 37;
        BytesDetector.JP_FREQ[16][48] = 36;
        BytesDetector.JP_FREQ[39][78] = 35;
        BytesDetector.JP_FREQ[41][53] = 34;
        BytesDetector.JP_FREQ[40][91] = 33;
        BytesDetector.JP_FREQ[40][72] = 32;
        BytesDetector.JP_FREQ[18][52] = 31;
        BytesDetector.JP_FREQ[35][66] = 30;
        BytesDetector.JP_FREQ[39][93] = 29;
        BytesDetector.JP_FREQ[19][48] = 28;
        BytesDetector.JP_FREQ[26][36] = 27;
        BytesDetector.JP_FREQ[27][25] = 26;
        BytesDetector.JP_FREQ[42][71] = 25;
        BytesDetector.JP_FREQ[42][85] = 24;
        BytesDetector.JP_FREQ[26][48] = 23;
        BytesDetector.JP_FREQ[28][15] = 22;
        BytesDetector.JP_FREQ[3][66] = 21;
        BytesDetector.JP_FREQ[25][24] = 20;
        BytesDetector.JP_FREQ[27][43] = 19;
        BytesDetector.JP_FREQ[27][78] = 18;
        BytesDetector.JP_FREQ[45][43] = 17;
        BytesDetector.JP_FREQ[27][72] = 16;
        BytesDetector.JP_FREQ[40][29] = 15;
        BytesDetector.JP_FREQ[41][0] = 14;
        BytesDetector.JP_FREQ[19][57] = 13;
        BytesDetector.JP_FREQ[15][59] = 12;
        BytesDetector.JP_FREQ[29][29] = 11;
        BytesDetector.JP_FREQ[4][25] = 10;
        BytesDetector.JP_FREQ[21][42] = 9;
        BytesDetector.JP_FREQ[23][35] = 8;
        BytesDetector.JP_FREQ[33][1] = 7;
        BytesDetector.JP_FREQ[4][57] = 6;
        BytesDetector.JP_FREQ[17][60] = 5;
        BytesDetector.JP_FREQ[25][19] = 4;
        BytesDetector.JP_FREQ[22][65] = 3;
        BytesDetector.JP_FREQ[42][29] = 2;
        BytesDetector.JP_FREQ[27][66] = 1;
        BytesDetector.JP_FREQ[26][89] = 0;
    }

    private static class Encoding {
        private static final int TOTAL_TYPES = 23;
        private static final int GB2312 = 0;
        private static final int GBK = 1;
        private static final int GB18030 = 2;
        private static final int HZ = 3;
        private static final int BIG5 = 4;
        private static final int CNS11643 = 5;
        private static final int UTF8 = 6;
        private static final int UTF8T = 7;
        private static final int UTF8S = 8;
        private static final int UNICODE = 9;
        private static final int UNICODET = 10;
        private static final int UNICODES = 11;
        private static final int ISO2022CN = 12;
        private static final int ISO2022CN_CNS = 13;
        private static final int ISO2022CN_GB = 14;
        private static final int EUC_KR = 15;
        private static final int CP949 = 16;
        private static final int ISO2022KR = 17;
        private static final int JOHAB = 18;
        private static final int SJIS = 19;
        private static final int EUC_JP = 20;
        private static final int ISO2022JP = 21;
        private static final int ASCII = 22;
        private static final String[] JAVA_CHARSET = new String[23];
        private static final String[] NICE_CHARSET = new String[23];
        private static final String[] HTML_CHARSET = new String[23];

        private Encoding() {
        }

        static {
            Encoding.JAVA_CHARSET[0] = "GB2312";
            Encoding.JAVA_CHARSET[1] = "GBK";
            Encoding.JAVA_CHARSET[2] = "GB18030";
            Encoding.JAVA_CHARSET[3] = "ASCII";
            Encoding.JAVA_CHARSET[14] = "ISO2022CN_GB";
            Encoding.JAVA_CHARSET[4] = "Big5";
            Encoding.JAVA_CHARSET[5] = "EUC-TW";
            Encoding.JAVA_CHARSET[13] = "ISO2022CN_CNS";
            Encoding.JAVA_CHARSET[12] = "ISO2022CN";
            Encoding.JAVA_CHARSET[6] = "UTF-8";
            Encoding.JAVA_CHARSET[7] = "UTF-8";
            Encoding.JAVA_CHARSET[8] = "UTF-8";
            Encoding.JAVA_CHARSET[9] = "Unicode";
            Encoding.JAVA_CHARSET[10] = "Unicode";
            Encoding.JAVA_CHARSET[11] = "Unicode";
            Encoding.JAVA_CHARSET[15] = "EUC-KR";
            Encoding.JAVA_CHARSET[16] = "MS949";
            Encoding.JAVA_CHARSET[17] = "ISO2022KR";
            Encoding.JAVA_CHARSET[18] = "Johab";
            Encoding.JAVA_CHARSET[19] = "SJIS";
            Encoding.JAVA_CHARSET[20] = "EUC_JP";
            Encoding.JAVA_CHARSET[21] = "ISO2022JP";
            Encoding.JAVA_CHARSET[22] = "ASCII";
            Encoding.HTML_CHARSET[0] = "GB2312";
            Encoding.HTML_CHARSET[1] = "GBK";
            Encoding.HTML_CHARSET[2] = "GB18030";
            Encoding.HTML_CHARSET[3] = "HZ-GB-2312";
            Encoding.HTML_CHARSET[14] = "ISO-2022-CN-EXT";
            Encoding.HTML_CHARSET[4] = "Big5";
            Encoding.HTML_CHARSET[5] = "EUC-TW";
            Encoding.HTML_CHARSET[13] = "ISO-2022-CN-EXT";
            Encoding.HTML_CHARSET[12] = "ISO-2022-CN";
            Encoding.HTML_CHARSET[6] = "UTF-8";
            Encoding.HTML_CHARSET[7] = "UTF-8";
            Encoding.HTML_CHARSET[8] = "UTF-8";
            Encoding.HTML_CHARSET[9] = "UTF-16";
            Encoding.HTML_CHARSET[10] = "UTF-16";
            Encoding.HTML_CHARSET[11] = "UTF-16";
            Encoding.HTML_CHARSET[15] = "EUC-KR";
            Encoding.HTML_CHARSET[16] = "x-windows-949";
            Encoding.HTML_CHARSET[17] = "ISO-2022-KR";
            Encoding.HTML_CHARSET[18] = "x-Johab";
            Encoding.HTML_CHARSET[19] = "Shift_JIS";
            Encoding.HTML_CHARSET[20] = "EUC-JP";
            Encoding.HTML_CHARSET[21] = "ISO-2022-JP";
            Encoding.HTML_CHARSET[22] = "ASCII";
            Encoding.NICE_CHARSET[0] = "GB-2312";
            Encoding.NICE_CHARSET[1] = "GBK";
            Encoding.NICE_CHARSET[2] = "GB18030";
            Encoding.NICE_CHARSET[3] = "HZ";
            Encoding.NICE_CHARSET[14] = "ISO2022CN-GB";
            Encoding.NICE_CHARSET[4] = "Big5";
            Encoding.NICE_CHARSET[5] = "CNS11643";
            Encoding.NICE_CHARSET[13] = "ISO2022CN-CNS";
            Encoding.NICE_CHARSET[12] = "ISO2022 CN";
            Encoding.NICE_CHARSET[6] = "UTF-8";
            Encoding.NICE_CHARSET[7] = "UTF-8 (Trad)";
            Encoding.NICE_CHARSET[8] = "UTF-8 (Simp)";
            Encoding.NICE_CHARSET[9] = "Unicode";
            Encoding.NICE_CHARSET[10] = "Unicode (Trad)";
            Encoding.NICE_CHARSET[11] = "Unicode (Simp)";
            Encoding.NICE_CHARSET[15] = "EUC-KR";
            Encoding.NICE_CHARSET[16] = "CP949";
            Encoding.NICE_CHARSET[17] = "ISO 2022 KR";
            Encoding.NICE_CHARSET[18] = "Johab";
            Encoding.NICE_CHARSET[19] = "Shift-JIS";
            Encoding.NICE_CHARSET[20] = "EUC-JP";
            Encoding.NICE_CHARSET[21] = "ISO 2022 JP";
            Encoding.NICE_CHARSET[22] = "ASCII";
        }
    }
}

