/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.digest;

import code.ponfee.commons.jce.DigestAlgorithms;
import code.ponfee.commons.jce.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.apache.commons.codec.binary.Hex;

public final class DigestUtils {
    private static final int BUFF_SIZE = 4096;

    public static byte[] md5(InputStream input) {
        return DigestUtils.digest(DigestAlgorithms.MD5, input);
    }

    public static byte[] md5(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.MD5, data);
    }

    public static String md5Hex(InputStream input) {
        return Hex.encodeHexString((byte[])DigestUtils.md5(input));
    }

    public static String md5Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.md5(data));
    }

    public static String md5Hex(String data) {
        return DigestUtils.md5Hex(data.getBytes());
    }

    public static String md5Hex(String data, String charset) {
        return DigestUtils.md5Hex(data.getBytes(Charset.forName(charset)));
    }

    public static byte[] sha1(InputStream input) {
        return DigestUtils.digest(DigestAlgorithms.SHA1, input);
    }

    public static byte[] sha1(String data) {
        return DigestUtils.digest(DigestAlgorithms.SHA1, data.getBytes());
    }

    public static byte[] sha1(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.SHA1, data);
    }

    public static String sha1Hex(InputStream input) {
        return Hex.encodeHexString((byte[])DigestUtils.sha1(input));
    }

    public static String sha1Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha1(data));
    }

    public static String sha1Hex(String data) {
        return DigestUtils.sha1Hex(data.getBytes());
    }

    public static String sha1Hex(String data, String charset) {
        return DigestUtils.sha1Hex(data.getBytes(Charset.forName(charset)));
    }

    public static byte[] sha224(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.SHA224, data);
    }

    public static String sha224Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha224(data));
    }

    public static byte[] sha256(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.SHA256, data);
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha256(data));
    }

    public static String sha256Hex(String data, String charset) {
        return DigestUtils.sha256Hex(data.getBytes(Charset.forName(charset)));
    }

    public static byte[] sha384(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.SHA384, data);
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha384(data));
    }

    public static byte[] sha512(byte[] input, byte[] ... data) {
        return DigestUtils.digest(DigestAlgorithms.SHA512, input, data);
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha512(data, new byte[0][]));
    }

    public static byte[] ripeMD128(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.RipeMD128, Providers.BC, data);
    }

    public static String ripeMD128Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.ripeMD128(data));
    }

    public static byte[] ripeMD160(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.RipeMD160, Providers.BC, data);
    }

    public static String ripeMD160Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.ripeMD160(data));
    }

    public static byte[] ripeMD256(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.RipeMD256, Providers.BC, data);
    }

    public static String ripeMD256Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.ripeMD256(data));
    }

    public static byte[] ripeMD320(byte[] data) {
        return DigestUtils.digest(DigestAlgorithms.RipeMD320, Providers.BC, data);
    }

    public static String ripeMD320Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.ripeMD320(data));
    }

    public static MessageDigest getMessageDigest(DigestAlgorithms alg, Provider provider) {
        try {
            return provider == null ? MessageDigest.getInstance(alg.algorithm()) : MessageDigest.getInstance(alg.algorithm(), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] digest(DigestAlgorithms alg, byte[] input) {
        return DigestUtils.digest(alg, null, input);
    }

    public static byte[] digest(DigestAlgorithms alg, Provider provider, byte[] input) {
        MessageDigest digest = DigestUtils.getMessageDigest(alg, provider);
        digest.update(input);
        return digest.digest();
    }

    public static byte[] digest(DigestAlgorithms alg, byte[] input, byte[] ... data) {
        return DigestUtils.digest(alg, null, input, data);
    }

    public static byte[] digest(DigestAlgorithms alg, Provider provider, byte[] input, byte[] ... data) {
        MessageDigest digest = DigestUtils.getMessageDigest(alg, provider);
        digest.update(input);
        for (byte[] bytes : data) {
            digest.update(bytes);
        }
        return digest.digest();
    }

    public static byte[] digest(DigestAlgorithms alg, InputStream input) {
        return DigestUtils.digest(alg, null, input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] digest(DigestAlgorithms alg, Provider provider, InputStream input) {
        byte[] buff = new byte[4096];
        MessageDigest digest = DigestUtils.getMessageDigest(alg, provider);
        try (InputStream in = input;){
            int n;
            while ((n = in.read(buff, 0, 4096)) != -1) {
                digest.update(buff, 0, n);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

