/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.implementation.rsa;

import code.ponfee.commons.jce.DigestAlgorithms;
import code.ponfee.commons.jce.digest.DigestUtils;
import code.ponfee.commons.jce.implementation.rsa.RSAKey;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSASigner {
    private static final Map<String, ASN1ObjectIdentifier> HASH_OID_MAPPING = ImmutableMap.builder().put((Object)"RIPEMD128", (Object)TeleTrusTObjectIdentifiers.ripemd128).put((Object)"RIPEMD160", (Object)TeleTrusTObjectIdentifiers.ripemd160).put((Object)"RIPEMD256", (Object)TeleTrusTObjectIdentifiers.ripemd256).put((Object)"SHA-1", (Object)X509ObjectIdentifiers.id_SHA1).put((Object)"SHA-224", (Object)NISTObjectIdentifiers.id_sha224).put((Object)"SHA-256", (Object)NISTObjectIdentifiers.id_sha256).put((Object)"SHA-384", (Object)NISTObjectIdentifiers.id_sha384).put((Object)"SHA-512", (Object)NISTObjectIdentifiers.id_sha512).put((Object)"SHA-512/224", (Object)NISTObjectIdentifiers.id_sha512_224).put((Object)"SHA-512/256", (Object)NISTObjectIdentifiers.id_sha512_256).put((Object)"SHA3-224", (Object)NISTObjectIdentifiers.id_sha3_224).put((Object)"SHA3-256", (Object)NISTObjectIdentifiers.id_sha3_256).put((Object)"SHA3-384", (Object)NISTObjectIdentifiers.id_sha3_384).put((Object)"SHA3-512", (Object)NISTObjectIdentifiers.id_sha3_512).put((Object)"MD2", (Object)PKCSObjectIdentifiers.md2).put((Object)"MD4", (Object)PKCSObjectIdentifiers.md4).put((Object)"MD5", (Object)PKCSObjectIdentifiers.md5).build();
    private final AsymmetricBlockCipher rsaEngine = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
    private final RSAKey rsaKey;

    public RSASigner(RSAKey rsaKey) {
        this.rsaKey = rsaKey;
        if (rsaKey.secret) {
            this.rsaEngine.init(true, (CipherParameters)new RSAKeyParameters(true, rsaKey.n, rsaKey.d));
        } else {
            this.rsaEngine.init(false, (CipherParameters)new RSAKeyParameters(false, rsaKey.n, rsaKey.e));
        }
    }

    public byte[] signSha1(byte[] data) {
        return this.sign(data, DigestAlgorithms.SHA1);
    }

    public boolean verifySha1(byte[] data, byte[] signature) {
        return this.verify(data, signature, DigestAlgorithms.SHA1);
    }

    public byte[] signSha256(byte[] data) {
        return this.sign(data, DigestAlgorithms.SHA256);
    }

    public boolean verifySha256(byte[] data, byte[] signature) {
        return this.verify(data, signature, DigestAlgorithms.SHA256);
    }

    public byte[] sign(byte[] data, DigestAlgorithms alg) {
        if (!this.rsaKey.isSecret()) {
            throw new IllegalArgumentException("Sign must use private key.");
        }
        ASN1ObjectIdentifier oid = HASH_OID_MAPPING.get(alg.algorithm());
        if (oid == null) {
            throw new IllegalArgumentException("Invalid hash algorithm " + alg.name());
        }
        byte[] hash = DigestUtils.digest(alg, data);
        try {
            byte[] result = this.derEncode(hash, oid);
            return this.rsaEngine.processBlock(result, 0, result.length);
        }
        catch (IOException | InvalidCipherTextException e) {
            throw new SecurityException(e);
        }
    }

    public boolean verify(byte[] data, byte[] signature, DigestAlgorithms alg) {
        byte[] sig;
        byte[] expected;
        if (this.rsaKey.isSecret()) {
            throw new IllegalArgumentException("Verify signature must use public key.");
        }
        ASN1ObjectIdentifier oid = HASH_OID_MAPPING.get(alg.algorithm());
        if (oid == null) {
            throw new IllegalArgumentException("Invalid hash algorithm " + alg.name());
        }
        byte[] hash = DigestUtils.digest(alg, data);
        try {
            expected = this.derEncode(hash, oid);
            sig = this.rsaEngine.processBlock(signature, 0, signature.length);
        }
        catch (IOException | InvalidCipherTextException e) {
            return false;
        }
        if (sig.length == expected.length) {
            return Arrays.equals(sig, expected);
        }
        if (sig.length == expected.length - 2) {
            int i;
            int sigOffset = sig.length - hash.length - 2;
            int expOffset = expected.length - hash.length - 2;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            for (i = 0; i < sigOffset; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
            for (i = 0; i < hash.length; ++i) {
                if (sig[sigOffset + i] == expected[expOffset + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private byte[] derEncode(byte[] hash, ASN1ObjectIdentifier digestOid) throws IOException {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(digestOid, (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo dInfo = new DigestInfo(algId, hash);
        return dInfo.getEncoded("DER");
    }
}

