/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.passwd;

import code.ponfee.commons.jce.HmacAlgorithms;
import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.digest.HmacUtils;
import code.ponfee.commons.util.Base64UrlSafe;
import code.ponfee.commons.util.Bytes;
import code.ponfee.commons.util.SecureRandoms;
import com.google.common.base.Preconditions;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.Mac;

public class Crypt {
    private static final char SEPARATOR = '$';

    public static String create(String passwd) {
        return Crypt.create(HmacAlgorithms.HmacSHA256, passwd, 32, Providers.BC);
    }

    public static String create(HmacAlgorithms alg, String passwd, int rounds, Provider provider) {
        Preconditions.checkArgument((rounds >= 1 && rounds <= 255 ? 1 : 0) != 0, (Object)"iterations must between 1 and 255");
        byte[] salt = SecureRandoms.nextBytes(16);
        int algIdx = (Integer)HmacAlgorithms.ALGORITHM_MAPPING.inverse().get((Object)alg) & 0xF;
        byte[] hashed = Crypt.crypt(alg, passwd.getBytes(), salt, rounds, provider);
        return new StringBuilder(6 + (salt.length + hashed.length << 2) / 3 + 4).append('$').append(Integer.toString(algIdx << 8 | rounds, 16)).append('$').append(Base64UrlSafe.encode(salt)).append('$').append(Base64UrlSafe.encode(hashed)).toString();
    }

    public static boolean check(String passwd, String hashed) {
        return Crypt.check(passwd, hashed, null);
    }

    public static boolean check(String passwd, String hashed, Provider provider) {
        String[] parts = hashed.split("\\$");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid hashed value");
        }
        int params = Integer.parseInt(parts[1], 16);
        HmacAlgorithms alg = (HmacAlgorithms)((Object)HmacAlgorithms.ALGORITHM_MAPPING.get((Object)(params >> 8 & 0xF)));
        byte[] salt = Base64UrlSafe.decode(parts[2]);
        byte[] testHash = Crypt.crypt(alg, passwd.getBytes(), salt, params & 0xFF, provider);
        return Arrays.equals(Base64UrlSafe.decode(parts[3]), testHash);
    }

    private static byte[] crypt(HmacAlgorithms alg, byte[] password, byte[] salt, int rounds, Provider provider) {
        Mac mac = HmacUtils.getInitializedMac(alg, provider, salt);
        password = mac.doFinal(password);
        for (int i = 1; i < rounds; ++i) {
            mac.update(Bytes.toBytes(i));
            password = mac.doFinal(password);
        }
        return password;
    }
}

