/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.security;

import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.cert.X509CertUtils;
import code.ponfee.commons.jce.security.RSAPrivateKeys;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.cert.Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public final class RSAPublicKeys {
    private RSAPublicKeys() {
    }

    public static java.security.interfaces.RSAPublicKey toRSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        try {
            return (java.security.interfaces.RSAPublicKey)Providers.getKeyFactory("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static java.security.interfaces.RSAPublicKey getPublicKey(Certificate cert) {
        return (java.security.interfaces.RSAPublicKey)cert.getPublicKey();
    }

    public static RSAPrivateKey inverse(java.security.interfaces.RSAPublicKey publicKey) {
        return RSAPrivateKeys.toRSAPrivateKey(publicKey.getModulus(), publicKey.getPublicExponent());
    }

    public static String toPkcs1(java.security.interfaces.RSAPublicKey publicKey) {
        SubjectPublicKeyInfo spkInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        try {
            return Base64.getEncoder().encodeToString(spkInfo.parsePublicKey().getEncoded());
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public static java.security.interfaces.RSAPublicKey fromPkcs1(String pkcs1PublicKey) {
        byte[] bytes = Base64.getDecoder().decode(pkcs1PublicKey);
        try {
            RSAPublicKey pk = RSAPublicKey.getInstance((Object)bytes);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(pk.getModulus(), pk.getPublicExponent());
            return (java.security.interfaces.RSAPublicKey)Providers.getKeyFactory("RSA").generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static String toPkcs8(java.security.interfaces.RSAPublicKey publicKey) {
        return Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static java.security.interfaces.RSAPublicKey fromPkcs8(String pkcs8PublicKey) {
        byte[] keyBytes = Base64.getDecoder().decode(pkcs8PublicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = Providers.getKeyFactory("RSA");
        try {
            return (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static String toPkcs8Pem(java.security.interfaces.RSAPublicKey publicKey) {
        return X509CertUtils.exportToPem(publicKey);
    }

    /*
     * Exception decompiling
     */
    public static java.security.interfaces.RSAPublicKey fromPkcs8Pem(String pemPublicKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getKeyLength(RSAKey rsaKey) {
        return rsaKey.getModulus().bitLength();
    }
}

