/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.json;

import com.alibaba.fastjson.serializer.PropertyFilter;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;

public class FastjsonPropertyFilter
implements PropertyFilter {
    private final boolean isIncludes;
    private final boolean forceNonNull;
    private final String[] fields;

    public FastjsonPropertyFilter(@Nonnull PropertyFilterType type, boolean forceNonNull, String ... fields) {
        this.isIncludes = type == PropertyFilterType.INCLUDES;
        this.forceNonNull = forceNonNull;
        this.fields = fields;
    }

    public boolean apply(Object source, String name, Object value) {
        if (this.forceNonNull && value != null) {
            return true;
        }
        return this.isIncludes == ArrayUtils.contains((Object[])this.fields, (Object)name);
    }

    public static FastjsonPropertyFilter exclude(String ... fields) {
        return FastjsonPropertyFilter.exclude(false, fields);
    }

    public static FastjsonPropertyFilter exclude(boolean forceNonNull, String ... fields) {
        return new FastjsonPropertyFilter(PropertyFilterType.EXCLUDES, forceNonNull, fields);
    }

    public static FastjsonPropertyFilter include(String ... fields) {
        return FastjsonPropertyFilter.include(false, fields);
    }

    public static FastjsonPropertyFilter include(boolean forceNonNull, String ... fields) {
        return new FastjsonPropertyFilter(PropertyFilterType.INCLUDES, forceNonNull, fields);
    }

    private static enum PropertyFilterType {
        INCLUDES,
        EXCLUDES;

    }
}

