/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.log;

import code.ponfee.commons.exception.Throwables;
import code.ponfee.commons.limit.current.CurrentLimiter;
import code.ponfee.commons.log.LogAnnotation;
import code.ponfee.commons.log.LogInfo;
import code.ponfee.commons.util.ObjectUtils;
import com.google.common.base.Preconditions;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogRecorder {
    private static final int DEFAULT_ALARM_THRESHOLD_MILLIS = 2000;
    private static final Logger logger = LoggerFactory.getLogger(LogRecorder.class);
    private final int alarmThresholdMillis;
    private final CurrentLimiter limiter;

    public LogRecorder() {
        this(2000);
    }

    public LogRecorder(int alarmThresholdMillis) {
        this(alarmThresholdMillis, null);
    }

    public LogRecorder(CurrentLimiter circuitBreaker) {
        this(2000, circuitBreaker);
    }

    public LogRecorder(int alarmThresholdMillis, CurrentLimiter circuitBreaker) {
        Preconditions.checkArgument((alarmThresholdMillis > 0 ? 1 : 0) != 0);
        this.alarmThresholdMillis = alarmThresholdMillis;
        this.limiter = circuitBreaker;
    }

    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return this.around(pjp, null);
    }

    public Object around(ProceedingJoinPoint pjp, LogAnnotation log) throws Throwable {
        MethodSignature ms = (MethodSignature)pjp.getSignature();
        String methodName = ms.getMethod().toGenericString();
        if (this.limiter != null && log != null && log.enabled() && !this.limiter.checkpoint(methodName)) {
            throw new IllegalStateException("request denied");
        }
        LogInfo logInfo = new LogInfo(methodName);
        if (log != null) {
            logInfo.setType(log.type());
            logInfo.setDesc(log.desc());
        }
        String logs = this.getLogs(log);
        logInfo.setArgs(pjp.getArgs());
        if (logger.isInfoEnabled()) {
            logger.info("[exec-before]-[{}]{}-{}", new Object[]{methodName, logs, ObjectUtils.toString(logInfo.getArgs())});
        }
        long start = System.currentTimeMillis();
        try {
            Object retVal = pjp.proceed();
            logInfo.setCostTime((int)(System.currentTimeMillis() - start));
            logInfo.setRetVal(retVal);
            if (logger.isInfoEnabled()) {
                logger.info("[exec-after]-[{}]{}-[{}]", new Object[]{methodName, logs, ObjectUtils.toString(retVal)});
            }
            if (logger.isWarnEnabled() && logInfo.getCostTime() > this.alarmThresholdMillis) {
                logger.warn("[exec-time]-[{}]{}-[cost {}]", new Object[]{methodName, logs, logInfo.getCostTime()});
            }
            Object object = retVal;
            return object;
        }
        catch (Throwable e) {
            logger.error("[exec-throw]-[{}]{}-{}", new Object[]{methodName, logs, ObjectUtils.toString(logInfo.getArgs()), e});
            logInfo.setCostTime((int)(System.currentTimeMillis() - start));
            logInfo.setException(Throwables.getRootCauseStackTrace(e));
            throw e;
        }
        finally {
            try {
                this.log(logInfo);
            }
            catch (Throwable ex) {
                logger.error("Handle log info occur error.", ex);
            }
        }
    }

    protected void log(LogInfo logInfo) {
    }

    private String getLogs(LogAnnotation log) {
        if (log == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder("-[");
        builder.append((Object)log.type());
        if (log.desc() != null) {
            builder.append(',').append(log.desc());
        }
        return builder.append(']').toString();
    }
}

