/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.math;

import code.ponfee.commons.util.Asserts;
import org.springframework.util.Assert;

public class Maths {
    public static strictfp double log2(double n) {
        return Maths.log(n, 2.0);
    }

    public static strictfp double log(double n, double base) {
        return Math.log(n) / Math.log(base);
    }

    public static int rotateLeft(int x, int n) {
        Assert.isTrue((n >= 0 && n <= 32 ? 1 : 0) != 0, (String)"N must be range [0, 32].");
        return x << n | x >>> 32 - n;
    }

    public static long bitsMask(int bits) {
        Asserts.range(bits, 0, 64, "bits must range [0,64].");
        return bits == 64 ? -1L : -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long pow(long base, int exponent) {
        Assert.isTrue((base >= 1L ? 1 : 0) != 0, (String)"Base number cannot  less than 1.");
        Assert.isTrue((exponent >= 0 ? 1 : 0) != 0, (String)"Exponent number cannot  less than 1.");
        if (exponent == 0) {
            return 1L;
        }
        long result = base;
        while (--exponent > 0) {
            result *= base;
        }
        return result;
    }

    public static int abs(int a) {
        return a == Integer.MIN_VALUE ? Integer.MAX_VALUE : (a < 0 ? -a : a);
    }

    public static long abs(long a) {
        return a == Long.MIN_VALUE ? Long.MAX_VALUE : (a < 0L ? -a : a);
    }

    public static strictfp double sqrtBinary(double value) {
        double square;
        double root;
        double upper;
        double lower;
        if (value < 0.0) {
            return Double.NaN;
        }
        if (value == 0.0 || value == 1.0) {
            return value;
        }
        if (value > 1.0) {
            lower = 1.0;
            upper = value;
        } else {
            lower = value;
            upper = 1.0;
        }
        while ((root = lower + (upper - lower) / 2.0) != lower && root != upper && (square = root * root) != value) {
            if (square > value) {
                upper = root;
                continue;
            }
            lower = root;
        }
        return root;
    }

    public static strictfp double sqrtNewton(double value) {
        double t;
        if (value < 0.0) {
            return Double.NaN;
        }
        if (value == 0.0) {
            return value;
        }
        double r = value / 2.0;
        while ((t = r) != (r = (t + value / t) / 2.0)) {
        }
        return r;
    }

    public static int plus(int a, int b) {
        if (a > 0 && b > 0) {
            return Integer.MAX_VALUE - b < a ? Integer.MAX_VALUE : a + b;
        }
        if (a < 0 && b < 0) {
            return Integer.MIN_VALUE - b > a ? Integer.MIN_VALUE : a + b;
        }
        return a + b;
    }

    public static int minus(int a, int b) {
        if (a > 0 && b < 0) {
            return Integer.MAX_VALUE + b < a ? Integer.MAX_VALUE : a - b;
        }
        if (a < 0 && b > 0) {
            return Integer.MIN_VALUE + b > a ? Integer.MIN_VALUE : a - b;
        }
        return a - b;
    }

    public static long plus(long a, long b) {
        if (a > 0L && b > 0L) {
            return Long.MAX_VALUE - b < a ? Long.MAX_VALUE : a + b;
        }
        if (a < 0L && b < 0L) {
            return Long.MIN_VALUE - b > a ? Long.MIN_VALUE : a + b;
        }
        return a + b;
    }

    public static long minus(long a, long b) {
        if (a > 0L && b < 0L) {
            return Long.MAX_VALUE + b < a ? Long.MAX_VALUE : a - b;
        }
        if (a < 0L && b > 0L) {
            return Long.MIN_VALUE + b > a ? Long.MIN_VALUE : a - b;
        }
        return a - b;
    }

    public static int gcd(int a, int b) {
        int c;
        if (a < 0 || b < 0) {
            throw new ArithmeticException();
        }
        if (a == 0 || b == 0) {
            return Math.abs(a - b);
        }
        while ((c = a % b) != 0) {
            a = b;
            b = c;
        }
        return b;
    }

    public static int gcd(int[] array) {
        int result = array[0];
        for (int i = 1; i < array.length; ++i) {
            result = Maths.gcd(result, array[i]);
        }
        return result;
    }
}

