/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.model;

import code.ponfee.commons.model.Page;
import code.ponfee.commons.model.Result;
import code.ponfee.commons.reflect.BeanCopiers;
import code.ponfee.commons.reflect.BeanMaps;
import code.ponfee.commons.reflect.GenericUtils;
import code.ponfee.commons.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cglib.beans.BeanCopier;

public abstract class AbstractDataConverter<S, T>
implements Function<S, T> {
    private final Class<T> targetType = GenericUtils.getActualTypeArgument(this.getClass(), 1);
    private final BeanCopier copier = AbstractDataConverter.createBeanCopier(GenericUtils.getActualTypeArgument(this.getClass(), 0), this.targetType);

    public T convert(S source) {
        if (source == null) {
            return null;
        }
        return AbstractDataConverter.convert(source, this.targetType, this.copier);
    }

    public final void copyProperties(S source, T target) {
        AbstractDataConverter.copy(source, target, this.copier);
    }

    public final List<T> convert(List<S> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(this).collect(Collectors.toList());
    }

    public final Page<T> convert(Page<S> page) {
        if (page == null) {
            return null;
        }
        return page.map(this);
    }

    public final Result<T> convertResultBean(Result<S> result) {
        if (result == null) {
            return null;
        }
        return result.from(this.convert(result.getData()));
    }

    public final Result<List<T>> convertResultList(Result<List<S>> result) {
        if (result == null) {
            return null;
        }
        return result.from(this.convert(result.getData()));
    }

    public final Result<Page<T>> convertResultPage(Result<Page<S>> result) {
        if (result == null) {
            return null;
        }
        return result.from(this.convert(result.getData()));
    }

    @Override
    public final T apply(S source) {
        return this.convert(source);
    }

    public static <S, T> T convert(S source, Class<T> targetType) {
        return AbstractDataConverter.convert(source, targetType, null);
    }

    public static <S, T> T convert(S source, Class<T> targetType, BeanCopier copier) {
        if (source == null || targetType.isInstance(source)) {
            return (T)source;
        }
        if (Map.class.isAssignableFrom(targetType)) {
            return (T)(source instanceof Map ? source : BeanMaps.CGLIB.toMap(source));
        }
        if (source instanceof Map) {
            return BeanMaps.CGLIB.toBean((Map)source, targetType);
        }
        T target = ObjectUtils.newInstance(targetType);
        if (copier != null) {
            copier.copy(source, target, null);
        } else {
            BeanCopiers.copy(source, target);
        }
        return target;
    }

    public static <S, T> void copy(S source, T target) {
        AbstractDataConverter.copy(source, target, null);
    }

    public static <S, T> void copy(S source, T target, BeanCopier copier) {
        if (source == null || target == null) {
            return;
        }
        if (target instanceof Map) {
            if (source instanceof Map) {
                ((Map)target).putAll((Map)source);
            } else {
                ((Map)target).putAll(BeanMaps.CGLIB.toMap(source));
            }
        } else if (source instanceof Map) {
            BeanMaps.CGLIB.copyFromMap((Map)source, target);
        } else if (copier != null) {
            copier.copy(source, target, null);
        } else {
            BeanCopiers.copy(source, target);
        }
    }

    public static <S, T> T convert(S source, Function<S, T> converter) {
        if (source == null) {
            return null;
        }
        return converter.apply(source);
    }

    public static <S, T> List<T> convert(List<S> list, Function<S, T> converter) {
        if (list == null) {
            return null;
        }
        return list.stream().map(converter).collect(Collectors.toList());
    }

    public static <S, T> Page<T> convert(Page<S> page, Function<S, T> converter) {
        if (page == null) {
            return null;
        }
        return page.map(converter);
    }

    public static <S, T> Result<T> convertResultBean(Result<S> result, Function<S, T> converter) {
        if (result == null) {
            return null;
        }
        return result.from(converter.apply(result.getData()));
    }

    public static <S, T> Result<List<T>> convertResultList(Result<List<S>> result, Function<S, T> converter) {
        if (result == null) {
            return null;
        }
        return result.from(AbstractDataConverter.convert(result.getData(), converter));
    }

    public static <S, T> Result<Page<T>> convertResultPage(Result<Page<S>> result, Function<S, T> converter) {
        if (result == null) {
            return null;
        }
        return result.from(AbstractDataConverter.convert(result.getData(), converter));
    }

    private static BeanCopier createBeanCopier(Class<?> sourceType, Class<?> targetType) {
        if (ObjectUtils.isNotBeanType(sourceType) || ObjectUtils.isNotBeanType(targetType)) {
            return null;
        }
        try {
            return BeanCopiers.get(sourceType, targetType);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Create BeanCopier occur error.", e);
        }
    }
}

