/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.model;

import code.ponfee.commons.math.Numbers;
import code.ponfee.commons.reflect.Fields;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Dictionary;
import java.util.Map;
import javax.annotation.Nonnull;

public final class PageHandler {
    public static final String DEFAULT_PAGE_NUM = "pageNum";
    public static final String DEFAULT_PAGE_SIZE = "pageSize";
    public static final String DEFAULT_OFFSET = "offset";
    public static final String DEFAULT_LIMIT = "limit";
    public static final Map<String, Object> QUERY_ALL_PARAMS = ImmutableMap.of((Object)"pageNum", (Object)1, (Object)"pageSize", (Object)0, (Object)"offset", (Object)0, (Object)"limit", (Object)0);
    public static final PageHandler NORMAL = new PageHandler("pageNum", "pageSize", "offset", "limit");
    public static final int MAX_SIZE = 1000;
    private final String paramPageNum;
    private final String paramPageSize;
    private final String paramOffset;
    private final String paramLimit;

    public PageHandler(String paramPageNum, String paramPageSize, String paramOffset, String paramLimit) {
        this.paramPageNum = paramPageNum;
        this.paramPageSize = paramPageSize;
        this.paramOffset = paramOffset;
        this.paramLimit = paramLimit;
    }

    public void handle(@Nonnull Object params) {
        Integer pageSize = PageHandler.getInt(params, this.paramPageSize);
        Integer limit = PageHandler.getInt(params, this.paramLimit);
        if (PageHandler.nullOrNegative(pageSize) && PageHandler.nullOrNegative(limit)) {
            pageSize = 0;
        }
        if (pageSize != null && pageSize > -1) {
            PageHandler.startPage(PageHandler.getInt(params, this.paramPageNum), Numbers.bounds(pageSize, 0, 1000));
        } else {
            PageHandler.offsetPage(PageHandler.getInt(params, this.paramOffset), Numbers.bounds(limit, 0, 1000));
        }
    }

    public static void startPage(Integer pageNum, Integer pageSize) {
        if (pageNum == null || pageNum < 1) {
            pageNum = 1;
        }
        if (PageHandler.nullOrNegative(pageSize)) {
            pageSize = 0;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
    }

    public static void offsetPage(Integer offset, Integer limit) {
        if (PageHandler.nullOrNegative(offset)) {
            offset = 0;
        }
        if (PageHandler.nullOrNegative(limit)) {
            limit = 0;
        }
        PageHelper.offsetPage((int)offset, (int)limit);
    }

    public static int computeTotalPages(long totalRecords, int pageSize) {
        return pageSize == 0 ? 0 : (int)((totalRecords + (long)pageSize - 1L) / (long)pageSize);
    }

    public static int computePageNum(long offset, int limit) {
        return limit == 0 ? 0 : (int)(offset / (long)limit + 1L);
    }

    public static int computeOffset(long pageNum, int pageSize) {
        return (int)((pageNum - 1L) * (long)pageSize);
    }

    private static Integer getInt(Object params, String name) {
        try {
            Object value = params instanceof Map ? ((Map)params).get(name) : (params instanceof Dictionary ? ((Dictionary)params).get(name) : Fields.get(params, name));
            return Numbers.toWrapInt(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean nullOrNegative(Integer val) {
        return val == null || val < 0;
    }
}

