/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.model;

import code.ponfee.commons.model.TypedParameter;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class PageParameter
extends TypedParameter {
    private static final long serialVersionUID = 6176654946390797217L;
    public static final List<String> PAGE_PARAMS = ImmutableList.of((Object)"pageNum", (Object)"pageSize", (Object)"offset", (Object)"limit");
    public static final String SORT_PARAM = "sort";
    private static final String[] ORDER_DIRECTION = new String[]{"ASC", "DESC"};
    private int pageNum = -1;
    private int pageSize = -1;
    private int offset = -1;
    private int limit = -1;
    private String sort = null;

    public PageParameter() {
        this(new LinkedHashMap<String, Object>());
    }

    public PageParameter(int initialCapacity) {
        this(new LinkedHashMap<String, Object>(initialCapacity));
    }

    public PageParameter(int initialCapacity, int loadFactor) {
        this(new LinkedHashMap<String, Object>(initialCapacity, loadFactor));
    }

    public PageParameter(Map<String, Object> params) {
        super(params);
    }

    public PageParameter searchAll() {
        this.setPageNum(1);
        this.setPageSize(0);
        this.setLimit(0);
        this.setOffset(0);
        return this;
    }

    public void validateSort(String ... allows) {
        String[] orders;
        if (ArrayUtils.isEmpty((Object[])allows)) {
            return;
        }
        String sort = this.getString(SORT_PARAM);
        if (StringUtils.isBlank((CharSequence)sort)) {
            return;
        }
        for (String order : orders = sort.split(",")) {
            String[] array;
            if (StringUtils.isBlank((CharSequence)order) || ArrayUtils.contains((Object[])allows, (Object)(array = order.trim().split(" ", 2))[0].trim()) && (array.length != 2 || ArrayUtils.contains((Object[])ORDER_DIRECTION, (Object)array[1].trim().toUpperCase()))) continue;
            throw new IllegalArgumentException("Illegal sort param: " + sort);
        }
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
        this.put("pageNum", pageNum);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.put("pageSize", pageSize);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.put("offset", offset);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.put("limit", limit);
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
        this.put(SORT_PARAM, sort);
    }
}

