/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.model;

import code.ponfee.commons.math.Numbers;
import code.ponfee.commons.util.ObjectUtils;
import java.util.Objects;

public interface TypedKeyValue<K, V> {
    public V getValue(K var1);

    public V removeKey(K var1);

    default public boolean hasKey(K key) {
        return !ObjectUtils.isEmpty(this.getValue(key));
    }

    default public V getRequired(K key) {
        V value = this.getValue(key);
        TypedKeyValue.assertPresented(key, value);
        return value;
    }

    default public V get(K key, V defaultVal) {
        V value = this.getValue(key);
        return value == null ? defaultVal : value;
    }

    default public String getRequiredString(K key) {
        V value = this.getValue(key);
        TypedKeyValue.assertPresented(key, value);
        return value.toString();
    }

    default public String getString(K key) {
        return this.getString(key, null);
    }

    default public String getString(K key, String defaultVal) {
        return Objects.toString(this.getValue(key), defaultVal);
    }

    default public String removeString(K key) {
        return this.removeString(key, null);
    }

    default public String removeString(K key, String defaultVal) {
        return Objects.toString(this.removeKey(key), defaultVal);
    }

    default public boolean getRequiredBoolean(K key) {
        V value = this.getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        TypedKeyValue.assertPresented(key, value);
        switch (value.toString()) {
            case "TRUE": 
            case "True": 
            case "true": {
                return true;
            }
            case "FALSE": 
            case "False": 
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + value);
    }

    default public boolean getBoolean(K key, boolean defaultValue) {
        return Numbers.toBoolean(this.getValue(key), defaultValue);
    }

    default public Boolean getBoolean(K key) {
        return Numbers.toWrapBoolean(this.getValue(key));
    }

    default public boolean removeBoolean(K key, boolean defaultValue) {
        return Numbers.toBoolean(this.removeKey(key), defaultValue);
    }

    default public Boolean removeBoolean(K key) {
        return Numbers.toWrapBoolean(this.removeKey(key));
    }

    default public int getRequiredInt(K key) {
        Integer value = Numbers.toWrapInt(this.getValue(key));
        TypedKeyValue.assertPresented(key, value);
        return value;
    }

    default public int getInt(K key, int defaultValue) {
        return Numbers.toInt(this.getValue(key), defaultValue);
    }

    default public Integer getInt(K key) {
        return Numbers.toWrapInt(this.getValue(key));
    }

    default public int removeInt(K key, int defaultValue) {
        return Numbers.toInt(this.removeKey(key), defaultValue);
    }

    default public Integer removeInt(K key) {
        return Numbers.toWrapInt(this.removeKey(key));
    }

    default public long getRequiredLong(K key) {
        Long value = Numbers.toWrapLong(this.getValue(key));
        TypedKeyValue.assertPresented(key, value);
        return value;
    }

    default public long getLong(K key, long defaultValue) {
        return Numbers.toLong(this.getValue(key), defaultValue);
    }

    default public Long getLong(K key) {
        return Numbers.toWrapLong(this.getValue(key));
    }

    default public long removeLong(K key, long defaultValue) {
        return Numbers.toLong(this.removeKey(key), defaultValue);
    }

    default public Long removeLong(K key) {
        return Numbers.toWrapLong(this.removeKey(key));
    }

    default public float getRequiredFloat(K key) {
        Float value = Numbers.toWrapFloat(this.getValue(key));
        TypedKeyValue.assertPresented(key, value);
        return value.floatValue();
    }

    default public float getFloat(K key, float defaultValue) {
        return Numbers.toFloat(this.getValue(key), defaultValue);
    }

    default public Float getFloat(K key) {
        return Numbers.toWrapFloat(this.getValue(key));
    }

    default public float removeFloat(K key, float defaultValue) {
        return Numbers.toFloat(this.removeKey(key), defaultValue);
    }

    default public Float removeFloat(K key) {
        return Numbers.toWrapFloat(this.removeKey(key));
    }

    default public double getRequiredDouble(K key) {
        Double value = Numbers.toWrapDouble(this.getValue(key));
        TypedKeyValue.assertPresented(key, value);
        return value;
    }

    default public double getDouble(K key, double defaultValue) {
        return Numbers.toDouble(this.getValue(key), defaultValue);
    }

    default public Double getDouble(K key) {
        return Numbers.toWrapDouble(this.getValue(key));
    }

    default public double removeDouble(K key, double defaultValue) {
        return Numbers.toDouble(this.removeKey(key), defaultValue);
    }

    default public Double removeDouble(K key) {
        return Numbers.toWrapDouble(this.removeKey(key));
    }

    public static void assertPresented(Object key, Object value) {
        if (ObjectUtils.isEmpty(value)) {
            throw new IllegalArgumentException("Not presented value of '" + key + "'");
        }
    }
}

