/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.mybatis;

import code.ponfee.commons.data.lookup.MultipleDataSourceContext;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.MyBatisExceptionTranslator;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class MultipleSqlSessionTemplate
extends SqlSessionTemplate {
    private final SqlSessionFactory defaultTargetSqlSessionFactory;
    private final ExecutorType defaultTargetExecutorType;
    private final PersistenceExceptionTranslator defaultTargetExceptionTranslator;
    private final Map<Object, SqlSessionFactory> targetSqlSessionFactories;
    private final SqlSession sqlSessionProxy;

    public MultipleSqlSessionTemplate(SqlSessionFactory defaultTargetSqlSessionFactory, Map<Object, SqlSessionFactory> targetSqlSessionFactories) {
        super(defaultTargetSqlSessionFactory);
        this.targetSqlSessionFactories = Objects.requireNonNull(targetSqlSessionFactories);
        this.defaultTargetSqlSessionFactory = defaultTargetSqlSessionFactory;
        this.defaultTargetExecutorType = defaultTargetSqlSessionFactory.getConfiguration().getDefaultExecutorType();
        this.defaultTargetExceptionTranslator = new MyBatisExceptionTranslator(defaultTargetSqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
        this.sqlSessionProxy = (SqlSession)Proxy.newProxyInstance(SqlSessionFactory.class.getClassLoader(), new Class[]{SqlSession.class}, (proxy, method, args) -> {
            SqlSessionFactory sqlSessionFactory = this.getSqlSessionFactory();
            SqlSession sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)sqlSessionFactory, (ExecutorType)this.defaultTargetExecutorType, (PersistenceExceptionTranslator)this.defaultTargetExceptionTranslator);
            try {
                Object result = method.invoke((Object)sqlSession, args);
                if (!SqlSessionUtils.isSqlSessionTransactional((SqlSession)sqlSession, (SqlSessionFactory)sqlSessionFactory)) {
                    sqlSession.commit(true);
                }
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
                if (this.defaultTargetExceptionTranslator != null && unwrapped instanceof PersistenceException) {
                    SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)sqlSessionFactory);
                    sqlSession = null;
                    DataAccessException translated = this.defaultTargetExceptionTranslator.translateExceptionIfPossible((RuntimeException)((PersistenceException)unwrapped));
                    if (translated != null) {
                        unwrapped = translated;
                    }
                }
                throw unwrapped;
            }
            finally {
                if (sqlSession != null) {
                    SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)sqlSessionFactory);
                }
            }
        });
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return Optional.ofNullable(this.targetSqlSessionFactories.get(MultipleDataSourceContext.get())).orElse(this.defaultTargetSqlSessionFactory);
    }

    public ExecutorType getExecutorType() {
        return this.defaultTargetExecutorType;
    }

    public PersistenceExceptionTranslator getPersistenceExceptionTranslator() {
        return this.defaultTargetExceptionTranslator;
    }

    public <T> T selectOne(String statement) {
        return (T)this.sqlSessionProxy.selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.sqlSessionProxy.selectOne(statement, parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.sqlSessionProxy.selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.sqlSessionProxy.selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectMap(statement, parameter, mapKey, rowBounds);
    }

    public <T> Cursor<T> selectCursor(String statement) {
        return this.sqlSessionProxy.selectCursor(statement);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        return this.sqlSessionProxy.selectCursor(statement, parameter);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectCursor(statement, parameter, rowBounds);
    }

    public <E> List<E> selectList(String statement) {
        return this.sqlSessionProxy.selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.sqlSessionProxy.selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.sqlSessionProxy.selectList(statement, parameter, rowBounds);
    }

    public void select(String statement, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, handler);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, parameter, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.sqlSessionProxy.select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.sqlSessionProxy.insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.sqlSessionProxy.insert(statement, parameter);
    }

    public int update(String statement) {
        return this.sqlSessionProxy.update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.sqlSessionProxy.update(statement, parameter);
    }

    public int delete(String statement) {
        return this.sqlSessionProxy.delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.sqlSessionProxy.delete(statement, parameter);
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.getConfiguration().getMapper(type, (SqlSession)this);
    }

    public void commit() {
        throw new UnsupportedOperationException("Manual commit is not allowed over a Spring managed SqlSession");
    }

    public void commit(boolean force) {
        throw new UnsupportedOperationException("Manual commit is not allowed over a Spring managed SqlSession");
    }

    public void rollback() {
        throw new UnsupportedOperationException("Manual rollback is not allowed over a Spring managed SqlSession");
    }

    public void rollback(boolean force) {
        throw new UnsupportedOperationException("Manual rollback is not allowed over a Spring managed SqlSession");
    }

    public void close() {
        throw new UnsupportedOperationException("Manual close is not allowed over a Spring managed SqlSession");
    }

    public void clearCache() {
        this.sqlSessionProxy.clearCache();
    }

    public Configuration getConfiguration() {
        return this.defaultTargetSqlSessionFactory.getConfiguration();
    }

    public Connection getConnection() {
        return this.sqlSessionProxy.getConnection();
    }

    public List<BatchResult> flushStatements() {
        return this.sqlSessionProxy.flushStatements();
    }
}

