/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.mybatis;

import code.ponfee.commons.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class SqlMapper {
    private final SqlSession sqlSession;
    private final MSUtils msUtils;

    public SqlMapper(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
        this.msUtils = new MSUtils(sqlSession.getConfiguration());
    }

    public Map<String, Object> selectOne(String sql) {
        return this.asSingleItem(this.selectList(sql));
    }

    public Map<String, Object> selectOne(String sql, Object param) {
        return this.asSingleItem(this.selectList(sql, param));
    }

    public <T> T selectOne(String sql, Class<T> resultType) {
        return this.asSingleItem(this.selectList(sql, resultType));
    }

    public <T> T selectOne(String sql, Object param, Class<T> resultType) {
        return this.asSingleItem(this.selectList(sql, param, resultType));
    }

    public List<Map<String, Object>> selectList(String sql) {
        return this.sqlSession.selectList(this.msUtils.select(sql));
    }

    public List<Map<String, Object>> selectList(String sql, Object param) {
        return this.sqlSession.selectList(this.msUtils.selectDynamic(sql, ObjectUtils.typeOf(param)), param);
    }

    public <T> List<T> selectList(String sql, Class<T> resultType) {
        String msId = resultType == null ? this.msUtils.select(sql) : this.msUtils.select(sql, resultType);
        return this.sqlSession.selectList(msId);
    }

    public <T> List<T> selectList(String sql, Object param, Class<T> resultType) {
        String msId = resultType == null ? this.msUtils.selectDynamic(sql, ObjectUtils.typeOf(param)) : this.msUtils.selectDynamic(sql, ObjectUtils.typeOf(param), resultType);
        return this.sqlSession.selectList(msId, param);
    }

    public <P, R> void selectScroll(String sql, P param, Class<R> resultType, BiFunction<P, List<R>, P> action) {
        boolean hasNext;
        do {
            List<R> list;
            if (!(hasNext = CollectionUtils.isNotEmpty(list = this.selectList(sql, param, resultType)))) continue;
            param = action.apply(param, list);
        } while (hasNext);
    }

    public int insert(String sql) {
        return this.sqlSession.insert(this.msUtils.insert(sql));
    }

    public int insert(String sql, Object param) {
        return this.sqlSession.insert(this.msUtils.insertDynamic(sql, ObjectUtils.typeOf(param)), param);
    }

    public int update(String sql) {
        return this.sqlSession.update(this.msUtils.update(sql));
    }

    public int update(String sql, Object param) {
        return this.sqlSession.update(this.msUtils.updateDynamic(sql, ObjectUtils.typeOf(param)), param);
    }

    public int delete(String sql) {
        return this.sqlSession.delete(this.msUtils.delete(sql));
    }

    public int delete(String sql, Object param) {
        return this.sqlSession.delete(this.msUtils.deleteDynamic(sql, ObjectUtils.typeOf(param)), param);
    }

    private <T> T asSingleItem(List<T> list) {
        int rowSize;
        int n = rowSize = list == null ? 0 : list.size();
        if (rowSize > 1) {
            throw new TooManyResultsException("Expected one row (or null) to be returned by selectOne(), but found: " + list.size());
        }
        return rowSize == 1 ? (T)list.get(0) : null;
    }

    private static class MSUtils {
        private final Configuration configuration;
        private final LanguageDriver languageDriver;

        private MSUtils(Configuration configuration) {
            this.configuration = configuration;
            this.languageDriver = configuration.getDefaultScriptingLanguageInstance();
        }

        private String newMsId(String sql, SqlCommandType sqlCommandType) {
            return sqlCommandType.toString() + "." + sql.hashCode();
        }

        private boolean hasMappedStatement(String msId) {
            return this.configuration.hasStatement(msId, false);
        }

        private void newSelectMappedStatement(String msId, SqlSource sqlSource, Class<?> resultType) {
            List<ResultMap> list = Collections.singletonList(new ResultMap.Builder(this.configuration, "defaultResultMap", resultType, new ArrayList(0)).build());
            MappedStatement ms = new MappedStatement.Builder(this.configuration, msId, sqlSource, SqlCommandType.SELECT).resultMaps(list).build();
            this.configuration.addMappedStatement(ms);
        }

        private void newUpdateMappedStatement(String msId, SqlSource sqlSource, SqlCommandType sqlCommandType) {
            List<ResultMap> list = Collections.singletonList(new ResultMap.Builder(this.configuration, "defaultResultMap", Integer.TYPE, new ArrayList(0)).build());
            MappedStatement ms = new MappedStatement.Builder(this.configuration, msId, sqlSource, sqlCommandType).resultMaps(list).build();
            this.configuration.addMappedStatement(ms);
        }

        private String select(String sql) {
            String msId = this.newMsId(sql, SqlCommandType.SELECT);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
            this.newSelectMappedStatement(msId, (SqlSource)sqlSource, Map.class);
            return msId;
        }

        private String selectDynamic(String sql, Class<?> parameterType) {
            String msId = this.newMsId(sql + parameterType, SqlCommandType.SELECT);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
            this.newSelectMappedStatement(msId, sqlSource, Map.class);
            return msId;
        }

        private String select(String sql, Class<?> resultType) {
            String msId = this.newMsId(resultType + sql, SqlCommandType.SELECT);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
            this.newSelectMappedStatement(msId, (SqlSource)sqlSource, resultType);
            return msId;
        }

        private String selectDynamic(String sql, Class<?> parameterType, Class<?> resultType) {
            String msId = this.newMsId(resultType + sql + parameterType, SqlCommandType.SELECT);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
            this.newSelectMappedStatement(msId, sqlSource, resultType);
            return msId;
        }

        private String insert(String sql) {
            String msId = this.newMsId(sql, SqlCommandType.INSERT);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
            this.newUpdateMappedStatement(msId, (SqlSource)sqlSource, SqlCommandType.INSERT);
            return msId;
        }

        private String insertDynamic(String sql, Class<?> parameterType) {
            String msId = this.newMsId(sql + parameterType, SqlCommandType.INSERT);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
            this.newUpdateMappedStatement(msId, sqlSource, SqlCommandType.INSERT);
            return msId;
        }

        private String update(String sql) {
            String msId = this.newMsId(sql, SqlCommandType.UPDATE);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
            this.newUpdateMappedStatement(msId, (SqlSource)sqlSource, SqlCommandType.UPDATE);
            return msId;
        }

        private String updateDynamic(String sql, Class<?> parameterType) {
            String msId = this.newMsId(sql + parameterType, SqlCommandType.UPDATE);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
            this.newUpdateMappedStatement(msId, sqlSource, SqlCommandType.UPDATE);
            return msId;
        }

        private String delete(String sql) {
            String msId = this.newMsId(sql, SqlCommandType.DELETE);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
            this.newUpdateMappedStatement(msId, (SqlSource)sqlSource, SqlCommandType.DELETE);
            return msId;
        }

        private String deleteDynamic(String sql, Class<?> parameterType) {
            String msId = this.newMsId(sql + parameterType, SqlCommandType.DELETE);
            if (this.hasMappedStatement(msId)) {
                return msId;
            }
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
            this.newUpdateMappedStatement(msId, sqlSource, SqlCommandType.DELETE);
            return msId;
        }
    }
}

