/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PdfWaterMark {
    public static void waterImgMark(InputStream pdf, byte[] img, OutputStream out) {
        PdfStamper stamper = null;
        PdfReader reader = null;
        try {
            reader = new PdfReader(pdf);
            stamper = new PdfStamper(reader, out);
            Image image = Image.getInstance((byte[])img);
            int n = stamper.getReader().getNumberOfPages() + 1;
            for (int i = 1; i < n; ++i) {
                Rectangle pageRect = stamper.getReader().getPageSizeWithRotation(i);
                PdfContentByte content = stamper.getUnderContent(i);
                content.saveState();
                image.setAbsolutePosition(pageRect.getWidth() - image.getWidth(), 0.0f);
                content.addImage(image);
            }
            out.flush();
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (DocumentException | IOException ignored) {
                    ignored.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void waterWordMark(InputStream pdf, String words, OutputStream out) {
        PdfStamper stamper = null;
        PdfReader reader = null;
        try {
            reader = new PdfReader(pdf);
            stamper = new PdfStamper(reader, out);
            BaseFont base = BaseFont.createFont((String)"code/ponfee/commons/pdf/aspose/simfang.ttf", (String)"Identity-H", (boolean)true);
            PdfGState pdfGState = new PdfGState();
            pdfGState.setStrokeOpacity(0.2f);
            pdfGState.setFillOpacity(0.2f);
            int totalPage = stamper.getReader().getNumberOfPages();
            for (int i = 1; i <= totalPage; ++i) {
                Rectangle pageRect = stamper.getReader().getPageSizeWithRotation(i);
                float x = pageRect.getWidth() / 2.0f;
                float y = pageRect.getHeight() / 2.0f;
                PdfContentByte content = stamper.getUnderContent(i);
                content.saveState();
                content.setGState(pdfGState);
                content.beginText();
                content.setColorFill(BaseColor.LIGHT_GRAY);
                content.setFontAndSize(base, 60.0f);
                content.showTextAligned(1, words, x, y, 45.0f);
                content.endText();
            }
            out.flush();
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (DocumentException | IOException ignored) {
                    ignored.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

