/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.pdf.sign;

import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.pdf.sign.Signer;
import code.ponfee.commons.pdf.sign.Stamp;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import sun.security.x509.AlgorithmId;

public class PdfSignature {
    public static final float SIGN_AREA_RATE = 0.8f;

    public static void sign(InputStream pdfInput, OutputStream pdfOutput, Stamp stamp, Signer signer) {
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            reader = new PdfReader(pdfInput);
            stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)pdfOutput, (char)'\u0000', null, (boolean)true);
            stamper.getWriter().setCompressionLevel(-1);
            Calendar calendar = Calendar.getInstance();
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setVisibleSignature(PdfSignature.calcRectangle(signer.getImage(), stamp), stamp.getPageNo(), String.valueOf(calendar.getTimeInMillis()));
            appearance.setSignDate(calendar);
            appearance.setSignatureGraphic(signer.getImage());
            appearance.setCertificationLevel(0);
            appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
            PrivateKeySignature signature = new PrivateKeySignature(signer.getPriKey(), AlgorithmId.getDigAlgFromSigAlg((String)((X509Certificate)signer.getCertChain()[0]).getSigAlgName()), Providers.BC.getName());
            MakeSignature.signDetached((PdfSignatureAppearance)appearance, (ExternalDigest)new BouncyCastleDigest(), (ExternalSignature)signature, (Certificate[])signer.getCertChain(), null, null, null, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CMS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
    }

    public static byte[] sign(byte[] pdf, Stamp[] stamps, Signer signer) {
        for (Stamp stamp : stamps) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            PdfSignature.sign(new ByteArrayInputStream(pdf), baos, stamp, signer);
            pdf = baos.toByteArray();
        }
        return pdf;
    }

    private static Rectangle calcRectangle(Image image, Stamp stamp) {
        return new Rectangle(stamp.getLeft(), stamp.getBottom(), stamp.getLeft() + image.getWidth() * 0.8f, stamp.getBottom() + image.getTop() * 0.8f);
    }
}

