/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.reflect;

import code.ponfee.commons.base.PrimitiveTypes;
import code.ponfee.commons.base.tuple.Tuple2;
import code.ponfee.commons.base.tuple.Tuple3;
import code.ponfee.commons.collect.ArrayHashKey;
import code.ponfee.commons.collect.Collects;
import code.ponfee.commons.model.Null;
import code.ponfee.commons.model.Predicates;
import code.ponfee.commons.util.Asserts;
import code.ponfee.commons.util.Strings;
import code.ponfee.commons.util.SynchronizedCaches;
import code.ponfee.commons.util.URLCodes;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.objenesis.ObjenesisHelper;

public final class ClassUtils {
    private static final Map<Object, Constructor<?>> CONSTRUCTOR_CACHE = new HashMap();
    private static final Map<Object, Method> METHOD_CACHE = new HashMap<Object, Method>();

    public static String[] getMethodParamNames(final Method method) {
        ClassReader classReader;
        try {
            Class<?> clazz = method.getDeclaringClass();
            classReader = new ClassReader(clazz.getResourceAsStream(clazz.getSimpleName() + ".class"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final String[] paramNames = new String[method.getParameterTypes().length];
        classReader.accept(new ClassVisitor(327680, (ClassVisitor)new ClassWriter(1)){

            public MethodVisitor visitMethod(int access, String name, String desc, String sign, String[] ex) {
                if (!name.equals(method.getName()) || !ClassUtils.isSameType(Type.getArgumentTypes((String)desc), method.getParameterTypes())) {
                    return super.visitMethod(access, name, desc, sign, ex);
                }
                return new MethodVisitor(327680, this.cv.visitMethod(access, name, desc, sign, ex)){

                    public void visitLocalVariable(String name, String desc, String sign, Label start, Label end, int index) {
                        int i = index;
                        if (!Modifier.isStatic(method.getModifiers())) {
                            --i;
                        }
                        if (i >= 0 && i < paramNames.length) {
                            paramNames[i] = name;
                        }
                        super.visitLocalVariable(name, desc, sign, start, end, index);
                    }
                };
            }
        }, 0);
        return paramNames;
    }

    public static String getMethodSignature(Method method) {
        String[] names = ClassUtils.getMethodParamNames(method);
        Class<?>[] types = method.getParameterTypes();
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            params.add(ClassUtils.getClassName(types[i]) + " " + names[i]);
        }
        return Modifier.toString(method.getModifiers() & Modifier.methodModifiers()) + ' ' + ClassUtils.getClassName(method.getReturnType()) + ' ' + ClassUtils.getClassName(method.getDeclaringClass()) + '.' + method.getName() + '(' + Strings.join(params, ",") + ')';
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        if (clazz.isInterface() || clazz == Object.class) {
            return null;
        }
        Exception firstOccurException = null;
        do {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (!Modifier.isStatic(field.getModifiers())) {
                    return field;
                }
            }
            catch (Exception e) {
                if (firstOccurException != null) continue;
                firstOccurException = e;
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        throw new RuntimeException(firstOccurException);
    }

    public static List<Field> listFields(Class<?> clazz) {
        if (clazz.isInterface() || clazz == Object.class) {
            return null;
        }
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    int mdf = field.getModifiers();
                    if (Modifier.isStatic(mdf) || Modifier.isTransient(mdf)) continue;
                    list.add(field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return list;
    }

    public static Tuple2<Class<?>, Field> getStaticFieldInClassChain(Class<?> clazz, String staticFieldName) {
        if (clazz == Object.class) {
            return null;
        }
        Exception firstOccurException = null;
        LinkedList<Class<?>> queue = Collects.newLinkedList(clazz);
        while (!queue.isEmpty()) {
            for (int i = queue.size(); i > 0; --i) {
                Class type;
                block7: {
                    type = (Class)queue.poll();
                    try {
                        Field field = type.getDeclaredField(staticFieldName);
                        if (Modifier.isStatic(field.getModifiers())) {
                            return Tuple2.of(type, field);
                        }
                    }
                    catch (Exception e) {
                        if (firstOccurException != null) break block7;
                        firstOccurException = e;
                    }
                }
                if (type.getSuperclass() != Object.class) {
                    queue.offer(type.getSuperclass());
                }
                Arrays.stream(type.getInterfaces()).forEach(queue::offer);
            }
        }
        throw new RuntimeException(firstOccurException);
    }

    public static Field getStaticField(Class<?> clazz, String staticFieldName) {
        if (clazz == Object.class) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(staticFieldName);
            if (Modifier.isStatic(field.getModifiers())) {
                return field;
            }
            throw new RuntimeException("Non-static field " + ClassUtils.getClassName(clazz) + "#" + staticFieldName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    public static String getPackagePath(String packageName) {
        return packageName.replace('.', '/') + "/";
    }

    public static String getPackagePath(Class<?> clazz) {
        String className = ClassUtils.getClassName(clazz);
        if (className.indexOf(46) < 0) {
            return "";
        }
        return ClassUtils.getPackagePath(className.substring(0, className.lastIndexOf(46)));
    }

    public static String getClassFilePath(Class<?> clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String path = new File(URLCodes.decodeURI(url.getPath(), "UTF-8")).getAbsolutePath();
        if (path.toLowerCase().endsWith(".jar")) {
            path = path + "!";
        }
        return path + File.separator + ClassUtils.getClassName(clazz).replace('.', File.separatorChar) + ".class";
    }

    public static String getClasspath(Class<?> clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String path = URLCodes.decodeURI(url.getPath(), "UTF-8");
        if (path.toLowerCase().endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        return new File(path).getAbsolutePath() + File.separator;
    }

    public static String getClasspath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        path = URLCodes.decodeURI(new File(path).getAbsolutePath(), "UTF-8");
        return path + File.separator;
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        boolean noArgs = ArrayUtils.isEmpty((Object[])parameterTypes);
        Class key = noArgs ? type : Tuple2.of(type, ArrayHashKey.of(parameterTypes));
        Constructor constructor = SynchronizedCaches.get(key, CONSTRUCTOR_CACHE, () -> {
            try {
                return ClassUtils.getConstructor0(type, parameterTypes);
            }
            catch (Exception ignored) {
                return Null.BROKEN_CONSTRUCTOR;
            }
        });
        return constructor == Null.BROKEN_CONSTRUCTOR ? null : constructor;
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ClassUtils.newInstance(constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        try {
            return ArrayUtils.isEmpty((Object[])args) ? constructor.newInstance(new Object[0]) : constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> type, Class<?>[] parameterTypes, Object[] args) {
        ClassUtils.checkObjectArray(args);
        ClassUtils.checkSameLength(parameterTypes, args);
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            return ClassUtils.newInstance(type, null);
        }
        Constructor<T> constructor = ClassUtils.getConstructor(type, parameterTypes);
        if (constructor == null) {
            throw new RuntimeException("No such constructor: " + ClassUtils.getClassName(type) + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.newInstance(constructor, args);
    }

    public static <T> T newInstance(Class<T> type) {
        return ClassUtils.newInstance(type, null);
    }

    public static <T> T newInstance(Class<T> type, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (ArrayUtils.isEmpty((Object[])args)) {
            Constructor<T> constructor = ClassUtils.getConstructor(type, new Class[0]);
            return (T)(constructor != null ? ClassUtils.newInstance(constructor, null) : ObjenesisHelper.newInstance(type));
        }
        Class<?>[] parameterTypes = ClassUtils.parseParameterTypes(args);
        Constructor<T> constructor = ClassUtils.obtainConstructor(type, parameterTypes);
        if (constructor == null) {
            throw new RuntimeException("Not found constructor: " + ClassUtils.getClassName(type) + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.newInstance(constructor, args);
    }

    public static Method getMethod(Object caller, String methodName, Class<?> ... parameterTypes) {
        Tuple2<Class<?>, Predicates> tuple = ClassUtils.obtainClass(caller);
        Class type = (Class)tuple.a;
        boolean noArgs = ArrayUtils.isEmpty((Object[])parameterTypes);
        Tuple2<Class, String> key = noArgs ? Tuple2.of(type, methodName) : Tuple3.of(type, methodName, ArrayHashKey.of(parameterTypes));
        Method method = SynchronizedCaches.get(key, METHOD_CACHE, () -> {
            try {
                Method m = ClassUtils.getMethod0(type, methodName, parameterTypes);
                return ((Predicates)((Object)((Object)tuple.b))).equals(Modifier.isStatic(m.getModifiers())) && !m.isSynthetic() ? m : null;
            }
            catch (Exception ignored) {
                return Null.BROKEN_METHOD;
            }
        });
        return method == Null.BROKEN_METHOD ? null : method;
    }

    public static <T> T invoke(Object caller, Method method) {
        return ClassUtils.invoke(caller, method, null);
    }

    public static <T> T invoke(Object caller, Method method, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)(ArrayUtils.isEmpty((Object[])args) ? method.invoke(caller, new Object[0]) : method.invoke(caller, args));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(Object caller, String methodName) {
        return ClassUtils.invoke(caller, methodName, null, null);
    }

    public static <T> T invoke(Object caller, String methodName, Class<?>[] parameterTypes, Object[] args) {
        ClassUtils.checkObjectArray(args);
        ClassUtils.checkSameLength(parameterTypes, args);
        Method method = ClassUtils.getMethod(caller, methodName, parameterTypes);
        if (method == null) {
            throw new RuntimeException("No such method: " + ClassUtils.getClassName(caller.getClass()) + "#" + methodName + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.invoke(caller, method, args);
    }

    public static <T> T invoke(Object caller, String methodName, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (ArrayUtils.isEmpty((Object[])args)) {
            return ClassUtils.invoke(caller, methodName, null, null);
        }
        Class<?>[] parameterTypes = ClassUtils.parseParameterTypes(args);
        Method method = ClassUtils.obtainMethod(caller, methodName, parameterTypes);
        if (method == null) {
            Class<?> clazz = caller instanceof Class ? (Class<?>)caller : caller.getClass();
            throw new RuntimeException("Not found method: " + ClassUtils.getClassName(clazz) + "#" + methodName + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.invoke(caller, method, args);
    }

    public static Tuple2<Class<?>, Predicates> obtainClass(Object obj) {
        if (obj instanceof Class && obj != Class.class) {
            return Tuple2.of((Class)obj, Predicates.Y);
        }
        return Tuple2.of(obj.getClass(), Predicates.N);
    }

    private static void checkSameLength(Object[] a, Object[] b) {
        if (ArrayUtils.isEmpty((Object[])a) && ArrayUtils.isEmpty((Object[])b)) {
            return;
        }
        if (a.length != b.length) {
            throw new RuntimeException("Two array are different length: " + a.length + ", " + b.length);
        }
    }

    private static void checkObjectArray(Object[] array) {
        if (array != null && array.getClass() != Object[].class) {
            throw new RuntimeException("Args must Object[] type, but actual is " + array.getClass().getSimpleName());
        }
    }

    private static Class<?>[] parseParameterTypes(Object[] args) {
        Asserts.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])args), (String)"Should be always non empty.");
        Class[] parameterTypes = new Class[args.length];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            parameterTypes[i] = args[i] == null ? null : args[i].getClass();
        }
        return parameterTypes;
    }

    private static Method getMethod0(Class<?> type, String methodName, Class<?>[] parameterTypes) throws Exception {
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            try {
                return type.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                throw e;
            }
        }
    }

    private static <T> Constructor<T> getConstructor0(Class<T> type, Class<?>[] parameterTypes) throws Exception {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            try {
                return type.getDeclaredConstructor(parameterTypes);
            }
            catch (Exception exception) {
                throw e;
            }
        }
    }

    private static <T> Constructor<T> obtainConstructor(Class<T> type, Class<?>[] actualTypes) {
        Asserts.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])actualTypes), (String)"Should be always non empty.");
        Constructor<?> constructor = ClassUtils.obtainConstructor(type.getConstructors(), actualTypes);
        if (constructor != null) {
            return constructor;
        }
        return ClassUtils.obtainConstructor(type.getDeclaredConstructors(), actualTypes);
    }

    private static <T> Constructor<T> obtainConstructor(Constructor<T>[] constructors, Class<?>[] actualTypes) {
        if (ArrayUtils.isEmpty((Object[])constructors)) {
            return null;
        }
        for (Constructor<T> constructor : constructors) {
            if (!ClassUtils.matches(constructor.getParameterTypes(), actualTypes)) continue;
            return constructor;
        }
        return null;
    }

    private static Method obtainMethod(Object caller, String methodName, Class<?>[] actualTypes) {
        Asserts.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])actualTypes), (String)"Should be always non empty.");
        Tuple2<Class<?>, Predicates> tuple = ClassUtils.obtainClass(caller);
        Method method = ClassUtils.obtainMethod(((Class)tuple.a).getMethods(), methodName, (Predicates)((Object)tuple.b), actualTypes);
        if (method != null) {
            return method;
        }
        return ClassUtils.obtainMethod(((Class)tuple.a).getDeclaredMethods(), methodName, (Predicates)((Object)tuple.b), actualTypes);
    }

    private static Method obtainMethod(Method[] methods, String methodName, Predicates flag, Class<?>[] actualTypes) {
        if (ArrayUtils.isEmpty((Object[])methods)) {
            return null;
        }
        for (Method method : methods) {
            boolean matches;
            boolean bl = matches = method.getName().equals(methodName) && !method.isSynthetic() && flag.equals(Modifier.isStatic(method.getModifiers())) && ClassUtils.matches(method.getParameterTypes(), actualTypes);
            if (!matches) continue;
            return method;
        }
        return null;
    }

    private static boolean matches(Class<?>[] definedTypes, Class<?>[] actualTypes) {
        if (definedTypes.length != actualTypes.length) {
            return false;
        }
        int n = definedTypes.length;
        for (int i = 0; i < n; ++i) {
            Class<?> definedType = definedTypes[i];
            Class<?> actualType = actualTypes[i];
            if (definedType.isPrimitive()) {
                PrimitiveTypes ept = PrimitiveTypes.ofPrimitive(definedType);
                PrimitiveTypes apt = PrimitiveTypes.ofPrimitiveOrWrapper(actualType);
                if (apt != null && apt.isCastable(ept)) continue;
                return false;
            }
            if (actualType == null || definedType.isAssignableFrom(actualType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameType(Type[] types, Class<?>[] classes) {
        if (types.length != classes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(classes[i]).equals((Object)types[i])) continue;
            return false;
        }
        return true;
    }

    private static String toString(Class<?>[] parameterTypes) {
        return ArrayUtils.isEmpty((Object[])parameterTypes) ? "()" : "(" + Strings.join(Arrays.asList(parameterTypes), ", ") + ")";
    }
}

