/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.resource;

import code.ponfee.commons.resource.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebappResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(WebappResourceLoader.class);
    private ServletContext servletContext;

    WebappResourceLoader() {
    }

    void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    ServletContext getServletContext() {
        return this.servletContext;
    }

    Resource getResource(String filePath, String encoding) {
        try {
            File f = new File(this.servletContext.getRealPath(filePath));
            return new Resource(f.getAbsolutePath(), f.getName(), new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            LOG.error("file not found [" + filePath + "]", (Throwable)e);
            return null;
        }
    }

    List<Resource> listResources(String directory, String[] extensions, boolean recursive, String encoding) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        try {
            File fileDir = new File(this.servletContext.getRealPath(directory));
            Collection files = FileUtils.listFiles((File)fileDir, (String[])extensions, (boolean)recursive);
            if (files != null && !files.isEmpty()) {
                for (File f : files) {
                    list.add(new Resource(f.getAbsolutePath(), f.getName(), new FileInputStream(f)));
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("file not found [" + directory + "]", (Throwable)e);
        }
        return list;
    }
}

