/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.schema.json;

import code.ponfee.commons.collect.Collects;
import code.ponfee.commons.collect.Maps;
import code.ponfee.commons.exception.Throwables;
import code.ponfee.commons.json.JsonUtils;
import code.ponfee.commons.json.Jsons;
import code.ponfee.commons.model.Null;
import code.ponfee.commons.schema.DataColumn;
import code.ponfee.commons.schema.DataStructure;
import code.ponfee.commons.schema.DataType;
import code.ponfee.commons.schema.PlainStructure;
import code.ponfee.commons.schema.TableStructure;
import code.ponfee.commons.schema.json.JsonId;
import code.ponfee.commons.schema.json.JsonTree;
import code.ponfee.commons.tree.NodePath;
import code.ponfee.commons.tree.PlainNode;
import code.ponfee.commons.tree.TreeNode;
import code.ponfee.commons.tree.TreeNodeBuilder;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class JsonExtractUtils {
    static final String ARRAY_EMPTY = "[--]";
    static final String ARRAY_ARRAY = "[[]]";
    static final String ARRAY_OBJECT = "[{}]";
    static final String ARRAY_BASIC = "[()]";
    static final String ARRAY_INDEX = "[%02d]";
    static final Map<String, Object> NULL_VALUE_MAPPING = Collections.unmodifiableMap(Maps.toMap("[--]", null, "[[]]", Collections.singletonList(Collections.emptyList()), "[{}]", Collections.singletonList(Collections.emptyMap()), "[()]", Collections.emptyList()));
    private static final String ROOT = "Root";

    public static TreeNode<JsonId, Null> extractSchema(String text) throws ParseException {
        return JsonExtractUtils.extractSchema(JSON.parse((String)text));
    }

    public static TreeNode<JsonId, Null> extractSchema(Object obj) throws ParseException {
        if (!JsonUtils.isComplexType(obj)) {
            throw new ParseException("The basic type data cannot extract schema: " + obj, 0);
        }
        LinkedList<JsonId> ids = new LinkedList<JsonId>();
        JsonExtractUtils.extractSchema(ids, null, obj, new AtomicInteger(1));
        return ids.isEmpty() ? null : JsonExtractUtils.buildTree(ids);
    }

    public static DataStructure extractData(String original, @Nonnull JsonTree tree) {
        Object obj;
        try {
            obj = JSON.parse((String)original);
        }
        catch (Exception ignored) {
            Throwables.ignore(ignored);
            return new PlainStructure(original);
        }
        if (!JsonUtils.isComplexType(obj)) {
            return new PlainStructure(original);
        }
        return JsonExtractUtils.extractData(obj, tree);
    }

    public static TableStructure extractData(@Nonnull Object object, @Nonnull JsonTree tree) {
        LinkedList<List<Object>> dataset = new LinkedList<List<Object>>();
        LinkedHashSet<NodePath<String>> extracted = new LinkedHashSet<NodePath<String>>();
        Map<NodePath<String>, JsonTree> config = tree.toFlatMap();
        JsonExtractUtils.extractData(dataset, tree.getPath(), object, config, extracted);
        Set duplicate = extracted.stream().map(Collects::getLast).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        DataColumn[] columns = new DataColumn[extracted.size()];
        int i = 0;
        for (NodePath nodePath : extracted) {
            JsonTree node = config.get(nodePath);
            String name = node.getName();
            if (duplicate.contains(name)) {
                name = name + "-" + String.format("%02d", node.getOrders());
            }
            columns[i++] = new DataColumn(name, node.getType(), null);
        }
        return new TableStructure(columns, dataset.stream().map(List::toArray).collect(Collectors.toList()));
    }

    private static void extractSchema(List<JsonId> ids, JsonId parent, Object object, AtomicInteger count) {
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                DataType dataType = JsonExtractUtils.detectDataType(entry.getValue());
                JsonId id = new JsonId(parent, (String)entry.getKey(), dataType, count.getAndIncrement());
                ids.add(id);
                if (dataType != null) continue;
                JsonExtractUtils.extractSchema(ids, id, entry.getValue(), count);
            }
        } else if (object instanceof List || object.getClass().isArray()) {
            List<Object> list = Collects.toList(object);
            switch (JsonExtractUtils.detectArrayType(list)) {
                case EMPTY: {
                    ids.add(new JsonId(parent, ARRAY_EMPTY, null, count.getAndIncrement()));
                    break;
                }
                case ARRAY: {
                    parent = new JsonId(parent, ARRAY_ARRAY, null, count.getAndIncrement());
                    ids.add(parent);
                    JsonExtractUtils.buildArrayColumns(JsonExtractUtils.findFirstArray(list), ids, parent, count);
                    break;
                }
                case OBJECT: {
                    parent = new JsonId(parent, ARRAY_OBJECT, null, count.getAndIncrement());
                    ids.add(parent);
                    JsonExtractUtils.extractSchema(ids, parent, JsonExtractUtils.findFirstObject(list), count);
                    break;
                }
                case BASIC: {
                    parent = new JsonId(parent, ARRAY_BASIC, null, count.getAndIncrement());
                    ids.add(parent);
                    JsonExtractUtils.buildArrayColumns(list, ids, parent, count);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown data type: " + Jsons.toJson(list));
                }
            }
        }
    }

    private static TreeNode<JsonId, Null> buildTree(List<JsonId> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        TreeNode<JsonId, Null> root = TreeNodeBuilder.newBuilder(new JsonId(null, ROOT, null, 0)).build();
        try {
            root.mount(ids.stream().map(JsonExtractUtils::toNode).collect(Collectors.toList()));
            return root;
        }
        catch (Exception e) {
            throw new IllegalStateException("Parsed json schema occur error: " + e.getMessage(), e);
        }
    }

    private static PlainNode<JsonId, Null> toNode(JsonId id) {
        return new PlainNode<JsonId, Object>(id, (JsonId)id.getParent(), null);
    }

    /*
     * WARNING - void declaration
     */
    private static void extractData(List<List<Object>> dataset, NodePath<String> parent, Object object, Map<NodePath<String>, JsonTree> config, LinkedHashSet<NodePath<String>> extracted) {
        JsonTree tree = config.get(parent);
        if (CollectionUtils.isEmpty(tree.getChildren())) {
            throw new IllegalStateException("Parent \"" + parent + "\" have not children.");
        }
        if (!tree.isChecked()) {
            return;
        }
        if (object == null) {
            if (tree.getChildren().size() == 1) {
                String childName = tree.getChildren().get(0).getName();
                object = NULL_VALUE_MAPPING.getOrDefault(childName, Collections.emptyMap());
            } else {
                object = Collections.emptyMap();
            }
        }
        if (object instanceof Map) {
            Map map = object;
            LinkedList<JsonTree> checkedNodes = new LinkedList<JsonTree>();
            for (String string : map.keySet()) {
                JsonTree node = config.get(new NodePath<String>(parent, string));
                if (node == null || !node.isChecked()) continue;
                checkedNodes.add(node);
            }
            checkedNodes.sort(Comparator.comparing(JsonTree::getOrders));
            LinkedList<List<Object>> subset = new LinkedList<List<Object>>();
            for (JsonTree node : checkedNodes) {
                Object v = map.get(node.getName());
                if (node.getType() != null) {
                    extracted.add(node.getPath());
                    JsonExtractUtils.concat(subset, JsonExtractUtils.getValue(v, node.getType()));
                    continue;
                }
                LinkedList<List<Object>> dataset0 = new LinkedList<List<Object>>();
                JsonExtractUtils.extractData(dataset0, node.getPath(), v, config, extracted);
                JsonExtractUtils.concat(subset, dataset0);
            }
            JsonExtractUtils.append(dataset, subset);
        } else if (object instanceof List || object.getClass().isArray()) {
            List<Object> list = Collects.toList(object);
            switch (JsonExtractUtils.detectArrayType(list)) {
                case EMPTY: {
                    break;
                }
                case ARRAY: {
                    JsonTree node = config.get(new NodePath<String>(parent, ARRAY_ARRAY));
                    if (node == null || !node.isChecked()) break;
                    List<Pair<Integer, JsonTree>> checkedNodes = JsonExtractUtils.getCheckedChildren(node, config, extracted);
                    LinkedList<List<Object>> linkedList = new LinkedList<List<Object>>();
                    for (List list2 : list) {
                        LinkedList<Object> row = new LinkedList<Object>();
                        int size = list2.size();
                        for (Pair<Integer, JsonTree> pair : checkedNodes) {
                            int idx = (Integer)pair.getLeft();
                            row.add(idx >= size ? null : JsonExtractUtils.getValue(list2.get(idx), ((JsonTree)pair.getRight()).getType()));
                        }
                        linkedList.add(row);
                    }
                    JsonExtractUtils.concat(dataset, linkedList);
                    break;
                }
                case OBJECT: {
                    JsonTree node = config.get(new NodePath<String>(parent, ARRAY_OBJECT));
                    if (node == null || !node.isChecked()) break;
                    for (Map map : list) {
                        void var9_18;
                        if (map == null) {
                            Map map2 = Collections.emptyMap();
                        }
                        JsonExtractUtils.extractData(dataset, node.getPath(), var9_18, config, extracted);
                    }
                    break;
                }
                case BASIC: {
                    JsonTree node = config.get(new NodePath<String>(parent, ARRAY_BASIC));
                    if (node == null || !node.isChecked()) break;
                    List<Pair<Integer, JsonTree>> checkedNodes = JsonExtractUtils.getCheckedChildren(node, config, extracted);
                    int n = list.size();
                    LinkedList<Object> row = new LinkedList<Object>();
                    for (Pair<Integer, JsonTree> pair : checkedNodes) {
                        int idx = (Integer)pair.getLeft();
                        row.add(idx >= n ? null : JsonExtractUtils.getValue(list.get(idx), ((JsonTree)pair.getRight()).getType()));
                    }
                    JsonExtractUtils.concat(dataset, Collections.singletonList(row));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown data type: " + Jsons.toJson(list));
                }
            }
        }
    }

    private static ArrayType detectArrayType(List<?> list) {
        if (list.isEmpty()) {
            return ArrayType.EMPTY;
        }
        for (Object obj : list) {
            if (obj == null) continue;
            if (obj instanceof Map) {
                return ArrayType.OBJECT;
            }
            if (obj instanceof List) {
                return ArrayType.ARRAY;
            }
            return ArrayType.BASIC;
        }
        return ArrayType.BASIC;
    }

    private static Map<String, Object> findFirstObject(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            if (map == null) continue;
            return map;
        }
        throw new RuntimeException("Empty [OBJECT]");
    }

    private static List<Object> findFirstArray(List<List<Object>> list) {
        for (List<Object> array : list) {
            if (array == null) continue;
            return array;
        }
        throw new RuntimeException("Empty [ARRAY]");
    }

    private static DataType detectDataType(Object value, DataType defaultType) {
        DataType dataType = JsonExtractUtils.detectDataType(value);
        return dataType == null ? defaultType : dataType;
    }

    private static DataType detectDataType(Object value) {
        if (value == null || value instanceof CharSequence) {
            return DataType.STRING;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            return DataType.INTEGER;
        }
        if (value instanceof BigDecimal || value instanceof Float || value instanceof Double) {
            return DataType.DECIMAL;
        }
        return JsonUtils.isComplexType(value) ? null : DataType.STRING;
    }

    private static Object getValue(Object value, DataType dataType) {
        return dataType == DataType.STRING ? Objects.toString(value, null) : value;
    }

    private static void buildArrayColumns(List<?> list, List<JsonId> ids, JsonId parent, AtomicInteger count) {
        for (Object element : list) {
            int index = count.getAndIncrement();
            DataType dataType = JsonExtractUtils.detectDataType(element, DataType.STRING);
            ids.add(new JsonId(parent, String.format(ARRAY_INDEX, index), dataType, index));
        }
    }

    private static List<Pair<Integer, JsonTree>> getCheckedChildren(JsonTree node, Map<NodePath<String>, JsonTree> config, LinkedHashSet<NodePath<String>> columns) {
        int startIndex = node.getOrders() + 1;
        LinkedList<Pair<Integer, JsonTree>> checkedNodes = new LinkedList<Pair<Integer, JsonTree>>();
        int n = node.getChildren().size();
        for (int i = 0; i < n; ++i) {
            String name = String.format(ARRAY_INDEX, startIndex + i);
            JsonTree child = config.get(new NodePath<String>(node.getPath(), name));
            if (child == null || !child.isChecked()) continue;
            checkedNodes.add((Pair<Integer, JsonTree>)Pair.of((Object)i, (Object)child));
            columns.add(child.getPath());
        }
        if (checkedNodes.isEmpty()) {
            throw new IllegalStateException("Parent is checked but not checked children: " + node.getPath().toString());
        }
        return checkedNodes;
    }

    public static void append(List<List<Object>> dataset, List<List<Object>> subset) {
        if (subset.isEmpty()) {
            return;
        }
        if (dataset.isEmpty()) {
            for (List<Object> row : subset) {
                dataset.add(new LinkedList<Object>(row));
            }
            return;
        }
        int maxCol = Math.max(dataset.get(0).size(), subset.get(0).size());
        JsonExtractUtils.completeCol(dataset, maxCol);
        JsonExtractUtils.completeCol(subset, maxCol);
        dataset.addAll(subset);
    }

    private static void completeCol(List<List<Object>> listArray, int maxCol) {
        if (listArray.isEmpty() || listArray.get(0).size() >= maxCol) {
            return;
        }
        for (List<Object> array : listArray) {
            Object lastCol = array.get(array.size() - 1);
            for (int i = maxCol - array.size(); i > 0; --i) {
                array.add(lastCol);
            }
        }
    }

    public static void concat(List<List<Object>> dataset, Object value) {
        if (dataset.isEmpty()) {
            LinkedList<Object> row = new LinkedList<Object>();
            row.add(value);
            dataset.add(row);
        } else {
            for (List<Object> array : dataset) {
                array.add(value);
            }
        }
    }

    public static void concat(List<List<Object>> dataset, List<List<Object>> subset) {
        if (subset.isEmpty()) {
            return;
        }
        if (dataset.isEmpty()) {
            dataset.addAll(subset);
            return;
        }
        int maxRow = Math.max(dataset.size(), subset.size());
        JsonExtractUtils.completeRow(dataset, maxRow);
        JsonExtractUtils.completeRow(subset, maxRow);
        for (int i = 0; i < maxRow; ++i) {
            dataset.get(i).addAll((Collection<Object>)subset.get(i));
        }
    }

    private static void completeRow(List<List<Object>> listArray, int maxRow) {
        if (listArray.size() >= maxRow) {
            return;
        }
        List<Object> lastRow = listArray.get(listArray.size() - 1);
        for (int i = maxRow - listArray.size(); i > 0; --i) {
            listArray.add(new LinkedList<Object>(lastRow));
        }
    }

    private static enum ArrayType {
        EMPTY,
        OBJECT,
        ARRAY,
        BASIC;

    }
}

