/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.schema.json;

import code.ponfee.commons.schema.DataType;
import code.ponfee.commons.tree.NodeId;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JsonId
extends NodeId<JsonId> {
    private static final long serialVersionUID = -6344204521700761391L;
    private final String name;
    private final DataType type;
    private final int orders;

    public JsonId(JsonId parent, @Nonnull String name, DataType type, int orders) {
        super(parent);
        this.name = Objects.requireNonNull(name);
        this.type = type;
        this.orders = orders;
    }

    @Override
    protected boolean equals(JsonId another) {
        return this.name.equals(another.name);
    }

    @Override
    protected int compare(JsonId another) {
        int a = this.orders - another.orders;
        return a != 0 ? a : this.name.compareTo(another.name);
    }

    @Override
    protected int hash() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    @Override
    public JsonId clone() {
        return new JsonId(this.parent == null ? null : ((JsonId)this.parent).clone(), this.name, this.type, this.orders);
    }

    public String getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public int getOrders() {
        return this.orders;
    }
}

