/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.serial;

import code.ponfee.commons.collect.ByteArrayTrait;
import code.ponfee.commons.io.GzipProcessor;
import code.ponfee.commons.reflect.ClassUtils;
import code.ponfee.commons.serial.SerializationException;
import code.ponfee.commons.serial.Serializer;

public class ByteArrayTraitSerializer
extends Serializer {
    protected byte[] serialize0(Object obj, boolean compress) {
        if (!(obj instanceof ByteArrayTrait)) {
            throw new SerializationException("object must be ByteArrayTrait type, but it's " + ClassUtils.getClassName(obj.getClass()) + " type");
        }
        return this.serialize((ByteArrayTrait)obj, compress);
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        if (!ByteArrayTrait.class.isAssignableFrom(clazz)) {
            throw new SerializationException("clazz must be ByteArrayTrait.class, but it's " + ClassUtils.getClassName(clazz) + ".class");
        }
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        return ByteArrayTraitSerializer.ofBytes(bytes, clazz);
    }

    public static <T extends ByteArrayTrait> T ofBytes(byte[] bytes, Class<T> type) {
        return (T)((ByteArrayTrait)ClassUtils.newInstance(type, new Class[]{byte[].class}, new Object[]{bytes}));
    }

    public byte[] serialize(ByteArrayTrait trait, boolean compress) {
        if (trait == null) {
            return null;
        }
        byte[] bytes = trait.toByteArray();
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }
}

