/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.serial;

import code.ponfee.commons.io.Closeables;
import code.ponfee.commons.io.ExtendedGZIPOutputStream;
import code.ponfee.commons.serial.SerializationException;
import code.ponfee.commons.serial.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.ClassUtils;

public class JdkSerializer
extends Serializer {
    protected byte[] serialize0(Object obj, boolean compress) {
        byte[] byArray;
        ExtendedGZIPOutputStream gzout = null;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            if (compress) {
                gzout = new ExtendedGZIPOutputStream(baos);
                oos = new ObjectOutputStream(gzout);
            } else {
                oos = new ObjectOutputStream(baos);
            }
            oos.writeObject(obj);
            oos.close();
            oos = null;
            if (gzout != null) {
                gzout.close();
                gzout = null;
            }
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new SerializationException(e);
            }
            catch (Throwable throwable) {
                Closeables.log(oos, "close ObjectOutputStream exception");
                Closeables.log(gzout, "close GZIPOutputStream exception");
                throw throwable;
            }
        }
        Closeables.log(oos, "close ObjectOutputStream exception");
        Closeables.log(gzout, "close GZIPOutputStream exception");
        return byArray;
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        Object object;
        GZIPInputStream gzin = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            if (compress) {
                gzin = new GZIPInputStream(bais);
                ois = new ObjectInputStream(gzin);
            } else {
                ois = new ObjectInputStream(bais);
            }
            Object t = ois.readObject();
            if (t != null && !ClassUtils.isAssignable(t.getClass(), clazz)) {
                throw new ClassCastException(ClassUtils.getName(t.getClass()) + " can't be cast to " + ClassUtils.getName(clazz));
            }
            object = t;
        }
        catch (IOException | ClassNotFoundException e) {
            try {
                throw new SerializationException(e);
            }
            catch (Throwable throwable) {
                Closeables.log(ois, "close ObjectInputStream exception");
                Closeables.log(gzin, "close GZIPInputStream exception");
                throw throwable;
            }
        }
        Closeables.log(ois, "close ObjectInputStream exception");
        Closeables.log(gzin, "close GZIPInputStream exception");
        return (T)object;
    }
}

