/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.serial;

import code.ponfee.commons.io.Closeables;
import code.ponfee.commons.io.ExtendedGZIPOutputStream;
import code.ponfee.commons.serial.SerializationException;
import code.ponfee.commons.serial.Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class JsonSerializer
extends Serializer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    protected byte[] serialize0(Object obj, boolean compress) {
        ExtendedGZIPOutputStream gzout = null;
        try {
            byte[] data = MAPPER.writeValueAsBytes(obj);
            if (compress) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                gzout = new ExtendedGZIPOutputStream(baos);
                gzout.write(data, 0, data.length);
                gzout.close();
                gzout = null;
                data = baos.toByteArray();
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            Closeables.log(gzout, "close GZIPOutputStream exception");
        }
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        Object object;
        GZIPInputStream gzin = null;
        try {
            if (compress) {
                gzin = new GZIPInputStream(new ByteArrayInputStream(bytes));
                bytes = IOUtils.toByteArray((InputStream)gzin);
            }
            object = MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            try {
                throw new SerializationException(e);
            }
            catch (Throwable throwable) {
                Closeables.log(gzin, "close GZIPInputStream exception");
                throw throwable;
            }
        }
        Closeables.log(gzin, "close GZIPInputStream exception");
        return (T)object;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

