/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.serial;

import code.ponfee.commons.io.GzipProcessor;
import code.ponfee.commons.serial.Serializer;
import code.ponfee.commons.util.ObjectUtils;
import code.ponfee.commons.util.SynchronizedCaches;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.HashMap;
import java.util.Map;

public class ProtostuffSerializer
extends Serializer {
    private static final Map<Class<?>, Schema<?>> SCHEMA_CACHE = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> byte[] serialize0(T obj, boolean compress) {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            byte[] bytes = ProtostuffIOUtil.toByteArray(obj, ProtostuffSerializer.getSchema(obj.getClass()), (LinkedBuffer)buffer);
            byte[] byArray = compress ? GzipProcessor.compress(bytes) : bytes;
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> type, boolean compress) {
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        T message = ObjectUtils.newInstance(type);
        ProtostuffIOUtil.mergeFrom((byte[])bytes, message, ProtostuffSerializer.getSchema(type));
        return message;
    }

    private static <T> Schema<T> getSchema(Class<T> type) {
        return SynchronizedCaches.get(type, SCHEMA_CACHE, RuntimeSchema::createFrom);
    }
}

