/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.serial;

import code.ponfee.commons.io.GzipProcessor;
import code.ponfee.commons.reflect.ClassUtils;
import code.ponfee.commons.serial.Serializer;
import code.ponfee.commons.util.ObjectUtils;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ToStringSerializer
extends Serializer {
    private final Charset charset;

    public ToStringSerializer() {
        this(StandardCharsets.UTF_8);
    }

    public ToStringSerializer(@Nonnull Charset charset) {
        this.charset = Objects.requireNonNull(charset);
    }

    protected byte[] serialize0(Object obj, boolean compress) {
        byte[] bytes = obj.toString().getBytes(this.charset);
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> type, boolean compress) {
        Constructor<T> constructor;
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        if ((constructor = ClassUtils.getConstructor(type, byte[].class)) != null) {
            try {
                return constructor.newInstance(new Object[]{bytes});
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return ObjectUtils.cast(new String(bytes, this.charset), type);
    }
}

