/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.tree;

import code.ponfee.commons.util.Strings;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;

public abstract class BaseNode<T extends Serializable & Comparable<? super T>, A extends Serializable>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4116799955526185765L;
    protected final T nid;
    protected final T pid;
    protected final boolean enabled;
    protected final boolean available;
    protected final A attach;
    protected int level;
    protected List<T> path;
    protected int degree;
    protected int leftLeafCount;
    protected int treeDepth;
    protected int treeNodeCount;
    protected int treeMaxDegree;
    protected int treeLeafCount;
    protected int childrenCount;
    protected int siblingOrder;

    public BaseNode(T nid, T pid, A attach) {
        this(nid, pid, true, attach);
    }

    public BaseNode(T nid, T pid, boolean enabled, A attach) {
        this(nid, pid, enabled, enabled, attach);
    }

    public BaseNode(T nid, T pid, boolean enabled, boolean available, A attach) {
        Preconditions.checkArgument((!Strings.isBlank(nid) ? 1 : 0) != 0, (Object)"Node id cannot be empty.");
        this.nid = nid;
        this.pid = pid;
        this.enabled = enabled;
        this.available = available;
        this.attach = attach;
    }

    public BaseNode<T, A> clone() {
        return (BaseNode)SerializationUtils.clone((Serializable)this);
    }

    public T getNid() {
        return this.nid;
    }

    public T getPid() {
        return this.pid;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public A getAttach() {
        return this.attach;
    }

    public int getLevel() {
        return this.level;
    }

    public List<T> getPath() {
        return this.path;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getLeftLeafCount() {
        return this.leftLeafCount;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public int getTreeNodeCount() {
        return this.treeNodeCount;
    }

    public int getTreeMaxDegree() {
        return this.treeMaxDegree;
    }

    public int getTreeLeafCount() {
        return this.treeLeafCount;
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public int getSiblingOrder() {
        return this.siblingOrder;
    }
}

