/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.tree;

import code.ponfee.commons.collect.Collects;
import code.ponfee.commons.reflect.Fields;
import code.ponfee.commons.tree.BaseNode;
import code.ponfee.commons.tree.FlatNode;
import code.ponfee.commons.tree.TreeTrait;
import code.ponfee.commons.tree.print.MultiwayTreePrinter;
import code.ponfee.commons.util.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;

public final class TreeNode<T extends Serializable & Comparable<? super T>, A extends Serializable>
extends BaseNode<T, A> {
    private static final long serialVersionUID = -9081626363752680404L;
    public static final String DEFAULT_ROOT_ID = "__ROOT__";
    private final Comparator<? super TreeNode<T, A>> siblingNodeSort;
    private final LinkedList<TreeNode<T, A>> children = new LinkedList();
    private final boolean buildPath;

    TreeNode(T nid, T pid, boolean enabled, boolean available, A attach, @Nonnull Comparator<? super TreeNode<T, A>> siblingNodeSort, boolean buildPath, boolean doMount) {
        super(nid, pid, enabled, available, attach);
        this.siblingNodeSort = Objects.requireNonNull(siblingNodeSort);
        this.buildPath = buildPath;
        if (doMount) {
            this.mount(null);
        }
    }

    public static <T extends Serializable & Comparable<? super T>, A extends Serializable> TreeNode<T, A> of(BaseNode<T, A> node) {
        return TreeNode.of(node, Comparator.comparing(BaseNode::getNid));
    }

    public static <T extends Serializable & Comparable<? super T>, A extends Serializable> TreeNode<T, A> of(BaseNode<T, A> node, Comparator<? super TreeNode<T, A>> siblingNodeSort) {
        return TreeNode.of(node, siblingNodeSort, true);
    }

    public static <T extends Serializable & Comparable<? super T>, A extends Serializable> TreeNode<T, A> of(BaseNode<T, A> node, Comparator<? super TreeNode<T, A>> siblingNodeSort, boolean buildPath) {
        return new TreeNode(node.nid, node.pid, node.enabled, node.available, node.attach, siblingNodeSort, buildPath, true);
    }

    public <E extends BaseNode<T, A>> TreeNode<T, A> mount(List<E> nodes) {
        this.mount(nodes, false);
        return this;
    }

    public <E extends BaseNode<T, A>> TreeNode<T, A> mount(List<E> list, boolean ignoreOrphan) {
        if (list == null) {
            list = Collections.emptyList();
        }
        List<BaseNode<BaseNode, A>> nodes = this.prepare(list);
        LinkedList checkDuplicateList = Collects.newLinkedList(this.nid);
        nodes.forEach((? super T n) -> checkDuplicateList.add(n.nid));
        List duplicated = Collects.duplicate(checkDuplicateList);
        if (CollectionUtils.isNotEmpty(duplicated)) {
            throw new RuntimeException("Duplicated nodes: " + duplicated);
        }
        this.level = 1;
        this.path = null;
        this.leftLeafCount = 0;
        this.siblingOrder = 1;
        this.mount0(null, nodes, ignoreOrphan, this.nid);
        if (!ignoreOrphan && CollectionUtils.isNotEmpty(nodes)) {
            String nids = nodes.stream().map(e -> String.valueOf(e.getNid())).collect(Collectors.joining(","));
            throw new RuntimeException("Invalid orphan nodes: [" + nids + "]");
        }
        this.count();
        return this;
    }

    public List<FlatNode<T, A>> flatDFS() {
        LinkedList collect = Lists.newLinkedList();
        LinkedList<TreeNode> stack = Collects.newLinkedList(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            collect.add(new FlatNode(node));
            if (!node.hasChildren()) continue;
            Iterator<TreeNode<T, A>> iter = node.children.descendingIterator();
            while (iter.hasNext()) {
                stack.push(iter.next());
            }
        }
        return collect;
    }

    public List<FlatNode<T, A>> flatCFS() {
        LinkedList collect = Collects.newLinkedList(new FlatNode(this));
        LinkedList<TreeNode> stack = Collects.newLinkedList(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            if (!node.hasChildren()) continue;
            node.forEachChild(child -> collect.add(new FlatNode(child)));
            Iterator<TreeNode<T, A>> iter = node.children.descendingIterator();
            while (iter.hasNext()) {
                stack.push(iter.next());
            }
        }
        return collect;
    }

    public List<FlatNode<T, A>> flatBFS() {
        LinkedList<FlatNode<T, A>> collect = new LinkedList<FlatNode<T, A>>();
        LinkedList<TreeNode> queue = Collects.newLinkedList(this);
        while (!queue.isEmpty()) {
            for (int i = queue.size(); i > 0; --i) {
                TreeNode node = (TreeNode)queue.poll();
                collect.add(new FlatNode(node));
                node.forEachChild(queue::offer);
            }
        }
        return collect;
    }

    public void forEach(Consumer<TreeNode<T, A>> action) {
        LinkedList<TreeNode> stack = Collects.newLinkedList(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            action.accept(node);
            node.forEachChild(stack::push);
        }
    }

    public <E extends TreeTrait<T, A, E>> E convert(Function<TreeNode<T, A>, E> convert) {
        return this.convert(convert, true);
    }

    public <E extends TreeTrait<T, A, E>> E convert(Function<TreeNode<T, A>, E> convert, boolean containsUnavailable) {
        if (!this.available && !containsUnavailable) {
            return null;
        }
        TreeTrait root = (TreeTrait)convert.apply(this);
        this.convert(convert, root, containsUnavailable);
        return (E)root;
    }

    public LinkedList<TreeNode<T, A>> getChildren() {
        return this.children;
    }

    public String print(Function<TreeNode<T, A>, CharSequence> nodeLabel) throws IOException {
        StringBuilder builder = new StringBuilder();
        new MultiwayTreePrinter<TreeNode>(builder, nodeLabel, TreeNode::getChildren).print(this);
        return builder.toString();
    }

    public String toString() {
        try {
            return this.print(e -> String.valueOf(e.getNid()));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    private void forEachChild(Consumer<TreeNode<T, A>> action) {
        if (this.hasChildren()) {
            this.children.forEach(action);
        }
    }

    private <E extends BaseNode<T, A>> List<BaseNode<T, A>> prepare(List<E> nodes) {
        LinkedList list = Lists.newLinkedList();
        for (BaseNode node : nodes) {
            if (node instanceof TreeNode) {
                ((TreeNode)node).forEach(list::add);
                continue;
            }
            list.add(node);
        }
        if (this.hasChildren()) {
            this.forEachChild(child -> child.forEach(list::add));
            this.children.clear();
        }
        return list;
    }

    private <E extends BaseNode<T, A>> void mount0(List<T> parentPath, List<E> nodes, boolean ignoreOrphan, T mountPidIfNull) {
        this.path = this.buildPath(parentPath, this.nid);
        Iterator<E> iter = nodes.iterator();
        while (iter.hasNext()) {
            BaseNode node = (BaseNode)iter.next();
            if (!ignoreOrphan && Strings.isBlank(node.pid)) {
                Fields.put((Object)node, "pid", mountPidIfNull);
            }
            if (!this.nid.equals(node.pid)) continue;
            TreeNode child2 = new TreeNode(node.nid, node.pid, node.enabled, this.available && node.enabled, node.attach, this.siblingNodeSort, this.buildPath, false);
            child2.level = this.level + 1;
            this.children.add(child2);
            iter.remove();
        }
        if (this.hasChildren()) {
            this.children.sort(this.siblingNodeSort);
            this.forEachChild(child -> child.mount0(this.path, nodes, ignoreOrphan, mountPidIfNull));
        }
        this.degree = this.children == null ? 0 : this.children.size();
    }

    private void count() {
        if (CollectionUtils.isEmpty(this.children)) {
            this.treeDepth = 1;
            this.treeMaxDegree = 0;
            this.treeLeafCount = 1;
            this.treeNodeCount = 1;
            this.childrenCount = 0;
            return;
        }
        int maxChildTreeDepth = 0;
        int maxChildTreeMaxDegree = 0;
        int sumChildrenTreeLeafCount = 0;
        int sumChildrenTreeNodeCount = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            TreeNode<T, A> child = this.children.get(i);
            child.siblingOrder = i + 1;
            if (i == 0) {
                child.leftLeafCount = this.leftLeafCount;
            } else {
                TreeNode<T, A> prevSibling = this.children.get(i - 1);
                child.leftLeafCount = prevSibling.leftLeafCount + prevSibling.treeLeafCount;
            }
            super.count();
            maxChildTreeDepth = Math.max(maxChildTreeDepth, child.treeDepth);
            maxChildTreeMaxDegree = Math.max(maxChildTreeMaxDegree, child.degree);
            sumChildrenTreeLeafCount += child.treeLeafCount;
            sumChildrenTreeNodeCount += child.treeNodeCount;
        }
        this.treeDepth = maxChildTreeDepth + 1;
        this.treeMaxDegree = Math.max(maxChildTreeMaxDegree, this.degree);
        this.treeLeafCount = sumChildrenTreeLeafCount;
        this.treeNodeCount = sumChildrenTreeNodeCount + 1;
        this.childrenCount = this.children.size();
    }

    private List<T> buildPath(List<T> parentPath, T nid) {
        if (!this.buildPath) {
            return null;
        }
        int size = parentPath == null ? 1 : parentPath.size() + 1;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        if (parentPath != null) {
            builder.addAll(parentPath);
        }
        return builder.add(nid).build();
    }

    private <E extends TreeTrait<T, A, E>> void convert(Function<TreeNode<T, A>, E> convert, E parent, boolean containsUnavailable) {
        if (CollectionUtils.isEmpty(this.children)) {
            parent.setChildren(null);
            return;
        }
        LinkedList<TreeTrait> list = new LinkedList<TreeTrait>();
        for (TreeNode treeNode : this.children) {
            if (!treeNode.available && !containsUnavailable) continue;
            TreeTrait node = (TreeTrait)convert.apply(treeNode);
            treeNode.convert(convert, node, containsUnavailable);
            list.add(node);
        }
        parent.setChildren(list);
    }
}

