/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.util.Enums;
import java.util.Currency;
import java.util.Map;

public enum CurrencyEnum {
    CNY(new char[]{'\u00a5'}),
    USD(new char[]{'U', 'S', '$'}),
    HKD(new char[]{'H', 'K', '$'}),
    TWD(new char[]{'N', 'T', '$'}),
    EUR(new char[]{'\u20ac'}),
    GBP(new char[]{'\u00a3'}),
    JPY(new char[]{'\u00a5'}),
    BRL(new char[]{'R', '$'}),
    RUB(new char[]{'\u20bd'}),
    AUD(new char[]{'A', 'U', '$'}),
    CAD(new char[]{'C', 'A', '$'}),
    INR(new char[]{'\u20b9'}),
    UAH(new char[]{'\u20b4'}),
    MXN(new char[]{'M', 'X', '$'}),
    CHF(new char[]{'C', 'H', 'F'}),
    SGD(new char[]{'S', 'G', '$'}),
    PLN(new char[]{'z', '\u0142'}),
    SEK(new char[]{'k', 'r'}),
    CLP(new char[]{'C', 'L', '$'}),
    KRW(new char[]{'\u20a9'}),
    KES(new char[]{'K', 'S', 'h'}),
    MOP(new char[]{'M', 'O', 'P'}),
    IDR(new char[]{'R', 'p'}),
    SAR(new char[]{'\ufdfc'}),
    BGN(new char[]{'\u043b', '\u0432'}),
    RON(new char[]{'l', 'e', 'i'}),
    CZK(new char[]{'K', '\u010d'}),
    HUF(new char[]{'F', 't'}),
    VND(new char[]{'\u20ab'}),
    MYR(new char[]{'R', 'M'}),
    PHP(new char[]{'\u20b1'}),
    THB(new char[]{'\u0e3f'}),
    PKR(new char[]{'\u20a8'}),
    NOK(new char[]{'k', 'r'}),
    DKK(new char[]{'k', 'r'}),
    AED(new char[]{'A', 'E', 'D'}),
    AFN(new char[]{'\u060b'}),
    ALL(new char[]{'L', 'e', 'k'}),
    AMD(new char[]{'A', 'M', 'D'}),
    ANG(new char[]{'\u0192'}),
    AOA(new char[]{'A', 'O', 'A'}),
    ARS(new char[]{'$'}),
    AWG(new char[]{'\u0192'}),
    AZN(new char[]{'\u20bc'}),
    BAM(new char[]{'K', 'M'}),
    BBD(new char[]{'$'}),
    BDT(new char[]{'B', 'D', 'T'}),
    BHD(new char[]{'B', 'H', 'D'}),
    BIF(new char[]{'B', 'I', 'F'}),
    BMD(new char[]{'$'}),
    BND(new char[]{'$'}),
    BOB(new char[]{'$', 'b'}),
    BSD(new char[]{'$'}),
    BTN(new char[]{'B', 'T', 'N'}),
    BWP(new char[]{'P'}),
    BYR(new char[]{'p', '.'}),
    BZD(new char[]{'B', 'Z', '$'}),
    CDF(new char[]{'C', 'D', 'F'}),
    COP(new char[]{'$'}),
    CRC(new char[]{'\u20a1'}),
    CUC(new char[]{'C', 'U', 'C'}),
    CUP(new char[]{'\u20b1'}),
    CVE(new char[]{'C', 'V', 'E'}),
    DJF(new char[]{'D', 'J', 'F'}),
    DOP(new char[]{'R', 'D', '$'}),
    DZD(new char[]{'D', 'Z', 'D'}),
    EGP(new char[]{'\u00a3'}),
    ERN(new char[]{'E', 'R', 'N'}),
    ETB(new char[]{'E', 'T', 'B'}),
    FJD(new char[]{'$'}),
    FKP(new char[]{'\u00a3'}),
    GEL(new char[]{'G', 'E', 'L'}),
    GHS(new char[]{'\u00a2'}),
    GIP(new char[]{'\u00a3'}),
    GMD(new char[]{'G', 'M', 'D'}),
    GNF(new char[]{'G', 'N', 'F'}),
    GTQ(new char[]{'Q'}),
    GYD(new char[]{'$'}),
    HNL(new char[]{'L'}),
    HRK(new char[]{'k', 'n'}),
    HTG(new char[]{'H', 'T', 'G'}),
    ILS(new char[]{'\u20aa'}),
    IQD(new char[]{'I', 'Q', 'D'}),
    IRR(new char[]{'\ufdfc'}),
    ISK(new char[]{'k', 'r'}),
    JMD(new char[]{'J', '$'}),
    JOD(new char[]{'J', 'O', 'D'}),
    KGS(new char[]{'\u043b', '\u0432'}),
    KHR(new char[]{'\u17db'}),
    KMF(new char[]{'K', 'M', 'F'}),
    KPW(new char[]{'\u20a9'}),
    KWD(new char[]{'K', 'W', 'D'}),
    KYD(new char[]{'$'}),
    KZT(new char[]{'\u043b', '\u0432'}),
    LAK(new char[]{'\u20ad'}),
    LBP(new char[]{'\u00a3'}),
    LKR(new char[]{'\u20a8'}),
    LRD(new char[]{'$'}),
    LSL(new char[]{'L', 'S', 'L'}),
    LYD(new char[]{'L', 'Y', 'D'}),
    MAD(new char[]{'M', 'A', 'D'}),
    MDL(new char[]{'M', 'D', 'L'}),
    MGA(new char[]{'M', 'G', 'A'}),
    MKD(new char[]{'\u0434', '\u0435', '\u043d'}),
    MMK(new char[]{'M', 'M', 'K'}),
    MNT(new char[]{'\u20ae'}),
    MRO(new char[]{'M', 'R', 'O'}),
    MUR(new char[]{'\u20a8'}),
    MVR(new char[]{'M', 'V', 'R'}),
    MWK(new char[]{'M', 'W', 'K'}),
    MZN(new char[]{'M', 'T'}),
    NAD(new char[]{'$'}),
    NGN(new char[]{'\u20a6'}),
    NIO(new char[]{'C', '$'}),
    NPR(new char[]{'\u20a8'}),
    NZD(new char[]{'N', 'Z', '$'}),
    OMR(new char[]{'\ufdfc'}),
    PAB(new char[]{'B', '/', '.'}),
    PEN(new char[]{'S', '/', '.'}),
    PGK(new char[]{'P', 'G', 'K'}),
    PYG(new char[]{'G', 's'}),
    QAR(new char[]{'\ufdfc'}),
    RSD(new char[]{'\u0414', '\u0438', '\u043d', '.'}),
    RWF(new char[]{'R', 'W', 'F'}),
    SBD(new char[]{'$'}),
    SCR(new char[]{'\u20a8'}),
    SDG(new char[]{'S', 'D', 'G'}),
    SHP(new char[]{'\u00a3'}),
    SLL(new char[]{'S', 'L', 'L'}),
    SOS(new char[]{'S'}),
    SRD(new char[]{'$'}),
    STD(new char[]{'S', 'T', 'D'}),
    SYP(new char[]{'\u00a3'}),
    SZL(new char[]{'S', 'Z', 'L'}),
    TJS(new char[]{'T', 'J', 'S'}),
    TMT(new char[]{'T', 'M', 'T'}),
    TND(new char[]{'T', 'N', 'D'}),
    TOP(new char[]{'T', 'O', 'P'}),
    TRY(new char[]{'\u20ba'}),
    TTD(new char[]{'T', 'T', '$'}),
    TZS(new char[]{'T', 'Z', 'S'}),
    UGX(new char[]{'U', 'G', 'X'}),
    UYU(new char[]{'$', 'U'}),
    UZS(new char[]{'\u043b', '\u0432'}),
    VEF(new char[]{'B', 's'}),
    VUV(new char[]{'V', 'U', 'V'}),
    WST(new char[]{'W', 'S', 'T'}),
    XAF(new char[]{'X', 'A', 'F'}),
    XAG(new char[]{'X', 'A', 'G'}),
    XAU(new char[]{'X', 'A', 'U'}),
    XCD(new char[]{'$'}),
    XDR(new char[]{'X', 'D', 'R'}),
    XOF(new char[]{'X', 'O', 'F'}),
    XPD(new char[]{'X', 'P', 'D'}),
    XPF(new char[]{'X', 'P', 'F'}),
    XPT(new char[]{'X', 'P', 'T'}),
    YER(new char[]{'\ufdfc'}),
    ZAR(new char[]{'R'}),
    BYN(new char[]{'B', 'r'}),
    SVC(new char[]{'$'}),
    ZWD(new char[]{'Z', '$'}),
    ADP(new char[]{'A', 'D', 'P'}),
    ATS(new char[]{'A', 'T', 'S'}),
    AYM(new char[]{'A', 'Y', 'M'}),
    BEF(new char[]{'B', 'E', 'F'}),
    BGL(new char[]{'B', 'G', 'L'}),
    BOV(new char[]{'B', 'O', 'V'}),
    CHE(new char[]{'C', 'H', 'E'}),
    CHW(new char[]{'C', 'H', 'W'}),
    CLF(new char[]{'C', 'L', 'F'}),
    COU(new char[]{'C', 'O', 'U'}),
    CYP(new char[]{'C', 'Y', 'P'}),
    DEM(new char[]{'D', 'E', 'M'}),
    EEK(new char[]{'E', 'E', 'K'}),
    ESP(new char[]{'E', 'S', 'P'}),
    FIM(new char[]{'F', 'I', 'M'}),
    FRF(new char[]{'F', 'R', 'F'}),
    GHC(new char[]{'G', 'H', 'C'}),
    GRD(new char[]{'G', 'R', 'D'}),
    GWP(new char[]{'G', 'W', 'P'}),
    IEP(new char[]{'I', 'E', 'P'}),
    ITL(new char[]{'I', 'T', 'L'}),
    LTL(new char[]{'L', 'T', 'L'}),
    LUF(new char[]{'L', 'U', 'F'}),
    LVL(new char[]{'L', 'V', 'L'}),
    MGF(new char[]{'M', 'G', 'F'}),
    MRU(new char[]{'M', 'R', 'U'}),
    MTL(new char[]{'M', 'T', 'L'}),
    MXV(new char[]{'M', 'X', 'V'}),
    MZM(new char[]{'M', 'Z', 'M'}),
    NLG(new char[]{'N', 'L', 'G'}),
    PTE(new char[]{'P', 'T', 'E'}),
    SDD(new char[]{'S', 'D', 'D'}),
    SIT(new char[]{'S', 'I', 'T'}),
    SKK(new char[]{'S', 'K', 'K'}),
    SRG(new char[]{'S', 'R', 'G'}),
    SSP(new char[]{'S', 'S', 'P'}),
    STN(new char[]{'S', 'T', 'N'}),
    TMM(new char[]{'T', 'M', 'M'}),
    TPE(new char[]{'T', 'P', 'E'}),
    TRL(new char[]{'T', 'R', 'L'}),
    USN(new char[]{'U', 'S', 'N'}),
    USS(new char[]{'U', 'S', 'S'}),
    UYI(new char[]{'U', 'Y', 'I'}),
    VEB(new char[]{'V', 'E', 'B'}),
    VES(new char[]{'V', 'E', 'S'}),
    XBA(new char[]{'X', 'B', 'A'}),
    XBB(new char[]{'X', 'B', 'B'}),
    XBC(new char[]{'X', 'B', 'C'}),
    XBD(new char[]{'X', 'B', 'D'}),
    XFU(new char[]{'X', 'F', 'U'}),
    XSU(new char[]{'X', 'S', 'U'}),
    XTS(new char[]{'X', 'T', 'S'}),
    XUA(new char[]{'X', 'U', 'A'}),
    YUM(new char[]{'Y', 'U', 'M'}),
    ZMK(new char[]{'Z', 'M', 'K'}),
    XXX(new char[]{'X', 'X', 'X'});

    private static final Map<String, CurrencyEnum> CURRENCY_CODES;
    private static final Map<String, CurrencyEnum> NUMERIC_CODES;
    private final String currencyCode = super.name();
    private final String currencySymbol;
    private final String numericCode;
    private final Currency currency;

    private CurrencyEnum(char[] currencySymbol) {
        this.currencySymbol = new String(currencySymbol);
        this.currency = Currency.getInstance(this.currencyCode);
        this.numericCode = String.format("%03d", this.currency.getNumericCode());
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public String numericCode() {
        return this.numericCode;
    }

    public String currencySymbol() {
        return this.currencySymbol;
    }

    public Currency currency() {
        return this.currency;
    }

    public static CurrencyEnum ofCurrencyCode(String currencyCode) {
        return CURRENCY_CODES.get(currencyCode);
    }

    public static CurrencyEnum ofNumericCode(String numericCode) {
        return NUMERIC_CODES.get(numericCode);
    }

    public static CurrencyEnum ofCurrency(Currency currency) {
        return CURRENCY_CODES.get(currency.getCurrencyCode());
    }

    static {
        CURRENCY_CODES = Enums.toMap(CurrencyEnum.class, CurrencyEnum::currencyCode);
        NUMERIC_CODES = Enums.toMap(CurrencyEnum.class, CurrencyEnum::numericCode);
    }
}

