/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.io.Closeables;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static int[] getImageSize(InputStream input) {
        try {
            BufferedImage image = ImageIO.read(input);
            int[] nArray = new int[]{image.getWidth(), image.getHeight()};
            return nArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.console(input);
        }
    }

    public static byte[] mergeHorizontal(String format, InputStream ... imgs) {
        int width = 0;
        int height = 0;
        try {
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            for (InputStream img : imgs) {
                BufferedImage i = ImageIO.read(img);
                width += i.getWidth();
                height = Math.max(height, i.getHeight());
                list.add(i);
            }
            BufferedImage result = new BufferedImage(width, height, 1);
            width = 0;
            for (BufferedImage i : list) {
                int[] array = new int[i.getWidth() * i.getHeight()];
                array = i.getRGB(0, 0, i.getWidth(), i.getHeight(), array, 0, i.getWidth());
                result.setRGB(width, 0, i.getWidth(), i.getHeight(), array, 0, i.getWidth());
                width += i.getWidth();
                i.flush();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)result, format, out);
            out.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("\u56fe\u7247\u5408\u5e76\u5931\u8d25", e);
        }
    }

    public static byte[] mergeVertical(String format, InputStream ... imgs) {
        try {
            int width = 0;
            int height = 0;
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            for (InputStream img : imgs) {
                BufferedImage i = ImageIO.read(img);
                height += i.getHeight();
                width = Math.max(width, i.getWidth());
                list.add(i);
            }
            BufferedImage result = new BufferedImage(width, height, 1);
            height = 0;
            for (BufferedImage i : list) {
                int[] array = new int[i.getWidth() * i.getHeight()];
                array = i.getRGB(0, 0, i.getWidth(), i.getHeight(), array, 0, i.getWidth());
                result.setRGB(0, height, i.getWidth(), i.getHeight(), array, 0, i.getWidth());
                height += i.getHeight();
                i.flush();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)result, format, out);
            out.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("\u56fe\u7247\u5408\u5e76\u5931\u8d25", e);
        }
    }

    public static byte[] transparent(InputStream image, int refer, int normal) {
        try {
            ImageIcon icon = new ImageIcon(ImageIO.read(image));
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            Graphics2D g2D = (Graphics2D)img.getGraphics();
            g2D.drawImage(icon.getImage(), 0, 0, icon.getImageObserver());
            for (int i = img.getMinX(); i < img.getWidth(); ++i) {
                for (int j = img.getMinY(); j < img.getHeight(); ++j) {
                    int rgb = img.getRGB(i, j);
                    if (rgb == 0) continue;
                    int alpha = ImageUtils.compare(rgb, refer) ? 0 : normal;
                    rgb = alpha << 24 | rgb & 0xFFFFFF;
                    img.setRGB(i, j, rgb);
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", bos);
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getImageType(InputStream img) throws IOException {
        ArrayList<String> types = new ArrayList<String>();
        try (MemoryCacheImageInputStream m = new MemoryCacheImageInputStream(img);){
            Iterator<ImageReader> i = ImageIO.getImageReaders(m);
            while (i.hasNext()) {
                types.add(i.next().getFormatName());
            }
            String[] stringArray = types.isEmpty() ? null : types.toArray(new String[0]);
            return stringArray;
        }
    }

    private static boolean compare(int color, int colorRange) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        return r >= colorRange && g >= colorRange && b >= colorRange;
    }
}

