/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MessageFormats {
    private static final String PREFIX = "#\\{(\\s|\\t)*";
    private static final String SUFFIX = "(\\s|\\t)*\\}";
    private static final Pattern PATTERN = Pattern.compile("#\\{(\\s|\\t)*(\\w+)(\\s|\\t)*\\}");

    public static String format(String text, Map<String, Object> args) {
        ArrayList<String> arguments = new ArrayList<String>(args.size());
        int i = 0;
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            text = text.replaceAll(PREFIX + entry.getKey() + SUFFIX, "{" + i++ + "}");
            arguments.add(Objects.toString(entry.getValue(), ""));
        }
        return MessageFormat.format(text, arguments.toArray());
    }

    public static String format(String text, Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>(args.length << 1);
        Matcher matcher = PATTERN.matcher(text);
        int n = args.length;
        for (int i = 0; i < n && matcher.find(); ++i) {
            map.put(matcher.group(2), args[i]);
        }
        return MessageFormats.format(text, map);
    }

    public static String formatPair(String text, Object ... args) {
        return MessageFormats.format(text, Maps.toMap(args));
    }
}

