/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.util.Bytes;
import code.ponfee.commons.util.RegexUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Networks {
    private static final Logger LOG = LoggerFactory.getLogger(Networks.class);
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final String LOCALHOST_NAME = "localhost";
    private static final String EMPTY_IP = "0.0.0.0";
    public static final long MAX_IP_VALUE = 0xFFFFFFFFL;
    private static final long[] MASK = new long[]{-16777216L, 0xFF0000L, 65280L, 255L};
    public static final String HOST_IP = Networks.getHostIp();

    public static String getMacOrIp(InetAddress ia) {
        String mac;
        if (ia == null) {
            try {
                ia = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return StringUtils.isBlank((CharSequence)(mac = Networks.getMacAddress(ia))) ? Networks.getIpAddress(ia) : mac;
    }

    public static String getMacAddress(InetAddress ia) {
        byte[] mac;
        try {
            if (ia == null) {
                ia = InetAddress.getLocalHost();
            }
            mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        }
        catch (SocketException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (mac == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(17);
        for (int i = 0; i < mac.length; ++i) {
            if (i != 0) {
                sb.append("-");
            }
            sb.append(Bytes.toHex(mac[i], false));
        }
        return sb.toString();
    }

    public static String getHostIp() {
        InetAddress address = Networks.getHostAddress();
        return address == null ? LOCALHOST_IP : address.getHostAddress();
    }

    public static String getHostName() {
        InetAddress address = Networks.getHostAddress();
        return address == null ? LOCALHOST_NAME : address.getHostName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailablePort(int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            ss.bind(null);
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static int findAvailablePort(int startPort) {
        int port;
        if (startPort < 0 || startPort > 65535) {
            return -1;
        }
        for (port = startPort; port <= 65535; ++port) {
            if (!Networks.isAvailablePort(port)) continue;
            return port;
        }
        for (port = startPort - 1; port >= 0; --port) {
            if (!Networks.isAvailablePort(port)) continue;
            return port;
        }
        return -1;
    }

    public static long toLong(String ip) {
        if (!RegexUtils.isIpv4(ip)) {
            throw new IllegalArgumentException("invalid ip address[" + ip + "]");
        }
        String[] ipNums = ip.split("\\.", 4);
        return (Long.parseLong(ipNums[0]) << 24) + (Long.parseLong(ipNums[1]) << 16) + (Long.parseLong(ipNums[2]) << 8) + Long.parseLong(ipNums[3]);
    }

    public static String fromLong(long ip) {
        return new StringBuilder(15).append((ip & MASK[0]) >> 24).append('.').append((ip & MASK[1]) >> 16).append('.').append((ip & MASK[2]) >> 8).append('.').append(ip & MASK[3]).toString();
    }

    private static String getIpAddress(InetAddress ia) {
        return ia.getHostAddress();
    }

    private static InetAddress getHostAddress() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (Networks.isValidHostAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get local host address: {} ", (Object)e.getMessage());
        }
        try {
            Enumeration<NetworkInterface> inters = NetworkInterface.getNetworkInterfaces();
            if (inters == null) {
                return localAddress;
            }
            while (inters.hasMoreElements()) {
                try {
                    Enumeration<InetAddress> addresses = inters.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            InetAddress address = addresses.nextElement();
                            if (!Networks.isValidHostAddress(address)) continue;
                            return address;
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to get host address: {}", (Object)e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to get network address: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get network interface: {}", (Object)e.getMessage());
        }
        LOG.warn("Could not get host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }

    private static boolean isValidHostAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String ip = address.getHostAddress();
        return ip != null && !EMPTY_IP.equals(ip) && !LOCALHOST_IP.equals(ip) && RegexUtils.isIpv4(ip);
    }
}

