/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.reflect.Fields;
import code.ponfee.commons.util.ObjectUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

public final class SecureRandoms {
    private static final SecureRandom SECURE_RANDOM;

    public static byte[] nextBytes(int numOfByte) {
        byte[] bytes = new byte[numOfByte];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static int nextInt(int bound) {
        return SECURE_RANDOM.nextInt(bound);
    }

    public static int nextInt() {
        return SECURE_RANDOM.nextInt();
    }

    public static long nextLong() {
        return SECURE_RANDOM.nextLong();
    }

    public static float nextFloat() {
        return SECURE_RANDOM.nextFloat();
    }

    public static double nextDouble() {
        return SECURE_RANDOM.nextDouble();
    }

    public static boolean nextBoolean() {
        return SECURE_RANDOM.nextBoolean();
    }

    public static BigInteger random(int bitLen) {
        BigInteger rnd;
        while ((rnd = new BigInteger(bitLen, SECURE_RANDOM)).bitLength() != bitLen) {
        }
        return rnd;
    }

    public static BigInteger random(BigInteger mod) {
        return SecureRandoms.random(mod.bitLength() - 1);
    }

    public static byte[] generateSeed(int numBytes) {
        return SECURE_RANDOM.generateSeed(numBytes);
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(56);
        buffer.putLong(System.currentTimeMillis());
        buffer.putLong(System.nanoTime());
        buffer.putLong(Thread.currentThread().getId());
        buffer.putLong(Fields.addressOf(SecureRandoms.class));
        buffer.putLong(Fields.addressOf(buffer));
        buffer.put(ObjectUtils.uuid());
        buffer.flip();
        SECURE_RANDOM = new SecureRandom(new SecureRandom(buffer.array()).generateSeed(32));
    }
}

