/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.math.Maths;

public final class Snowflake {
    private static final int SIZE = 63;
    private static final long TWEPOCH = 1514736000000L;
    private final int datacenterId;
    private final int workerId;
    private final int workerIdShift;
    private final int datacenterIdShift;
    private final int timestampShift;
    private final long sequenceMask;
    private final long timestampMask;
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    public Snowflake(int workerId, int datacenterId, int sequenceBits, int workerIdBits, int datacenterIdBits) {
        long maxWorkerId = Maths.bitsMask(workerIdBits);
        if ((long)workerId > maxWorkerId || workerId < 0) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", maxWorkerId));
        }
        long maxDatacenterId = Maths.bitsMask(datacenterIdBits);
        if ((long)datacenterId > maxDatacenterId || datacenterId < 0) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", maxDatacenterId));
        }
        this.workerIdShift = sequenceBits;
        this.datacenterIdShift = sequenceBits + workerIdBits;
        this.timestampShift = sequenceBits + workerIdBits + datacenterIdBits;
        this.sequenceMask = Maths.bitsMask(sequenceBits);
        this.timestampMask = Maths.bitsMask(63 - this.timestampShift);
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public Snowflake(int workerId, int datacenterId) {
        this(workerId, datacenterId, 12, 5, 5);
    }

    public Snowflake(int workerId) {
        this(workerId, 0, 14, 5, 0);
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                this.lastTimestamp = timestamp = this.untilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
            this.lastTimestamp = timestamp;
        }
        return timestamp - 1514736000000L << this.timestampShift & this.timestampMask | (long)(this.datacenterId << this.datacenterIdShift) | (long)(this.workerId << this.workerIdShift) | this.sequence;
    }

    private long untilNextMillis(long lastTimestamp) {
        long timestamp;
        while ((timestamp = this.timeGen()) <= lastTimestamp) {
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

