/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.math.Numbers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Strings {
    public static final char BLANK_CHAR = ' ';
    private static final char[] REGEX_SPECIALS = new char[]{'\\', '$', '(', ')', '*', '+', '.', '[', ']', '?', '^', '{', '}', '|'};

    public static String join(Collection<?> coll) {
        return Strings.join(coll, ",", String::valueOf, "", "");
    }

    public static String join(Collection<?> coll, String delimiter) {
        return Strings.join(coll, delimiter, String::valueOf, "", "");
    }

    public static String[] hexadecimal(String text) {
        return (String[])IntStream.range(0, text.length()).mapToObj(i -> "0x" + Integer.toHexString(text.charAt(i))).toArray(String[]::new);
    }

    public static <T> String join(Collection<T> coll, String delimiter, Function<T, String> mapper, String open, String close) {
        if (coll == null) {
            return null;
        }
        if (coll.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(128);
        for (T o : coll) {
            builder.append(open).append(mapper.apply(o)).append(close).append(delimiter);
        }
        builder.setLength(builder.length() - delimiter.length());
        return builder.toString();
    }

    public static Map<String, String> fromArgs(String[] args) {
        if (args == null) {
            return null;
        }
        return Arrays.stream(args).filter(s -> s != null && s.contains("=")).map(s -> s.split("=", 2)).collect(Collectors.toMap(p -> p[0], p -> p[1], (v1, v2) -> v1));
    }

    public static String mask(String text, String regex, String replacement) {
        if (text == null) {
            return null;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String mask(String text, int start, int len) {
        return Strings.mask(text, start, len, '*');
    }

    public static String mask(String text, int start, int len, char maskChar) {
        int length;
        if (len < 1 || StringUtils.isEmpty((CharSequence)text) || (length = text.length()) < start) {
            return text;
        }
        if (start < 0) {
            start = 0;
        }
        if (length < start + len) {
            len = length - start;
        }
        int end = length - start - len;
        String regex = "(\\w{" + start + "})\\w{" + len + "}(\\w{" + end + "})";
        return Strings.mask(text, regex, "$1" + StringUtils.repeat((char)maskChar, (int)len) + "$2");
    }

    public static int count(String text, String str) {
        int count = 0;
        int len = str.length();
        int index = -len;
        while ((index = text.indexOf(str, index + len)) != -1) {
            ++count;
        }
        return count;
    }

    public static String[] slice(String str, int segment) {
        int[] array = Numbers.slice(str.length(), segment);
        String[] result = new String[array.length];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            result[i] = str.substring(j, j += array[i]);
        }
        return result;
    }

    public static boolean isMatch(String s, String p) {
        int idxs = 0;
        int idxp = 0;
        int idxstar = -1;
        int idxmatch = 0;
        while (idxs < s.length()) {
            if (idxp < p.length() && (s.charAt(idxs) == p.charAt(idxp) || p.charAt(idxp) == '?')) {
                ++idxp;
                ++idxs;
                continue;
            }
            if (idxp < p.length() && p.charAt(idxp) == '*') {
                idxstar = idxp++;
                idxmatch = idxs;
                continue;
            }
            if (idxstar != -1) {
                idxp = idxstar + 1;
                idxs = ++idxmatch;
                continue;
            }
            return false;
        }
        while (idxp < p.length() && p.charAt(idxp) == '*') {
            ++idxp;
        }
        return idxp == p.length();
    }

    public static String safePath(String path) {
        if (path == null) {
            return null;
        }
        return Strings.cleanPath(path).replace("../", "");
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace((String)path, (String)"\\", (String)"/");
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains("/")) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.split((String)pathToUse, (String)"/");
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, "..");
        }
        return prefix + String.join((CharSequence)"/", pathElements);
    }

    @Deprecated
    public static String underscoreName(String camelCaseName) {
        if (StringUtils.isEmpty((CharSequence)camelCaseName)) {
            return camelCaseName;
        }
        StringBuilder result = new StringBuilder(camelCaseName.length() << 1);
        result.append(Character.toLowerCase(camelCaseName.charAt(0)));
        int len = camelCaseName.length();
        for (int i = 1; i < len; ++i) {
            char ch = camelCaseName.charAt(i);
            if (Character.isUpperCase(ch)) {
                result.append('_').append(Character.toLowerCase(ch));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    @Deprecated
    public static String camelCaseName(String underscoreName) {
        if (StringUtils.isEmpty((CharSequence)underscoreName)) {
            return underscoreName;
        }
        StringBuilder result = new StringBuilder(underscoreName.length());
        int len = underscoreName.length();
        for (int i = 0; i < len; ++i) {
            char ch = underscoreName.charAt(i);
            if ('_' == ch) {
                if (++i >= len) continue;
                result.append(Character.toUpperCase(underscoreName.charAt(i)));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static boolean isEmpty(Object value) {
        return value == null || value instanceof CharSequence && StringUtils.isEmpty((CharSequence)((CharSequence)value));
    }

    public static boolean isBlank(Object value) {
        return value == null || value instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)value));
    }

    public static String ifEmpty(String str, String defaultStr) {
        return StringUtils.isEmpty((CharSequence)str) ? defaultStr : str;
    }

    public static String ifBlank(String str, String defaultStr) {
        return StringUtils.isBlank((CharSequence)str) ? defaultStr : str;
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.replace((String)str, (String)"'", (String)"''");
    }

    public static String escapeRegex(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        StringBuilder escaped = new StringBuilder(text.length() + 8);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (ArrayUtils.contains((char[])REGEX_SPECIALS, (char)c)) {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    public static String[] csvSplit(String s) {
        if (s == null) {
            return null;
        }
        return Strings.csvSplit(s, 0, s.length());
    }

    public static String[] csvSplit(String s, int off, int len) {
        if (s == null) {
            return null;
        }
        if (off < 0 || len < 0 || off > s.length()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> list = new ArrayList<String>();
        Strings.csvSplit(list, s, off, len);
        return list.toArray(new String[0]);
    }

    public static List<String> csvSplit(List<String> list, String s, int off, int len) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        CsvSplitState state = CsvSplitState.PRE_DATA;
        StringBuilder out = new StringBuilder();
        int last = -1;
        block13: while (len > 0) {
            char ch = s.charAt(off++);
            --len;
            switch (state) {
                case PRE_DATA: {
                    if (Character.isWhitespace(ch)) continue block13;
                    if ('\"' == ch) {
                        state = CsvSplitState.QUOTE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add("");
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    continue block13;
                }
                case DATA: {
                    if (Character.isWhitespace(ch)) {
                        last = out.length();
                        out.append(ch);
                        state = CsvSplitState.WHITE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case WHITE: {
                    if (Character.isWhitespace(ch)) {
                        out.append(ch);
                        continue block13;
                    }
                    if (',' == ch) {
                        out.setLength(last);
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    last = -1;
                    continue block13;
                }
                case QUOTE: {
                    if ('\\' == ch) {
                        state = CsvSplitState.SLOSH;
                        continue block13;
                    }
                    if ('\"' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.POST_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case SLOSH: {
                    out.append(ch);
                    state = CsvSplitState.QUOTE;
                    continue block13;
                }
                case POST_DATA: {
                    if (',' != ch) continue block13;
                    state = CsvSplitState.PRE_DATA;
                    continue block13;
                }
            }
            throw new UnsupportedOperationException("Unsupported state " + (Object)((Object)state));
        }
        switch (state) {
            case PRE_DATA: 
            case POST_DATA: {
                break;
            }
            case DATA: 
            case QUOTE: 
            case SLOSH: {
                list.add(out.toString());
                break;
            }
            case WHITE: {
                out.setLength(last);
                list.add(out.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported state " + (Object)((Object)state));
            }
        }
        return list;
    }

    private static enum CsvSplitState {
        PRE_DATA,
        QUOTE,
        SLOSH,
        DATA,
        WHITE,
        POST_DATA;

    }
}

