/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class TimingWheel<T extends Timing<T>>
implements Serializable {
    private static final long serialVersionUID = -3950831738037257527L;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MILLIS_PER_MINUTE = 60000;
    private final TimingQueue<T>[] ringBuffer;

    public TimingWheel() {
        this(11);
    }

    public TimingWheel(int priorityQueueInitialCapacity) {
        TimingQueue[] array = new TimingQueue[60];
        for (int i = 0; i < 60; ++i) {
            array[i] = new TimingQueue(priorityQueueInitialCapacity);
        }
        this.ringBuffer = array;
    }

    protected boolean verify(T timing) {
        return true;
    }

    public final boolean offer(T timing) {
        return this.offer(timing, System.currentTimeMillis() + 1099L);
    }

    public final boolean offer(T timing, long leastTimeMillis) {
        if (!this.verify(timing)) {
            return false;
        }
        long slotTimeMillis = Math.max(timing.timing(), leastTimeMillis);
        int ringSecond = TimingWheel.secondOfMinute(slotTimeMillis);
        return this.ringBuffer[ringSecond].offer(timing);
    }

    public final List<T> poll() {
        return this.poll(System.currentTimeMillis());
    }

    public final List<T> poll(long latestTimeMillis) {
        ArrayList<Timing> ringTrigger = new ArrayList<Timing>();
        int ringSecond = TimingWheel.secondOfMinute(latestTimeMillis);
        long maximumTiming = latestTimeMillis / 1000L * 1000L + 999L;
        block0: for (int i = 0; i < 2; ++i) {
            Timing first;
            TimingQueue<T> ringTick = this.ringBuffer[(ringSecond - i + 60) % 60];
            while ((first = (Timing)ringTick.peek()) != null && first.timing() <= maximumTiming && (first = (Timing)ringTick.poll()) != null) {
                if (first.timing() > maximumTiming) {
                    ringTick.offer(first);
                    continue block0;
                }
                ringTrigger.add(first);
            }
        }
        return ringTrigger;
    }

    private static int secondOfMinute(long timeMillis) {
        return (int)(timeMillis % 60000L / 1000L);
    }

    public static class TimingQueue<T extends Timing<T>>
    extends PriorityBlockingQueue<T> {
        public TimingQueue() {
        }

        public TimingQueue(int initialCapacity) {
            super(initialCapacity);
        }
    }

    public static interface Timing<T extends Timing<T>>
    extends Comparable<T> {
        public long timing();

        @Override
        default public int compareTo(T other) {
            return Long.compare(this.timing(), other.timing());
        }
    }
}

