/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.io.Files;
import java.io.File;
import java.util.ArrayList;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ZipUtils {
    private static final String SUFFIX = ".zip";

    public static String zip(String src) throws ZipException {
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            throw new ZipException("source file not found: " + src);
        }
        String dest = srcFile.getParent() + File.separator;
        dest = srcFile.isFile() ? dest + FilenameUtils.getBaseName((String)srcFile.getName()) : dest + srcFile.getName();
        return ZipUtils.zip(src, dest + SUFFIX);
    }

    public static String zip(String src, String dest) throws ZipException {
        return ZipUtils.zip(src, dest, null);
    }

    public static String zip(String src, String dest, String passwd) throws ZipException {
        return ZipUtils.zip(src, dest, true, passwd, null);
    }

    public static String zip(String src, String dest, boolean recursion, String passwd, String comment) throws ZipException {
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            throw new ZipException("source file not found: " + src);
        }
        if (StringUtils.isEmpty((CharSequence)dest)) {
            throw new ZipException("dest file cannot be null");
        }
        File destFile = new File(dest);
        if (destFile.exists()) {
            throw new ZipException("dest file exists: " + dest);
        }
        Files.mkdir(destFile.getParent());
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(CompressionMethod.DEFLATE);
        parameters.setCompressionLevel(CompressionLevel.NORMAL);
        if (!StringUtils.isEmpty((CharSequence)passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.AES);
            parameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        }
        ZipFile zipFile = new ZipFile(destFile, ZipUtils.toCharArray(passwd));
        if (srcFile.isFile()) {
            zipFile.addFile(srcFile, parameters);
        } else {
            File[] files = srcFile.listFiles();
            if (files == null || files.length == 0) {
                return null;
            }
            for (File file : files) {
                if (file.isFile()) {
                    zipFile.addFile(file, parameters);
                    continue;
                }
                if (!recursion) continue;
                zipFile.addFolder(file, parameters);
            }
        }
        if (comment != null) {
            zipFile.setComment(comment);
        }
        return destFile.getAbsolutePath();
    }

    public static String unzip(String zipFile) throws ZipException {
        if (StringUtils.isBlank((CharSequence)zipFile)) {
            throw new ZipException("zip file cannot be null");
        }
        String lowercasePath = zipFile.toLowerCase();
        if (lowercasePath.endsWith(SUFFIX)) {
            String dest = zipFile.substring(0, lowercasePath.indexOf(SUFFIX));
            ZipUtils.unzip(zipFile, dest);
            return dest;
        }
        throw new ZipException("the zip file name must be end with .zip");
    }

    public static File[] unzip(String zipFile, String dest) throws ZipException {
        return ZipUtils.unzip(zipFile, dest, null);
    }

    public static File[] unzip(String zipFile, String dest, String passwd) throws ZipException {
        return ZipUtils.unzip(new File(zipFile), dest, passwd);
    }

    public static File[] unzip(File zipFile, String dest, String passwd) throws ZipException {
        if (!zipFile.exists()) {
            throw new ZipException("zip file not found: " + zipFile.getAbsolutePath());
        }
        ZipFile zFile = new ZipFile(zipFile, ZipUtils.toCharArray(passwd));
        if (!zFile.isValidZipFile()) {
            throw new ZipException("invalid zip file.");
        }
        if (zFile.isEncrypted() && StringUtils.isEmpty((CharSequence)passwd)) {
            throw new ZipException("passwd can't be null");
        }
        if (StringUtils.isEmpty((CharSequence)dest)) {
            throw new ZipException("dest file path can't be null");
        }
        if (new File(dest).exists()) {
            throw new ZipException("dest file is exists: " + dest);
        }
        Files.mkdir(dest);
        zFile.extractAll(dest);
        ArrayList<File> fileEntries = new ArrayList<File>();
        for (FileHeader fileHeader : zFile.getFileHeaders()) {
            if (fileHeader.isDirectory()) continue;
            fileEntries.add(new File(dest, fileHeader.getFileName()));
        }
        return fileEntries.toArray(new File[0]);
    }

    private static char[] toCharArray(String str) {
        return StringUtils.isEmpty((CharSequence)str) ? null : str.toCharArray();
    }
}

