/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.ws.adapter;

import code.ponfee.commons.model.Result;
import code.ponfee.commons.reflect.GenericUtils;
import code.ponfee.commons.ws.adapter.model.MapEntry;
import code.ponfee.commons.ws.adapter.model.MapItem;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class ResultMapAdapter<K, V>
extends XmlAdapter<Result<MapItem>, Result<Map<K, V>>> {
    protected final Class<K> ktype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 0);
    protected final Class<V> vtype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 1);

    protected ResultMapAdapter() {
    }

    public Result<Map<K, V>> unmarshal(Result<MapItem> v) {
        if (v.getData() == null || v.getData().getItem() == null) {
            return v.from(null);
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (MapEntry e : v.getData().getItem()) {
            map.put(e.getKey(), e.getValue());
        }
        return v.from(map);
    }

    public Result<MapItem> marshal(Result<Map<K, V>> v) {
        if (v.getData() == null) {
            return v.from(null);
        }
        MapEntry[] entries = new MapEntry[v.getData().size()];
        int i = 0;
        for (Map.Entry<K, V> entry : v.getData().entrySet()) {
            entries[i++] = new MapEntry<K, V>(entry);
        }
        return v.from(new MapItem(entries));
    }
}

