/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.SAXValidator;
import org.dom4j.util.XMLErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SimpleXmlHandler {
    private static final int MAX_ERROR_SIZE = 500;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Map<String, String>> parse(InputStream input) {
        try (InputStream xml = input;){
            LinkedList<Map<String, String>> results = new LinkedList<Map<String, String>>();
            Element root = new SAXReader().read(xml).getRootElement();
            Iterator seconds = root.elementIterator();
            while (seconds.hasNext()) {
                Element second = (Element)seconds.next();
                HashMap<String, String> element = new HashMap<String, String>();
                for (Attribute attr : second.attributes()) {
                    element.put(attr.getName(), attr.getValue());
                }
                Iterator thirds = second.elementIterator();
                while (thirds.hasNext()) {
                    Element third = (Element)thirds.next();
                    element.put(third.getName().trim(), third.getText().trim());
                }
                results.add(element);
            }
            LinkedList<Map<String, String>> linkedList = results;
            return linkedList;
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Invalid xml data.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, String>> parse(String xml) {
        return SimpleXmlHandler.parse(new ByteArrayInputStream(xml.getBytes()));
    }

    public static void validate(InputStream xmlIn, InputStream xsdIn) {
        try (InputStream xml = xmlIn;
             InputStream xsd = xsdIn;){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", xsd);
            if (!parser.isValidating()) {
                throw new IllegalStateException("Invalid xsd definition.");
            }
            XMLErrorHandler errorHandler = new XMLErrorHandler();
            SAXValidator validator = new SAXValidator(parser.getXMLReader());
            validator.setErrorHandler((ErrorHandler)errorHandler);
            validator.validate(new SAXReader().read(xml));
            if (errorHandler.getErrors().hasContent()) {
                StringBuilder errors = new StringBuilder(128);
                HashSet<String> exists = new HashSet<String>();
                for (Element e : errorHandler.getErrors().elements()) {
                    String position = e.attributeValue("line") + "#" + e.attributeValue("column");
                    if (!exists.add(position)) continue;
                    errors.append(position).append(":").append(e.getTextTrim()).append("\n");
                    if (errors.length() <= 500) continue;
                    break;
                }
                if (errors.length() > 500) {
                    errors.setLength(497);
                    errors.append("...");
                }
                throw new IllegalStateException(errors.toString());
            }
        }
        catch (ParserConfigurationException | DocumentException | SAXException e) {
            throw new IllegalStateException("Invalid xml data.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void validate(String xml, String xsd) {
        SimpleXmlHandler.validate(new ByteArrayInputStream(xml.getBytes()), new ByteArrayInputStream(xsd.getBytes()));
    }

    private static final class JAXPConstants {
        static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
        static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

        private JAXPConstants() {
        }
    }
}

