/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.xml;

import code.ponfee.commons.io.Closeables;
import code.ponfee.commons.xml.XmlException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlReader {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    private Document document;
    private String root;
    private XPath xpath;

    private XmlReader() {
    }

    public static XmlReader create(String xml) {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            throw new IllegalArgumentException("xml can't be empty.");
        }
        return XmlReader.create(new ByteArrayInputStream(xml.getBytes()));
    }

    public static XmlReader create(InputStream inputStream) {
        try {
            XmlReader readers = new XmlReader();
            readers.document = FACTORY.newDocumentBuilder().parse(inputStream);
            readers.root = readers.document.getFirstChild().getNodeName();
            readers.xpath = XPathFactory.newInstance().newXPath();
            XmlReader xmlReader = readers;
            return xmlReader;
        }
        catch (Exception e) {
            throw new XmlException("Xmls create fail", e);
        }
        finally {
            Closeables.console(inputStream);
        }
    }

    public String getRoot() {
        return this.root;
    }

    public String evaluate(String xpathExp) {
        try {
            return this.xpath.evaluate(xpathExp, this.document);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("xpath evaluate error", e);
        }
    }

    public Node getNode(String tagName) {
        NodeList nodes = this.document.getElementsByTagName(tagName);
        if (nodes.getLength() <= 0) {
            return null;
        }
        return nodes.item(0);
    }

    public NodeList getNodes(String tagName) {
        NodeList nodes = this.document.getElementsByTagName(tagName);
        if (nodes.getLength() <= 0) {
            return null;
        }
        return nodes;
    }

    public String getNodeText(String tagName) {
        Node node = this.getNode(tagName);
        return node == null ? null : node.getTextContent();
    }

    public Integer getNodeInt(String tagName) {
        String nodeContent = this.getNodeText(tagName);
        return nodeContent == null ? null : Integer.valueOf(nodeContent);
    }

    public Long getNodeLong(String tagName) {
        String nodeContent = this.getNodeText(tagName);
        return nodeContent == null ? null : Long.valueOf(nodeContent);
    }

    public Float getNodeFloat(String tagName) {
        String nodeContent = this.getNodeText(tagName);
        return nodeContent == null ? null : Float.valueOf(nodeContent);
    }

    static {
        FACTORY.setExpandEntityReferences(false);
    }
}

