/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.xml;

import code.ponfee.commons.xml.XmlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class XmlWriter {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private final List<E<?>> elements = new ArrayList();

    private XmlWriter() {
    }

    public static XmlWriter create() {
        return new XmlWriter();
    }

    public XmlWriter element(String name, String text) {
        this.elements.add(new TextE(name, text));
        return this;
    }

    public XmlWriter element(String name, Number number) {
        this.elements.add(new NumberE(name, number));
        return this;
    }

    public XmlWriter element(String parentName, String childName, String childText) {
        return this.element(parentName, new TextE(childName, childText));
    }

    public XmlWriter element(String parentName, String childName, Number childNumber) {
        return this.element(parentName, new NumberE(childName, childNumber));
    }

    public XmlWriter element(String parentName, Object ... childPairs) {
        return this.element(parentName, XmlWriter.newElement(childPairs));
    }

    public XmlWriter element(String parentName, E<?> child) {
        return this.element(parentName, Collections.singletonList(child));
    }

    public XmlWriter element(String parentName, List<E<?>> children) {
        this.elements.add(new NodeE(parentName, children));
        return this;
    }

    public String build() {
        return this.build("xml");
    }

    public String build(String root) {
        StringBuilder xml = new StringBuilder(XML_DECLARATION).append("<").append(root).append(">");
        for (E<?> e : this.elements) {
            xml.append(((E)e).render());
        }
        return xml.append("</").append(root).append(">").toString();
    }

    public static List<E<?>> newElement(Object ... childPairs) {
        if ((childPairs.length & 1) == 1) {
            throw new XmlException("args Object array must be pair");
        }
        ArrayList nodes = new ArrayList();
        for (int i = 0; i < childPairs.length; i += 2) {
            nodes.add(XmlWriter.newElement((String)childPairs[i], childPairs[i + 1]));
        }
        return nodes;
    }

    public static E<?> newElement(String name, Object value) {
        if (value instanceof Number) {
            return new NumberE(name, (Number)value);
        }
        if (value instanceof E) {
            return new NodeE(name, Collections.singletonList((NodeE)value));
        }
        return new TextE(name, Objects.toString(value, null));
    }

    public static class NodeE
    extends E<List<E<?>>> {
        public NodeE(String name, List<E<?>> nodes) {
            super(name, nodes);
        }

        @Override
        protected String value() {
            StringBuilder content = new StringBuilder();
            for (E e : (List)this.value) {
                if (e == null) continue;
                content.append(e.render());
            }
            return content.toString();
        }
    }

    public static class NumberE
    extends E<Number> {
        public NumberE(String name, Number value) {
            super(name, value);
        }

        @Override
        protected String value() {
            return ((Number)this.value).toString();
        }
    }

    public static class TextE
    extends E<String> {
        public TextE(String name, String content) {
            super(name, content);
        }

        @Override
        protected String value() {
            return "<![CDATA[" + (String)this.value + "]]>";
        }
    }

    public static abstract class E<T> {
        protected final String name;
        protected final T value;

        public E(String name, T value) {
            if (name == null) {
                throw new IllegalArgumentException("element name cannot be null.");
            }
            this.name = name;
            this.value = value;
        }

        private String render() {
            StringBuilder content = new StringBuilder("<").append(this.name).append(">");
            if (this.value != null) {
                content.append(this.value());
            }
            return content.append("</").append(this.name).append(">").toString();
        }

        protected abstract String value();
    }
}

