/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.collect;

import cn.ponfee.commons.collect.Collects;
import cn.ponfee.commons.collect.DelegatedIntSpliterator;
import cn.ponfee.commons.model.ToJsonString;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.ArrayUtils;

public class ImmutableArrayList<E>
extends ToJsonString
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7013120001220709229L;
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final E[] elements;

    public ImmutableArrayList() {
        this.elements = EMPTY_OBJECT_ARRAY;
    }

    public ImmutableArrayList(Object[] elements) {
        this.elements = Objects.requireNonNull(elements);
    }

    public static <T> ImmutableArrayList<T> of() {
        return new ImmutableArrayList();
    }

    @SafeVarargs
    public static <T> ImmutableArrayList<T> of(T ... array) {
        return new ImmutableArrayList(array);
    }

    public static <T> ImmutableArrayList<T> of(T[] array, T last) {
        return ImmutableArrayList.of(ArrayUtils.addAll((Object[])Objects.requireNonNull(array), (Object[])new Object[]{last}));
    }

    public static <T> ImmutableArrayList<T> of(List<T> list) {
        return ImmutableArrayList.of(list.isEmpty() ? EMPTY_OBJECT_ARRAY : list.toArray());
    }

    public static <T> ImmutableArrayList<T> of(List<T> list, T last) {
        return ImmutableArrayList.of(list.toArray(), last);
    }

    protected int offset() {
        return 0;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Object[] toArray() {
        if (this.isEmpty()) {
            return this.elements.length == 0 ? this.elements : EMPTY_OBJECT_ARRAY;
        }
        return Arrays.copyOfRange(this.elements, this.offset(), this.offset() + this.size());
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        if (this.isEmpty()) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        if (a.length < this.size()) {
            return Arrays.copyOfRange(this.elements, this.offset(), this.offset() + this.size(), a.getClass());
        }
        System.arraycopy(this.elements, this.offset(), a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    public final E get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size());
        }
        return this.elements[this.offset() + index];
    }

    @Override
    public final int indexOf(Object o) {
        if (o == null) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (this.elements[this.offset() + i] != null) continue;
                return i;
            }
        } else {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (!o.equals(this.elements[this.offset() + i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.elements[this.offset() + i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!o.equals(this.elements[this.offset() + i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Iterator<E> iterator() {
        return new UnmodifiableIterator(this.offset(), this.offset() + this.size());
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new UnmodifiableListIterator(this.offset(), this.offset() + this.size());
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        return new UnmodifiableListIterator(this.offset() + index, this.offset() + this.size());
    }

    @Override
    public final ImmutableArrayList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes((int)fromIndex, (int)toIndex, (int)this.size());
        int length = toIndex - fromIndex;
        if (length == this.size()) {
            return this;
        }
        if (length == 0) {
            return ImmutableArrayList.of(EMPTY_OBJECT_ARRAY);
        }
        return new SubList(this.offset() + fromIndex, this.offset() + toIndex);
    }

    @Override
    public final Spliterator<E> spliterator() {
        return new DelegatedIntSpliterator<Object>(this.offset(), this.offset() + this.size(), i -> this.elements[i]);
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> a = this.listIterator();
        ListIterator b = ((List)o).listIterator();
        while (a.hasNext() && b.hasNext()) {
            if (Objects.equals(a.next(), b.next())) continue;
            return false;
        }
        return !a.hasNext() && !b.hasNext();
    }

    @Override
    public String toString() {
        return Arrays.toString(this.elements);
    }

    public Object clone() {
        return this;
    }

    public final E[] join(E last) {
        if (this.isEmpty()) {
            return last == null ? new Object[]{null} : Collects.toArray(last);
        }
        Class<?> arrayType = this.elements.getClass();
        Object[] array = arrayType.equals(Object[].class) ? new Object[this.size() + 1] : (Object[])Array.newInstance(arrayType.getComponentType(), this.size() + 1);
        System.arraycopy(this.elements, this.offset(), array, 0, this.size());
        array[this.size()] = last;
        return array;
    }

    public final ImmutableArrayList<E> concat(E last) {
        return ImmutableArrayList.of(this.join(last));
    }

    @Override
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    private class SubList
    extends ImmutableArrayList<E> {
        private static final long serialVersionUID = 8017446305586649188L;
        final int offset;
        final int size;

        SubList(int from, int to) {
            super(ImmutableArrayList.this.elements);
            this.offset = from;
            this.size = to - from;
        }

        @Override
        protected int offset() {
            return this.offset;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator<E> {
        UnmodifiableListIterator(int position, int end) {
            super(position, end);
        }

        @Override
        public boolean hasPrevious() {
            return !ImmutableArrayList.this.isEmpty() && this.position > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return ImmutableArrayList.this.elements[--this.position];
        }

        @Override
        public int nextIndex() {
            return this.position;
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private class UnmodifiableIterator
    implements Iterator<E> {
        protected int position;
        protected final int end;

        UnmodifiableIterator(int position, int end) {
            this.position = position;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return !ImmutableArrayList.this.isEmpty() && this.position < this.end;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ImmutableArrayList.this.elements[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

